/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.executor;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.orientdb.executor.OGremlinResult;

public class OGremlinResultSet
implements Iterable<OGremlinResult>,
AutoCloseable {
    private OrientGraph graph;
    private OResultSet inner;

    public OGremlinResultSet(OrientGraph graph, OResultSet inner) {
        this.graph = graph;
        this.inner = inner;
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public Iterator<OGremlinResult> iterator() {
        return new Iterator<OGremlinResult>(){

            @Override
            public boolean hasNext() {
                return OGremlinResultSet.this.inner.hasNext();
            }

            @Override
            public OGremlinResult next() {
                OResult next = OGremlinResultSet.this.inner.next();
                return new OGremlinResult(OGremlinResultSet.this.graph, next);
            }
        };
    }

    public Stream<OGremlinResult> stream() {
        return this.inner.stream().map(result -> new OGremlinResult(this.graph, (OResult)result));
    }

    public OResultSet getRawResultSet() {
        return this.inner;
    }
}

