/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.io.kryo;

import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORecordId;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;

public class ORidBagKryoSerializer
extends Serializer<ORidBag> {
    @Override
    public ORidBag read(Kryo kryo, Input input, Class<ORidBag> tinkerGraphClass) {
        String[] ids;
        ORidBag bag = new ORidBag();
        for (String id : ids = input.readString().split(";")) {
            bag.add(new ORecordId(id));
        }
        return bag;
    }

    @Override
    public void write(Kryo kryo, Output output, ORidBag bag) {
        StringBuilder ids = new StringBuilder();
        bag.forEach(rid -> ids.append(rid.getIdentity()).append(";"));
        output.writeString(ids);
    }
}

