/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.javatuples.Pair;

public final class ElementHelper {
    private ElementHelper() {
    }

    public static void validateLabel(String label) throws IllegalArgumentException {
        if (null == label) {
            throw Element.Exceptions.labelCanNotBeNull();
        }
        if (label.isEmpty()) {
            throw Element.Exceptions.labelCanNotBeEmpty();
        }
        if (Graph.Hidden.isHidden(label)) {
            throw Element.Exceptions.labelCanNotBeAHiddenKey(label);
        }
    }

    public static void validateMixedElementIds(Class<? extends Element> clazz, Object ... ids) throws IllegalArgumentException {
        if (ids.length > 1) {
            boolean element = clazz.isAssignableFrom(ids[0].getClass());
            for (int i = 1; i < ids.length; ++i) {
                if (clazz.isAssignableFrom(ids[i].getClass()) == element) continue;
                throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
            }
        }
    }

    public static void validateProperty(String key, Object value) throws IllegalArgumentException {
        if (null == value) {
            throw Property.Exceptions.propertyValueCanNotBeNull();
        }
        if (null == key) {
            throw Property.Exceptions.propertyKeyCanNotBeNull();
        }
        if (key.isEmpty()) {
            throw Property.Exceptions.propertyKeyCanNotBeEmpty();
        }
        if (Graph.Hidden.isHidden(key)) {
            throw Property.Exceptions.propertyKeyCanNotBeAHiddenKey(key);
        }
    }

    public static void legalPropertyKeyValueArray(Object ... propertyKeyValues) throws IllegalArgumentException {
        if (propertyKeyValues.length % 2 != 0) {
            throw Element.Exceptions.providedKeyValuesMustBeAMultipleOfTwo();
        }
        for (int i = 0; i < propertyKeyValues.length; i += 2) {
            if (!(propertyKeyValues[i] instanceof String) && !(propertyKeyValues[i] instanceof T)) {
                throw Element.Exceptions.providedKeyValuesMustHaveALegalKeyOnEvenIndices();
            }
            if (null != propertyKeyValues[i + 1]) continue;
            throw Property.Exceptions.propertyValueCanNotBeNull();
        }
    }

    public static Optional<Object> getIdValue(Object ... keyValues) {
        for (int i = 0; i < keyValues.length; i += 2) {
            if (!keyValues[i].equals(T.id)) continue;
            return Optional.of(keyValues[i + 1]);
        }
        return Optional.empty();
    }

    public static Optional<Object[]> remove(String keyToRemove, Object ... keyValues) {
        return ElementHelper.remove((Object)keyToRemove, keyValues);
    }

    public static Optional<Object[]> remove(T accessor, Object ... keyValues) {
        return ElementHelper.remove((Object)accessor, keyValues);
    }

    private static Optional<Object[]> remove(Object keyToRemove, Object ... keyValues) {
        List<Object> list = Arrays.asList(keyValues);
        List revised = IntStream.range(0, list.size()).filter(i -> i % 2 == 0).filter(i -> !keyToRemove.equals(list.get(i))).flatMap(i -> IntStream.of(i, i + 1)).mapToObj(i -> list.get(i)).collect(Collectors.toList());
        return revised.size() > 0 ? Optional.of(revised.toArray()) : Optional.empty();
    }

    public static Object[] upsert(Object[] keyValues, Object key, Object val) {
        if (!ElementHelper.getKeys(keyValues).contains(key)) {
            return Stream.concat(Stream.of(keyValues), Stream.of(key, val)).toArray();
        }
        Object[] kvs = new Object[keyValues.length];
        for (int i = 0; i < keyValues.length; i += 2) {
            kvs[i] = keyValues[i];
            kvs[i + 1] = keyValues[i].equals(key) ? val : keyValues[i + 1];
        }
        return kvs;
    }

    public static Object[] replaceKey(Object[] keyValues, Object oldKey, Object newKey) {
        Object[] kvs = new Object[keyValues.length];
        for (int i = 0; i < keyValues.length; i += 2) {
            kvs[i] = keyValues[i].equals(oldKey) ? newKey : keyValues[i];
            kvs[i + 1] = keyValues[i + 1];
        }
        return kvs;
    }

    public static Map<String, Object> asMap(Object ... keyValues) {
        return ElementHelper.asPairs(keyValues).stream().collect(Collectors.toMap(p -> (String)p.getValue0(), p -> p.getValue1()));
    }

    public static List<Pair<String, Object>> asPairs(Object ... keyValues) {
        List<Object> list = Arrays.asList(keyValues);
        return IntStream.range(1, list.size()).filter(i -> i % 2 != 0).mapToObj(i -> Pair.with(list.get(i - 1).toString(), list.get(i))).collect(Collectors.toList());
    }

    public static Set<String> getKeys(Object ... keyValues) {
        HashSet<String> keys2 = new HashSet<String>();
        for (int i = 0; i < keyValues.length; i += 2) {
            keys2.add(keyValues[i].toString());
        }
        return keys2;
    }

    public static Optional<String> getLabelValue(Object ... keyValues) {
        for (int i = 0; i < keyValues.length; i += 2) {
            if (!keyValues[i].equals(T.label)) continue;
            ElementHelper.validateLabel((String)keyValues[i + 1]);
            return Optional.of((String)keyValues[i + 1]);
        }
        return Optional.empty();
    }

    public static void attachProperties(Element element, Object ... propertyKeyValues) {
        if (null == element) {
            throw Graph.Exceptions.argumentCanNotBeNull("element");
        }
        for (int i = 0; i < propertyKeyValues.length; i += 2) {
            if (propertyKeyValues[i].equals(T.id) || propertyKeyValues[i].equals(T.label)) continue;
            element.property((String)propertyKeyValues[i], propertyKeyValues[i + 1]);
        }
    }

    public static void attachProperties(Vertex vertex, Object ... propertyKeyValues) {
        if (null == vertex) {
            throw Graph.Exceptions.argumentCanNotBeNull("vertex");
        }
        for (int i = 0; i < propertyKeyValues.length; i += 2) {
            if (propertyKeyValues[i].equals(T.id) || propertyKeyValues[i].equals(T.label)) continue;
            vertex.property(vertex.graph().features().vertex().getCardinality((String)propertyKeyValues[i]), (String)propertyKeyValues[i], propertyKeyValues[i + 1], new Object[0]);
        }
    }

    public static void attachProperties(Vertex vertex, VertexProperty.Cardinality cardinality, Object ... propertyKeyValues) {
        if (null == vertex) {
            throw Graph.Exceptions.argumentCanNotBeNull("vertex");
        }
        for (int i = 0; i < propertyKeyValues.length; i += 2) {
            if (propertyKeyValues[i].equals(T.id) || propertyKeyValues[i].equals(T.label)) continue;
            vertex.property(cardinality, (String)propertyKeyValues[i], propertyKeyValues[i + 1], new Object[0]);
        }
    }

    public static <V> Optional<VertexProperty<V>> stageVertexProperty(Vertex vertex, VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        if (cardinality.equals((Object)VertexProperty.Cardinality.single)) {
            vertex.properties(key).forEachRemaining(Property::remove);
        } else if (cardinality.equals((Object)VertexProperty.Cardinality.set)) {
            Iterator itty = vertex.properties(key);
            while (itty.hasNext()) {
                VertexProperty property = itty.next();
                if (!property.value().equals(value)) continue;
                ElementHelper.attachProperties(property, keyValues);
                return Optional.of(property);
            }
        }
        return Optional.empty();
    }

    public static Object[] getProperties(Element element, boolean includeId, boolean includeLabel, Set<String> propertiesToCopy) {
        ArrayList<Object> keyValues = new ArrayList<Object>();
        if (includeId) {
            keyValues.add(T.id);
            keyValues.add(element.id());
        }
        if (includeLabel) {
            keyValues.add(T.label);
            keyValues.add(element.label());
        }
        element.keys().forEach(key -> {
            if (propertiesToCopy.isEmpty() || propertiesToCopy.contains(key)) {
                keyValues.add(key);
                keyValues.add(element.value((String)key));
            }
        });
        return keyValues.toArray(new Object[keyValues.size()]);
    }

    public static boolean areEqual(Element a, Object b) {
        if (a == b) {
            return true;
        }
        if (null == b || null == a) {
            return false;
        }
        if (!(a instanceof Vertex && b instanceof Vertex || a instanceof Edge && b instanceof Edge || a instanceof VertexProperty && b instanceof VertexProperty)) {
            return false;
        }
        return ElementHelper.haveEqualIds(a, (Element)b);
    }

    public static boolean areEqual(Vertex a, Vertex b) {
        return null != b && null != a && (a == b || ElementHelper.haveEqualIds(a, b));
    }

    public static boolean areEqual(Edge a, Edge b) {
        return null != b && null != a && (a == b || ElementHelper.haveEqualIds(a, b));
    }

    public static boolean areEqual(VertexProperty a, VertexProperty b) {
        return null != b && null != a && (a == b || ElementHelper.haveEqualIds(a, b));
    }

    public static boolean areEqual(VertexProperty a, Object b) {
        return ElementHelper.areEqual((Element)a, b);
    }

    public static boolean haveEqualIds(Element a, Element b) {
        return a.id().equals(b.id());
    }

    public static int hashCode(Element element) {
        return element.id().hashCode();
    }

    public static int hashCode(Property property) {
        return property.key().hashCode() + property.value().hashCode();
    }

    public static boolean areEqual(Property a, Object b) {
        if (a == b) {
            return true;
        }
        if (null == b || null == a) {
            return false;
        }
        if (!(b instanceof Property)) {
            return false;
        }
        if (!a.isPresent() && !((Property)b).isPresent()) {
            return true;
        }
        if (!a.isPresent() && ((Property)b).isPresent() || a.isPresent() && !((Property)b).isPresent()) {
            return false;
        }
        return a.key().equals(((Property)b).key()) && a.value().equals(((Property)b).value());
    }

    public static Map<String, Object> propertyValueMap(Element element, String ... propertyKeys) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        element.properties(propertyKeys).forEachRemaining(property -> values.put(property.key(), property.value()));
        return values;
    }

    public static Map<String, Property> propertyMap(Element element, String ... propertyKeys) {
        HashMap<String, Property> propertyMap = new HashMap<String, Property>();
        element.properties(propertyKeys).forEachRemaining(property -> propertyMap.put(property.key(), (Property)property));
        return propertyMap;
    }

    public static Map<String, List> vertexPropertyValueMap(Vertex vertex, String ... propertyKeys) {
        HashMap<String, List> valueMap = new HashMap<String, List>();
        vertex.properties(propertyKeys).forEachRemaining(property -> {
            if (valueMap.containsKey(property.key())) {
                ((List)valueMap.get(property.key())).add(property.value());
            } else {
                ArrayList list = new ArrayList();
                list.add(property.value());
                valueMap.put(property.key(), list);
            }
        });
        return valueMap;
    }

    public static Map<String, List<VertexProperty>> vertexPropertyMap(Vertex vertex, String ... propertyKeys) {
        HashMap<String, List<VertexProperty>> propertyMap = new HashMap<String, List<VertexProperty>>();
        vertex.properties(propertyKeys).forEachRemaining(property -> {
            if (propertyMap.containsKey(property.key())) {
                ((List)propertyMap.get(property.key())).add(property);
            } else {
                ArrayList<VertexProperty> list = new ArrayList<VertexProperty>();
                list.add((VertexProperty)property);
                propertyMap.put(property.key(), list);
            }
        });
        return propertyMap;
    }

    public static boolean keyExists(String key, String ... providedKeys) {
        if (Graph.Hidden.isHidden(key)) {
            return false;
        }
        if (0 == providedKeys.length) {
            return true;
        }
        if (1 == providedKeys.length) {
            return key.equals(providedKeys[0]);
        }
        for (String temp : providedKeys) {
            if (!temp.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean idExists(Object id, Object ... providedIds) {
        if (0 == providedIds.length) {
            return true;
        }
        if (1 == providedIds.length) {
            return id.toString().equals(providedIds[0].toString());
        }
        for (Object temp : providedIds) {
            if (!temp.toString().equals(id.toString())) continue;
            return true;
        }
        return false;
    }
}

