/*
 * Decompiled with CFR 0.152.
 */
package picocli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.BreakIterator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine {
    public static final String VERSION = "3.9.5";
    private final Tracer tracer = new Tracer();
    private final Model.CommandSpec commandSpec;
    private final Interpreter interpreter;
    private final IFactory factory;

    public CommandLine(Object command) {
        this(command, new DefaultFactory());
    }

    public CommandLine(Object command, IFactory factory) {
        this.factory = Assert.notNull(factory, "factory");
        this.interpreter = new Interpreter();
        this.commandSpec = Model.CommandSpec.forAnnotatedObject(command, factory);
        this.commandSpec.commandLine(this);
        this.commandSpec.validate();
        if (this.commandSpec.unmatchedArgsBindings().size() > 0) {
            this.setUnmatchedArgumentsAllowed(true);
        }
    }

    public Model.CommandSpec getCommandSpec() {
        return this.commandSpec;
    }

    public CommandLine addMixin(String name, Object mixin) {
        this.getCommandSpec().addMixin(name, Model.CommandSpec.forAnnotatedObject(mixin, this.factory));
        return this;
    }

    public Map<String, Object> getMixins() {
        Map<String, Model.CommandSpec> mixins = this.getCommandSpec().mixins();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String name : mixins.keySet()) {
            result.put(name, mixins.get(name).userObject);
        }
        return result;
    }

    public CommandLine addSubcommand(String name, Object command) {
        return this.addSubcommand(name, command, new String[0]);
    }

    public CommandLine addSubcommand(String name, Object command, String ... aliases) {
        CommandLine subcommandLine = CommandLine.toCommandLine(command, this.factory);
        subcommandLine.getCommandSpec().aliases.addAll(Arrays.asList(aliases));
        this.getCommandSpec().addSubcommand(name, subcommandLine);
        Model.CommandReflection.initParentCommand(subcommandLine.getCommandSpec().userObject(), this.getCommandSpec().userObject());
        return this;
    }

    public Map<String, CommandLine> getSubcommands() {
        return new LinkedHashMap<String, CommandLine>(this.getCommandSpec().subcommands());
    }

    public CommandLine getParent() {
        Model.CommandSpec parent = this.getCommandSpec().parent();
        return parent == null ? null : parent.commandLine();
    }

    public <T> T getCommand() {
        return (T)this.getCommandSpec().userObject();
    }

    public boolean isUsageHelpRequested() {
        return this.interpreter.parseResult != null && this.interpreter.parseResult.usageHelpRequested;
    }

    public boolean isVersionHelpRequested() {
        return this.interpreter.parseResult != null && this.interpreter.parseResult.versionHelpRequested;
    }

    public IHelpFactory getHelpFactory() {
        return this.getCommandSpec().usageMessage().helpFactory();
    }

    public CommandLine setHelpFactory(IHelpFactory helpFactory) {
        this.getCommandSpec().usageMessage().helpFactory(helpFactory);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setHelpFactory(helpFactory);
        }
        return this;
    }

    public List<String> getHelpSectionKeys() {
        return this.getCommandSpec().usageMessage().sectionKeys();
    }

    public CommandLine setHelpSectionKeys(List<String> keys2) {
        this.getCommandSpec().usageMessage().sectionKeys(keys2);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setHelpSectionKeys(keys2);
        }
        return this;
    }

    public Map<String, IHelpSectionRenderer> getHelpSectionMap() {
        return this.getCommandSpec().usageMessage().sectionMap();
    }

    public CommandLine setHelpSectionMap(Map<String, IHelpSectionRenderer> map) {
        this.getCommandSpec().usageMessage().sectionMap(map);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setHelpSectionMap(map);
        }
        return this;
    }

    public boolean isToggleBooleanFlags() {
        return this.getCommandSpec().parser().toggleBooleanFlags();
    }

    public CommandLine setToggleBooleanFlags(boolean newValue) {
        this.getCommandSpec().parser().toggleBooleanFlags(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setToggleBooleanFlags(newValue);
        }
        return this;
    }

    public boolean isOverwrittenOptionsAllowed() {
        return this.getCommandSpec().parser().overwrittenOptionsAllowed();
    }

    public CommandLine setOverwrittenOptionsAllowed(boolean newValue) {
        this.getCommandSpec().parser().overwrittenOptionsAllowed(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setOverwrittenOptionsAllowed(newValue);
        }
        return this;
    }

    public boolean isPosixClusteredShortOptionsAllowed() {
        return this.getCommandSpec().parser().posixClusteredShortOptionsAllowed();
    }

    public CommandLine setPosixClusteredShortOptionsAllowed(boolean newValue) {
        this.getCommandSpec().parser().posixClusteredShortOptionsAllowed(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setPosixClusteredShortOptionsAllowed(newValue);
        }
        return this;
    }

    public boolean isCaseInsensitiveEnumValuesAllowed() {
        return this.getCommandSpec().parser().caseInsensitiveEnumValuesAllowed();
    }

    public CommandLine setCaseInsensitiveEnumValuesAllowed(boolean newValue) {
        this.getCommandSpec().parser().caseInsensitiveEnumValuesAllowed(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setCaseInsensitiveEnumValuesAllowed(newValue);
        }
        return this;
    }

    public boolean isTrimQuotes() {
        return this.getCommandSpec().parser().trimQuotes();
    }

    public CommandLine setTrimQuotes(boolean newValue) {
        this.getCommandSpec().parser().trimQuotes(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setTrimQuotes(newValue);
        }
        return this;
    }

    public boolean isSplitQuotedStrings() {
        return this.getCommandSpec().parser().splitQuotedStrings();
    }

    public CommandLine setSplitQuotedStrings(boolean newValue) {
        this.getCommandSpec().parser().splitQuotedStrings(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setSplitQuotedStrings(newValue);
        }
        return this;
    }

    public String getEndOfOptionsDelimiter() {
        return this.getCommandSpec().parser().endOfOptionsDelimiter();
    }

    public CommandLine setEndOfOptionsDelimiter(String delimiter) {
        this.getCommandSpec().parser().endOfOptionsDelimiter(delimiter);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setEndOfOptionsDelimiter(delimiter);
        }
        return this;
    }

    public IDefaultValueProvider getDefaultValueProvider() {
        return this.getCommandSpec().defaultValueProvider();
    }

    public CommandLine setDefaultValueProvider(IDefaultValueProvider newValue) {
        this.getCommandSpec().defaultValueProvider(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setDefaultValueProvider(newValue);
        }
        return this;
    }

    public boolean isStopAtPositional() {
        return this.getCommandSpec().parser().stopAtPositional();
    }

    public CommandLine setStopAtPositional(boolean newValue) {
        this.getCommandSpec().parser().stopAtPositional(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setStopAtPositional(newValue);
        }
        return this;
    }

    public boolean isStopAtUnmatched() {
        return this.getCommandSpec().parser().stopAtUnmatched();
    }

    public CommandLine setStopAtUnmatched(boolean newValue) {
        this.getCommandSpec().parser().stopAtUnmatched(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setStopAtUnmatched(newValue);
        }
        if (newValue) {
            this.setUnmatchedArgumentsAllowed(true);
        }
        return this;
    }

    public boolean isUnmatchedOptionsArePositionalParams() {
        return this.getCommandSpec().parser().unmatchedOptionsArePositionalParams();
    }

    public CommandLine setUnmatchedOptionsArePositionalParams(boolean newValue) {
        this.getCommandSpec().parser().unmatchedOptionsArePositionalParams(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setUnmatchedOptionsArePositionalParams(newValue);
        }
        return this;
    }

    public boolean isUnmatchedArgumentsAllowed() {
        return this.getCommandSpec().parser().unmatchedArgumentsAllowed();
    }

    public CommandLine setUnmatchedArgumentsAllowed(boolean newValue) {
        this.getCommandSpec().parser().unmatchedArgumentsAllowed(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setUnmatchedArgumentsAllowed(newValue);
        }
        return this;
    }

    public List<String> getUnmatchedArguments() {
        return this.interpreter.parseResult == null ? Collections.emptyList() : UnmatchedArgumentException.stripErrorMessage(this.interpreter.parseResult.unmatched);
    }

    public static <T> T populateCommand(T command, String ... args) {
        CommandLine cli = CommandLine.toCommandLine(command, new DefaultFactory());
        cli.parse(args);
        return command;
    }

    public static <T> T populateSpec(Class<T> spec, String ... args) {
        CommandLine cli = CommandLine.toCommandLine(spec, new DefaultFactory());
        cli.parse(args);
        return cli.getCommand();
    }

    public List<CommandLine> parse(String ... args) {
        return this.interpreter.parse(args);
    }

    public ParseResult parseArgs(String ... args) {
        this.interpreter.parse(args);
        return this.interpreter.parseResult.build();
    }

    public ParseResult getParseResult() {
        return this.interpreter.parseResult == null ? null : this.interpreter.parseResult.build();
    }

    public static DefaultExceptionHandler<List<Object>> defaultExceptionHandler() {
        return new DefaultExceptionHandler<List<Object>>();
    }

    @Deprecated
    public static boolean printHelpIfRequested(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
        return CommandLine.printHelpIfRequested(parsedCommands, out, out, ansi);
    }

    public static boolean printHelpIfRequested(ParseResult parseResult) {
        return CommandLine.printHelpIfRequested(parseResult.asCommandLineList(), System.out, System.err, Help.Ansi.AUTO);
    }

    public static boolean printHelpIfRequested(List<CommandLine> parsedCommands, PrintStream out, PrintStream err, Help.Ansi ansi) {
        return CommandLine.printHelpIfRequested(parsedCommands, out, err, Help.defaultColorScheme(ansi));
    }

    public static boolean printHelpIfRequested(List<CommandLine> parsedCommands, PrintStream out, PrintStream err, Help.ColorScheme colorScheme) {
        for (int i = 0; i < parsedCommands.size(); ++i) {
            CommandLine parsed = parsedCommands.get(i);
            if (parsed.isUsageHelpRequested()) {
                parsed.usage(out, colorScheme);
                return true;
            }
            if (parsed.isVersionHelpRequested()) {
                parsed.printVersionHelp(out, colorScheme.ansi);
                return true;
            }
            if (!parsed.getCommandSpec().helpCommand()) continue;
            if (parsed.getCommand() instanceof IHelpCommandInitializable) {
                ((IHelpCommandInitializable)parsed.getCommand()).init(parsed, colorScheme.ansi, out, err);
            }
            CommandLine.execute(parsed, new ArrayList<Object>());
            return true;
        }
        return false;
    }

    private static List<Object> execute(CommandLine parsed, List<Object> executionResult) {
        Object command = parsed.getCommand();
        if (command instanceof Runnable) {
            try {
                ((Runnable)command).run();
                executionResult.add(null);
                return executionResult;
            }
            catch (ParameterException ex) {
                throw ex;
            }
            catch (ExecutionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExecutionException(parsed, "Error while running command (" + command + "): " + ex, ex);
            }
        }
        if (command instanceof Callable) {
            try {
                Callable callable = (Callable)command;
                executionResult.add(callable.call());
                return executionResult;
            }
            catch (ParameterException ex) {
                throw ex;
            }
            catch (ExecutionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExecutionException(parsed, "Error while calling command (" + command + "): " + ex, ex);
            }
        }
        if (command instanceof Method) {
            try {
                if (Modifier.isStatic(((Method)command).getModifiers())) {
                    executionResult.add(((Method)command).invoke(null, parsed.getCommandSpec().argValues()));
                    return executionResult;
                }
                if (parsed.getCommandSpec().parent() != null) {
                    executionResult.add(((Method)command).invoke(parsed.getCommandSpec().parent().userObject(), parsed.getCommandSpec().argValues()));
                    return executionResult;
                }
                for (Constructor<?> constructor : ((Method)command).getDeclaringClass().getDeclaredConstructors()) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    executionResult.add(((Method)command).invoke(constructor.newInstance(new Object[0]), parsed.getCommandSpec().argValues()));
                    return executionResult;
                }
                throw new UnsupportedOperationException("Invoking non-static method without default constructor not implemented");
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getTargetException();
                if (t instanceof ParameterException) {
                    throw (ParameterException)t;
                }
                if (t instanceof ExecutionException) {
                    throw (ExecutionException)t;
                }
                throw new ExecutionException(parsed, "Error while calling command (" + command + "): " + t, t);
            }
            catch (Exception ex) {
                throw new ExecutionException(parsed, "Unhandled error while calling command (" + command + "): " + ex, ex);
            }
        }
        throw new ExecutionException(parsed, "Parsed command (" + command + ") is not Method, Runnable or Callable");
    }

    @Deprecated
    public List<Object> parseWithHandler(IParseResultHandler handler, PrintStream out, String ... args) {
        return this.parseWithHandlers(handler, out, Help.Ansi.AUTO, CommandLine.defaultExceptionHandler(), args);
    }

    public <R> R parseWithHandler(IParseResultHandler2<R> handler, String[] args) {
        return this.parseWithHandlers(handler, new DefaultExceptionHandler(), args);
    }

    @Deprecated
    public List<Object> parseWithHandlers(IParseResultHandler handler, PrintStream out, Help.Ansi ansi, IExceptionHandler exceptionHandler, String ... args) {
        try {
            List<CommandLine> result = this.parse(args);
            return handler.handleParseResult(result, out, ansi);
        }
        catch (ParameterException ex) {
            return exceptionHandler.handleException(ex, out, ansi, args);
        }
    }

    public <R> R parseWithHandlers(IParseResultHandler2<R> handler, IExceptionHandler2<R> exceptionHandler, String ... args) {
        ParseResult parseResult = null;
        try {
            parseResult = this.parseArgs(args);
            return handler.handleParseResult(parseResult);
        }
        catch (ParameterException ex) {
            return exceptionHandler.handleParseException(ex, args);
        }
        catch (ExecutionException ex) {
            return exceptionHandler.handleExecutionException(ex, parseResult);
        }
    }

    static String versionString() {
        return String.format("%s, JVM: %s (%s %s %s), OS: %s %s %s", VERSION, System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    }

    public static void usage(Object command, PrintStream out) {
        CommandLine.toCommandLine(command, new DefaultFactory()).usage(out);
    }

    public static void usage(Object command, PrintStream out, Help.Ansi ansi) {
        CommandLine.toCommandLine(command, new DefaultFactory()).usage(out, ansi);
    }

    public static void usage(Object command, PrintStream out, Help.ColorScheme colorScheme) {
        CommandLine.toCommandLine(command, new DefaultFactory()).usage(out, colorScheme);
    }

    public void usage(PrintStream out) {
        this.usage(out, Help.Ansi.AUTO);
    }

    public void usage(PrintWriter writer) {
        this.usage(writer, Help.Ansi.AUTO);
    }

    public void usage(PrintStream out, Help.Ansi ansi) {
        this.usage(out, Help.defaultColorScheme(ansi));
    }

    public void usage(PrintWriter writer, Help.Ansi ansi) {
        this.usage(writer, Help.defaultColorScheme(ansi));
    }

    public void usage(PrintStream out, Help.ColorScheme colorScheme) {
        out.print(this.usage(new StringBuilder(), this.getHelpFactory().create(this.getCommandSpec(), colorScheme)));
    }

    public void usage(PrintWriter writer, Help.ColorScheme colorScheme) {
        writer.print(this.usage(new StringBuilder(), this.getHelpFactory().create(this.getCommandSpec(), colorScheme)));
    }

    public String getUsageMessage() {
        return this.usage(new StringBuilder(), this.getHelpFactory().create(this.getCommandSpec(), Help.defaultColorScheme(Help.Ansi.AUTO))).toString();
    }

    public String getUsageMessage(Help.Ansi ansi) {
        return this.usage(new StringBuilder(), this.getHelpFactory().create(this.getCommandSpec(), Help.defaultColorScheme(ansi))).toString();
    }

    public String getUsageMessage(Help.ColorScheme colorScheme) {
        return this.usage(new StringBuilder(), this.getHelpFactory().create(this.getCommandSpec(), colorScheme)).toString();
    }

    private StringBuilder usage(StringBuilder sb, Help help) {
        for (String key : this.getHelpSectionKeys()) {
            IHelpSectionRenderer renderer = this.getHelpSectionMap().get(key);
            if (renderer == null) continue;
            sb.append(renderer.render(help));
        }
        return sb;
    }

    public void printVersionHelp(PrintStream out) {
        this.printVersionHelp(out, Help.Ansi.AUTO);
    }

    public void printVersionHelp(PrintStream out, Help.Ansi ansi) {
        for (String versionInfo : this.getCommandSpec().version()) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            out.println(ansi2.new Help.Ansi.Text(versionInfo));
        }
    }

    public void printVersionHelp(PrintStream out, Help.Ansi ansi, Object ... params) {
        for (String versionInfo : this.getCommandSpec().version()) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            out.println(ansi2.new Help.Ansi.Text(CommandLine.format(versionInfo, params)));
        }
    }

    public static <C extends Callable<T>, T> T call(C callable, String ... args) {
        return CommandLine.call(callable, System.out, System.err, Help.Ansi.AUTO, args);
    }

    public static <C extends Callable<T>, T> T call(C callable, PrintStream out, String ... args) {
        return CommandLine.call(callable, out, System.err, Help.Ansi.AUTO, args);
    }

    public static <C extends Callable<T>, T> T call(C callable, PrintStream out, Help.Ansi ansi, String ... args) {
        return CommandLine.call(callable, out, System.err, ansi, args);
    }

    public static <C extends Callable<T>, T> T call(C callable, PrintStream out, PrintStream err, Help.Ansi ansi, String ... args) {
        CommandLine cmd = new CommandLine(callable);
        List results = (List)cmd.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(out)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(err)).useAnsi(ansi), args);
        T result = results == null || results.isEmpty() ? null : (T)results.get(0);
        return result;
    }

    public static <C extends Callable<T>, T> T call(Class<C> callableClass, IFactory factory, String ... args) {
        return CommandLine.call(callableClass, factory, System.out, System.err, Help.Ansi.AUTO, args);
    }

    public static <C extends Callable<T>, T> T call(Class<C> callableClass, IFactory factory, PrintStream out, String ... args) {
        return CommandLine.call(callableClass, factory, out, System.err, Help.Ansi.AUTO, args);
    }

    public static <C extends Callable<T>, T> T call(Class<C> callableClass, IFactory factory, PrintStream out, Help.Ansi ansi, String ... args) {
        return CommandLine.call(callableClass, factory, out, System.err, ansi, args);
    }

    public static <C extends Callable<T>, T> T call(Class<C> callableClass, IFactory factory, PrintStream out, PrintStream err, Help.Ansi ansi, String ... args) {
        CommandLine cmd = new CommandLine(callableClass, factory);
        List results = (List)cmd.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(out)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(err)).useAnsi(ansi), args);
        T result = results == null || results.isEmpty() ? null : (T)results.get(0);
        return result;
    }

    public static <R extends Runnable> void run(R runnable, String ... args) {
        CommandLine.run(runnable, System.out, System.err, Help.Ansi.AUTO, args);
    }

    public static <R extends Runnable> void run(R runnable, PrintStream out, String ... args) {
        CommandLine.run(runnable, out, System.err, Help.Ansi.AUTO, args);
    }

    public static <R extends Runnable> void run(R runnable, PrintStream out, Help.Ansi ansi, String ... args) {
        CommandLine.run(runnable, out, System.err, ansi, args);
    }

    public static <R extends Runnable> void run(R runnable, PrintStream out, PrintStream err, Help.Ansi ansi, String ... args) {
        CommandLine cmd = new CommandLine(runnable);
        cmd.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(out)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(err)).useAnsi(ansi), args);
    }

    public static <R extends Runnable> void run(Class<R> runnableClass, IFactory factory, String ... args) {
        CommandLine.run(runnableClass, factory, System.out, System.err, Help.Ansi.AUTO, args);
    }

    public static <R extends Runnable> void run(Class<R> runnableClass, IFactory factory, PrintStream out, String ... args) {
        CommandLine.run(runnableClass, factory, out, System.err, Help.Ansi.AUTO, args);
    }

    public static <R extends Runnable> void run(Class<R> runnableClass, IFactory factory, PrintStream out, Help.Ansi ansi, String ... args) {
        CommandLine.run(runnableClass, factory, out, System.err, ansi, args);
    }

    public static <R extends Runnable> void run(Class<R> runnableClass, IFactory factory, PrintStream out, PrintStream err, Help.Ansi ansi, String ... args) {
        CommandLine cmd = new CommandLine(runnableClass, factory);
        cmd.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(out)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(err)).useAnsi(ansi), args);
    }

    public static Object invoke(String methodName, Class<?> cls, String ... args) {
        return CommandLine.invoke(methodName, cls, System.out, System.err, Help.Ansi.AUTO, args);
    }

    public static Object invoke(String methodName, Class<?> cls, PrintStream out, String ... args) {
        return CommandLine.invoke(methodName, cls, out, System.err, Help.Ansi.AUTO, args);
    }

    public static Object invoke(String methodName, Class<?> cls, PrintStream out, Help.Ansi ansi, String ... args) {
        return CommandLine.invoke(methodName, cls, out, System.err, ansi, args);
    }

    public static Object invoke(String methodName, Class<?> cls, PrintStream out, PrintStream err, Help.Ansi ansi, String ... args) {
        List<Method> candidates = CommandLine.getCommandMethods(cls, methodName);
        if (candidates.size() != 1) {
            throw new InitializationException("Expected exactly one @Command-annotated method for " + cls.getName() + "::" + methodName + "(...), but got: " + candidates);
        }
        Method method = candidates.get(0);
        CommandLine cmd = new CommandLine(method);
        List list = (List)cmd.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(out)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(err)).useAnsi(ansi), args);
        return list == null ? null : list.get(0);
    }

    public static List<Method> getCommandMethods(Class<?> cls, String methodName) {
        HashSet<Method> candidates = new HashSet<Method>();
        candidates.addAll(Arrays.asList(Assert.notNull(cls, "class").getMethods()));
        candidates.addAll(Arrays.asList(Assert.notNull(cls, "class").getDeclaredMethods()));
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : candidates) {
            if (!method.isAnnotationPresent(Command.class) || methodName != null && !methodName.equals(method.getName())) continue;
            result.add(method);
        }
        Collections.sort(result, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }

    public <K> CommandLine registerConverter(Class<K> cls, ITypeConverter<K> converter) {
        this.interpreter.converterRegistry.put(Assert.notNull(cls, "class"), Assert.notNull(converter, "converter"));
        for (CommandLine command : this.getCommandSpec().commands.values()) {
            command.registerConverter(cls, converter);
        }
        return this;
    }

    public String getSeparator() {
        return this.getCommandSpec().parser().separator();
    }

    public CommandLine setSeparator(String separator) {
        this.getCommandSpec().parser().separator(Assert.notNull(separator, "separator"));
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setSeparator(separator);
        }
        return this;
    }

    public ResourceBundle getResourceBundle() {
        return this.getCommandSpec().resourceBundle();
    }

    public CommandLine setResourceBundle(ResourceBundle bundle) {
        this.getCommandSpec().resourceBundle(bundle);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.getCommandSpec().resourceBundle(bundle);
        }
        return this;
    }

    public int getUsageHelpWidth() {
        return this.getCommandSpec().usageMessage().width();
    }

    public CommandLine setUsageHelpWidth(int width) {
        this.getCommandSpec().usageMessage().width(width);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setUsageHelpWidth(width);
        }
        return this;
    }

    public String getCommandName() {
        return this.getCommandSpec().name();
    }

    public CommandLine setCommandName(String commandName) {
        this.getCommandSpec().name(Assert.notNull(commandName, "commandName"));
        return this;
    }

    public boolean isExpandAtFiles() {
        return this.getCommandSpec().parser().expandAtFiles();
    }

    public CommandLine setExpandAtFiles(boolean expandAtFiles) {
        this.getCommandSpec().parser().expandAtFiles(expandAtFiles);
        return this;
    }

    public Character getAtFileCommentChar() {
        return this.getCommandSpec().parser().atFileCommentChar();
    }

    public CommandLine setAtFileCommentChar(Character atFileCommentChar) {
        this.getCommandSpec().parser().atFileCommentChar(atFileCommentChar);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setAtFileCommentChar(atFileCommentChar);
        }
        return this;
    }

    public boolean isUseSimplifiedAtFiles() {
        return this.getCommandSpec().parser().useSimplifiedAtFiles();
    }

    public CommandLine setUseSimplifiedAtFiles(boolean simplifiedAtFiles) {
        this.getCommandSpec().parser().useSimplifiedAtFiles(simplifiedAtFiles);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setUseSimplifiedAtFiles(simplifiedAtFiles);
        }
        return this;
    }

    private static boolean empty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static boolean empty(Object[] array) {
        return array == null || array.length == 0;
    }

    private static String str(String[] arr, int i) {
        return arr == null || arr.length <= i ? "" : arr[i];
    }

    private static boolean isBoolean(Class<?> type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }

    private static CommandLine toCommandLine(Object obj, IFactory factory) {
        return obj instanceof CommandLine ? (CommandLine)obj : new CommandLine(obj, factory);
    }

    private static boolean isMultiValue(Class<?> cls) {
        return cls.isArray() || Collection.class.isAssignableFrom(cls) || Map.class.isAssignableFrom(cls);
    }

    private static String format(String formatString, Object ... params) {
        try {
            return formatString == null ? "" : String.format(formatString, params);
        }
        catch (IllegalFormatException ex) {
            new Tracer().warn("Could not format '%s' (Underlying error: %s). Using raw String: '%%n' format strings have not been replaced with newlines. Please ensure to escape '%%' characters with another '%%'.%n", formatString, ex.getMessage());
            return formatString;
        }
    }

    static IFactory defaultFactory() {
        return new DefaultFactory();
    }

    private static void validatePositionalParameters(List<Model.PositionalParamSpec> positionalParametersFields) {
        int min = 0;
        for (Model.PositionalParamSpec positional : positionalParametersFields) {
            Range index = positional.index();
            if (index.min > min) {
                throw new ParameterIndexGapException("Command definition should have a positional parameter with index=" + min + ". Nearest positional parameter '" + positional.paramLabel() + "' has index=" + index.min);
            }
            min = (min = Math.max(min, index.max)) == Integer.MAX_VALUE ? min : min + 1;
        }
    }

    private static Stack<String> copy(Stack<String> stack) {
        return (Stack)stack.clone();
    }

    private static <T> Stack<T> reverse(Stack<T> stack) {
        Collections.reverse(stack);
        return stack;
    }

    private static <T> List<T> reverseList(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    public static class MissingTypeConverterException
    extends ParameterException {
        private static final long serialVersionUID = -6050931703233083760L;

        public MissingTypeConverterException(CommandLine commandLine, String msg) {
            super(commandLine, msg);
        }
    }

    public static class OverwrittenOptionException
    extends ParameterException {
        private static final long serialVersionUID = 1338029208271055776L;
        private final Model.ArgSpec overwrittenArg;

        public OverwrittenOptionException(CommandLine commandLine, Model.ArgSpec overwritten, String msg) {
            super(commandLine, msg);
            this.overwrittenArg = overwritten;
        }

        public Model.ArgSpec getOverwritten() {
            return this.overwrittenArg;
        }
    }

    public static class MaxValuesExceededException
    extends ParameterException {
        private static final long serialVersionUID = 6536145439570100641L;

        public MaxValuesExceededException(CommandLine commandLine, String msg) {
            super(commandLine, msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnmatchedArgumentException
    extends ParameterException {
        private static final long serialVersionUID = -8700426380701452440L;
        private List<String> unmatched = Collections.emptyList();

        public UnmatchedArgumentException(CommandLine commandLine, String msg) {
            super(commandLine, msg);
        }

        public UnmatchedArgumentException(CommandLine commandLine, Stack<String> args) {
            this(commandLine, new ArrayList<String>(CommandLine.reverse(args)));
        }

        public UnmatchedArgumentException(CommandLine commandLine, List<String> args) {
            this(commandLine, UnmatchedArgumentException.describe(args, commandLine) + (args.size() == 1 ? ": " : "s: ") + UnmatchedArgumentException.str(args));
            this.unmatched = args == null ? Collections.emptyList() : args;
        }

        public static boolean printSuggestions(ParameterException ex, PrintStream out) {
            return ex instanceof UnmatchedArgumentException && ((UnmatchedArgumentException)ex).printSuggestions(out);
        }

        public List<String> getUnmatched() {
            return UnmatchedArgumentException.stripErrorMessage(this.unmatched);
        }

        static List<String> stripErrorMessage(List<String> unmatched) {
            ArrayList<String> result = new ArrayList<String>();
            for (String s : unmatched) {
                int pos;
                if (s == null) {
                    result.add(null);
                }
                result.add((pos = s.indexOf(" (while processing option:")) < 0 ? s : s.substring(0, pos));
            }
            return Collections.unmodifiableList(result);
        }

        public boolean isUnknownOption() {
            return UnmatchedArgumentException.isUnknownOption(this.unmatched, this.getCommandLine());
        }

        public boolean printSuggestions(PrintStream out) {
            List<String> suggestions = this.getSuggestions();
            if (!suggestions.isEmpty()) {
                out.println(this.isUnknownOption() ? "Possible solutions: " + UnmatchedArgumentException.str(suggestions) : "Did you mean: " + UnmatchedArgumentException.str(suggestions).replace(", ", " or ") + "?");
            }
            return !suggestions.isEmpty();
        }

        public List<String> getSuggestions() {
            if (this.unmatched == null || this.unmatched.isEmpty()) {
                return Collections.emptyList();
            }
            String arg = this.unmatched.get(0);
            String stripped = Model.CommandSpec.stripPrefix(arg);
            Model.CommandSpec spec = this.getCommandLine().getCommandSpec();
            if (spec.resemblesOption(arg, null)) {
                return spec.findOptionNamesWithPrefix(stripped.substring(0, Math.min(2, stripped.length())));
            }
            if (!spec.subcommands().isEmpty()) {
                List<String> mostSimilar = CosineSimilarity.mostSimilar(arg, spec.subcommands().keySet());
                return mostSimilar.subList(0, Math.min(3, mostSimilar.size()));
            }
            return Collections.emptyList();
        }

        private static boolean isUnknownOption(List<String> unmatch, CommandLine cmd) {
            return unmatch != null && !unmatch.isEmpty() && cmd.getCommandSpec().resemblesOption(unmatch.get(0), null);
        }

        private static String describe(List<String> unmatch, CommandLine cmd) {
            return UnmatchedArgumentException.isUnknownOption(unmatch, cmd) ? "Unknown option" : "Unmatched argument";
        }

        static String str(List<String> list) {
            String s = list.toString();
            return s.substring(0, s.length() - 1).substring(1);
        }
    }

    public static class ParameterIndexGapException
    extends InitializationException {
        private static final long serialVersionUID = -1520981133257618319L;

        public ParameterIndexGapException(String msg) {
            super(msg);
        }
    }

    public static class DuplicateOptionAnnotationsException
    extends InitializationException {
        private static final long serialVersionUID = -3355128012575075641L;

        public DuplicateOptionAnnotationsException(String msg) {
            super(msg);
        }

        private static DuplicateOptionAnnotationsException create(String name, Model.ArgSpec argSpec1, Model.ArgSpec argSpec2) {
            return new DuplicateOptionAnnotationsException("Option name '" + name + "' is used by both " + argSpec1.toString() + " and " + argSpec2.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MissingParameterException
    extends ParameterException {
        private static final long serialVersionUID = 5075678535706338753L;
        private final List<Model.ArgSpec> missing;

        public MissingParameterException(CommandLine commandLine, Model.ArgSpec missing, String msg) {
            this(commandLine, Arrays.asList(missing), msg);
        }

        public MissingParameterException(CommandLine commandLine, Collection<Model.ArgSpec> missing, String msg) {
            super(commandLine, msg);
            this.missing = Collections.unmodifiableList(new ArrayList<Model.ArgSpec>(missing));
        }

        public List<Model.ArgSpec> getMissing() {
            return this.missing;
        }

        private static MissingParameterException create(CommandLine cmd, Collection<Model.ArgSpec> missing, String separator) {
            if (missing.size() == 1) {
                return new MissingParameterException(cmd, missing, "Missing required option '" + MissingParameterException.describe(missing.iterator().next(), separator) + "'");
            }
            ArrayList<String> names = new ArrayList<String>(missing.size());
            for (Model.ArgSpec argSpec : missing) {
                names.add(MissingParameterException.describe(argSpec, separator));
            }
            return new MissingParameterException(cmd, missing, "Missing required options " + ((Object)names).toString());
        }

        private static String describe(Model.ArgSpec argSpec, String separator) {
            String prefix = argSpec.isOption() ? ((Model.OptionSpec)argSpec).longestName() + separator : "params[" + ((Model.PositionalParamSpec)argSpec).index() + "]" + separator;
            return prefix + argSpec.paramLabel();
        }
    }

    public static class ParameterException
    extends PicocliException {
        private static final long serialVersionUID = 1477112829129763139L;
        private final CommandLine commandLine;
        private Model.ArgSpec argSpec = null;
        private String value = null;

        public ParameterException(CommandLine commandLine, String msg) {
            super(msg);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public ParameterException(CommandLine commandLine, String msg, Throwable t) {
            super(msg, t);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public ParameterException(CommandLine commandLine, String msg, Throwable t, Model.ArgSpec argSpec, String value) {
            super(msg, t);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
            if (argSpec == null && value == null) {
                throw new IllegalArgumentException("ArgSpec and value cannot both be null");
            }
            this.argSpec = argSpec;
            this.value = value;
        }

        public ParameterException(CommandLine commandLine, String msg, Model.ArgSpec argSpec, String value) {
            super(msg);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
            if (argSpec == null && value == null) {
                throw new IllegalArgumentException("ArgSpec and value cannot both be null");
            }
            this.argSpec = argSpec;
            this.value = value;
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }

        public Model.ArgSpec getArgSpec() {
            return this.argSpec;
        }

        public String getValue() {
            return this.value;
        }

        private static ParameterException create(CommandLine cmd, Exception ex, String arg, int i, String[] args) {
            String msg = ex.getClass().getSimpleName() + ": " + ex.getLocalizedMessage() + " while processing argument at or before arg[" + i + "] '" + arg + "' in " + Arrays.toString(args) + ": " + ex.toString();
            return new ParameterException(cmd, msg, ex, null, arg);
        }
    }

    public static class TypeConversionException
    extends PicocliException {
        private static final long serialVersionUID = 4251973913816346114L;

        public TypeConversionException(String msg) {
            super(msg);
        }
    }

    public static class ExecutionException
    extends PicocliException {
        private static final long serialVersionUID = 7764539594267007998L;
        private final CommandLine commandLine;

        public ExecutionException(CommandLine commandLine, String msg) {
            super(msg);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public ExecutionException(CommandLine commandLine, String msg, Throwable t) {
            super(msg, t);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }
    }

    public static class InitializationException
    extends PicocliException {
        private static final long serialVersionUID = 8423014001666638895L;

        public InitializationException(String msg) {
            super(msg);
        }

        public InitializationException(String msg, Exception ex) {
            super(msg, ex);
        }
    }

    public static class PicocliException
    extends RuntimeException {
        private static final long serialVersionUID = -2574128880125050818L;

        public PicocliException(String msg) {
            super(msg);
        }

        public PicocliException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CosineSimilarity {
        private CosineSimilarity() {
        }

        static List<String> mostSimilar(String pattern, Iterable<String> candidates) {
            return CosineSimilarity.mostSimilar(pattern, candidates, 0.0);
        }

        static List<String> mostSimilar(String pattern, Iterable<String> candidates, double threshold) {
            pattern = pattern.toLowerCase();
            TreeMap<Double, String> sorted = new TreeMap<Double, String>();
            for (String candidate : candidates) {
                double score = CosineSimilarity.similarity(pattern, candidate.toLowerCase(), 2);
                if (!(score > threshold)) continue;
                sorted.put(score, candidate);
            }
            return CommandLine.reverseList(new ArrayList(sorted.values()));
        }

        private static double similarity(String sequence1, String sequence2, int degree) {
            Map<String, Integer> m1 = CosineSimilarity.countNgramFrequency(sequence1, degree);
            Map<String, Integer> m2 = CosineSimilarity.countNgramFrequency(sequence2, degree);
            return CosineSimilarity.dotProduct(m1, m2) / Math.sqrt(CosineSimilarity.dotProduct(m1, m1) * CosineSimilarity.dotProduct(m2, m2));
        }

        private static Map<String, Integer> countNgramFrequency(String sequence, int degree) {
            HashMap<String, Integer> m = new HashMap<String, Integer>();
            int i = 0;
            while (i + degree <= sequence.length()) {
                String gram;
                m.put(gram, 1 + (m.containsKey(gram = sequence.substring(i, i + degree)) ? (Integer)m.get(gram) : 0));
                ++i;
            }
            return m;
        }

        private static double dotProduct(Map<String, Integer> m1, Map<String, Integer> m2) {
            double result = 0.0;
            for (String key : m1.keySet()) {
                result += (double)(m1.get(key) * (m2.containsKey(key) ? m2.get(key) : 0));
            }
            return result;
        }
    }

    static class Tracer {
        TraceLevel level = TraceLevel.lookup(System.getProperty("picocli.trace"));
        PrintStream stream = System.err;

        Tracer() {
        }

        void warn(String msg, Object ... params) {
            TraceLevel.WARN.print(this, msg, params);
        }

        void info(String msg, Object ... params) {
            TraceLevel.INFO.print(this, msg, params);
        }

        void debug(String msg, Object ... params) {
            TraceLevel.DEBUG.print(this, msg, params);
        }

        boolean isWarn() {
            return this.level.isEnabled(TraceLevel.WARN);
        }

        boolean isInfo() {
            return this.level.isEnabled(TraceLevel.INFO);
        }

        boolean isDebug() {
            return this.level.isEnabled(TraceLevel.DEBUG);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TraceLevel {
        OFF,
        WARN,
        INFO,
        DEBUG;


        public boolean isEnabled(TraceLevel other) {
            return this.ordinal() >= other.ordinal();
        }

        private void print(Tracer tracer, String msg, Object ... params) {
            if (tracer.level.isEnabled(this)) {
                tracer.stream.printf(this.prefix(msg), params);
            }
        }

        private String prefix(String msg) {
            return "[picocli " + (Object)((Object)this) + "] " + msg;
        }

        static TraceLevel lookup(String key) {
            return key == null ? WARN : (CommandLine.empty(key) || "true".equalsIgnoreCase(key) ? INFO : TraceLevel.valueOf(key));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Assert {
        static <T> T notNull(T object, String description) {
            if (object == null) {
                throw new NullPointerException(description);
            }
            return object;
        }

        static boolean equals(Object obj1, Object obj2) {
            return obj1 == null ? obj2 == null : obj1.equals(obj2);
        }

        static int hashCode(Object obj) {
            return obj == null ? 0 : obj.hashCode();
        }

        static int hashCode(boolean bool) {
            return bool ? 1 : 0;
        }

        static void assertTrue(boolean condition, String message) {
            if (!condition) {
                throw new IllegalStateException(message);
            }
        }

        private Assert() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Help {
        protected static final String DEFAULT_COMMAND_NAME = "<main class>";
        protected static final String DEFAULT_SEPARATOR = "=";
        private static final int defaultOptionsColumnWidth = 24;
        private final Model.CommandSpec commandSpec;
        private final ColorScheme colorScheme;
        private final Map<String, Help> commands = new LinkedHashMap<String, Help>();
        private List<String> aliases = Collections.emptyList();
        private IParamLabelRenderer parameterLabelRenderer;

        public Help(Object command) {
            this(command, Ansi.AUTO);
        }

        public Help(Object command, Ansi ansi) {
            this(command, Help.defaultColorScheme(ansi));
        }

        @Deprecated
        public Help(Object command, ColorScheme colorScheme) {
            this(Model.CommandSpec.forAnnotatedObject(command, new DefaultFactory()), colorScheme);
        }

        public Help(Model.CommandSpec commandSpec, ColorScheme colorScheme) {
            this.commandSpec = Assert.notNull(commandSpec, "commandSpec");
            this.aliases = new ArrayList<String>(Arrays.asList(commandSpec.aliases()));
            this.aliases.add(0, commandSpec.name());
            this.colorScheme = Assert.notNull(colorScheme, "colorScheme").applySystemProperties();
            this.parameterLabelRenderer = this.createDefaultParamLabelRenderer();
            this.addAllSubcommands(commandSpec.subcommands());
        }

        Help withCommandNames(List<String> aliases) {
            this.aliases = aliases;
            return this;
        }

        public Model.CommandSpec commandSpec() {
            return this.commandSpec;
        }

        public ColorScheme colorScheme() {
            return this.colorScheme;
        }

        private IHelpFactory getHelpFactory() {
            return this.commandSpec.usageMessage().helpFactory();
        }

        protected Map<String, Help> subcommands() {
            return Collections.unmodifiableMap(this.commands);
        }

        protected List<String> aliases() {
            return Collections.unmodifiableList(this.aliases);
        }

        public IParamLabelRenderer parameterLabelRenderer() {
            return this.parameterLabelRenderer;
        }

        public Help addAllSubcommands(Map<String, CommandLine> commands) {
            if (commands != null) {
                List aliases;
                IdentityHashMap<CommandLine, ArrayList<String>> done = new IdentityHashMap<CommandLine, ArrayList<String>>();
                for (CommandLine commandLine : commands.values()) {
                    if (done.containsKey(commandLine)) continue;
                    done.put(commandLine, new ArrayList<String>(Arrays.asList(commandLine.commandSpec.aliases())));
                }
                for (Map.Entry entry : commands.entrySet()) {
                    aliases = (List)done.get(entry.getValue());
                    if (aliases.contains(entry.getKey())) continue;
                    aliases.add(0, entry.getKey());
                }
                for (Map.Entry entry : commands.entrySet()) {
                    if (((CommandLine)entry.getValue()).getCommandSpec().usageMessage().hidden() || (aliases = (List)done.remove(entry.getValue())) == null) continue;
                    this.addSubcommand(aliases, (CommandLine)entry.getValue());
                }
            }
            return this;
        }

        Help addSubcommand(List<String> commandNames, CommandLine commandLine) {
            String all = commandNames.toString();
            this.commands.put(all.substring(1, all.length() - 1), this.getHelpFactory().create(commandLine.commandSpec, this.colorScheme).withCommandNames(commandNames));
            return this;
        }

        @Deprecated
        public Help addSubcommand(String commandName, Object command) {
            this.commands.put(commandName, this.getHelpFactory().create(Model.CommandSpec.forAnnotatedObject(command, this.commandSpec.commandLine().factory), Help.defaultColorScheme(Ansi.AUTO)));
            return this;
        }

        List<Model.OptionSpec> options() {
            return this.commandSpec.options();
        }

        List<Model.PositionalParamSpec> positionalParameters() {
            return this.commandSpec.positionalParameters();
        }

        String commandName() {
            return this.commandSpec.name();
        }

        @Deprecated
        public String synopsis() {
            return this.synopsis(0);
        }

        public String synopsis(int synopsisHeadingLength) {
            if (!CommandLine.empty(this.commandSpec.usageMessage().customSynopsis())) {
                return this.customSynopsis(new Object[0]);
            }
            return this.commandSpec.usageMessage().abbreviateSynopsis() ? this.abbreviatedSynopsis() : this.detailedSynopsis(synopsisHeadingLength, Help.createShortOptionArityAndNameComparator(), true);
        }

        public String abbreviatedSynopsis() {
            StringBuilder sb = new StringBuilder();
            if (!this.commandSpec.optionsMap().isEmpty()) {
                sb.append(" [OPTIONS]");
            }
            for (Model.PositionalParamSpec positionalParam : this.commandSpec.positionalParameters()) {
                if (positionalParam.hidden()) continue;
                sb.append(' ').append(this.parameterLabelRenderer().renderParameterLabel(positionalParam, this.ansi(), this.colorScheme.parameterStyles));
            }
            if (!this.commandSpec.subcommands().isEmpty()) {
                sb.append(" [COMMAND]");
            }
            return this.colorScheme.commandText(this.commandSpec.qualifiedName()).toString() + sb.toString() + System.getProperty("line.separator");
        }

        @Deprecated
        public String detailedSynopsis(Comparator<Model.OptionSpec> optionSort, boolean clusterBooleanOptions) {
            return this.detailedSynopsis(0, optionSort, clusterBooleanOptions);
        }

        public String detailedSynopsis(int synopsisHeadingLength, Comparator<Model.OptionSpec> optionSort, boolean clusterBooleanOptions) {
            Ansi.Text optionText = this.createDetailedSynopsisOptionsText(optionSort, clusterBooleanOptions);
            Ansi.Text positionalParamText = this.createDetailedSynopsisPositionalsText();
            Ansi.Text commandText = this.createDetailedSynopsisCommandText();
            Ansi.Text text = optionText.concat(positionalParamText).concat(commandText);
            return this.insertSynopsisCommandName(synopsisHeadingLength, text);
        }

        protected Ansi.Text createDetailedSynopsisOptionsText(Comparator<Model.OptionSpec> optionSort, boolean clusterBooleanOptions) {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text optionText = ansi.new Ansi.Text(0);
            ArrayList<Model.OptionSpec> options = new ArrayList<Model.OptionSpec>(this.commandSpec.options());
            if (optionSort != null) {
                Collections.sort(options, optionSort);
            }
            if (clusterBooleanOptions) {
                ArrayList<Model.OptionSpec> booleanOptions = new ArrayList<Model.OptionSpec>();
                StringBuilder clusteredRequired = new StringBuilder("-");
                StringBuilder clusteredOptional = new StringBuilder("-");
                for (Model.OptionSpec option : options) {
                    String shortestName;
                    boolean isFlagOption;
                    if (option.hidden() || !(isFlagOption = option.type() == Boolean.TYPE || option.type() == Boolean.class) || option.arity().max > 0 || (shortestName = option.shortestName()).length() != 2 || !shortestName.startsWith("-")) continue;
                    booleanOptions.add(option);
                    if (option.required()) {
                        clusteredRequired.append(shortestName.substring(1));
                        continue;
                    }
                    clusteredOptional.append(shortestName.substring(1));
                }
                options.removeAll(booleanOptions);
                if (clusteredRequired.length() > 1) {
                    optionText = optionText.concat(" ").concat(this.colorScheme.optionText(clusteredRequired.toString()));
                }
                if (clusteredOptional.length() > 1) {
                    optionText = optionText.concat(" [").concat(this.colorScheme.optionText(clusteredOptional.toString())).concat("]");
                }
            }
            for (Model.OptionSpec option : options) {
                if (option.hidden()) continue;
                Ansi.Text name = this.colorScheme.optionText(option.shortestName());
                Ansi.Text param = this.parameterLabelRenderer().renderParameterLabel(option, this.colorScheme.ansi(), this.colorScheme.optionParamStyles);
                if (option.required()) {
                    optionText = optionText.concat(" ").concat(name).concat(param).concat("");
                    if (!option.isMultiValue()) continue;
                    optionText = optionText.concat(" [").concat(name).concat(param).concat("]...");
                    continue;
                }
                optionText = optionText.concat(" [").concat(name).concat(param).concat("]");
                if (!option.isMultiValue()) continue;
                optionText = optionText.concat("...");
            }
            return optionText;
        }

        protected Ansi.Text createDetailedSynopsisPositionalsText() {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text positionalParamText = ansi.new Ansi.Text(0);
            for (Model.PositionalParamSpec positionalParam : this.commandSpec.positionalParameters()) {
                if (positionalParam.hidden()) continue;
                positionalParamText = positionalParamText.concat(" ");
                Ansi.Text label = this.parameterLabelRenderer().renderParameterLabel(positionalParam, this.colorScheme.ansi(), this.colorScheme.parameterStyles);
                positionalParamText = positionalParamText.concat(label);
            }
            return positionalParamText;
        }

        protected Ansi.Text createDetailedSynopsisCommandText() {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text commandText = ansi.new Ansi.Text(0);
            if (!this.commandSpec.subcommands().isEmpty()) {
                commandText = commandText.concat(" [").concat("COMMAND").concat("]");
            }
            return commandText;
        }

        protected String insertSynopsisCommandName(int synopsisHeadingLength, Ansi.Text optionsAndPositionalsAndCommandsDetails) {
            String commandName = this.commandSpec.qualifiedName();
            int firstColumnLength = commandName.length() + synopsisHeadingLength;
            TextTable textTable = TextTable.forColumnWidths(this.ansi(), firstColumnLength, this.width() - firstColumnLength);
            textTable.indentWrappedLines = 1;
            Ansi ansi = Ansi.OFF;
            ((Object)((Object)ansi)).getClass();
            Ansi.Text PADDING = ansi.new Ansi.Text(Help.stringOf('X', synopsisHeadingLength));
            textTable.addRowValues(PADDING.concat(this.colorScheme.commandText(commandName)), optionsAndPositionalsAndCommandsDetails);
            return textTable.toString().substring(synopsisHeadingLength);
        }

        public int synopsisHeadingLength() {
            Ansi ansi = Ansi.OFF;
            ((Object)((Object)ansi)).getClass();
            String[] lines = ansi.new Ansi.Text(this.commandSpec.usageMessage().synopsisHeading()).toString().split("\\r?\\n|\\r|%n", -1);
            return lines[lines.length - 1].length();
        }

        public String optionList() {
            Comparator<Model.OptionSpec> sortOrder = this.commandSpec.usageMessage().sortOptions() ? Help.createShortOptionNameComparator() : Help.createOrderComparatorIfNecessary(this.commandSpec.options());
            return this.optionList(this.createLayout(this.calcLongOptionColumnWidth()), sortOrder, this.parameterLabelRenderer());
        }

        private static Comparator<Model.OptionSpec> createOrderComparatorIfNecessary(List<Model.OptionSpec> options) {
            for (Model.OptionSpec option : options) {
                if (option.order() == -1) continue;
                return Help.createOrderComparator();
            }
            return null;
        }

        private int calcLongOptionColumnWidth() {
            int max = 0;
            DefaultOptionRenderer optionRenderer = new DefaultOptionRenderer(false, " ");
            for (Model.OptionSpec option : this.commandSpec.options()) {
                Ansi.Text[][] values = optionRenderer.render(option, this.parameterLabelRenderer(), this.colorScheme);
                int len = values[0][3].length;
                if (len >= 21) continue;
                max = Math.max(max, len);
            }
            DefaultParameterRenderer paramRenderer = new DefaultParameterRenderer(false, " ");
            for (Model.PositionalParamSpec positional : this.commandSpec.positionalParameters()) {
                Ansi.Text[][] values = paramRenderer.render(positional, this.parameterLabelRenderer(), this.colorScheme);
                int len = values[0][3].length;
                if (len >= 21) continue;
                max = Math.max(max, len);
            }
            return max + 3;
        }

        public String optionList(Layout layout, Comparator<Model.OptionSpec> optionSort, IParamLabelRenderer valueLabelRenderer) {
            ArrayList<Model.OptionSpec> options = new ArrayList<Model.OptionSpec>(this.commandSpec.options());
            if (optionSort != null) {
                Collections.sort(options, optionSort);
            }
            layout.addOptions(options, valueLabelRenderer);
            return layout.toString();
        }

        public String parameterList() {
            return this.parameterList(this.createLayout(this.calcLongOptionColumnWidth()), this.parameterLabelRenderer());
        }

        public String parameterList(Layout layout, IParamLabelRenderer paramLabelRenderer) {
            layout.addPositionalParameters(this.commandSpec.positionalParameters(), paramLabelRenderer);
            return layout.toString();
        }

        private static String heading(Ansi ansi, int usageWidth, String values, Object ... params) {
            StringBuilder sb = Help.join(ansi, usageWidth, new String[]{values}, new StringBuilder(), params);
            return Help.trimLineSeparator(sb.toString()) + new String(Help.spaces(Help.countTrailingSpaces(values)));
        }

        static String trimLineSeparator(String result) {
            return result.endsWith(System.getProperty("line.separator")) ? result.substring(0, result.length() - System.getProperty("line.separator").length()) : result;
        }

        private static char[] spaces(int length) {
            char[] result = new char[length];
            Arrays.fill(result, ' ');
            return result;
        }

        private static int countTrailingSpaces(String str) {
            if (str == null) {
                return 0;
            }
            int trailingSpaces = 0;
            for (int i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
                ++trailingSpaces;
            }
            return trailingSpaces;
        }

        public static StringBuilder join(Ansi ansi, int usageHelpWidth, String[] values, StringBuilder sb, Object ... params) {
            if (values != null) {
                TextTable table = TextTable.forColumnWidths(ansi, usageHelpWidth);
                table.indentWrappedLines = 0;
                for (String summaryLine : values) {
                    Ansi.Text[] lines;
                    Ansi ansi2 = ansi;
                    ((Object)((Object)ansi2)).getClass();
                    for (Ansi.Text line : lines = ansi2.new Ansi.Text(CommandLine.format(summaryLine, params)).splitLines()) {
                        table.addRowValues(line);
                    }
                }
                table.toString(sb);
            }
            return sb;
        }

        private int width() {
            return this.commandSpec.usageMessage().width();
        }

        public String customSynopsis(Object ... params) {
            return Help.join(this.ansi(), this.width(), this.commandSpec.usageMessage().customSynopsis(), new StringBuilder(), params).toString();
        }

        public String description(Object ... params) {
            return Help.join(this.ansi(), this.width(), this.commandSpec.usageMessage().description(), new StringBuilder(), params).toString();
        }

        public String header(Object ... params) {
            return Help.join(this.ansi(), this.width(), this.commandSpec.usageMessage().header(), new StringBuilder(), params).toString();
        }

        public String footer(Object ... params) {
            return Help.join(this.ansi(), this.width(), this.commandSpec.usageMessage().footer(), new StringBuilder(), params).toString();
        }

        public String headerHeading(Object ... params) {
            return Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().headerHeading(), params);
        }

        public String synopsisHeading(Object ... params) {
            return Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().synopsisHeading(), params);
        }

        public String descriptionHeading(Object ... params) {
            return CommandLine.empty(this.commandSpec.usageMessage().descriptionHeading()) ? "" : Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().descriptionHeading(), params);
        }

        public String parameterListHeading(Object ... params) {
            return this.commandSpec.positionalParameters().isEmpty() ? "" : Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().parameterListHeading(), params);
        }

        public String optionListHeading(Object ... params) {
            return this.commandSpec.optionsMap().isEmpty() ? "" : Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().optionListHeading(), params);
        }

        public String commandListHeading(Object ... params) {
            return this.commands.isEmpty() ? "" : Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().commandListHeading(), params);
        }

        public String footerHeading(Object ... params) {
            return Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().footerHeading(), params);
        }

        public String commandList() {
            if (this.subcommands().isEmpty()) {
                return "";
            }
            int commandLength = Help.maxLength(this.subcommands().keySet());
            TextTable textTable = TextTable.forColumns(this.ansi(), new Column(commandLength + 2, 2, Column.Overflow.SPAN), new Column(this.width() - (commandLength + 2), 2, Column.Overflow.WRAP));
            for (Map.Entry<String, Help> entry : this.subcommands().entrySet()) {
                Help help = entry.getValue();
                Model.UsageMessageSpec usage = help.commandSpec().usageMessage();
                String header = !CommandLine.empty(usage.header()) ? usage.header()[0] : (!CommandLine.empty(usage.description()) ? usage.description()[0] : "");
                Ansi.Text[] lines = this.ansi().text(CommandLine.format(header, new Object[0])).splitLines();
                for (int i = 0; i < lines.length; ++i) {
                    textTable.addRowValues(i == 0 ? help.commandNamesText(", ") : Ansi.EMPTY_TEXT, lines[i]);
                }
            }
            return textTable.toString();
        }

        private static int maxLength(Collection<String> any) {
            ArrayList<String> strings = new ArrayList<String>(any);
            Collections.sort(strings, Collections.reverseOrder(Help.shortestFirst()));
            return ((String)strings.get(0)).length();
        }

        public Ansi.Text commandNamesText(String separator) {
            Ansi.Text result = this.colorScheme().commandText(this.aliases().get(0));
            for (int i = 1; i < this.aliases().size(); ++i) {
                result = result.concat(separator).concat(this.colorScheme().commandText(this.aliases().get(i)));
            }
            return result;
        }

        private static String join(String[] names, int offset, int length, String separator) {
            if (names == null) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            for (int i = offset; i < offset + length; ++i) {
                result.append(i > offset ? separator : "").append(names[i]);
            }
            return result.toString();
        }

        private static String stringOf(char chr, int length) {
            char[] buff = new char[length];
            Arrays.fill(buff, chr);
            return new String(buff);
        }

        public Layout createDefaultLayout() {
            return this.createLayout(24);
        }

        private Layout createLayout(int longOptionsColumnWidth) {
            return new Layout(this.colorScheme, TextTable.forDefaultColumns(this.colorScheme.ansi(), longOptionsColumnWidth, this.width()), this.createDefaultOptionRenderer(), this.createDefaultParameterRenderer());
        }

        public IOptionRenderer createDefaultOptionRenderer() {
            return new DefaultOptionRenderer(this.commandSpec.usageMessage.showDefaultValues(), "" + this.commandSpec.usageMessage().requiredOptionMarker());
        }

        public static IOptionRenderer createMinimalOptionRenderer() {
            return new MinimalOptionRenderer();
        }

        public IParameterRenderer createDefaultParameterRenderer() {
            return new DefaultParameterRenderer(this.commandSpec.usageMessage.showDefaultValues(), "" + this.commandSpec.usageMessage().requiredOptionMarker());
        }

        public static IParameterRenderer createMinimalParameterRenderer() {
            return new MinimalParameterRenderer();
        }

        public static IParamLabelRenderer createMinimalParamLabelRenderer() {
            return new IParamLabelRenderer(){

                @Override
                public Ansi.Text renderParameterLabel(Model.ArgSpec argSpec, Ansi ansi, List<Ansi.IStyle> styles) {
                    return ansi.apply(argSpec.paramLabel(), styles);
                }

                @Override
                public String separator() {
                    return "";
                }
            };
        }

        public IParamLabelRenderer createDefaultParamLabelRenderer() {
            return new DefaultParamLabelRenderer(this.commandSpec);
        }

        public static Comparator<Model.OptionSpec> createShortOptionNameComparator() {
            return new SortByShortestOptionNameAlphabetically();
        }

        public static Comparator<Model.OptionSpec> createShortOptionArityAndNameComparator() {
            return new SortByOptionArityAndNameAlphabetically();
        }

        public static Comparator<String> shortestFirst() {
            return new ShortestFirst();
        }

        static Comparator<Model.OptionSpec> createOrderComparator() {
            return new SortByOptionOrder();
        }

        public Ansi ansi() {
            return this.colorScheme.ansi;
        }

        private static void addTrailingDefaultLine(List<Ansi.Text[]> result, Model.ArgSpec arg, ColorScheme scheme) {
            Ansi.Text EMPTY = Ansi.EMPTY_TEXT;
            Ansi.Text[] textArray = new Ansi.Text[5];
            textArray[0] = EMPTY;
            textArray[1] = EMPTY;
            textArray[2] = EMPTY;
            textArray[3] = EMPTY;
            Ansi ansi = scheme.ansi();
            ((Object)((Object)ansi)).getClass();
            textArray[4] = ansi.new Ansi.Text("  Default: " + arg.defaultValueString());
            result.add(textArray);
        }

        private static Ansi.Text[] createDescriptionFirstLines(ColorScheme scheme, Model.ArgSpec arg, String[] description, boolean[] showDefault) {
            Ansi ansi = scheme.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text[] result = ansi.new Ansi.Text(CommandLine.str(description, 0)).splitLines();
            if (result.length == 0 || result.length == 1 && result[0].plain.length() == 0) {
                if (showDefault[0]) {
                    Ansi.Text[] textArray = new Ansi.Text[1];
                    Ansi ansi2 = scheme.ansi();
                    ((Object)((Object)ansi2)).getClass();
                    textArray[0] = ansi2.new Ansi.Text("  Default: " + arg.defaultValueString());
                    result = textArray;
                    showDefault[0] = false;
                } else {
                    result = new Ansi.Text[]{Ansi.EMPTY_TEXT};
                }
            }
            return result;
        }

        public static ColorScheme defaultColorScheme(Ansi ansi) {
            return new ColorScheme(ansi).commands(Ansi.Style.bold).options(Ansi.Style.fg_yellow).parameters(Ansi.Style.fg_yellow).optionParams(Ansi.Style.italic);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Ansi {
            AUTO,
            ON,
            OFF;

            static Text EMPTY_TEXT;
            static Boolean tty;

            static boolean isTTY() {
                if (tty == null) {
                    tty = Ansi.calcTTY();
                }
                return tty;
            }

            static final boolean isWindows() {
                return System.getProperty("os.name").startsWith("Windows");
            }

            static final boolean isXterm() {
                return System.getenv("TERM") != null && System.getenv("TERM").startsWith("xterm");
            }

            static final boolean hasOsType() {
                return System.getenv("OSTYPE") != null;
            }

            static final boolean hintDisabled() {
                return "0".equals(System.getenv("CLICOLOR")) || "OFF".equals(System.getenv("ConEmuANSI"));
            }

            static final boolean hintEnabled() {
                return System.getenv("ANSICON") != null || "1".equals(System.getenv("CLICOLOR")) || "ON".equals(System.getenv("ConEmuANSI"));
            }

            static final boolean forceDisabled() {
                return System.getenv("NO_COLOR") != null;
            }

            static final boolean forceEnabled() {
                return System.getenv("CLICOLOR_FORCE") != null && !"0".equals(System.getenv("CLICOLOR_FORCE"));
            }

            static boolean calcTTY() {
                try {
                    return System.class.getDeclaredMethod("console", new Class[0]).invoke(null, new Object[0]) != null;
                }
                catch (Throwable reflectionFailed) {
                    return true;
                }
            }

            static boolean isPseudoTTY() {
                return Ansi.isWindows() && (Ansi.isXterm() || Ansi.hasOsType());
            }

            static boolean ansiPossible() {
                if (Ansi.forceDisabled()) {
                    return false;
                }
                if (Ansi.forceEnabled()) {
                    return true;
                }
                if (Ansi.isWindows() && Ansi.isJansiConsoleInstalled()) {
                    return true;
                }
                if (Ansi.hintDisabled()) {
                    return false;
                }
                if (!Ansi.isTTY() && !Ansi.isPseudoTTY()) {
                    return false;
                }
                return Ansi.hintEnabled() || !Ansi.isWindows() || Ansi.isXterm() || Ansi.hasOsType();
            }

            static boolean isJansiConsoleInstalled() {
                try {
                    Class<?> ansiConsole = Class.forName("org.fusesource.jansi.AnsiConsole");
                    Field out = ansiConsole.getField("out");
                    return out.get(null) == System.out;
                }
                catch (Exception reflectionFailed) {
                    return false;
                }
            }

            public boolean enabled() {
                if (this == ON) {
                    return true;
                }
                if (this == OFF) {
                    return false;
                }
                String ansi = System.getProperty("picocli.ansi");
                boolean auto = ansi == null || "AUTO".equalsIgnoreCase(ansi);
                return auto ? Ansi.ansiPossible() : Boolean.getBoolean("picocli.ansi");
            }

            public Text text(String stringWithMarkup) {
                return new Text(stringWithMarkup);
            }

            public String string(String stringWithMarkup) {
                return new Text(stringWithMarkup).toString();
            }

            public static Ansi valueOf(boolean enabled) {
                return enabled ? ON : OFF;
            }

            public Text apply(String plainText, List<IStyle> styles) {
                if (plainText.length() == 0) {
                    return new Text(0);
                }
                Text result = new Text(plainText.length());
                IStyle[] all = styles.toArray(new IStyle[styles.size()]);
                result.sections.add(new StyledSection(0, plainText.length(), Style.on(all), Style.off(Ansi.reverse(all)) + Style.reset.off()));
                result.plain.append(plainText);
                result.length = result.plain.length();
                return result;
            }

            private static <T> T[] reverse(T[] all) {
                for (int i = 0; i < all.length / 2; ++i) {
                    T temp = all[i];
                    all[i] = all[all.length - i - 1];
                    all[all.length - i - 1] = temp;
                }
                return all;
            }

            static {
                Ansi ansi = OFF;
                ((Object)((Object)ansi)).getClass();
                EMPTY_TEXT = ansi.new Text(0);
            }

            public class Text
            implements Cloneable {
                private final int maxLength;
                private int from;
                private int length;
                private StringBuilder plain = new StringBuilder();
                private List<StyledSection> sections = new ArrayList<StyledSection>();

                public Text(int maxLength) {
                    this.maxLength = maxLength;
                }

                public Text(Text other) {
                    this.maxLength = other.maxLength;
                    this.from = other.from;
                    this.length = other.length;
                    this.plain = new StringBuilder(other.plain);
                    this.sections = new ArrayList<StyledSection>(other.sections);
                }

                public Text(String input) {
                    this.maxLength = -1;
                    this.plain.setLength(0);
                    int i = 0;
                    while (true) {
                        int j;
                        if ((j = input.indexOf("@|", i)) == -1) {
                            if (i == 0) {
                                this.plain.append(input);
                                this.length = this.plain.length();
                                return;
                            }
                            this.plain.append(input.substring(i, input.length()));
                            this.length = this.plain.length();
                            return;
                        }
                        this.plain.append(input.substring(i, j));
                        int k = input.indexOf("|@", j);
                        if (k == -1) {
                            this.plain.append(input);
                            this.length = this.plain.length();
                            return;
                        }
                        String spec = input.substring(j += 2, k);
                        String[] items = spec.split(" ", 2);
                        if (items.length == 1) {
                            this.plain.append(input);
                            this.length = this.plain.length();
                            return;
                        }
                        Object[] styles = Style.parse(items[0]);
                        this.addStyledSection(this.plain.length(), items[1].length(), Style.on((IStyle[])styles), Style.off((IStyle[])Ansi.reverse(styles)) + Style.reset.off());
                        this.plain.append(items[1]);
                        i = k + 2;
                    }
                }

                private void addStyledSection(int start, int length, String startStyle, String endStyle) {
                    this.sections.add(new StyledSection(start, length, startStyle, endStyle));
                }

                public Object clone() {
                    return new Text(this);
                }

                public Text[] splitLines() {
                    ArrayList<Text> result = new ArrayList<Text>();
                    int start = 0;
                    int end = 0;
                    int i = 0;
                    while (i < this.plain.length()) {
                        boolean eol;
                        char c = this.plain.charAt(i);
                        boolean bl = eol = c == '\n';
                        if (c == '\r' && i + 1 < this.plain.length() && this.plain.charAt(i + 1) == '\n') {
                            eol = true;
                            ++i;
                        }
                        if (eol |= c == '\r') {
                            result.add(this.substring(start, end));
                            start = i + 1;
                        }
                        end = ++i;
                    }
                    result.add(this.substring(start, this.plain.length()));
                    return result.toArray(new Text[result.size()]);
                }

                public Text substring(int start) {
                    return this.substring(start, this.length);
                }

                public Text substring(int start, int end) {
                    Text result = (Text)this.clone();
                    result.from = this.from + start;
                    result.length = end - start;
                    return result;
                }

                @Deprecated
                public Text append(String string) {
                    return this.concat(string);
                }

                @Deprecated
                public Text append(Text text) {
                    return this.concat(text);
                }

                public Text concat(String string) {
                    return this.concat(new Text(string));
                }

                public Text concat(Text other) {
                    Text result = (Text)this.clone();
                    result.plain = new StringBuilder(this.plain.toString().substring(this.from, this.from + this.length));
                    result.from = 0;
                    result.sections = new ArrayList<StyledSection>();
                    for (StyledSection section : this.sections) {
                        result.sections.add(section.withStartIndex(section.startIndex - this.from));
                    }
                    result.plain.append(other.plain.toString().substring(other.from, other.from + other.length));
                    for (StyledSection section : other.sections) {
                        int index = result.length + section.startIndex - other.from;
                        result.sections.add(section.withStartIndex(index));
                    }
                    result.length = result.plain.length();
                    return result;
                }

                public void getStyledChars(int from, int length, Text destination, int offset) {
                    if (destination.length < offset) {
                        for (int i = destination.length; i < offset; ++i) {
                            destination.plain.append(' ');
                        }
                        destination.length = offset;
                    }
                    for (StyledSection section : this.sections) {
                        destination.sections.add(section.withStartIndex(section.startIndex - from + destination.length));
                    }
                    destination.plain.append(this.plain.toString().substring(from, from + length));
                    destination.length = destination.plain.length();
                }

                public String plainString() {
                    return this.plain.toString().substring(this.from, this.from + this.length);
                }

                public boolean equals(Object obj) {
                    return this.toString().equals(String.valueOf(obj));
                }

                public int hashCode() {
                    return this.toString().hashCode();
                }

                public String toString() {
                    if (!Ansi.this.enabled()) {
                        return this.plain.toString().substring(this.from, this.from + this.length);
                    }
                    if (this.length == 0) {
                        return "";
                    }
                    StringBuilder sb = new StringBuilder(this.plain.length() + 20 * this.sections.size());
                    StyledSection current = null;
                    int end = Math.min(this.from + this.length, this.plain.length());
                    for (int i = this.from; i < end; ++i) {
                        StyledSection section = this.findSectionContaining(i);
                        if (section != current) {
                            if (current != null) {
                                sb.append(current.endStyles);
                            }
                            if (section != null) {
                                sb.append(section.startStyles);
                            }
                            current = section;
                        }
                        sb.append(this.plain.charAt(i));
                    }
                    if (current != null) {
                        sb.append(current.endStyles);
                    }
                    return sb.toString();
                }

                private StyledSection findSectionContaining(int index) {
                    for (StyledSection section : this.sections) {
                        if (index < section.startIndex || index >= section.startIndex + section.length) continue;
                        return section;
                    }
                    return null;
                }
            }

            private static class StyledSection {
                int startIndex;
                int length;
                String startStyles;
                String endStyles;

                StyledSection(int start, int len, String style1, String style2) {
                    this.startIndex = start;
                    this.length = len;
                    this.startStyles = style1;
                    this.endStyles = style2;
                }

                StyledSection withStartIndex(int newStart) {
                    return new StyledSection(newStart, this.length, this.startStyles, this.endStyles);
                }
            }

            static class Palette256Color
            implements IStyle {
                private final int fgbg;
                private final int color;

                Palette256Color(boolean foreground, String color) {
                    this.fgbg = foreground ? 38 : 48;
                    String[] rgb = color.split(";");
                    this.color = rgb.length == 3 ? 16 + 36 * Integer.decode(rgb[0]) + 6 * Integer.decode(rgb[1]) + Integer.decode(rgb[2]) : Integer.decode(color);
                }

                public String on() {
                    return String.format("\u001b[%d;5;%dm", this.fgbg, this.color);
                }

                public String off() {
                    return "\u001b[" + (this.fgbg + 1) + "m";
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Style implements IStyle
            {
                reset(0, 0),
                bold(1, 21),
                faint(2, 22),
                italic(3, 23),
                underline(4, 24),
                blink(5, 25),
                reverse(7, 27),
                fg_black(30, 39),
                fg_red(31, 39),
                fg_green(32, 39),
                fg_yellow(33, 39),
                fg_blue(34, 39),
                fg_magenta(35, 39),
                fg_cyan(36, 39),
                fg_white(37, 39),
                bg_black(40, 49),
                bg_red(41, 49),
                bg_green(42, 49),
                bg_yellow(43, 49),
                bg_blue(44, 49),
                bg_magenta(45, 49),
                bg_cyan(46, 49),
                bg_white(47, 49);

                private final int startCode;
                private final int endCode;

                private Style(int startCode, int endCode) {
                    this.startCode = startCode;
                    this.endCode = endCode;
                }

                @Override
                public String on() {
                    return "\u001b[" + this.startCode + "m";
                }

                @Override
                public String off() {
                    return "\u001b[" + this.endCode + "m";
                }

                public static String on(IStyle ... styles) {
                    StringBuilder result = new StringBuilder();
                    for (IStyle style : styles) {
                        result.append(style.on());
                    }
                    return result.toString();
                }

                public static String off(IStyle ... styles) {
                    StringBuilder result = new StringBuilder();
                    for (IStyle style : styles) {
                        result.append(style.off());
                    }
                    return result.toString();
                }

                public static IStyle fg(String str) {
                    try {
                        return Style.valueOf(str.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("fg_" + str.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            return new Palette256Color(true, str);
                        }
                    }
                }

                public static IStyle bg(String str) {
                    try {
                        return Style.valueOf(str.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("bg_" + str.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            return new Palette256Color(false, str);
                        }
                    }
                }

                public static IStyle[] parse(String commaSeparatedCodes) {
                    String[] codes = commaSeparatedCodes.split(",");
                    IStyle[] styles = new IStyle[codes.length];
                    for (int i = 0; i < codes.length; ++i) {
                        int end;
                        if (codes[i].toLowerCase(Locale.ENGLISH).startsWith("fg(")) {
                            end = codes[i].indexOf(41);
                            styles[i] = Style.fg(codes[i].substring(3, end < 0 ? codes[i].length() : end));
                            continue;
                        }
                        if (codes[i].toLowerCase(Locale.ENGLISH).startsWith("bg(")) {
                            end = codes[i].indexOf(41);
                            styles[i] = Style.bg(codes[i].substring(3, end < 0 ? codes[i].length() : end));
                            continue;
                        }
                        styles[i] = Style.fg(codes[i]);
                    }
                    return styles;
                }
            }

            public static interface IStyle {
                public static final String CSI = "\u001b[";

                public String on();

                public String off();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ColorScheme {
            public final List<Ansi.IStyle> commandStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> optionStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> parameterStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> optionParamStyles = new ArrayList<Ansi.IStyle>();
            private final Ansi ansi;

            public ColorScheme() {
                this(Ansi.AUTO);
            }

            public ColorScheme(Ansi ansi) {
                this.ansi = Assert.notNull(ansi, "ansi");
            }

            public ColorScheme commands(Ansi.IStyle ... styles) {
                return this.addAll(this.commandStyles, styles);
            }

            public ColorScheme options(Ansi.IStyle ... styles) {
                return this.addAll(this.optionStyles, styles);
            }

            public ColorScheme parameters(Ansi.IStyle ... styles) {
                return this.addAll(this.parameterStyles, styles);
            }

            public ColorScheme optionParams(Ansi.IStyle ... styles) {
                return this.addAll(this.optionParamStyles, styles);
            }

            public Ansi.Text commandText(String command) {
                return this.ansi().apply(command, this.commandStyles);
            }

            public Ansi.Text optionText(String option) {
                return this.ansi().apply(option, this.optionStyles);
            }

            public Ansi.Text parameterText(String parameter) {
                return this.ansi().apply(parameter, this.parameterStyles);
            }

            public Ansi.Text optionParamText(String optionParam) {
                return this.ansi().apply(optionParam, this.optionParamStyles);
            }

            public ColorScheme applySystemProperties() {
                this.replace(this.commandStyles, System.getProperty("picocli.color.commands"));
                this.replace(this.optionStyles, System.getProperty("picocli.color.options"));
                this.replace(this.parameterStyles, System.getProperty("picocli.color.parameters"));
                this.replace(this.optionParamStyles, System.getProperty("picocli.color.optionParams"));
                return this;
            }

            private void replace(List<Ansi.IStyle> styles, String property) {
                if (property != null) {
                    styles.clear();
                    this.addAll(styles, Ansi.Style.parse(property));
                }
            }

            private ColorScheme addAll(List<Ansi.IStyle> styles, Ansi.IStyle ... add) {
                styles.addAll(Arrays.asList(add));
                return this;
            }

            public Ansi ansi() {
                return this.ansi;
            }
        }

        public static class Column {
            public final int width;
            public int indent;
            public final Overflow overflow;

            public Column(int width, int indent, Overflow overflow) {
                this.width = width;
                this.indent = indent;
                this.overflow = Assert.notNull(overflow, "overflow");
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Overflow {
                TRUNCATE,
                SPAN,
                WRAP;

            }
        }

        public static class TextTable {
            private static final int OPTION_SEPARATOR_COLUMN = 2;
            private static final int LONG_OPTION_COLUMN = 3;
            private final Column[] columns;
            protected final List<Ansi.Text> columnValues = new ArrayList<Ansi.Text>();
            public int indentWrappedLines = 2;
            private final Ansi ansi;
            private final int tableWidth;

            public static TextTable forDefaultColumns(Ansi ansi, int usageHelpWidth) {
                return TextTable.forDefaultColumns(ansi, 24, usageHelpWidth);
            }

            public static TextTable forDefaultColumns(Ansi ansi, int longOptionsColumnWidth, int usageHelpWidth) {
                return TextTable.forColumns(ansi, new Column(2, 0, Column.Overflow.TRUNCATE), new Column(2, 0, Column.Overflow.TRUNCATE), new Column(1, 0, Column.Overflow.TRUNCATE), new Column(longOptionsColumnWidth, 1, Column.Overflow.SPAN), new Column(usageHelpWidth - longOptionsColumnWidth, 1, Column.Overflow.WRAP));
            }

            public static TextTable forColumnWidths(Ansi ansi, int ... columnWidths) {
                Column[] columns = new Column[columnWidths.length];
                for (int i = 0; i < columnWidths.length; ++i) {
                    columns[i] = new Column(columnWidths[i], 0, i == columnWidths.length - 1 ? Column.Overflow.WRAP : Column.Overflow.SPAN);
                }
                return new TextTable(ansi, columns);
            }

            public static TextTable forColumns(Ansi ansi, Column ... columns) {
                return new TextTable(ansi, columns);
            }

            protected TextTable(Ansi ansi, Column[] columns) {
                this.ansi = Assert.notNull(ansi, "ansi");
                this.columns = (Column[])Assert.notNull(columns, "columns").clone();
                if (columns.length == 0) {
                    throw new IllegalArgumentException("At least one column is required");
                }
                int totalWidth = 0;
                for (Column col : columns) {
                    totalWidth += col.width;
                }
                this.tableWidth = totalWidth;
            }

            public Column[] columns() {
                return (Column[])this.columns.clone();
            }

            public Ansi.Text textAt(int row, int col) {
                return this.columnValues.get(col + row * this.columns.length);
            }

            @Deprecated
            public Ansi.Text cellAt(int row, int col) {
                return this.textAt(row, col);
            }

            public int rowCount() {
                return this.columnValues.size() / this.columns.length;
            }

            public void addEmptyRow() {
                for (int i = 0; i < this.columns.length; ++i) {
                    Ansi ansi = this.ansi;
                    ((Object)((Object)ansi)).getClass();
                    this.columnValues.add(ansi.new Ansi.Text(this.columns[i].width));
                }
            }

            public void addRowValues(String ... values) {
                Ansi.Text[] array = new Ansi.Text[values.length];
                for (int i = 0; i < array.length; ++i) {
                    Ansi.Text text;
                    if (values[i] == null) {
                        text = Ansi.EMPTY_TEXT;
                    } else {
                        Ansi ansi = this.ansi;
                        ((Object)((Object)ansi)).getClass();
                        text = ansi.new Ansi.Text(values[i]);
                    }
                    array[i] = text;
                }
                this.addRowValues(array);
            }

            public void addRowValues(Ansi.Text ... values) {
                if (values.length > this.columns.length) {
                    throw new IllegalArgumentException(values.length + " values don't fit in " + this.columns.length + " columns");
                }
                this.addEmptyRow();
                int oldIndent = this.unindent(values);
                for (int col = 0; col < values.length; ++col) {
                    int row = this.rowCount() - 1;
                    Cell cell = this.putValue(row, col, values[col]);
                    if (cell.row == row && cell.column == col || col == values.length - 1) continue;
                    this.addEmptyRow();
                }
                this.reindent(oldIndent);
            }

            private int unindent(Ansi.Text[] values) {
                if (this.columns.length <= 3) {
                    return 0;
                }
                int oldIndent = this.columns[3].indent;
                if (Help.DEFAULT_SEPARATOR.equals(values[2].toString())) {
                    this.columns[3].indent = 0;
                }
                return oldIndent;
            }

            private void reindent(int oldIndent) {
                if (this.columns.length <= 3) {
                    return;
                }
                this.columns[3].indent = oldIndent;
            }

            public Cell putValue(int row, int col, Ansi.Text value) {
                if (row > this.rowCount() - 1) {
                    throw new IllegalArgumentException("Cannot write to row " + row + ": rowCount=" + this.rowCount());
                }
                if (value == null || value.plain.length() == 0) {
                    return new Cell(col, row);
                }
                Column column = this.columns[col];
                int indent = column.indent;
                switch (column.overflow) {
                    case TRUNCATE: {
                        TextTable.copy(value, this.textAt(row, col), indent);
                        return new Cell(col, row);
                    }
                    case SPAN: {
                        int startColumn = col;
                        do {
                            boolean lastColumn = col == this.columns.length - 1;
                            int charsWritten = lastColumn ? this.copy(BreakIterator.getLineInstance(), value, this.textAt(row, col), indent) : TextTable.copy(value, this.textAt(row, col), indent);
                            value = value.substring(charsWritten);
                            indent = 0;
                            if (value.length > 0) {
                                ++col;
                            }
                            if (value.length <= 0 || col < this.columns.length) continue;
                            this.addEmptyRow();
                            ++row;
                            col = startColumn;
                            indent = column.indent + this.indentWrappedLines;
                        } while (value.length > 0);
                        return new Cell(col, row);
                    }
                    case WRAP: {
                        BreakIterator lineBreakIterator = BreakIterator.getLineInstance();
                        do {
                            int charsWritten = this.copy(lineBreakIterator, value, this.textAt(row, col), indent);
                            value = value.substring(charsWritten);
                            indent = column.indent + this.indentWrappedLines;
                            if (value.length <= 0) continue;
                            ++row;
                            this.addEmptyRow();
                        } while (value.length > 0);
                        return new Cell(col, row);
                    }
                }
                throw new IllegalStateException(column.overflow.toString());
            }

            private static int length(Ansi.Text str) {
                return str.length;
            }

            private int copy(BreakIterator line, Ansi.Text text, Ansi.Text columnValue, int offset) {
                line.setText(text.plainString().replace("-", "\u00ff"));
                int done = 0;
                int start = line.first();
                int end = line.next();
                while (end != -1) {
                    Ansi.Text word = text.substring(start, end);
                    if (columnValue.maxLength < offset + done + TextTable.length(word)) break;
                    done += TextTable.copy(word, columnValue, offset + done);
                    start = end;
                    end = line.next();
                }
                if (done == 0 && TextTable.length(text) + offset > columnValue.maxLength) {
                    done = TextTable.copy(text, columnValue, offset);
                }
                return done;
            }

            private static int copy(Ansi.Text value, Ansi.Text destination, int offset) {
                int length = Math.min(value.length, destination.maxLength - offset);
                value.getStyledChars(value.from, length, destination, offset);
                return length;
            }

            public StringBuilder toString(StringBuilder text) {
                int columnCount = this.columns.length;
                StringBuilder row = new StringBuilder(this.tableWidth);
                for (int i = 0; i < this.columnValues.size(); ++i) {
                    int lastChar;
                    Ansi.Text column = this.columnValues.get(i);
                    row.append(column.toString());
                    row.append(new String(Help.spaces(this.columns[i % columnCount].width - column.length)));
                    if (i % columnCount != columnCount - 1) continue;
                    for (lastChar = row.length() - 1; lastChar >= 0 && row.charAt(lastChar) == ' '; --lastChar) {
                    }
                    row.setLength(lastChar + 1);
                    text.append(row.toString()).append(System.getProperty("line.separator"));
                    row.setLength(0);
                }
                return text;
            }

            public String toString() {
                return this.toString(new StringBuilder()).toString();
            }

            public static class Cell {
                public final int column;
                public final int row;

                public Cell(int column, int row) {
                    this.column = column;
                    this.row = row;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class SortByOptionOrder
        implements Comparator<Model.OptionSpec> {
            SortByOptionOrder() {
            }

            @Override
            public int compare(Model.OptionSpec o1, Model.OptionSpec o2) {
                return Integer.signum(o1.order() - o2.order());
            }
        }

        static class SortByOptionArityAndNameAlphabetically
        extends SortByShortestOptionNameAlphabetically {
            SortByOptionArityAndNameAlphabetically() {
            }

            public int compare(Model.OptionSpec o1, Model.OptionSpec o2) {
                Range arity1 = o1.arity();
                Range arity2 = o2.arity();
                int result = arity1.max - arity2.max;
                if (result == 0) {
                    result = arity1.min - arity2.min;
                }
                if (result == 0) {
                    if (o1.isMultiValue() && !o2.isMultiValue()) {
                        result = 1;
                    }
                    if (!o1.isMultiValue() && o2.isMultiValue()) {
                        result = -1;
                    }
                }
                return result == 0 ? super.compare(o1, o2) : result;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class SortByShortestOptionNameAlphabetically
        implements Comparator<Model.OptionSpec> {
            SortByShortestOptionNameAlphabetically() {
            }

            @Override
            public int compare(Model.OptionSpec o1, Model.OptionSpec o2) {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                String[] names1 = ShortestFirst.sort(o1.names());
                String[] names2 = ShortestFirst.sort(o2.names());
                int result = names1[0].toUpperCase().compareTo(names2[0].toUpperCase());
                int n = result = result == 0 ? -names1[0].compareTo(names2[0]) : result;
                return o1.help() == o2.help() ? result : (o2.help() ? -1 : 1);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ShortestFirst
        implements Comparator<String> {
            ShortestFirst() {
            }

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }

            public static String[] sort(String[] names) {
                Arrays.sort(names, new ShortestFirst());
                return names;
            }

            public static String[] longestFirst(String[] names) {
                Arrays.sort(names, Collections.reverseOrder(new ShortestFirst()));
                return names;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Layout {
            protected final ColorScheme colorScheme;
            protected final TextTable table;
            protected IOptionRenderer optionRenderer;
            protected IParameterRenderer parameterRenderer;

            public Layout(ColorScheme colorScheme, int tableWidth) {
                this(colorScheme, TextTable.forDefaultColumns(colorScheme.ansi(), tableWidth));
            }

            public Layout(ColorScheme colorScheme, TextTable textTable) {
                this(colorScheme, textTable, new DefaultOptionRenderer(false, " "), new DefaultParameterRenderer(false, " "));
            }

            public Layout(ColorScheme colorScheme, TextTable textTable, IOptionRenderer optionRenderer, IParameterRenderer parameterRenderer) {
                this.colorScheme = Assert.notNull(colorScheme, "colorScheme");
                this.table = Assert.notNull(textTable, "textTable");
                this.optionRenderer = Assert.notNull(optionRenderer, "optionRenderer");
                this.parameterRenderer = Assert.notNull(parameterRenderer, "parameterRenderer");
            }

            public void layout(Model.ArgSpec argSpec, Ansi.Text[][] cellValues) {
                for (Ansi.Text[] oneRow : cellValues) {
                    this.table.addRowValues(oneRow);
                }
            }

            public void addOptions(List<Model.OptionSpec> options, IParamLabelRenderer paramLabelRenderer) {
                for (Model.OptionSpec option : options) {
                    if (option.hidden()) continue;
                    this.addOption(option, paramLabelRenderer);
                }
            }

            public void addOption(Model.OptionSpec option, IParamLabelRenderer paramLabelRenderer) {
                Ansi.Text[][] values = this.optionRenderer.render(option, paramLabelRenderer, this.colorScheme);
                this.layout(option, values);
            }

            public void addPositionalParameters(List<Model.PositionalParamSpec> params, IParamLabelRenderer paramLabelRenderer) {
                for (Model.PositionalParamSpec param : params) {
                    if (param.hidden()) continue;
                    this.addPositionalParameter(param, paramLabelRenderer);
                }
            }

            public void addPositionalParameter(Model.PositionalParamSpec param, IParamLabelRenderer paramLabelRenderer) {
                Ansi.Text[][] values = this.parameterRenderer.render(param, paramLabelRenderer, this.colorScheme);
                this.layout(param, values);
            }

            public String toString() {
                return this.table.toString();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class DefaultParamLabelRenderer
        implements IParamLabelRenderer {
            private final Model.CommandSpec commandSpec;

            public DefaultParamLabelRenderer(Model.CommandSpec commandSpec) {
                this.commandSpec = Assert.notNull(commandSpec, "commandSpec");
            }

            @Override
            public String separator() {
                return this.commandSpec.parser().separator();
            }

            @Override
            public Ansi.Text renderParameterLabel(Model.ArgSpec argSpec, Ansi ansi, List<Ansi.IStyle> styles) {
                String optionSeparator;
                boolean effectivelyVariable;
                Range capacity;
                Range range = capacity = argSpec.isOption() ? argSpec.arity() : ((Model.PositionalParamSpec)argSpec).capacity();
                if (capacity.max == 0) {
                    Ansi ansi2 = ansi;
                    ((Object)((Object)ansi2)).getClass();
                    return ansi2.new Ansi.Text("");
                }
                if (argSpec.hideParamSyntax()) {
                    return ansi.apply((argSpec.isOption() ? this.separator() : "") + argSpec.paramLabel(), styles);
                }
                Ansi.Text paramName = ansi.apply(argSpec.paramLabel(), styles);
                String split = argSpec.splitRegex();
                String mandatorySep = CommandLine.empty(split) ? " " : split;
                String optionalSep = CommandLine.empty(split) ? " [" : "[" + split;
                boolean unlimitedSplit = !CommandLine.empty(split) && !this.commandSpec.parser().limitSplit();
                boolean limitedSplit = !CommandLine.empty(split) && this.commandSpec.parser().limitSplit();
                Ansi.Text repeating = paramName;
                int paramCount = 1;
                if (unlimitedSplit) {
                    repeating = paramName.concat("[" + split).concat(paramName).concat("...]");
                    ++paramCount;
                    mandatorySep = " ";
                    optionalSep = " [";
                }
                Ansi.Text result = repeating;
                for (int done = 1; done < capacity.min; ++done) {
                    result = result.concat(mandatorySep).concat(repeating);
                    paramCount += paramCount;
                }
                if (!capacity.isVariable) {
                    int i;
                    for (i = done; i < capacity.max; ++i) {
                        result = result.concat(optionalSep).concat(paramName);
                        ++paramCount;
                    }
                    for (i = done; i < capacity.max; ++i) {
                        result = result.concat("]");
                    }
                }
                boolean bl = effectivelyVariable = capacity.isVariable || limitedSplit && paramCount == 1;
                if (limitedSplit && effectivelyVariable && paramCount == 1) {
                    result = result.concat(optionalSep).concat(repeating).concat("]");
                }
                if (effectivelyVariable) {
                    if (!argSpec.arity().isVariable && argSpec.arity().min > 1) {
                        Ansi ansi3 = ansi;
                        ((Object)((Object)ansi3)).getClass();
                        result = ansi3.new Ansi.Text("(").concat(result).concat(")");
                    }
                    result = result.concat("...");
                }
                String string = optionSeparator = argSpec.isOption() ? this.separator() : "";
                if (capacity.min == 0) {
                    String sep2 = CommandLine.empty(optionSeparator.trim()) ? optionSeparator + "[" : "[" + optionSeparator;
                    Ansi ansi4 = ansi;
                    ((Object)((Object)ansi4)).getClass();
                    result = ansi4.new Ansi.Text(sep2).concat(result).concat("]");
                } else {
                    Ansi ansi5 = ansi;
                    ((Object)((Object)ansi5)).getClass();
                    result = ansi5.new Ansi.Text(optionSeparator).concat(result);
                }
                return result;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IParamLabelRenderer {
            public Ansi.Text renderParameterLabel(Model.ArgSpec var1, Ansi var2, List<Ansi.IStyle> var3);

            public String separator();
        }

        static class DefaultParameterRenderer
        implements IParameterRenderer {
            private String requiredMarker = " ";
            private boolean showDefaultValues;

            public DefaultParameterRenderer(boolean showDefaultValues, String requiredMarker) {
                this.showDefaultValues = showDefaultValues;
                this.requiredMarker = Assert.notNull(requiredMarker, "requiredMarker");
            }

            public Ansi.Text[][] render(Model.PositionalParamSpec param, IParamLabelRenderer paramLabelRenderer, ColorScheme scheme) {
                int i;
                Ansi.Text label = paramLabelRenderer.renderParameterLabel(param, scheme.ansi(), scheme.parameterStyles);
                Ansi.Text requiredParameter = scheme.parameterText(param.arity().min > 0 ? this.requiredMarker : "");
                Ansi.Text EMPTY = Ansi.EMPTY_TEXT;
                boolean[] showDefault = new boolean[]{param.internalShowDefaultValue(this.showDefaultValues)};
                ArrayList<Ansi.Text[]> result = new ArrayList<Ansi.Text[]>();
                String[] description = param.renderedDescription();
                Ansi.Text[] descriptionFirstLines = Help.createDescriptionFirstLines(scheme, param, description, showDefault);
                result.add(new Ansi.Text[]{requiredParameter, EMPTY, EMPTY, label, descriptionFirstLines[0]});
                for (i = 1; i < descriptionFirstLines.length; ++i) {
                    result.add(new Ansi.Text[]{EMPTY, EMPTY, EMPTY, EMPTY, descriptionFirstLines[i]});
                }
                for (i = 1; i < description.length; ++i) {
                    Ansi.Text[] descriptionNextLines;
                    Ansi ansi = scheme.ansi();
                    ((Object)((Object)ansi)).getClass();
                    for (Ansi.Text line : descriptionNextLines = ansi.new Ansi.Text(description[i]).splitLines()) {
                        result.add(new Ansi.Text[]{EMPTY, EMPTY, EMPTY, EMPTY, line});
                    }
                }
                if (showDefault[0]) {
                    Help.addTrailingDefaultLine(result, param, scheme);
                }
                return (Ansi.Text[][])result.toArray((T[])new Ansi.Text[result.size()][]);
            }
        }

        public static interface IParameterRenderer {
            public Ansi.Text[][] render(Model.PositionalParamSpec var1, IParamLabelRenderer var2, ColorScheme var3);
        }

        static class MinimalParameterRenderer
        implements IParameterRenderer {
            MinimalParameterRenderer() {
            }

            public Ansi.Text[][] render(Model.PositionalParamSpec param, IParamLabelRenderer parameterLabelRenderer, ColorScheme scheme) {
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = parameterLabelRenderer.renderParameterLabel(param, scheme.ansi(), scheme.parameterStyles);
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = ansi.new Ansi.Text(param.description().length == 0 ? "" : param.description()[0]);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class MinimalOptionRenderer
        implements IOptionRenderer {
            MinimalOptionRenderer() {
            }

            public Ansi.Text[][] render(Model.OptionSpec option, IParamLabelRenderer parameterLabelRenderer, ColorScheme scheme) {
                Ansi.Text optionText = scheme.optionText(option.names()[0]);
                Ansi.Text paramLabelText = parameterLabelRenderer.renderParameterLabel(option, scheme.ansi(), scheme.optionParamStyles);
                optionText = optionText.concat(paramLabelText);
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = optionText;
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = ansi.new Ansi.Text(option.description().length == 0 ? "" : option.description()[0]);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class DefaultOptionRenderer
        implements IOptionRenderer {
            private String requiredMarker = " ";
            private boolean showDefaultValues;
            private String sep;

            public DefaultOptionRenderer(boolean showDefaultValues, String requiredMarker) {
                this.showDefaultValues = showDefaultValues;
                this.requiredMarker = Assert.notNull(requiredMarker, "requiredMarker");
            }

            public Ansi.Text[][] render(Model.OptionSpec option, IParamLabelRenderer paramLabelRenderer, ColorScheme scheme) {
                String[] names = ShortestFirst.sort(option.names());
                int shortOptionCount = names[0].length() == 2 ? 1 : 0;
                String shortOption = shortOptionCount > 0 ? names[0] : "";
                this.sep = shortOptionCount > 0 && names.length > 1 ? "," : "";
                String longOption = Help.join(names, shortOptionCount, names.length - shortOptionCount, ", ");
                Ansi.Text longOptionText = this.createLongOptionText(option, paramLabelRenderer, scheme, longOption);
                String requiredOption = option.required() ? this.requiredMarker : "";
                return this.renderDescriptionLines(option, scheme, requiredOption, shortOption, longOptionText);
            }

            private Ansi.Text createLongOptionText(Model.OptionSpec option, IParamLabelRenderer renderer, ColorScheme scheme, String longOption) {
                Ansi.Text paramLabelText = renderer.renderParameterLabel(option, scheme.ansi(), scheme.optionParamStyles);
                if (paramLabelText.length > 0 && longOption.length() == 0) {
                    this.sep = renderer.separator();
                    int sepStart = paramLabelText.plainString().indexOf(this.sep);
                    Ansi.Text prefix = paramLabelText.substring(0, sepStart);
                    paramLabelText = prefix.concat(paramLabelText.substring(sepStart + this.sep.length()));
                }
                Ansi.Text longOptionText = scheme.optionText(longOption);
                longOptionText = longOptionText.concat(paramLabelText);
                return longOptionText;
            }

            private Ansi.Text[][] renderDescriptionLines(Model.OptionSpec option, ColorScheme scheme, String requiredOption, String shortOption, Ansi.Text longOptionText) {
                int i;
                Ansi.Text EMPTY = Ansi.EMPTY_TEXT;
                boolean[] showDefault = new boolean[]{option.internalShowDefaultValue(this.showDefaultValues)};
                ArrayList<Ansi.Text[]> result = new ArrayList<Ansi.Text[]>();
                String[] description = option.renderedDescription();
                Ansi.Text[] descriptionFirstLines = Help.createDescriptionFirstLines(scheme, option, description, showDefault);
                Ansi.Text[] textArray = new Ansi.Text[5];
                textArray[0] = scheme.optionText(requiredOption);
                textArray[1] = scheme.optionText(shortOption);
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray[2] = ansi.new Ansi.Text(this.sep);
                textArray[3] = longOptionText;
                textArray[4] = descriptionFirstLines[0];
                result.add(textArray);
                for (i = 1; i < descriptionFirstLines.length; ++i) {
                    result.add(new Ansi.Text[]{EMPTY, EMPTY, EMPTY, EMPTY, descriptionFirstLines[i]});
                }
                for (i = 1; i < description.length; ++i) {
                    Ansi.Text[] descriptionNextLines;
                    Ansi ansi2 = scheme.ansi();
                    ((Object)((Object)ansi2)).getClass();
                    for (Ansi.Text line : descriptionNextLines = ansi2.new Ansi.Text(description[i]).splitLines()) {
                        result.add(new Ansi.Text[]{EMPTY, EMPTY, EMPTY, EMPTY, line});
                    }
                }
                if (showDefault[0]) {
                    Help.addTrailingDefaultLine(result, option, scheme);
                }
                return (Ansi.Text[][])result.toArray((T[])new Ansi.Text[result.size()][]);
            }
        }

        public static interface IOptionRenderer {
            public Ansi.Text[][] render(Model.OptionSpec var1, IParamLabelRenderer var2, ColorScheme var3);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Visibility {
            ALWAYS,
            NEVER,
            ON_DEMAND;

        }
    }

    public static interface IHelpSectionRenderer {
        public String render(Help var1);
    }

    public static interface IHelpCommandInitializable {
        public void init(CommandLine var1, Help.Ansi var2, PrintStream var3, PrintStream var4);
    }

    @Command(name="help", header={"Displays help information about the specified command"}, synopsisHeading="%nUsage: ", helpCommand=true, description={"%nWhen no COMMAND is given, the usage help for the main command is displayed.", "If a COMMAND is specified, the help for that command is shown.%n"})
    public static final class HelpCommand
    implements IHelpCommandInitializable,
    Runnable {
        @Option(names={"-h", "--help"}, usageHelp=true, descriptionKey="helpCommand.help", description={"Show usage help for the help command and exit."})
        private boolean helpRequested;
        @Parameters(paramLabel="COMMAND", descriptionKey="helpCommand.command", description={"The COMMAND to display the usage help message for."})
        private String[] commands = new String[0];
        private CommandLine self;
        private PrintStream out;
        private PrintStream err;
        private Help.Ansi ansi;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            CommandLine parent;
            if (this.self == null) {
                return;
            }
            CommandLine commandLine = parent = this.self.getParent();
            if (parent == null) {
                return;
            }
            if (this.commands.length > 0) {
                CommandLine subcommand = parent.getSubcommands().get(this.commands[0]);
                if (subcommand == null) throw new ParameterException(parent, "Unknown subcommand '" + this.commands[0] + "'.", null, this.commands[0]);
                subcommand.usage(this.out, this.ansi);
                return;
            } else {
                parent.usage(this.out, this.ansi);
            }
        }

        public void init(CommandLine helpCommandLine, Help.Ansi ansi, PrintStream out, PrintStream err) {
            this.self = Assert.notNull(helpCommandLine, "helpCommandLine");
            this.ansi = Assert.notNull(ansi, "ansi");
            this.out = Assert.notNull(out, "out");
            this.err = Assert.notNull(err, "err");
        }
    }

    static class AutoHelpMixin {
        private static final String KEY = "mixinStandardHelpOptions";
        @Option(names={"-h", "--help"}, usageHelp=true, descriptionKey="mixinStandardHelpOptions.help", description={"Show this help message and exit."})
        private boolean helpRequested;
        @Option(names={"-V", "--version"}, versionHelp=true, descriptionKey="mixinStandardHelpOptions.version", description={"Print version information and exit."})
        private boolean versionRequested;

        AutoHelpMixin() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuiltIn {
        static Set<String> traced = new HashSet<String>();

        private static TypeConversionException fail(String value, Class<?> c) {
            return BuiltIn.fail(value, c, "'%s' is not a %s");
        }

        private static TypeConversionException fail(String value, Class<?> c, String template) {
            return new TypeConversionException(String.format(template, value, c.getSimpleName()));
        }

        static void registerIfAvailable(Map<Class<?>, ITypeConverter<?>> registry, Tracer tracer, String fqcn, String factoryMethodName, Class<?> ... paramTypes) {
            BuiltIn.registerIfAvailable(registry, tracer, fqcn, fqcn, factoryMethodName, paramTypes);
        }

        static void registerIfAvailable(Map<Class<?>, ITypeConverter<?>> registry, Tracer tracer, String fqcn, String factoryClass, String factoryMethodName, Class<?> ... paramTypes) {
            if (BuiltIn.excluded(fqcn, tracer)) {
                return;
            }
            try {
                Class<?> cls = Class.forName(fqcn);
                Class<?> factory = Class.forName(factoryClass);
                Method method = factory.getDeclaredMethod(factoryMethodName, paramTypes);
                registry.put(cls, new ReflectionConverter(method, paramTypes));
            }
            catch (Exception e) {
                if (!traced.contains(fqcn)) {
                    tracer.debug("Could not register converter for %s: %s%n", fqcn, e.toString());
                }
                traced.add(fqcn);
            }
        }

        static boolean excluded(String fqcn, Tracer tracer) {
            String[] excludes;
            for (String regex : excludes = System.getProperty("picocli.converters.excludes", "").split(",")) {
                if (!fqcn.matches(regex)) continue;
                tracer.debug("BuiltIn type converter for %s is not loaded: (picocli.converters.excludes=%s)%n", fqcn, System.getProperty("picocli.converters.excludes"));
                return true;
            }
            return false;
        }

        private BuiltIn() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ReflectionConverter
        implements ITypeConverter<Object> {
            private final Method method;
            private Class<?>[] paramTypes;

            public ReflectionConverter(Method method, Class<?> ... paramTypes) {
                this.method = Assert.notNull(method, "method");
                this.paramTypes = Assert.notNull(paramTypes, "paramTypes");
            }

            @Override
            public Object convert(String s) {
                try {
                    if (this.paramTypes.length > 1) {
                        return this.method.invoke(null, s, new String[0]);
                    }
                    return this.method.invoke(null, s);
                }
                catch (InvocationTargetException e) {
                    throw new TypeConversionException(String.format("cannot convert '%s' to %s (%s)", s, this.method.getReturnType(), e.getTargetException()));
                }
                catch (Exception e) {
                    throw new TypeConversionException(String.format("Internal error converting '%s' to %s (%s)", s, this.method.getReturnType(), e));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class NetworkInterfaceConverter
        implements ITypeConverter<NetworkInterface> {
            NetworkInterfaceConverter() {
            }

            @Override
            public NetworkInterface convert(String s) throws Exception {
                try {
                    InetAddress addr = new InetAddressConverter().convert(s);
                    return NetworkInterface.getByInetAddress(addr);
                }
                catch (Exception ex) {
                    try {
                        return NetworkInterface.getByName(s);
                    }
                    catch (Exception ex2) {
                        throw new TypeConversionException("'" + s + "' is not an InetAddress or NetworkInterface name");
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ClassConverter
        implements ITypeConverter<Class<?>> {
            ClassConverter() {
            }

            @Override
            public Class<?> convert(String s) throws Exception {
                return Class.forName(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ByteOrderConverter
        implements ITypeConverter<ByteOrder> {
            ByteOrderConverter() {
            }

            @Override
            public ByteOrder convert(String s) throws Exception {
                if (s.equalsIgnoreCase(ByteOrder.BIG_ENDIAN.toString())) {
                    return ByteOrder.BIG_ENDIAN;
                }
                if (s.equalsIgnoreCase(ByteOrder.LITTLE_ENDIAN.toString())) {
                    return ByteOrder.LITTLE_ENDIAN;
                }
                throw new TypeConversionException("'" + s + "' is not a valid ByteOrder");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class TimeZoneConverter
        implements ITypeConverter<TimeZone> {
            TimeZoneConverter() {
            }

            @Override
            public TimeZone convert(String s) throws Exception {
                return TimeZone.getTimeZone(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CurrencyConverter
        implements ITypeConverter<Currency> {
            CurrencyConverter() {
            }

            @Override
            public Currency convert(String s) throws Exception {
                return Currency.getInstance(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class UUIDConverter
        implements ITypeConverter<UUID> {
            UUIDConverter() {
            }

            @Override
            public UUID convert(String s) throws Exception {
                return UUID.fromString(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class PatternConverter
        implements ITypeConverter<Pattern> {
            PatternConverter() {
            }

            @Override
            public Pattern convert(String s) {
                return Pattern.compile(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class InetAddressConverter
        implements ITypeConverter<InetAddress> {
            InetAddressConverter() {
            }

            @Override
            public InetAddress convert(String s) throws Exception {
                return InetAddress.getByName(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharsetConverter
        implements ITypeConverter<Charset> {
            CharsetConverter() {
            }

            @Override
            public Charset convert(String s) {
                return Charset.forName(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BigIntegerConverter
        implements ITypeConverter<BigInteger> {
            BigIntegerConverter() {
            }

            @Override
            public BigInteger convert(String value) {
                return new BigInteger(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BigDecimalConverter
        implements ITypeConverter<BigDecimal> {
            BigDecimalConverter() {
            }

            @Override
            public BigDecimal convert(String value) {
                return new BigDecimal(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ISO8601TimeConverter
        implements ITypeConverter<Object> {
            private static String FQCN = "java.sql.Time";

            ISO8601TimeConverter() {
            }

            @Override
            public Object convert(String value) {
                try {
                    if (value.length() <= 5) {
                        return this.createTime(new SimpleDateFormat("HH:mm").parse(value).getTime());
                    }
                    if (value.length() <= 8) {
                        return this.createTime(new SimpleDateFormat("HH:mm:ss").parse(value).getTime());
                    }
                    if (value.length() <= 12) {
                        try {
                            return this.createTime(new SimpleDateFormat("HH:mm:ss.SSS").parse(value).getTime());
                        }
                        catch (ParseException e2) {
                            return this.createTime(new SimpleDateFormat("HH:mm:ss,SSS").parse(value).getTime());
                        }
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                throw new TypeConversionException("'" + value + "' is not a HH:mm[:ss[.SSS]] time");
            }

            private Object createTime(long epochMillis) {
                try {
                    Class<?> timeClass = Class.forName(FQCN);
                    Constructor<?> constructor = timeClass.getDeclaredConstructor(Long.TYPE);
                    return constructor.newInstance(epochMillis);
                }
                catch (Exception e) {
                    throw new TypeConversionException("Unable to create new java.sql.Time with long value " + epochMillis + ": " + e.getMessage());
                }
            }

            public static void registerIfAvailable(Map<Class<?>, ITypeConverter<?>> registry, Tracer tracer) {
                if (BuiltIn.excluded(FQCN, tracer)) {
                    return;
                }
                try {
                    registry.put(Class.forName(FQCN), new ISO8601TimeConverter());
                }
                catch (Exception e) {
                    if (!traced.contains(FQCN)) {
                        tracer.debug("Could not register converter for %s: %s%n", FQCN, e.toString());
                    }
                    traced.add(FQCN);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ISO8601DateConverter
        implements ITypeConverter<Date> {
            ISO8601DateConverter() {
            }

            @Override
            public Date convert(String value) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(value);
                }
                catch (ParseException e) {
                    throw new TypeConversionException("'" + value + "' is not a yyyy-MM-dd date");
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class URIConverter
        implements ITypeConverter<URI> {
            URIConverter() {
            }

            @Override
            public URI convert(String value) throws URISyntaxException {
                return new URI(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class URLConverter
        implements ITypeConverter<URL> {
            URLConverter() {
            }

            @Override
            public URL convert(String value) throws MalformedURLException {
                return new URL(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FileConverter
        implements ITypeConverter<File> {
            FileConverter() {
            }

            @Override
            public File convert(String value) {
                return new File(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class DoubleConverter
        implements ITypeConverter<Double> {
            DoubleConverter() {
            }

            @Override
            public Double convert(String value) {
                try {
                    return Double.valueOf(value);
                }
                catch (Exception ex) {
                    throw BuiltIn.fail(value, Double.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FloatConverter
        implements ITypeConverter<Float> {
            FloatConverter() {
            }

            @Override
            public Float convert(String value) {
                try {
                    return Float.valueOf(value);
                }
                catch (Exception ex) {
                    throw BuiltIn.fail(value, Float.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class LongConverter
        implements ITypeConverter<Long> {
            LongConverter() {
            }

            @Override
            public Long convert(String value) {
                try {
                    return Long.valueOf(value);
                }
                catch (Exception ex) {
                    throw BuiltIn.fail(value, Long.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class IntegerConverter
        implements ITypeConverter<Integer> {
            IntegerConverter() {
            }

            @Override
            public Integer convert(String value) {
                try {
                    return Integer.valueOf(value);
                }
                catch (Exception ex) {
                    throw BuiltIn.fail(value, Integer.TYPE, "'%s' is not an %s");
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ShortConverter
        implements ITypeConverter<Short> {
            ShortConverter() {
            }

            @Override
            public Short convert(String value) {
                try {
                    return Short.valueOf(value);
                }
                catch (Exception ex) {
                    throw BuiltIn.fail(value, Short.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ByteConverter
        implements ITypeConverter<Byte> {
            ByteConverter() {
            }

            @Override
            public Byte convert(String value) {
                try {
                    return Byte.valueOf(value);
                }
                catch (Exception ex) {
                    throw BuiltIn.fail(value, Byte.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharacterConverter
        implements ITypeConverter<Character> {
            CharacterConverter() {
            }

            @Override
            public Character convert(String value) {
                if (value.length() > 1) {
                    throw new TypeConversionException("'" + value + "' is not a single character");
                }
                return Character.valueOf(value.charAt(0));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BooleanConverter
        implements ITypeConverter<Boolean> {
            BooleanConverter() {
            }

            @Override
            public Boolean convert(String value) {
                if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                    return Boolean.parseBoolean(value);
                }
                throw new TypeConversionException("'" + value + "' is not a boolean");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharSequenceConverter
        implements ITypeConverter<CharSequence> {
            CharSequenceConverter() {
            }

            @Override
            public String convert(String value) {
                return value;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class StringBuilderConverter
        implements ITypeConverter<StringBuilder> {
            StringBuilderConverter() {
            }

            @Override
            public StringBuilder convert(String value) {
                return new StringBuilder(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class StringConverter
        implements ITypeConverter<String> {
            StringConverter() {
            }

            @Override
            public String convert(String value) {
                return value;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PositionalParametersSorter
    implements Comparator<Model.ArgSpec> {
        private static final Range OPTION_INDEX = new Range(0, 0, false, true, "0");

        private PositionalParametersSorter() {
        }

        @Override
        public int compare(Model.ArgSpec p1, Model.ArgSpec p2) {
            int result = this.index(p1).compareTo(this.index(p2));
            return result == 0 ? p1.arity().compareTo(p2.arity()) : result;
        }

        private Range index(Model.ArgSpec arg) {
            return arg.isOption() ? OPTION_INDEX : ((Model.PositionalParamSpec)arg).index();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Interpreter {
        private final Map<Class<?>, ITypeConverter<?>> converterRegistry = new HashMap();
        private boolean isHelpRequested;
        private int position;
        private boolean endOfOptions;
        private ParseResult.Builder parseResult;

        Interpreter() {
            this.registerBuiltInConverters();
        }

        private void registerBuiltInConverters() {
            this.converterRegistry.put(Object.class, new BuiltIn.StringConverter());
            this.converterRegistry.put(String.class, new BuiltIn.StringConverter());
            this.converterRegistry.put(StringBuilder.class, new BuiltIn.StringBuilderConverter());
            this.converterRegistry.put(CharSequence.class, new BuiltIn.CharSequenceConverter());
            this.converterRegistry.put(Byte.class, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Byte.TYPE, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Boolean.class, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Boolean.TYPE, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Character.class, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Character.TYPE, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Short.class, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Short.TYPE, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Integer.class, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Integer.TYPE, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Long.class, new BuiltIn.LongConverter());
            this.converterRegistry.put(Long.TYPE, new BuiltIn.LongConverter());
            this.converterRegistry.put(Float.class, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Float.TYPE, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Double.class, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(Double.TYPE, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(File.class, new BuiltIn.FileConverter());
            this.converterRegistry.put(URI.class, new BuiltIn.URIConverter());
            this.converterRegistry.put(URL.class, new BuiltIn.URLConverter());
            this.converterRegistry.put(Date.class, new BuiltIn.ISO8601DateConverter());
            this.converterRegistry.put(BigDecimal.class, new BuiltIn.BigDecimalConverter());
            this.converterRegistry.put(BigInteger.class, new BuiltIn.BigIntegerConverter());
            this.converterRegistry.put(Charset.class, new BuiltIn.CharsetConverter());
            this.converterRegistry.put(InetAddress.class, new BuiltIn.InetAddressConverter());
            this.converterRegistry.put(Pattern.class, new BuiltIn.PatternConverter());
            this.converterRegistry.put(UUID.class, new BuiltIn.UUIDConverter());
            this.converterRegistry.put(Currency.class, new BuiltIn.CurrencyConverter());
            this.converterRegistry.put(TimeZone.class, new BuiltIn.TimeZoneConverter());
            this.converterRegistry.put(ByteOrder.class, new BuiltIn.ByteOrderConverter());
            this.converterRegistry.put(Class.class, new BuiltIn.ClassConverter());
            this.converterRegistry.put(NetworkInterface.class, new BuiltIn.NetworkInterfaceConverter());
            BuiltIn.ISO8601TimeConverter.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.sql.Connection", "java.sql.DriverManager", "getConnection", String.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.sql.Driver", "java.sql.DriverManager", "getDriver", String.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.sql.Timestamp", "java.sql.Timestamp", "valueOf", String.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.Duration", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.Instant", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.LocalDate", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.LocalDateTime", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.LocalTime", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.MonthDay", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.OffsetDateTime", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.OffsetTime", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.Period", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.Year", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.YearMonth", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.ZonedDateTime", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.ZoneId", "of", String.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.ZoneOffset", "of", String.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.nio.file.Path", "java.nio.file.Paths", "get", String.class, String[].class);
        }

        private Model.ParserSpec config() {
            return CommandLine.this.commandSpec.parser();
        }

        List<CommandLine> parse(String ... args) {
            Assert.notNull(args, "argument array");
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("Picocli version: %s%n", CommandLine.versionString());
            }
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("Parsing %d command line args %s%n", args.length, Arrays.toString(args));
            }
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Parser configuration: %s%n", this.config());
            }
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("(ANSI is %s by default: isatty=%s, XTERM=%s, OSTYPE=%s, isWindows=%s, JansiConsoleInstalled=%s, ANSICON=%s, ConEmuANSI=%s, NO_COLOR=%s, CLICOLOR=%s, CLICOLOR_FORCE=%s)%n", Help.Ansi.ansiPossible() ? "enabled" : "disabled", Help.Ansi.isTTY(), System.getenv("XTERM"), System.getenv("OSTYPE"), Help.Ansi.isWindows(), Help.Ansi.isJansiConsoleInstalled(), System.getenv("ANSICON"), System.getenv("ConEmuANSI"), System.getenv("NO_COLOR"), System.getenv("CLICOLOR"), System.getenv("CLICOLOR_FORCE"));
            }
            ArrayList<String> expanded = new ArrayList<String>();
            for (String arg : args) {
                this.addOrExpand(arg, expanded, new LinkedHashSet<String>());
            }
            Stack<String> arguments = new Stack<String>();
            arguments.addAll(CommandLine.reverseList(expanded));
            ArrayList<CommandLine> result = new ArrayList<CommandLine>();
            this.parse(result, arguments, args, new ArrayList<Object>());
            return result;
        }

        private void addOrExpand(String arg, List<String> arguments, Set<String> visited) {
            if (this.config().expandAtFiles() && !arg.equals("@") && arg.startsWith("@")) {
                if ((arg = arg.substring(1)).startsWith("@")) {
                    if (CommandLine.this.tracer.isInfo()) {
                        CommandLine.this.tracer.info("Not expanding @-escaped argument %s (trimmed leading '@' char)%n", arg);
                    }
                } else {
                    if (CommandLine.this.tracer.isInfo()) {
                        CommandLine.this.tracer.info("Expanding argument file @%s%n", arg);
                    }
                    this.expandArgumentFile(arg, arguments, visited);
                    return;
                }
            }
            arguments.add(arg);
        }

        private void expandArgumentFile(String fileName, List<String> arguments, Set<String> visited) {
            File file = new File(fileName);
            if (!file.canRead()) {
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("File %s does not exist or cannot be read; treating argument literally%n", fileName);
                }
                arguments.add("@" + fileName);
            } else if (visited.contains(file.getAbsolutePath())) {
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("Already visited file %s; ignoring...%n", file.getAbsolutePath());
                }
            } else {
                this.expandValidArgumentFile(fileName, file, arguments, visited);
            }
        }

        private void expandValidArgumentFile(String fileName, File file, List<String> arguments, Set<String> visited) {
            ArrayList<String> result = new ArrayList<String>();
            BufferedReader reader = null;
            try {
                visited.add(file.getAbsolutePath());
                reader = new LineNumberReader(new FileReader(file));
                if (CommandLine.this.commandSpec.parser().useSimplifiedAtFiles()) {
                    String token;
                    while ((token = ((LineNumberReader)reader).readLine()) != null) {
                        if (token.length() <= 0 || token.trim().startsWith(String.valueOf(CommandLine.this.commandSpec.parser().atFileCommentChar()))) continue;
                        this.addOrExpand(token, result, visited);
                    }
                } else {
                    StreamTokenizer tok = new StreamTokenizer(reader);
                    tok.resetSyntax();
                    tok.wordChars(32, 255);
                    tok.whitespaceChars(0, 32);
                    tok.quoteChar(34);
                    tok.quoteChar(39);
                    if (CommandLine.this.commandSpec.parser().atFileCommentChar() != null) {
                        tok.commentChar(CommandLine.this.commandSpec.parser().atFileCommentChar().charValue());
                    }
                    while (tok.nextToken() != -1) {
                        this.addOrExpand(tok.sval, result, visited);
                    }
                }
            }
            catch (Exception ex) {
                throw new InitializationException("Could not read argument file @" + fileName, ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("Expanded file @%s to arguments %s%n", fileName, result);
            }
            arguments.addAll(result);
        }

        private void clear() {
            this.position = 0;
            this.endOfOptions = false;
            this.isHelpRequested = false;
            this.parseResult = ParseResult.builder(CommandLine.this.getCommandSpec());
            for (Model.OptionSpec option : CommandLine.this.getCommandSpec().options()) {
                this.clear(option);
            }
            for (Model.PositionalParamSpec positional : CommandLine.this.getCommandSpec().positionalParameters()) {
                this.clear(positional);
            }
        }

        private void clear(Model.ArgSpec argSpec) {
            argSpec.resetStringValues();
            argSpec.resetOriginalStringValues();
            argSpec.typedValues.clear();
            argSpec.typedValueAtPosition.clear();
            if (argSpec.hasInitialValue()) {
                try {
                    argSpec.setter().set(argSpec.initialValue());
                    CommandLine.this.tracer.debug("Set initial value for %s of type %s to %s.%n", argSpec, argSpec.type(), String.valueOf(argSpec.initialValue()));
                }
                catch (Exception ex) {
                    CommandLine.this.tracer.warn("Could not set initial value for %s of type %s to %s: %s%n", argSpec, argSpec.type(), String.valueOf(argSpec.initialValue()), ex);
                }
            } else {
                CommandLine.this.tracer.debug("Initial value not available for %s%n", argSpec);
            }
        }

        private void maybeThrow(PicocliException ex) throws PicocliException {
            if (!CommandLine.this.commandSpec.parser().collectErrors) {
                throw ex;
            }
            this.parseResult.addError(ex);
        }

        private void parse(List<CommandLine> parsedCommands, Stack<String> argumentStack, String[] originalArgs, List<Object> nowProcessing) {
            this.clear();
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Initializing %s: %d options, %d positional parameters, %d required, %d subcommands.%n", CommandLine.this.commandSpec.toString(), new HashSet<Model.OptionSpec>(CommandLine.this.commandSpec.optionsMap().values()).size(), CommandLine.this.commandSpec.positionalParameters().size(), CommandLine.this.commandSpec.requiredArgs().size(), CommandLine.this.commandSpec.subcommands().size());
            }
            parsedCommands.add(CommandLine.this);
            ArrayList<Model.ArgSpec> required = new ArrayList<Model.ArgSpec>(CommandLine.this.commandSpec.requiredArgs());
            HashSet<Model.ArgSpec> initialized = new HashSet<Model.ArgSpec>();
            Collections.sort(required, new PositionalParametersSorter());
            boolean continueOnError = CommandLine.this.commandSpec.parser().collectErrors();
            do {
                int stackSize = argumentStack.size();
                try {
                    this.applyDefaultValues(required);
                    this.processArguments(parsedCommands, argumentStack, required, initialized, originalArgs, nowProcessing);
                }
                catch (ParameterException ex) {
                    this.maybeThrow(ex);
                }
                catch (Exception ex) {
                    int offendingArgIndex = originalArgs.length - argumentStack.size() - 1;
                    String arg = offendingArgIndex >= 0 && offendingArgIndex < originalArgs.length ? originalArgs[offendingArgIndex] : "?";
                    this.maybeThrow(ParameterException.create(CommandLine.this, ex, arg, offendingArgIndex, originalArgs));
                }
                if (!continueOnError || stackSize != argumentStack.size() || stackSize <= 0) continue;
                this.parseResult.unmatched.add(argumentStack.pop());
            } while (!argumentStack.isEmpty() && continueOnError);
            if (!this.isAnyHelpRequested() && !required.isEmpty()) {
                for (Model.ArgSpec missing : required) {
                    if (missing.isOption()) {
                        this.maybeThrow(MissingParameterException.create(CommandLine.this, required, this.config().separator()));
                        continue;
                    }
                    this.assertNoMissingParameters(missing, missing.arity(), argumentStack);
                }
            }
            if (!this.parseResult.unmatched.isEmpty()) {
                String[] unmatched = this.parseResult.unmatched.toArray(new String[0]);
                for (Model.UnmatchedArgsBinding unmatchedArgsBinding : CommandLine.this.getCommandSpec().unmatchedArgsBindings()) {
                    unmatchedArgsBinding.addAll((String[])unmatched.clone());
                }
                if (!CommandLine.this.isUnmatchedArgumentsAllowed()) {
                    this.maybeThrow(new UnmatchedArgumentException(CommandLine.this, Collections.unmodifiableList(this.parseResult.unmatched)));
                }
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("Unmatched arguments: %s%n", this.parseResult.unmatched);
                }
            }
        }

        private void applyDefaultValues(List<Model.ArgSpec> required) throws Exception {
            this.parseResult.isInitializingDefaultValues = true;
            for (Model.OptionSpec option : CommandLine.this.commandSpec.options()) {
                this.applyDefault(CommandLine.this.commandSpec.defaultValueProvider(), option, required);
            }
            for (Model.PositionalParamSpec positional : CommandLine.this.commandSpec.positionalParameters()) {
                this.applyDefault(CommandLine.this.commandSpec.defaultValueProvider(), positional, required);
            }
            this.parseResult.isInitializingDefaultValues = false;
        }

        private void applyDefault(IDefaultValueProvider defaultValueProvider, Model.ArgSpec arg, List<Model.ArgSpec> required) throws Exception {
            String defaultValue;
            String fromProvider = defaultValueProvider == null ? null : defaultValueProvider.defaultValue(arg);
            String string = defaultValue = fromProvider == null ? arg.defaultValue() : fromProvider;
            if (defaultValue == null) {
                return;
            }
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Applying defaultValue (%s) to %s%n", defaultValue, arg);
            }
            Range arity = arg.arity().min(Math.max(1, arg.arity().min));
            this.applyOption(arg, LookBehind.SEPARATE, arity, this.stack(defaultValue), new HashSet<Model.ArgSpec>(), arg.toString);
            required.remove(arg);
        }

        private Stack<String> stack(String value) {
            Stack<String> result = new Stack<String>();
            result.push(value);
            return result;
        }

        private void processArguments(List<CommandLine> parsedCommands, Stack<String> args, Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, String[] originalArgs, List<Object> nowProcessing) throws Exception {
            this.parseResult.originalArgs(originalArgs);
            this.parseResult.nowProcessing = nowProcessing;
            String separator = this.config().separator();
            while (!args.isEmpty()) {
                if (this.endOfOptions) {
                    this.processRemainderAsPositionalParameters(required, initialized, args);
                    return;
                }
                String arg = args.pop();
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Processing argument '%s'. Remainder=%s%n", arg, CommandLine.reverse(CommandLine.copy(args)));
                }
                if (CommandLine.this.commandSpec.parser.endOfOptionsDelimiter().equals(arg)) {
                    CommandLine.this.tracer.info("Found end-of-options delimiter '--'. Treating remainder as positional parameters.%n", new Object[0]);
                    this.endOfOptions = true;
                    this.processRemainderAsPositionalParameters(required, initialized, args);
                    return;
                }
                if (CommandLine.this.commandSpec.subcommands().containsKey(arg)) {
                    CommandLine subcommand = CommandLine.this.commandSpec.subcommands().get(arg);
                    nowProcessing.add(subcommand.commandSpec);
                    this.updateHelpRequested(subcommand.commandSpec);
                    if (!this.isAnyHelpRequested() && !required.isEmpty()) {
                        throw MissingParameterException.create(CommandLine.this, required, separator);
                    }
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Found subcommand '%s' (%s)%n", arg, subcommand.commandSpec.toString());
                    }
                    subcommand.interpreter.parse(parsedCommands, args, originalArgs, nowProcessing);
                    this.parseResult.subcommand(((CommandLine)subcommand).interpreter.parseResult.build());
                    return;
                }
                boolean paramAttachedToOption = false;
                int separatorIndex = arg.indexOf(separator);
                if (separatorIndex > 0) {
                    String key = arg.substring(0, separatorIndex);
                    if (CommandLine.this.commandSpec.optionsMap().containsKey(key) && CommandLine.this.commandSpec.optionsMap().containsKey(arg)) {
                        CommandLine.this.tracer.warn("Both '%s' and '%s' are valid option names in %s. Using '%s'...%n", arg, key, CommandLine.this.getCommandName(), arg);
                    } else if (CommandLine.this.commandSpec.optionsMap().containsKey(key)) {
                        paramAttachedToOption = true;
                        String optionParam = arg.substring(separatorIndex + separator.length());
                        args.push(optionParam);
                        arg = key;
                        if (CommandLine.this.tracer.isDebug()) {
                            CommandLine.this.tracer.debug("Separated '%s' option from '%s' option parameter%n", key, optionParam);
                        }
                    } else if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("'%s' contains separator '%s' but '%s' is not a known option%n", arg, separator, key);
                    }
                } else if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("'%s' cannot be separated into <option>%s<option-parameter>%n", arg, separator);
                }
                if (this.isStandaloneOption(arg)) {
                    this.processStandaloneOption(required, initialized, arg, args, paramAttachedToOption);
                    continue;
                }
                if (this.config().posixClusteredShortOptionsAllowed() && arg.length() > 2 && arg.startsWith("-")) {
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Trying to process '%s' as clustered short options%n", arg, args);
                    }
                    this.processClusteredShortOptions(required, initialized, arg, args);
                    continue;
                }
                args.push(arg);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Could not find option '%s', deciding whether to treat as unmatched option or positional parameter...%n", arg);
                }
                if (CommandLine.this.commandSpec.resemblesOption(arg, CommandLine.this.tracer)) {
                    this.handleUnmatchedArgument(args);
                    continue;
                }
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("No option named '%s' found. Processing remainder as positional parameters%n", arg);
                }
                this.processPositionalParameter(required, initialized, args);
            }
        }

        private boolean isStandaloneOption(String arg) {
            return CommandLine.this.commandSpec.optionsMap().containsKey(arg);
        }

        private void handleUnmatchedArgument(Stack<String> args) throws Exception {
            if (!args.isEmpty()) {
                this.handleUnmatchedArgument(args.pop());
            }
            if (this.config().stopAtUnmatched()) {
                while (!args.isEmpty()) {
                    this.handleUnmatchedArgument(args.pop());
                }
            }
        }

        private void handleUnmatchedArgument(String arg) {
            this.parseResult.unmatched.add(arg);
        }

        private void processRemainderAsPositionalParameters(Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, Stack<String> args) throws Exception {
            while (!args.empty()) {
                this.processPositionalParameter(required, initialized, args);
            }
        }

        private void processPositionalParameter(Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, Stack<String> args) throws Exception {
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Processing next arg as a positional parameter at index=%d. Remainder=%s%n", this.position, CommandLine.reverse(CommandLine.copy(args)));
            }
            if (this.config().stopAtPositional()) {
                if (!this.endOfOptions && CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Parser was configured with stopAtPositional=true, treating remaining arguments as positional parameters.%n", new Object[0]);
                }
                this.endOfOptions = true;
            }
            int argsConsumed = 0;
            int interactiveConsumed = 0;
            int originalNowProcessingSize = this.parseResult.nowProcessing.size();
            for (Model.PositionalParamSpec positionalParam : CommandLine.this.commandSpec.positionalParameters()) {
                Range indexRange = positionalParam.index();
                if (!indexRange.contains(this.position) || positionalParam.typedValueAtPosition.get(this.position) != null) continue;
                Stack argsCopy = CommandLine.copy(args);
                Range arity = positionalParam.arity();
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Position %d is in index range %s. Trying to assign args to %s, arity=%s%n", this.position, indexRange, positionalParam, arity);
                }
                if (!this.assertNoMissingParameters(positionalParam, arity, argsCopy)) break;
                int originalSize = argsCopy.size();
                int actuallyConsumed = this.applyOption(positionalParam, LookBehind.SEPARATE, arity, argsCopy, initialized, "args[" + indexRange + "] at position " + this.position);
                int count = originalSize - argsCopy.size();
                if (count > 0 || actuallyConsumed > 0) {
                    required.remove(positionalParam);
                    if (positionalParam.interactive()) {
                        ++interactiveConsumed;
                    }
                }
                argsConsumed = Math.max(argsConsumed, count);
                while (this.parseResult.nowProcessing.size() > originalNowProcessingSize + count) {
                    this.parseResult.nowProcessing.remove(this.parseResult.nowProcessing.size() - 1);
                }
            }
            for (int i = 0; i < argsConsumed; ++i) {
                args.pop();
            }
            this.position += argsConsumed + interactiveConsumed;
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Consumed %d arguments and %d interactive values, moving position to index %d.%n", argsConsumed, interactiveConsumed, this.position);
            }
            if (argsConsumed == 0 && interactiveConsumed == 0 && !args.isEmpty()) {
                this.handleUnmatchedArgument(args);
            }
        }

        private void processStandaloneOption(Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, String arg, Stack<String> args, boolean paramAttachedToKey) throws Exception {
            LookBehind lookBehind;
            Model.ArgSpec argSpec = CommandLine.this.commandSpec.optionsMap().get(arg);
            required.remove(argSpec);
            Range arity = argSpec.arity();
            if (paramAttachedToKey) {
                arity = arity.min(Math.max(1, arity.min));
            }
            LookBehind lookBehind2 = lookBehind = paramAttachedToKey ? LookBehind.ATTACHED_WITH_SEPARATOR : LookBehind.SEPARATE;
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Found option named '%s': %s, arity=%s%n", arg, argSpec, arity);
            }
            this.parseResult.nowProcessing.add(argSpec);
            this.applyOption(argSpec, lookBehind, arity, args, initialized, "option " + arg);
        }

        private void processClusteredShortOptions(Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, String arg, Stack<String> args) throws Exception {
            String prefix = arg.substring(0, 1);
            String cluster = arg.substring(1);
            boolean paramAttachedToOption = true;
            boolean first = true;
            while (cluster.length() > 0 && CommandLine.this.commandSpec.posixOptionsMap().containsKey(Character.valueOf(cluster.charAt(0)))) {
                LookBehind lookBehind;
                Model.ArgSpec argSpec = CommandLine.this.commandSpec.posixOptionsMap().get(Character.valueOf(cluster.charAt(0)));
                Range arity = argSpec.arity();
                String argDescription = "option " + prefix + cluster.charAt(0);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Found option '%s%s' in %s: %s, arity=%s%n", prefix, Character.valueOf(cluster.charAt(0)), arg, argSpec, arity);
                }
                required.remove(argSpec);
                cluster = cluster.substring(1);
                paramAttachedToOption = cluster.length() > 0;
                LookBehind lookBehind2 = lookBehind = paramAttachedToOption ? LookBehind.ATTACHED : LookBehind.SEPARATE;
                if (cluster.startsWith(this.config().separator())) {
                    lookBehind = LookBehind.ATTACHED_WITH_SEPARATOR;
                    cluster = cluster.substring(this.config().separator().length());
                    arity = arity.min(Math.max(1, arity.min));
                }
                if (arity.min > 0 && !CommandLine.empty(cluster) && CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Trying to process '%s' as option parameter%n", cluster);
                }
                if (!CommandLine.empty(cluster)) {
                    args.push(cluster);
                }
                if (first) {
                    this.parseResult.nowProcessing.add(argSpec);
                    first = false;
                } else {
                    this.parseResult.nowProcessing.set(this.parseResult.nowProcessing.size() - 1, argSpec);
                }
                int argCount = args.size();
                int consumed = this.applyOption(argSpec, lookBehind, arity, args, initialized, argDescription);
                if (CommandLine.empty(cluster) || args.isEmpty() || args.size() < argCount) {
                    return;
                }
                cluster = args.pop();
            }
            if (cluster.length() == 0) {
                return;
            }
            if (arg.endsWith(cluster)) {
                args.push(paramAttachedToOption ? prefix + cluster : cluster);
                if (args.peek().equals(arg)) {
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Could not match any short options in %s, deciding whether to treat as unmatched option or positional parameter...%n", arg);
                    }
                    if (CommandLine.this.commandSpec.resemblesOption(arg, CommandLine.this.tracer)) {
                        this.handleUnmatchedArgument(args);
                        return;
                    }
                    this.processPositionalParameter(required, initialized, args);
                    return;
                }
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("No option found for %s in %s%n", cluster, arg);
                }
                String tmp = args.pop();
                tmp = tmp + " (while processing option: '" + arg + "')";
                args.push(tmp);
                this.handleUnmatchedArgument(args);
            } else {
                args.push(cluster);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("%s is not an option parameter for %s%n", cluster, arg);
                }
                this.processPositionalParameter(required, initialized, args);
            }
        }

        private int applyOption(Model.ArgSpec argSpec, LookBehind lookBehind, Range arity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            this.updateHelpRequested(argSpec);
            boolean consumeOnlyOne = CommandLine.this.commandSpec.parser().aritySatisfiedByAttachedOptionParam() && lookBehind.isAttached();
            Stack<String> workingStack = args;
            if (consumeOnlyOne) {
                workingStack = args.isEmpty() ? args : this.stack(args.pop());
            } else if (!this.assertNoMissingParameters(argSpec, arity, args)) {
                return 0;
            }
            if (argSpec.interactive()) {
                String name = argSpec.isOption() ? ((Model.OptionSpec)argSpec).longestName() : "position " + this.position;
                String prompt = String.format("Enter value for %s (%s): ", name, CommandLine.str(argSpec.renderedDescription(), 0));
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Reading value for %s from console...%n", name);
                }
                char[] value = this.readPassword(prompt);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("User entered '%s' for %s.%n", value, name);
                }
                workingStack.push(new String(value));
            }
            int result = argSpec.type().isArray() ? this.applyValuesToArrayField(argSpec, lookBehind, arity, workingStack, initialized, argDescription) : (Collection.class.isAssignableFrom(argSpec.type()) ? this.applyValuesToCollectionField(argSpec, lookBehind, arity, workingStack, initialized, argDescription) : (Map.class.isAssignableFrom(argSpec.type()) ? this.applyValuesToMapField(argSpec, lookBehind, arity, workingStack, initialized, argDescription) : this.applyValueToSingleValuedField(argSpec, lookBehind, arity, workingStack, initialized, argDescription)));
            if (workingStack != args && !workingStack.isEmpty()) {
                args.push(workingStack.pop());
                Assert.assertTrue(workingStack.isEmpty(), "Working stack should be empty but was " + new ArrayList<String>(workingStack));
            }
            return result;
        }

        private int applyValueToSingleValuedField(Model.ArgSpec argSpec, LookBehind lookBehind, Range derivedArity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            Range arity;
            boolean noMoreValues = args.isEmpty();
            String value = args.isEmpty() ? null : this.trim(args.pop());
            Range range = arity = argSpec.arity().isUnspecified ? derivedArity : argSpec.arity();
            if (arity.max == 0 && !arity.isUnspecified && lookBehind == LookBehind.ATTACHED_WITH_SEPARATOR) {
                throw new MaxValuesExceededException(CommandLine.this, this.optionDescription("", argSpec, 0) + " should be specified without '" + value + "' parameter");
            }
            int result = arity.min;
            Class<?> cls = argSpec.auxiliaryTypes()[0];
            if (arity.min <= 0) {
                if (cls == Boolean.class || cls == Boolean.TYPE) {
                    if (arity.max > 0 && ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value))) {
                        result = 1;
                        if (!lookBehind.isAttached()) {
                            this.parseResult.nowProcessing(argSpec, value);
                        }
                    } else if (lookBehind != LookBehind.ATTACHED_WITH_SEPARATOR) {
                        Boolean currentValue;
                        if (value != null) {
                            args.push(value);
                        }
                        value = CommandLine.this.commandSpec.parser().toggleBooleanFlags() ? String.valueOf((currentValue = (Boolean)argSpec.getValue()) == null || currentValue == false) : "true";
                    }
                } else if (this.isOption(value)) {
                    args.push(value);
                    value = "";
                } else if (value == null) {
                    value = "";
                } else if (!lookBehind.isAttached()) {
                    this.parseResult.nowProcessing(argSpec, value);
                }
            } else if (!lookBehind.isAttached()) {
                this.parseResult.nowProcessing(argSpec, value);
            }
            if (noMoreValues && value == null) {
                return 0;
            }
            ITypeConverter<?> converter = this.getTypeConverter(cls, argSpec, 0);
            Object newValue = this.tryConvert(argSpec, -1, converter, value, cls);
            Object oldValue = argSpec.getValue();
            String traceMessage = "Setting %s to '%3$s' (was '%2$s') for %4$s%n";
            if (initialized.contains(argSpec)) {
                if (!CommandLine.this.isOverwrittenOptionsAllowed()) {
                    throw new OverwrittenOptionException(CommandLine.this, argSpec, this.optionDescription("", argSpec, 0) + " should be specified only once");
                }
                traceMessage = "Overwriting %s value '%s' with '%s' for %s%n";
            }
            initialized.add(argSpec);
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info(traceMessage, argSpec.toString(), String.valueOf(oldValue), String.valueOf(newValue), argDescription);
            }
            argSpec.setValue(newValue);
            this.parseResult.addOriginalStringValue(argSpec, value);
            this.parseResult.addStringValue(argSpec, value);
            this.parseResult.addTypedValues(argSpec, this.position, newValue);
            this.parseResult.add(argSpec, this.position);
            return result;
        }

        private int applyValuesToMapField(Model.ArgSpec argSpec, LookBehind lookBehind, Range arity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            Class<?>[] classes = argSpec.auxiliaryTypes();
            if (classes.length < 2) {
                throw new ParameterException(CommandLine.this, argSpec.toString() + " needs two types (one for the map key, one for the value) but only has " + classes.length + " types configured.", argSpec, null);
            }
            ITypeConverter<?> keyConverter = this.getTypeConverter(classes[0], argSpec, 0);
            ITypeConverter<?> valueConverter = this.getTypeConverter(classes[1], argSpec, 1);
            Map<Object, Object> map = (Map<Object, Object>)argSpec.getValue();
            if (map == null || !map.isEmpty() && !initialized.contains(argSpec)) {
                CommandLine.this.tracer.debug("Initializing binding for %s with empty %s%n", this.optionDescription("", argSpec, 0), argSpec.type().getSimpleName());
                map = this.createMap(argSpec.type());
                argSpec.setValue(map);
            }
            initialized.add(argSpec);
            int originalSize = map.size();
            this.consumeMapArguments(argSpec, lookBehind, arity, args, classes, keyConverter, valueConverter, map, argDescription);
            this.parseResult.add(argSpec, this.position);
            argSpec.setValue(map);
            return map.size() - originalSize;
        }

        private void consumeMapArguments(Model.ArgSpec argSpec, LookBehind lookBehind, Range arity, Stack<String> args, Class<?>[] classes, ITypeConverter<?> keyConverter, ITypeConverter<?> valueConverter, Map<Object, Object> result, String argDescription) throws Exception {
            LinkedHashMap<Object, Object> typedValuesAtPosition;
            int currentPosition = this.position;
            int initialSize = argSpec.stringValues().size();
            int consumed = this.consumedCountMap(0, initialSize, argSpec);
            int i = 0;
            while (consumed < arity.min && !args.isEmpty()) {
                typedValuesAtPosition = new LinkedHashMap<Object, Object>();
                this.parseResult.addTypedValues(argSpec, currentPosition++, typedValuesAtPosition);
                this.assertNoMissingMandatoryParameter(argSpec, args, i, arity);
                this.consumeOneMapArgument(argSpec, lookBehind, arity, consumed, args.pop(), classes, keyConverter, valueConverter, typedValuesAtPosition, i, argDescription);
                result.putAll(typedValuesAtPosition);
                consumed = this.consumedCountMap(i + 1, initialSize, argSpec);
                lookBehind = LookBehind.SEPARATE;
                ++i;
            }
            i = consumed;
            while (consumed < arity.max && !args.isEmpty() && this.varargCanConsumeNextValue(argSpec, args.peek())) {
                typedValuesAtPosition = new LinkedHashMap();
                this.parseResult.addTypedValues(argSpec, currentPosition++, typedValuesAtPosition);
                if (!this.canConsumeOneMapArgument(argSpec, arity, consumed, args.peek(), classes, keyConverter, valueConverter, argDescription)) break;
                this.consumeOneMapArgument(argSpec, lookBehind, arity, consumed, args.pop(), classes, keyConverter, valueConverter, typedValuesAtPosition, i, argDescription);
                result.putAll(typedValuesAtPosition);
                consumed = this.consumedCountMap(i + 1, initialSize, argSpec);
                lookBehind = LookBehind.SEPARATE;
                ++i;
            }
        }

        private void consumeOneMapArgument(Model.ArgSpec argSpec, LookBehind lookBehind, Range arity, int consumed, String arg, Class<?>[] classes, ITypeConverter<?> keyConverter, ITypeConverter<?> valueConverter, Map<Object, Object> result, int index, String argDescription) {
            String[] values;
            if (!lookBehind.isAttached()) {
                this.parseResult.nowProcessing(argSpec, arg);
            }
            String raw = this.trim(arg);
            for (String value : values = argSpec.splitValue(raw, CommandLine.this.commandSpec.parser(), arity, consumed)) {
                String[] keyValue = this.splitKeyValue(argSpec, value);
                Object mapKey = this.tryConvert(argSpec, index, keyConverter, keyValue[0], classes[0]);
                Object mapValue = this.tryConvert(argSpec, index, valueConverter, keyValue[1], classes[1]);
                result.put(mapKey, mapValue);
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("Putting [%s : %s] in %s<%s, %s> %s for %s%n", String.valueOf(mapKey), String.valueOf(mapValue), result.getClass().getSimpleName(), classes[0].getSimpleName(), classes[1].getSimpleName(), argSpec.toString(), argDescription);
                }
                this.parseResult.addStringValue(argSpec, keyValue[0]);
                this.parseResult.addStringValue(argSpec, keyValue[1]);
            }
            this.parseResult.addOriginalStringValue(argSpec, raw);
        }

        private boolean canConsumeOneMapArgument(Model.ArgSpec argSpec, Range arity, int consumed, String raw, Class<?>[] classes, ITypeConverter<?> keyConverter, ITypeConverter<?> valueConverter, String argDescription) {
            String[] values = argSpec.splitValue(raw, CommandLine.this.commandSpec.parser(), arity, consumed);
            try {
                for (String value : values) {
                    String[] keyValue = this.splitKeyValue(argSpec, value);
                    this.tryConvert(argSpec, -1, keyConverter, keyValue[0], classes[0]);
                    this.tryConvert(argSpec, -1, valueConverter, keyValue[1], classes[1]);
                }
                return true;
            }
            catch (PicocliException ex) {
                CommandLine.this.tracer.debug("$s cannot be assigned to %s: type conversion fails: %s.%n", raw, argDescription, ex.getMessage());
                return false;
            }
        }

        private String[] splitKeyValue(Model.ArgSpec argSpec, String value) {
            String[] keyValue = Model.ArgSpec.splitRespectingQuotedStrings(value, 2, this.config(), argSpec, "=");
            if (keyValue.length < 2) {
                String splitRegex = argSpec.splitRegex();
                if (splitRegex.length() == 0) {
                    throw new ParameterException(CommandLine.this, "Value for option " + this.optionDescription("", argSpec, 0) + " should be in KEY=VALUE format but was " + value, argSpec, value);
                }
                throw new ParameterException(CommandLine.this, "Value for option " + this.optionDescription("", argSpec, 0) + " should be in KEY=VALUE[" + splitRegex + "KEY=VALUE]... format but was " + value, argSpec, value);
            }
            return keyValue;
        }

        private void assertNoMissingMandatoryParameter(Model.ArgSpec argSpec, Stack<String> args, int i, Range arity) {
            if (!this.varargCanConsumeNextValue(argSpec, args.peek())) {
                String desc = arity.min > 1 ? i + 1 + " (of " + arity.min + " mandatory parameters) " : "";
                throw new MissingParameterException(CommandLine.this, argSpec, "Expected parameter " + desc + "for " + this.optionDescription("", argSpec, -1) + " but found '" + args.peek() + "'");
            }
        }

        private int applyValuesToArrayField(Model.ArgSpec argSpec, LookBehind lookBehind, Range arity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            Object existing = argSpec.getValue();
            int length = existing == null ? 0 : Array.getLength(existing);
            Class<?> type = argSpec.auxiliaryTypes()[0];
            List<Object> converted = this.consumeArguments(argSpec, lookBehind, arity, args, type, argDescription);
            ArrayList<Object> newValues = new ArrayList<Object>();
            if (initialized.contains(argSpec)) {
                for (int i = 0; i < length; ++i) {
                    newValues.add(Array.get(existing, i));
                }
            }
            initialized.add(argSpec);
            for (Object obj : converted) {
                if (obj instanceof Collection) {
                    newValues.addAll((Collection)obj);
                    continue;
                }
                newValues.add(obj);
            }
            Object array = Array.newInstance(type, newValues.size());
            for (int i = 0; i < newValues.size(); ++i) {
                Array.set(array, i, newValues.get(i));
            }
            argSpec.setValue(array);
            this.parseResult.add(argSpec, this.position);
            return converted.size();
        }

        private int applyValuesToCollectionField(Model.ArgSpec argSpec, LookBehind lookBehind, Range arity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            Collection<Object> collection = (Collection<Object>)argSpec.getValue();
            Class<?> type = argSpec.auxiliaryTypes()[0];
            List<Object> converted = this.consumeArguments(argSpec, lookBehind, arity, args, type, argDescription);
            if (collection == null || !collection.isEmpty() && !initialized.contains(argSpec)) {
                CommandLine.this.tracer.debug("Initializing binding for %s with empty %s%n", this.optionDescription("", argSpec, 0), argSpec.type().getSimpleName());
                collection = this.createCollection(argSpec.type(), type);
                argSpec.setValue(collection);
            }
            initialized.add(argSpec);
            for (Object element : converted) {
                if (element instanceof Collection) {
                    collection.addAll((Collection)element);
                    continue;
                }
                collection.add(element);
            }
            this.parseResult.add(argSpec, this.position);
            argSpec.setValue(collection);
            return converted.size();
        }

        private List<Object> consumeArguments(Model.ArgSpec argSpec, LookBehind lookBehind, Range arity, Stack<String> args, Class<?> type, String argDescription) throws Exception {
            ArrayList<Object> typedValuesAtPosition;
            ArrayList<Object> result = new ArrayList<Object>();
            int currentPosition = this.position;
            int initialSize = argSpec.stringValues().size();
            int consumed = this.consumedCount(0, initialSize, argSpec);
            int i = 0;
            while (consumed < arity.min && !args.isEmpty()) {
                typedValuesAtPosition = new ArrayList<Object>();
                this.parseResult.addTypedValues(argSpec, currentPosition++, typedValuesAtPosition);
                this.assertNoMissingMandatoryParameter(argSpec, args, i, arity);
                this.consumeOneArgument(argSpec, lookBehind, arity, consumed, args.pop(), type, typedValuesAtPosition, i, argDescription);
                result.addAll(typedValuesAtPosition);
                consumed = this.consumedCount(i + 1, initialSize, argSpec);
                lookBehind = LookBehind.SEPARATE;
                ++i;
            }
            i = consumed;
            while (consumed < arity.max && !args.isEmpty() && this.varargCanConsumeNextValue(argSpec, args.peek())) {
                typedValuesAtPosition = new ArrayList();
                this.parseResult.addTypedValues(argSpec, currentPosition++, typedValuesAtPosition);
                if (!this.canConsumeOneArgument(argSpec, arity, consumed, args.peek(), type, argDescription)) break;
                this.consumeOneArgument(argSpec, lookBehind, arity, consumed, args.pop(), type, typedValuesAtPosition, i, argDescription);
                result.addAll(typedValuesAtPosition);
                consumed = this.consumedCount(i + 1, initialSize, argSpec);
                lookBehind = LookBehind.SEPARATE;
                ++i;
            }
            if (result.isEmpty() && arity.min == 0 && arity.max <= 1 && CommandLine.isBoolean(type)) {
                return Arrays.asList(Boolean.TRUE);
            }
            return result;
        }

        private int consumedCount(int i, int initialSize, Model.ArgSpec arg) {
            return CommandLine.this.commandSpec.parser().splitFirst() ? arg.stringValues().size() - initialSize : i;
        }

        private int consumedCountMap(int i, int initialSize, Model.ArgSpec arg) {
            return CommandLine.this.commandSpec.parser().splitFirst() ? (arg.stringValues().size() - initialSize) / 2 : i;
        }

        private int consumeOneArgument(Model.ArgSpec argSpec, LookBehind lookBehind, Range arity, int consumed, String arg, Class<?> type, List<Object> result, int index, String argDescription) {
            if (!lookBehind.isAttached()) {
                this.parseResult.nowProcessing(argSpec, arg);
            }
            String raw = this.trim(arg);
            String[] values = argSpec.splitValue(raw, CommandLine.this.commandSpec.parser(), arity, consumed);
            ITypeConverter<?> converter = this.getTypeConverter(type, argSpec, 0);
            for (int j = 0; j < values.length; ++j) {
                result.add(this.tryConvert(argSpec, index, converter, values[j], type));
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("Adding [%s] to %s for %s%n", String.valueOf(result.get(result.size() - 1)), argSpec.toString(), argDescription);
                }
                this.parseResult.addStringValue(argSpec, values[j]);
            }
            this.parseResult.addOriginalStringValue(argSpec, raw);
            return ++index;
        }

        private boolean canConsumeOneArgument(Model.ArgSpec argSpec, Range arity, int consumed, String arg, Class<?> type, String argDescription) {
            ITypeConverter<?> converter = this.getTypeConverter(type, argSpec, 0);
            try {
                String[] values;
                for (String value : values = argSpec.splitValue(this.trim(arg), CommandLine.this.commandSpec.parser(), arity, consumed)) {
                    this.tryConvert(argSpec, -1, converter, value, type);
                }
                return true;
            }
            catch (PicocliException ex) {
                CommandLine.this.tracer.debug("$s cannot be assigned to %s: type conversion fails: %s.%n", arg, argDescription, ex.getMessage());
                return false;
            }
        }

        private boolean varargCanConsumeNextValue(Model.ArgSpec argSpec, String nextValue) {
            if (this.endOfOptions && argSpec.isPositional()) {
                return true;
            }
            boolean isCommand = CommandLine.this.commandSpec.subcommands().containsKey(nextValue);
            return !isCommand && !this.isOption(nextValue);
        }

        private boolean isOption(String arg) {
            if (arg == null) {
                return false;
            }
            if ("--".equals(arg)) {
                return true;
            }
            if (CommandLine.this.commandSpec.optionsMap().containsKey(arg)) {
                return true;
            }
            int separatorIndex = arg.indexOf(this.config().separator());
            if (separatorIndex > 0 && CommandLine.this.commandSpec.optionsMap().containsKey(arg.substring(0, separatorIndex))) {
                return true;
            }
            return arg.length() > 2 && arg.startsWith("-") && CommandLine.this.commandSpec.posixOptionsMap().containsKey(Character.valueOf(arg.charAt(1)));
        }

        private Object tryConvert(Model.ArgSpec argSpec, int index, ITypeConverter<?> converter, String value, Class<?> type) throws ParameterException {
            try {
                return converter.convert(value);
            }
            catch (TypeConversionException ex) {
                String msg = String.format("Invalid value for %s: %s", this.optionDescription("", argSpec, index), ex.getMessage());
                throw new ParameterException(CommandLine.this, msg, argSpec, value);
            }
            catch (Exception other) {
                String desc = this.optionDescription("", argSpec, index);
                String msg = String.format("Invalid value for %s: cannot convert '%s' to %s (%s)", desc, value, type.getSimpleName(), other);
                throw new ParameterException(CommandLine.this, msg, other, argSpec, value);
            }
        }

        private String optionDescription(String prefix, Model.ArgSpec argSpec, int index) {
            String desc = "";
            if (argSpec.isOption()) {
                desc = prefix + "option '" + ((Model.OptionSpec)argSpec).longestName() + "'";
                if (index >= 0) {
                    if (argSpec.arity().max > 1) {
                        desc = desc + " at index " + index;
                    }
                    desc = desc + " (" + argSpec.paramLabel() + ")";
                }
            } else {
                desc = prefix + "positional parameter at index " + ((Model.PositionalParamSpec)argSpec).index() + " (" + argSpec.paramLabel() + ")";
            }
            return desc;
        }

        private boolean isAnyHelpRequested() {
            return this.isHelpRequested || this.parseResult.versionHelpRequested || this.parseResult.usageHelpRequested;
        }

        private void updateHelpRequested(Model.CommandSpec command) {
            this.isHelpRequested |= command.helpCommand();
        }

        private void updateHelpRequested(Model.ArgSpec argSpec) {
            if (!this.parseResult.isInitializingDefaultValues && argSpec.isOption()) {
                Model.OptionSpec option = (Model.OptionSpec)argSpec;
                this.isHelpRequested |= this.is(argSpec, "help", option.help());
                ParseResult.Builder builder = this.parseResult;
                builder.versionHelpRequested = builder.versionHelpRequested | this.is(argSpec, "versionHelp", option.versionHelp());
                builder = this.parseResult;
                builder.usageHelpRequested = builder.usageHelpRequested | this.is(argSpec, "usageHelp", option.usageHelp());
            }
        }

        private boolean is(Model.ArgSpec p, String attribute, boolean value) {
            if (value && CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("%s has '%s' annotation: not validating required fields%n", p.toString(), attribute);
            }
            return value;
        }

        private Collection<Object> createCollection(Class<?> collectionClass, Class<?> elementType) throws Exception {
            if (collectionClass.isInterface()) {
                if (List.class.isAssignableFrom(collectionClass)) {
                    return new ArrayList<Object>();
                }
                if (SortedSet.class.isAssignableFrom(collectionClass)) {
                    return new TreeSet<Object>();
                }
                if (Set.class.isAssignableFrom(collectionClass)) {
                    return new LinkedHashSet<Object>();
                }
                if (Queue.class.isAssignableFrom(collectionClass)) {
                    return new LinkedList<Object>();
                }
                return new ArrayList<Object>();
            }
            if (EnumSet.class.isAssignableFrom(collectionClass) && Enum.class.isAssignableFrom(elementType)) {
                EnumSet<?> enumSet = EnumSet.noneOf(elementType);
                return enumSet;
            }
            return (Collection)CommandLine.this.factory.create(collectionClass);
        }

        private Map<Object, Object> createMap(Class<?> mapClass) throws Exception {
            try {
                return (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                return new LinkedHashMap<Object, Object>();
            }
        }

        private ITypeConverter<?> getTypeConverter(final Class<?> type, Model.ArgSpec argSpec, int index) {
            if (argSpec.converters().length > index) {
                return argSpec.converters()[index];
            }
            if (this.converterRegistry.containsKey(type)) {
                return this.converterRegistry.get(type);
            }
            if (type.isEnum()) {
                return new ITypeConverter<Object>(){

                    @Override
                    public Object convert(String value) throws Exception {
                        String sensitivity = "case-sensitive";
                        if (CommandLine.this.commandSpec.parser().caseInsensitiveEnumValuesAllowed()) {
                            String upper = value.toUpperCase();
                            for (Object enumConstant : type.getEnumConstants()) {
                                if (!upper.equals(String.valueOf(enumConstant).toUpperCase())) continue;
                                return enumConstant;
                            }
                            sensitivity = "case-insensitive";
                        }
                        try {
                            return Enum.valueOf(type, value);
                        }
                        catch (Exception ex) {
                            Enum[] constants = (Enum[])type.getEnumConstants();
                            String[] names = new String[constants.length];
                            for (int i = 0; i < names.length; ++i) {
                                names[i] = constants[i].name();
                            }
                            throw new TypeConversionException(String.format("expected one of %s (%s) but was '%s'", Arrays.asList(names), sensitivity, value));
                        }
                    }
                };
            }
            throw new MissingTypeConverterException(CommandLine.this, "No TypeConverter registered for " + type.getName() + " of " + argSpec);
        }

        private boolean assertNoMissingParameters(Model.ArgSpec argSpec, Range arity, Stack<String> args) {
            if (argSpec.interactive()) {
                return true;
            }
            int available = args.size();
            if (available > 0 && CommandLine.this.commandSpec.parser().splitFirst() && argSpec.splitRegex().length() > 0) {
                available += argSpec.splitValue(args.peek(), CommandLine.this.commandSpec.parser(), arity, 0).length - 1;
            }
            if (arity.min > available) {
                if (arity.min == 1) {
                    if (argSpec.isOption()) {
                        this.maybeThrow(new MissingParameterException(CommandLine.this, argSpec, "Missing required parameter for " + this.optionDescription("", argSpec, 0)));
                        return false;
                    }
                    Range indexRange = ((Model.PositionalParamSpec)argSpec).index();
                    String sep = "";
                    String names = ": ";
                    int count = 0;
                    List<Model.PositionalParamSpec> positionalParameters = CommandLine.this.commandSpec.positionalParameters();
                    for (int i = indexRange.min; i < positionalParameters.size(); ++i) {
                        if (positionalParameters.get((int)i).arity().min <= 0) continue;
                        names = names + sep + positionalParameters.get(i).paramLabel();
                        sep = ", ";
                        ++count;
                    }
                    String msg = "Missing required parameter";
                    Range paramArity = argSpec.arity();
                    if (count > 1 || arity.min - available > 1) {
                        msg = msg + "s";
                    }
                    this.maybeThrow(new MissingParameterException(CommandLine.this, argSpec, msg + names));
                } else if (args.isEmpty()) {
                    this.maybeThrow(new MissingParameterException(CommandLine.this, argSpec, this.optionDescription("", argSpec, 0) + " requires at least " + arity.min + " values, but none were specified."));
                } else {
                    this.maybeThrow(new MissingParameterException(CommandLine.this, argSpec, this.optionDescription("", argSpec, 0) + " requires at least " + arity.min + " values, but only " + available + " were specified: " + CommandLine.reverse(args)));
                }
                return false;
            }
            return true;
        }

        private String trim(String value) {
            return this.unquote(value);
        }

        private String unquote(String value) {
            if (!CommandLine.this.commandSpec.parser().trimQuotes()) {
                return value;
            }
            return value == null ? null : (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value);
        }

        char[] readPassword(String prompt) {
            try {
                Object console = System.class.getDeclaredMethod("console", new Class[0]).invoke(null, new Object[0]);
                Method method = Class.forName("java.io.Console").getDeclaredMethod("readPassword", String.class, Object[].class);
                return (char[])method.invoke(console, prompt, new Object[0]);
            }
            catch (Exception e) {
                System.out.print(prompt);
                InputStreamReader isr = new InputStreamReader(System.in);
                BufferedReader in = new BufferedReader(isr);
                try {
                    return in.readLine().toCharArray();
                }
                catch (IOException ex2) {
                    throw new IllegalStateException(ex2);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LookBehind {
        SEPARATE,
        ATTACHED,
        ATTACHED_WITH_SEPARATOR;


        public boolean isAttached() {
            return this != SEPARATE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParseResult {
        private final Model.CommandSpec commandSpec;
        private final List<Model.OptionSpec> matchedOptions;
        private final List<Model.PositionalParamSpec> matchedUniquePositionals;
        private final List<String> originalArgs;
        private final List<String> unmatched;
        private final List<List<Model.PositionalParamSpec>> matchedPositionalParams;
        private final List<Exception> errors;
        final List<Object> tentativeMatch;
        private final ParseResult subcommand;
        private final boolean usageHelpRequested;
        private final boolean versionHelpRequested;

        public static Builder builder(Model.CommandSpec commandSpec) {
            return new Builder(commandSpec);
        }

        private ParseResult(Builder builder) {
            this.commandSpec = builder.commandSpec;
            this.subcommand = builder.subcommand;
            this.matchedOptions = new ArrayList<Model.OptionSpec>(builder.options);
            this.unmatched = new ArrayList<String>(builder.unmatched);
            this.originalArgs = new ArrayList<String>(builder.originalArgList);
            this.matchedUniquePositionals = new ArrayList<Model.PositionalParamSpec>(builder.positionals);
            this.matchedPositionalParams = new ArrayList<List<Model.PositionalParamSpec>>(builder.positionalParams);
            this.errors = new ArrayList<Exception>(builder.errors);
            this.usageHelpRequested = builder.usageHelpRequested;
            this.versionHelpRequested = builder.versionHelpRequested;
            this.tentativeMatch = builder.nowProcessing;
        }

        public Model.OptionSpec matchedOption(char shortName) {
            return Model.CommandSpec.findOption(shortName, this.matchedOptions);
        }

        public Model.OptionSpec matchedOption(String name) {
            return Model.CommandSpec.findOption(name, this.matchedOptions);
        }

        public Model.PositionalParamSpec matchedPositional(int position) {
            if (this.matchedPositionalParams.size() <= position || this.matchedPositionalParams.get(position).isEmpty()) {
                return null;
            }
            return this.matchedPositionalParams.get(position).get(0);
        }

        public List<Model.PositionalParamSpec> matchedPositionals(int position) {
            if (this.matchedPositionalParams.size() <= position) {
                return Collections.emptyList();
            }
            return this.matchedPositionalParams.get(position) == null ? Collections.emptyList() : this.matchedPositionalParams.get(position);
        }

        public Model.CommandSpec commandSpec() {
            return this.commandSpec;
        }

        public boolean hasMatchedOption(char shortName) {
            return this.matchedOption(shortName) != null;
        }

        public boolean hasMatchedOption(String name) {
            return this.matchedOption(name) != null;
        }

        public boolean hasMatchedOption(Model.OptionSpec option) {
            return this.matchedOptions.contains(option);
        }

        public boolean hasMatchedPositional(int position) {
            return this.matchedPositional(position) != null;
        }

        public boolean hasMatchedPositional(Model.PositionalParamSpec positional) {
            return this.matchedUniquePositionals.contains(positional);
        }

        public List<Model.OptionSpec> matchedOptions() {
            return Collections.unmodifiableList(this.matchedOptions);
        }

        public List<Model.PositionalParamSpec> matchedPositionals() {
            return Collections.unmodifiableList(this.matchedUniquePositionals);
        }

        public List<String> unmatched() {
            return Collections.unmodifiableList(this.unmatched);
        }

        public List<String> originalArgs() {
            return Collections.unmodifiableList(this.originalArgs);
        }

        public List<Exception> errors() {
            return Collections.unmodifiableList(this.errors);
        }

        public <T> T matchedOptionValue(char shortName, T defaultValue) {
            return this.matchedOptionValue(this.matchedOption(shortName), defaultValue);
        }

        public <T> T matchedOptionValue(String name, T defaultValue) {
            return this.matchedOptionValue(this.matchedOption(name), defaultValue);
        }

        private <T> T matchedOptionValue(Model.OptionSpec option, T defaultValue) {
            return option == null ? defaultValue : option.getValue();
        }

        public <T> T matchedPositionalValue(int position, T defaultValue) {
            return this.matchedPositionalValue(this.matchedPositional(position), defaultValue);
        }

        private <T> T matchedPositionalValue(Model.PositionalParamSpec positional, T defaultValue) {
            return positional == null ? defaultValue : positional.getValue();
        }

        public boolean hasSubcommand() {
            return this.subcommand != null;
        }

        public ParseResult subcommand() {
            return this.subcommand;
        }

        public boolean isUsageHelpRequested() {
            return this.usageHelpRequested;
        }

        public boolean isVersionHelpRequested() {
            return this.versionHelpRequested;
        }

        public List<CommandLine> asCommandLineList() {
            ArrayList<CommandLine> result = new ArrayList<CommandLine>();
            ParseResult pr = this;
            while (pr != null) {
                result.add(pr.commandSpec().commandLine());
                pr = pr.hasSubcommand() ? pr.subcommand() : null;
            }
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Builder {
            private final Model.CommandSpec commandSpec;
            private final Set<Model.OptionSpec> options = new LinkedHashSet<Model.OptionSpec>();
            private final Set<Model.PositionalParamSpec> positionals = new LinkedHashSet<Model.PositionalParamSpec>();
            private final List<String> unmatched = new ArrayList<String>();
            private final List<String> originalArgList = new ArrayList<String>();
            private final List<List<Model.PositionalParamSpec>> positionalParams = new ArrayList<List<Model.PositionalParamSpec>>();
            private ParseResult subcommand;
            private boolean usageHelpRequested;
            private boolean versionHelpRequested;
            boolean isInitializingDefaultValues;
            private List<Exception> errors = new ArrayList<Exception>(1);
            private List<Object> nowProcessing;

            private Builder(Model.CommandSpec spec) {
                this.commandSpec = Assert.notNull(spec, "commandSpec");
            }

            public ParseResult build() {
                return new ParseResult(this);
            }

            private void nowProcessing(Model.ArgSpec spec, Object value) {
                if (this.nowProcessing != null && !this.isInitializingDefaultValues) {
                    this.nowProcessing.add(spec.isPositional() ? spec : value);
                }
            }

            public Builder add(Model.ArgSpec arg, int position) {
                if (arg.isOption()) {
                    this.addOption((Model.OptionSpec)arg);
                } else {
                    this.addPositionalParam((Model.PositionalParamSpec)arg, position);
                }
                return this;
            }

            public Builder addOption(Model.OptionSpec option) {
                if (!this.isInitializingDefaultValues) {
                    this.options.add(option);
                }
                return this;
            }

            public Builder addPositionalParam(Model.PositionalParamSpec positionalParam, int position) {
                if (this.isInitializingDefaultValues) {
                    return this;
                }
                this.positionals.add(positionalParam);
                while (this.positionalParams.size() <= position) {
                    this.positionalParams.add(new ArrayList());
                }
                this.positionalParams.get(position).add(positionalParam);
                return this;
            }

            public Builder addUnmatched(String arg) {
                this.unmatched.add(arg);
                return this;
            }

            public Builder addUnmatched(Stack<String> args) {
                while (!args.isEmpty()) {
                    this.addUnmatched(args.pop());
                }
                return this;
            }

            public Builder subcommand(ParseResult subcommand) {
                this.subcommand = subcommand;
                return this;
            }

            public Builder originalArgs(String[] originalArgs) {
                this.originalArgList.addAll(Arrays.asList(originalArgs));
                return this;
            }

            void addStringValue(Model.ArgSpec argSpec, String value) {
                if (!this.isInitializingDefaultValues) {
                    argSpec.stringValues.add(value);
                }
            }

            void addOriginalStringValue(Model.ArgSpec argSpec, String value) {
                if (!this.isInitializingDefaultValues) {
                    argSpec.originalStringValues.add(value);
                }
            }

            void addTypedValues(Model.ArgSpec argSpec, int position, Object typedValue) {
                if (!this.isInitializingDefaultValues) {
                    argSpec.typedValues.add(typedValue);
                    argSpec.typedValueAtPosition.put(position, typedValue);
                }
            }

            public void addError(PicocliException ex) {
                this.errors.add(Assert.notNull(ex, "exception"));
            }
        }
    }

    public static final class Model {
        private Model() {
        }

        private static boolean initializable(Object current, Object candidate, Object defaultValue) {
            return current == null && Model.isNonDefault(candidate, defaultValue);
        }

        private static boolean initializable(Object current, Object[] candidate, Object[] defaultValue) {
            return current == null && Model.isNonDefault(candidate, defaultValue);
        }

        private static boolean isNonDefault(Object candidate, Object defaultValue) {
            return !Assert.notNull(defaultValue, "defaultValue").equals(candidate);
        }

        private static boolean isNonDefault(Object[] candidate, Object[] defaultValue) {
            return !Arrays.equals(Assert.notNull(defaultValue, "defaultValue"), candidate);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ObjectBinding
        implements IGetter,
        ISetter {
            private Object value;

            private ObjectBinding() {
            }

            @Override
            public <T> T get() {
                return (T)this.value;
            }

            @Override
            public <T> T set(T value) {
                T result = value;
                this.value = value;
                return result;
            }
        }

        private static class PicocliInvocationHandler
        implements InvocationHandler {
            final Map<String, Object> map = new HashMap<String, Object>();

            private PicocliInvocationHandler() {
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return this.map.get(method.getName());
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ProxyBinding
            implements IGetter,
            ISetter {
                private final Method method;

                ProxyBinding(Method method) {
                    this.method = Assert.notNull(method, "method");
                }

                @Override
                public <T> T get() {
                    return (T)PicocliInvocationHandler.this.map.get(this.method.getName());
                }

                @Override
                public <T> T set(T value) {
                    T result = this.get();
                    PicocliInvocationHandler.this.map.put(this.method.getName(), value);
                    return result;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class MethodBinding
        implements IGetter,
        ISetter {
            private final Object scope;
            private final Method method;
            private final CommandSpec spec;
            private Object currentValue;

            MethodBinding(Object scope, Method method, CommandSpec spec) {
                this.scope = scope;
                this.method = method;
                this.spec = spec;
            }

            @Override
            public <T> T get() {
                return (T)this.currentValue;
            }

            @Override
            public <T> T set(T value) throws PicocliException {
                try {
                    Object result = this.currentValue;
                    this.method.invoke(this.scope, value);
                    this.currentValue = value;
                    return (T)result;
                }
                catch (InvocationTargetException ex) {
                    if (ex.getCause() instanceof PicocliException) {
                        throw (PicocliException)ex.getCause();
                    }
                    throw this.createParameterException(value, ex.getCause());
                }
                catch (Exception ex) {
                    throw this.createParameterException(value, ex);
                }
            }

            private ParameterException createParameterException(Object value, Throwable t) {
                CommandLine cmd = this.spec.commandLine() == null ? new CommandLine(this.spec) : this.spec.commandLine();
                return new ParameterException(cmd, "Could not invoke " + this.method + " with " + value, t);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FieldBinding
        implements IGetter,
        ISetter {
            private final Object scope;
            private final Field field;

            FieldBinding(Object scope, Field field) {
                this.scope = scope;
                this.field = field;
            }

            @Override
            public <T> T get() throws PicocliException {
                try {
                    Object result = this.field.get(this.scope);
                    return (T)result;
                }
                catch (Exception ex) {
                    throw new PicocliException("Could not get value for field " + this.field, ex);
                }
            }

            @Override
            public <T> T set(T value) throws PicocliException {
                try {
                    Object result = this.field.get(this.scope);
                    this.field.set(this.scope, value);
                    return (T)result;
                }
                catch (Exception ex) {
                    throw new PicocliException("Could not set value for field " + this.field + " to " + value, ex);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ArgsReflection {
            ArgsReflection() {
            }

            static OptionSpec extractOptionSpec(TypedMember member, IFactory factory) {
                Option option = member.getAnnotation(Option.class);
                OptionSpec.Builder builder = OptionSpec.builder(option.names());
                ArgsReflection.initCommon(builder, member);
                builder.order(option.order());
                builder.help(option.help());
                builder.usageHelp(option.usageHelp());
                builder.versionHelp(option.versionHelp());
                builder.showDefaultValue(option.showDefaultValue());
                if (!NoCompletionCandidates.class.equals(option.completionCandidates())) {
                    builder.completionCandidates(DefaultFactory.createCompletionCandidates(factory, option.completionCandidates()));
                }
                builder.arity(Range.optionArity(member));
                builder.required(option.required());
                builder.interactive(option.interactive());
                Class<?>[] elementTypes = ArgsReflection.inferTypes(member.getType(), option.type(), member.getGenericType());
                builder.auxiliaryTypes(elementTypes);
                builder.paramLabel(ArgsReflection.inferLabel(option.paramLabel(), member.name(), member.getType(), elementTypes));
                builder.hideParamSyntax(option.hideParamSyntax());
                builder.description(option.description());
                builder.descriptionKey(option.descriptionKey());
                builder.splitRegex(option.split());
                builder.hidden(option.hidden());
                builder.defaultValue(option.defaultValue());
                builder.converters(DefaultFactory.createConverter(factory, option.converter()));
                return builder.build();
            }

            static PositionalParamSpec extractPositionalParamSpec(TypedMember member, IFactory factory) {
                PositionalParamSpec.Builder builder = PositionalParamSpec.builder();
                ArgsReflection.initCommon(builder, member);
                Range arity = Range.parameterArity(member);
                builder.arity(arity);
                builder.index(Range.parameterIndex(member));
                builder.capacity(Range.parameterCapacity(member));
                builder.required(arity.min > 0);
                Parameters parameters = member.getAnnotation(Parameters.class);
                builder.interactive(parameters.interactive());
                Class<?>[] elementTypes = ArgsReflection.inferTypes(member.getType(), parameters.type(), member.getGenericType());
                builder.auxiliaryTypes(elementTypes);
                builder.paramLabel(ArgsReflection.inferLabel(parameters.paramLabel(), member.name(), member.getType(), elementTypes));
                builder.hideParamSyntax(parameters.hideParamSyntax());
                builder.description(parameters.description());
                builder.descriptionKey(parameters.descriptionKey());
                builder.splitRegex(parameters.split());
                builder.hidden(parameters.hidden());
                builder.defaultValue(parameters.defaultValue());
                builder.converters(DefaultFactory.createConverter(factory, parameters.converter()));
                builder.showDefaultValue(parameters.showDefaultValue());
                if (!NoCompletionCandidates.class.equals(parameters.completionCandidates())) {
                    builder.completionCandidates(DefaultFactory.createCompletionCandidates(factory, parameters.completionCandidates()));
                }
                return builder.build();
            }

            static PositionalParamSpec extractUnannotatedPositionalParamSpec(TypedMember member, IFactory factory) {
                PositionalParamSpec.Builder builder = PositionalParamSpec.builder();
                ArgsReflection.initCommon(builder, member);
                Range arity = Range.parameterArity(member);
                builder.arity(arity);
                builder.index(Range.parameterIndex(member));
                builder.capacity(Range.parameterCapacity(member));
                builder.required(arity.min > 0);
                builder.interactive(false);
                Class<?>[] elementTypes = ArgsReflection.inferTypes(member.getType(), new Class[0], member.getGenericType());
                builder.auxiliaryTypes(elementTypes);
                builder.paramLabel(ArgsReflection.inferLabel(null, member.name(), member.getType(), elementTypes));
                builder.hideParamSyntax(false);
                builder.description(new String[0]);
                builder.splitRegex("");
                builder.hidden(false);
                builder.defaultValue(null);
                builder.converters();
                builder.showDefaultValue(Help.Visibility.ON_DEMAND);
                return builder.build();
            }

            private static void initCommon(ArgSpec.Builder<?> builder, TypedMember member) {
                builder.type(member.getType());
                builder.withToString((member.accessible instanceof Field ? "field " : (member.accessible instanceof Method ? "method " : member.accessible.getClass().getSimpleName() + " ")) + ArgsReflection.abbreviate(member.toGenericString()));
                ((ArgSpec.Builder)builder.getter(member.getter())).setter(member.setter());
                builder.hasInitialValue(member.hasInitialValue);
                try {
                    builder.initialValue(member.getter().get());
                }
                catch (Exception ex) {
                    builder.initialValue(null);
                }
            }

            static String abbreviate(String text) {
                return text.replace("private ", "").replace("protected ", "").replace("public ", "").replace("java.lang.", "");
            }

            private static String inferLabel(String label, String fieldName, Class<?> fieldType, Class<?>[] types) {
                if (!CommandLine.empty(label)) {
                    return label.trim();
                }
                String name = fieldName;
                if (Map.class.isAssignableFrom(fieldType)) {
                    Class<?>[] paramTypes = types;
                    name = paramTypes.length < 2 || paramTypes[0] == null || paramTypes[1] == null ? "String=String" : paramTypes[0].getSimpleName() + "=" + paramTypes[1].getSimpleName();
                }
                return "<" + name + ">";
            }

            private static Class<?>[] inferTypes(Class<?> propertyType, Class<?>[] annotationTypes, Type genericType) {
                if (annotationTypes.length > 0) {
                    return annotationTypes;
                }
                if (propertyType.isArray()) {
                    return new Class[]{propertyType.getComponentType()};
                }
                if (CommandLine.isMultiValue(propertyType)) {
                    if (genericType instanceof ParameterizedType) {
                        ParameterizedType parameterizedType = (ParameterizedType)genericType;
                        Type[] paramTypes = parameterizedType.getActualTypeArguments();
                        Object[] result = new Class[paramTypes.length];
                        for (int i = 0; i < paramTypes.length; ++i) {
                            if (paramTypes[i] instanceof Class) {
                                result[i] = (Class)paramTypes[i];
                                continue;
                            }
                            if (paramTypes[i] instanceof WildcardType) {
                                WildcardType wildcardType = (WildcardType)paramTypes[i];
                                Type[] lower = wildcardType.getLowerBounds();
                                if (lower.length > 0 && lower[0] instanceof Class) {
                                    result[i] = (Class)lower[0];
                                    continue;
                                }
                                Type[] upper = wildcardType.getUpperBounds();
                                if (upper.length > 0 && upper[0] instanceof Class) {
                                    result[i] = (Class)upper[0];
                                    continue;
                                }
                            }
                            Arrays.fill(result, String.class);
                            return result;
                        }
                        return result;
                    }
                    return new Class[]{String.class, String.class};
                }
                return new Class[]{propertyType};
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CommandReflection {
            private CommandReflection() {
            }

            static CommandSpec extractCommandSpec(Object command, IFactory factory, boolean annotationsAreMandatory) {
                Class<Object> cls = command.getClass();
                Tracer t = new Tracer();
                t.debug("Creating CommandSpec for object of class %s with factory %s%n", cls.getName(), factory.getClass().getName());
                if (command instanceof CommandSpec) {
                    return (CommandSpec)command;
                }
                Object instance = command;
                String commandClassName = cls.getName();
                if (command instanceof Class) {
                    cls = (Class)command;
                    commandClassName = cls.getName();
                    try {
                        t.debug("Getting a %s instance from the factory%n", cls.getName());
                        instance = DefaultFactory.create(factory, cls);
                        cls = instance.getClass();
                        commandClassName = cls.getName();
                        t.debug("Factory returned a %s instance%n", commandClassName);
                    }
                    catch (InitializationException ex) {
                        if (cls.isInterface()) {
                            t.debug("%s. Creating Proxy for interface %s%n", ex.getCause(), cls.getName());
                            instance = Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, (InvocationHandler)new PicocliInvocationHandler());
                        }
                        throw ex;
                    }
                } else if (command instanceof Method) {
                    cls = null;
                }
                CommandSpec result = CommandSpec.wrapWithoutInspection(Assert.notNull(instance, "command"));
                Stack hierarchy = new Stack();
                while (cls != null) {
                    hierarchy.add(cls);
                    cls = cls.getSuperclass();
                }
                boolean hasCommandAnnotation = false;
                boolean mixinStandardHelpOptions = false;
                while (!hierarchy.isEmpty()) {
                    cls = (Class)hierarchy.pop();
                    boolean thisCommandHasAnnotation = CommandReflection.updateCommandAttributes(cls, result, factory);
                    hasCommandAnnotation |= thisCommandHasAnnotation;
                    hasCommandAnnotation |= CommandReflection.initFromAnnotatedFields(instance, cls, result, factory);
                    if (!cls.isAnnotationPresent(Command.class)) continue;
                    mixinStandardHelpOptions |= cls.getAnnotation(Command.class).mixinStandardHelpOptions();
                }
                result.mixinStandardHelpOptions(mixinStandardHelpOptions);
                if (command instanceof Method) {
                    Method method = (Method)command;
                    t.debug("Using method %s as command %n", method);
                    commandClassName = method.toString();
                    hasCommandAnnotation |= CommandReflection.updateCommandAttributes(method, result, factory);
                    result.mixinStandardHelpOptions(method.getAnnotation(Command.class).mixinStandardHelpOptions());
                    CommandReflection.initFromMethodParameters(instance, method, result, factory);
                    result.initName(((Method)command).getName());
                }
                result.updateArgSpecMessages();
                if (annotationsAreMandatory) {
                    CommandReflection.validateCommandSpec(result, hasCommandAnnotation, commandClassName);
                }
                result.withToString(commandClassName).validate();
                return result;
            }

            private static boolean updateCommandAttributes(Class<?> cls, CommandSpec commandSpec, IFactory factory) {
                if (!cls.isAnnotationPresent(Command.class)) {
                    return false;
                }
                Command cmd = cls.getAnnotation(Command.class);
                return CommandReflection.updateCommandAttributes(cmd, cls, commandSpec, factory);
            }

            private static boolean updateCommandAttributes(Method method, CommandSpec commandSpec, IFactory factory) {
                Command cmd = method.getAnnotation(Command.class);
                return CommandReflection.updateCommandAttributes(cmd, null, commandSpec, factory);
            }

            private static boolean updateCommandAttributes(Command cmd, Class<?> cls, CommandSpec commandSpec, IFactory factory) {
                commandSpec.aliases(cmd.aliases());
                commandSpec.parser().updateSeparator(cmd.separator());
                commandSpec.updateName(cmd.name());
                commandSpec.updateVersion(cmd.version());
                commandSpec.updateHelpCommand(cmd.helpCommand());
                commandSpec.updateVersionProvider(cmd.versionProvider(), factory);
                commandSpec.initDefaultValueProvider(cmd.defaultValueProvider(), factory);
                commandSpec.usageMessage().updateFromCommand(cmd, commandSpec);
                CommandReflection.initSubcommands(cmd, cls, commandSpec, factory);
                return true;
            }

            private static void initSubcommands(Command cmd, Class<?> cls, CommandSpec parent, IFactory factory) {
                for (Class<?> sub : cmd.subcommands()) {
                    try {
                        if (Help.class == sub) {
                            throw new InitializationException(Help.class.getName() + " is not a valid subcommand. Did you mean " + HelpCommand.class.getName() + "?");
                        }
                        CommandLine subcommandLine = CommandLine.toCommandLine(factory.create(sub), factory);
                        parent.addSubcommand(CommandReflection.subcommandName(sub), subcommandLine);
                        CommandReflection.initParentCommand(subcommandLine.getCommandSpec().userObject(), parent.userObject());
                    }
                    catch (InitializationException ex) {
                        throw ex;
                    }
                    catch (NoSuchMethodException ex) {
                        throw new InitializationException("Cannot instantiate subcommand " + sub.getName() + ": the class has no constructor", ex);
                    }
                    catch (Exception ex) {
                        throw new InitializationException("Could not instantiate and add subcommand " + sub.getName() + ": " + ex, ex);
                    }
                }
                if (cmd.addMethodSubcommands() && cls != null) {
                    for (CommandLine sub : CommandSpec.createMethodSubcommands(cls, factory)) {
                        parent.addSubcommand(sub.getCommandName(), sub);
                    }
                }
            }

            static void initParentCommand(Object subcommand, Object parent) {
                if (subcommand == null) {
                    return;
                }
                try {
                    for (Class<?> cls = subcommand.getClass(); cls != null; cls = cls.getSuperclass()) {
                        for (Field f : cls.getDeclaredFields()) {
                            if (!f.isAnnotationPresent(ParentCommand.class)) continue;
                            f.setAccessible(true);
                            f.set(subcommand, parent);
                        }
                    }
                }
                catch (Exception ex) {
                    throw new InitializationException("Unable to initialize @ParentCommand field: " + ex, ex);
                }
            }

            private static String subcommandName(Class<?> sub) {
                Command subCommand = sub.getAnnotation(Command.class);
                if (subCommand == null || "<main class>".equals(subCommand.name())) {
                    throw new InitializationException("Subcommand " + sub.getName() + " is missing the mandatory @Command annotation with a 'name' attribute");
                }
                return subCommand.name();
            }

            private static boolean initFromAnnotatedFields(Object scope, Class<?> cls, CommandSpec receiver, IFactory factory) {
                boolean result = false;
                for (Field field : cls.getDeclaredFields()) {
                    result |= CommandReflection.initFromAnnotatedTypedMembers(TypedMember.createIfAnnotated(field, scope), receiver, factory);
                }
                for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
                    result |= CommandReflection.initFromAnnotatedTypedMembers(TypedMember.createIfAnnotated((Method)accessibleObject, scope, receiver), receiver, factory);
                }
                return result;
            }

            private static boolean initFromAnnotatedTypedMembers(TypedMember member, CommandSpec receiver, IFactory factory) {
                boolean result = false;
                if (member == null) {
                    return result;
                }
                if (member.isMixin()) {
                    CommandReflection.validateMixin(member);
                    receiver.addMixin(member.mixinName(), CommandReflection.buildMixinForField(member, factory));
                    result = true;
                }
                if (member.isUnmatched()) {
                    CommandReflection.validateUnmatched(member);
                    receiver.addUnmatchedArgsBinding(CommandReflection.buildUnmatchedForField(member));
                }
                if (member.isArgSpec()) {
                    CommandReflection.validateArgSpecField(member);
                    Messages msg = receiver.usageMessage.messages();
                    if (member.isOption()) {
                        receiver.addOption(ArgsReflection.extractOptionSpec(member, factory));
                    } else if (member.isParameter()) {
                        receiver.addPositional(ArgsReflection.extractPositionalParamSpec(member, factory));
                    } else {
                        receiver.addPositional(ArgsReflection.extractUnannotatedPositionalParamSpec(member, factory));
                    }
                }
                if (member.isInjectSpec()) {
                    CommandReflection.validateInjectSpec(member);
                    try {
                        member.setter().set(receiver);
                    }
                    catch (Exception ex) {
                        throw new InitializationException("Could not inject spec", ex);
                    }
                }
                return result;
            }

            private static boolean initFromMethodParameters(Object scope, Method method, CommandSpec receiver, IFactory factory) {
                boolean result = false;
                int optionCount = 0;
                int count = method.getParameterTypes().length;
                for (int i = 0; i < count; ++i) {
                    MethodParam param = new MethodParam(method, i);
                    if (param.isAnnotationPresent(Option.class) || param.isAnnotationPresent(Mixin.class)) {
                        ++optionCount;
                    } else {
                        param.position = i - optionCount;
                    }
                    result |= CommandReflection.initFromAnnotatedTypedMembers(new TypedMember(param, scope), receiver, factory);
                }
                return result;
            }

            private static void validateMixin(TypedMember member) {
                if (!member.isMixin()) {
                    throw new IllegalStateException("Bug: validateMixin() should only be called with mixins");
                }
                if (member.isArgSpec()) {
                    throw new DuplicateOptionAnnotationsException("A member cannot be both a @Mixin command and an @Option or @Parameters, but '" + member + "' is both.");
                }
                if (member.isUnmatched()) {
                    throw new DuplicateOptionAnnotationsException("A member cannot be both a @Mixin command and an @Unmatched but '" + member + "' is both.");
                }
            }

            private static void validateUnmatched(TypedMember member) {
                if (member.isUnmatched() && member.isArgSpec()) {
                    throw new DuplicateOptionAnnotationsException("A member cannot have both @Unmatched and @Option or @Parameters annotations, but '" + member + "' has both.");
                }
            }

            private static void validateArgSpecField(TypedMember member) {
                if (!member.isArgSpec()) {
                    throw new IllegalStateException("Bug: validateArgSpecField() should only be called with an @Option or @Parameters member");
                }
                if (member.isOption() && member.isParameter()) {
                    throw new DuplicateOptionAnnotationsException("A member can be either @Option or @Parameters, but '" + member + "' is both.");
                }
                if (member.isMixin()) {
                    throw new DuplicateOptionAnnotationsException("A member cannot be both a @Mixin command and an @Option or @Parameters, but '" + member + "' is both.");
                }
                if (!(member.accessible instanceof Field)) {
                    return;
                }
                Field field = (Field)member.accessible;
                if (Modifier.isFinal(field.getModifiers()) && (field.getType().isPrimitive() || String.class.isAssignableFrom(field.getType()))) {
                    throw new InitializationException("Constant (final) primitive and String fields like " + field + " cannot be used as " + (member.isOption() ? "an @Option" : "a @Parameter") + ": compile-time constant inlining may hide new values written to it.");
                }
            }

            private static void validateCommandSpec(CommandSpec result, boolean hasCommandAnnotation, String commandClassName) {
                if (!hasCommandAnnotation && result.positionalParameters.isEmpty() && result.optionsByNameMap.isEmpty() && result.unmatchedArgs.isEmpty()) {
                    throw new InitializationException(commandClassName + " is not a command: it has no @Command, @Option, @Parameters or @Unmatched annotations");
                }
            }

            private static void validateInjectSpec(TypedMember member) {
                if (!member.isInjectSpec()) {
                    throw new IllegalStateException("Bug: validateInjectSpec() should only be called with @Spec members");
                }
                if (member.isOption() || member.isParameter()) {
                    throw new DuplicateOptionAnnotationsException("A member cannot have both @Spec and @Option or @Parameters annotations, but '" + member + "' has both.");
                }
                if (member.isUnmatched()) {
                    throw new DuplicateOptionAnnotationsException("A member cannot have both @Spec and @Unmatched annotations, but '" + member + "' has both.");
                }
                if (member.isMixin()) {
                    throw new DuplicateOptionAnnotationsException("A member cannot have both @Spec and @Mixin annotations, but '" + member + "' has both.");
                }
                if (member.getType() != CommandSpec.class) {
                    throw new InitializationException("@picocli.CommandLine.Spec annotation is only supported on fields of type " + CommandSpec.class.getName());
                }
            }

            private static CommandSpec buildMixinForField(TypedMember member, IFactory factory) {
                try {
                    Object userObject = member.getter().get();
                    if (userObject == null) {
                        userObject = factory.create(member.getType());
                        member.setter().set(userObject);
                    }
                    CommandSpec result = CommandSpec.forAnnotatedObject(userObject, factory);
                    return result.withToString(ArgsReflection.abbreviate("mixin from member " + member.toGenericString()));
                }
                catch (InitializationException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new InitializationException("Could not access or modify mixin member " + member + ": " + ex, ex);
                }
            }

            private static UnmatchedArgsBinding buildUnmatchedForField(final TypedMember member) {
                if (!(member.getType().equals(String[].class) || List.class.isAssignableFrom(member.getType()) && member.getGenericType() instanceof ParameterizedType && ((ParameterizedType)member.getGenericType()).getActualTypeArguments()[0].equals(String.class))) {
                    throw new InitializationException("Invalid type for " + member + ": must be either String[] or List<String>");
                }
                if (member.getType().equals(String[].class)) {
                    return UnmatchedArgsBinding.forStringArrayConsumer(member.setter());
                }
                return UnmatchedArgsBinding.forStringCollectionSupplier(new IGetter(){

                    @Override
                    public <T> T get() throws Exception {
                        ArrayList result = (ArrayList)member.getter().get();
                        if (result == null) {
                            result = new ArrayList();
                            member.setter().set(result);
                        }
                        return (T)result;
                    }
                });
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Messages {
            private final CommandSpec spec;
            private final ResourceBundle rb;
            private final Set<String> keys;

            public Messages(CommandSpec spec, ResourceBundle rb) {
                this.spec = Assert.notNull(spec, "CommandSpec");
                this.rb = rb;
                this.keys = Messages.keys(rb);
            }

            private static Set<String> keys(ResourceBundle rb) {
                if (rb == null) {
                    return Collections.emptySet();
                }
                LinkedHashSet<String> keys2 = new LinkedHashSet<String>();
                Enumeration<String> k = rb.getKeys();
                while (k.hasMoreElements()) {
                    keys2.add(k.nextElement());
                }
                return keys2;
            }

            public static Messages copy(CommandSpec spec, Messages original) {
                return original == null ? null : new Messages(spec, original.rb);
            }

            public static boolean empty(Messages messages) {
                return messages == null || messages.rb == null;
            }

            public String getString(String key, String defaultValue) {
                if (this.isEmpty()) {
                    return defaultValue;
                }
                String cmd = this.spec.qualifiedName(".");
                if (this.keys.contains(cmd + "." + key)) {
                    return this.rb.getString(cmd + "." + key);
                }
                if (this.keys.contains(key)) {
                    return this.rb.getString(key);
                }
                return defaultValue;
            }

            boolean isEmpty() {
                return this.rb == null || this.keys.isEmpty();
            }

            public String[] getStringArray(String key, String[] defaultValues) {
                if (this.isEmpty()) {
                    return defaultValues;
                }
                String cmd = this.spec.qualifiedName(".");
                List<String> result = Messages.addAllWithPrefix(this.rb, cmd + "." + key, this.keys, new ArrayList<String>());
                if (!result.isEmpty()) {
                    return result.toArray(new String[0]);
                }
                Messages.addAllWithPrefix(this.rb, key, this.keys, result);
                return result.isEmpty() ? defaultValues : result.toArray(new String[0]);
            }

            private static List<String> addAllWithPrefix(ResourceBundle rb, String key, Set<String> keys2, List<String> result) {
                if (keys2.contains(key)) {
                    result.add(rb.getString(key));
                }
                int i = 0;
                String elementKey;
                while (keys2.contains(elementKey = key + "." + i)) {
                    result.add(rb.getString(elementKey));
                    ++i;
                }
                return result;
            }

            public static ResourceBundle resourceBundle(Messages messages) {
                return messages == null ? null : messages.resourceBundle();
            }

            public ResourceBundle resourceBundle() {
                return this.rb;
            }

            public CommandSpec commandSpec() {
                return this.spec;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class TypedMember {
            final AccessibleObject accessible;
            final String name;
            final Class<?> type;
            final Type genericType;
            final boolean hasInitialValue;
            private IGetter getter;
            private ISetter setter;

            TypedMember(Field field) {
                this.accessible = Assert.notNull(field, "field");
                this.accessible.setAccessible(true);
                this.name = field.getName();
                this.type = field.getType();
                this.genericType = field.getGenericType();
                this.hasInitialValue = true;
            }

            static TypedMember createIfAnnotated(Field field, Object scope) {
                return TypedMember.isAnnotated(field) ? new TypedMember(field, scope) : null;
            }

            private TypedMember(Field field, Object scope) {
                this(field);
                if (Proxy.isProxyClass(scope.getClass())) {
                    throw new InitializationException("Invalid picocli annotation on interface field");
                }
                FieldBinding binding = new FieldBinding(scope, field);
                this.getter = binding;
                this.setter = binding;
            }

            static TypedMember createIfAnnotated(Method method, Object scope, CommandSpec spec) {
                return TypedMember.isAnnotated(method) ? new TypedMember(method, scope, spec) : null;
            }

            private TypedMember(Method method, Object scope, CommandSpec spec) {
                boolean isSetter;
                this.accessible = Assert.notNull(method, "method");
                this.accessible.setAccessible(true);
                this.name = TypedMember.propertyName(method.getName());
                Class<?>[] parameterTypes = method.getParameterTypes();
                boolean isGetter = parameterTypes.length == 0 && method.getReturnType() != Void.TYPE && method.getReturnType() != Void.class;
                boolean bl = isSetter = parameterTypes.length > 0;
                if (isSetter == isGetter) {
                    throw new InitializationException("Invalid method, must be either getter or setter: " + method);
                }
                if (isGetter) {
                    this.hasInitialValue = true;
                    this.type = method.getReturnType();
                    this.genericType = method.getGenericReturnType();
                    if (Proxy.isProxyClass(scope.getClass())) {
                        PicocliInvocationHandler handler;
                        PicocliInvocationHandler picocliInvocationHandler = handler = (PicocliInvocationHandler)Proxy.getInvocationHandler(scope);
                        picocliInvocationHandler.getClass();
                        PicocliInvocationHandler.ProxyBinding binding = picocliInvocationHandler.new PicocliInvocationHandler.ProxyBinding(method);
                        this.getter = binding;
                        this.setter = binding;
                        this.initializeInitialValue(method);
                    } else {
                        MethodBinding binding = new MethodBinding(scope, method, spec);
                        this.getter = binding;
                        this.setter = binding;
                    }
                } else {
                    this.hasInitialValue = false;
                    this.type = parameterTypes[0];
                    this.genericType = method.getGenericParameterTypes()[0];
                    MethodBinding binding = new MethodBinding(scope, method, spec);
                    this.getter = binding;
                    this.setter = binding;
                }
            }

            private TypedMember(MethodParam param, Object scope) {
                this.accessible = Assert.notNull(param, "command method parameter");
                this.accessible.setAccessible(true);
                this.name = param.getName();
                this.type = param.getType();
                this.genericType = param.getParameterizedType();
                ObjectBinding binding = new ObjectBinding();
                this.getter = binding;
                this.setter = binding;
                this.initializeInitialValue(param);
                this.hasInitialValue = true;
            }

            private void initializeInitialValue(Object arg) {
                try {
                    if (this.type == Boolean.TYPE) {
                        this.setter.set(false);
                    } else if (this.type == Byte.TYPE) {
                        this.setter.set((byte)0);
                    } else if (this.type == Character.TYPE) {
                        this.setter.set(Character.valueOf('\u0000'));
                    } else if (this.type == Short.TYPE) {
                        this.setter.set((short)0);
                    } else if (this.type == Integer.TYPE) {
                        this.setter.set(0);
                    } else if (this.type == Long.TYPE) {
                        this.setter.set(0L);
                    } else if (this.type == Float.TYPE) {
                        this.setter.set(Float.valueOf(0.0f));
                    } else if (this.type == Double.TYPE) {
                        this.setter.set(0.0);
                    } else {
                        this.setter.set(null);
                    }
                }
                catch (Exception ex) {
                    throw new InitializationException("Could not set initial value for " + arg + ": " + ex.toString(), ex);
                }
            }

            static boolean isAnnotated(AnnotatedElement e) {
                return e.isAnnotationPresent(Option.class) || e.isAnnotationPresent(Parameters.class) || e.isAnnotationPresent(Unmatched.class) || e.isAnnotationPresent(Mixin.class) || e.isAnnotationPresent(Spec.class) || e.isAnnotationPresent(ParentCommand.class);
            }

            boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
                return this.accessible.isAnnotationPresent(annotationClass);
            }

            <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return this.accessible.getAnnotation(annotationClass);
            }

            String name() {
                return this.name;
            }

            boolean isArgSpec() {
                return this.isOption() || this.isParameter() || this.isMethodParameter() && !this.isMixin();
            }

            boolean isOption() {
                return this.isAnnotationPresent(Option.class);
            }

            boolean isParameter() {
                return this.isAnnotationPresent(Parameters.class);
            }

            boolean isMixin() {
                return this.isAnnotationPresent(Mixin.class);
            }

            boolean isUnmatched() {
                return this.isAnnotationPresent(Unmatched.class);
            }

            boolean isInjectSpec() {
                return this.isAnnotationPresent(Spec.class);
            }

            boolean isMultiValue() {
                return CommandLine.isMultiValue(this.getType());
            }

            IGetter getter() {
                return this.getter;
            }

            ISetter setter() {
                return this.setter;
            }

            Class<?> getType() {
                return this.type;
            }

            Type getGenericType() {
                return this.genericType;
            }

            public String toString() {
                return this.accessible.toString();
            }

            String toGenericString() {
                return this.accessible instanceof Field ? ((Field)this.accessible).toGenericString() : (this.accessible instanceof Method ? ((Method)this.accessible).toGenericString() : ((MethodParam)this.accessible).toString());
            }

            boolean isMethodParameter() {
                return this.accessible instanceof MethodParam;
            }

            String mixinName() {
                String annotationName = this.getAnnotation(Mixin.class).name();
                return CommandLine.empty(annotationName) ? this.name() : annotationName;
            }

            static String propertyName(String methodName) {
                if (methodName.length() > 3 && (methodName.startsWith("get") || methodName.startsWith("set"))) {
                    return TypedMember.decapitalize(methodName.substring(3));
                }
                return TypedMember.decapitalize(methodName);
            }

            private static String decapitalize(String name) {
                if (name == null || name.length() == 0) {
                    return name;
                }
                char[] chars = name.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                return new String(chars);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class MethodParam
        extends AccessibleObject {
            final Method method;
            final int paramIndex;
            final String name;
            int position;

            public MethodParam(Method method, int paramIndex) {
                this.method = method;
                this.paramIndex = paramIndex;
                String tmp = "arg" + paramIndex;
                try {
                    Method getParameters = Method.class.getMethod("getParameters", new Class[0]);
                    Object parameters = getParameters.invoke((Object)method, new Object[0]);
                    Object parameter = Array.get(parameters, paramIndex);
                    tmp = (String)Class.forName("java.lang.reflect.Parameter").getDeclaredMethod("getName", new Class[0]).invoke(parameter, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.name = tmp;
            }

            public Type getParameterizedType() {
                return this.method.getGenericParameterTypes()[this.paramIndex];
            }

            public String getName() {
                return this.name;
            }

            public Class<?> getType() {
                return this.method.getParameterTypes()[this.paramIndex];
            }

            public Method getDeclaringExecutable() {
                return this.method;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                for (Annotation annotation : this.getDeclaredAnnotations()) {
                    if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
                    return (T)((Annotation)annotationClass.cast(annotation));
                }
                return null;
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return this.method.getParameterAnnotations()[this.paramIndex];
            }

            @Override
            public void setAccessible(boolean flag) throws SecurityException {
                this.method.setAccessible(flag);
            }

            @Override
            public boolean isAccessible() throws SecurityException {
                return this.method.isAccessible();
            }

            public String toString() {
                return this.method.toString() + ":" + this.getName();
            }
        }

        public static class UnmatchedArgsBinding {
            private final IGetter getter;
            private final ISetter setter;

            public static UnmatchedArgsBinding forStringArrayConsumer(ISetter setter) {
                return new UnmatchedArgsBinding(null, setter);
            }

            public static UnmatchedArgsBinding forStringCollectionSupplier(IGetter getter) {
                return new UnmatchedArgsBinding(getter, null);
            }

            private UnmatchedArgsBinding(IGetter getter, ISetter setter) {
                if (getter == null && setter == null) {
                    throw new IllegalArgumentException("Getter and setter cannot both be null");
                }
                this.setter = setter;
                this.getter = getter;
            }

            public IGetter getter() {
                return this.getter;
            }

            public ISetter setter() {
                return this.setter;
            }

            void addAll(String[] unmatched) {
                if (this.setter != null) {
                    try {
                        this.setter.set(unmatched);
                    }
                    catch (Exception ex) {
                        throw new PicocliException(String.format("Could not invoke setter (%s) with unmatched argument array '%s': %s", this.setter, Arrays.toString(unmatched), ex), ex);
                    }
                }
                if (this.getter != null) {
                    try {
                        Collection collection = (Collection)this.getter.get();
                        Assert.notNull(collection, "getter returned null Collection");
                        collection.addAll(Arrays.asList(unmatched));
                    }
                    catch (Exception ex) {
                        throw new PicocliException(String.format("Could not add unmatched argument array '%s' to collection returned by getter (%s): %s", Arrays.toString(unmatched), this.getter, ex), ex);
                    }
                }
            }
        }

        public static class PositionalParamSpec
        extends ArgSpec {
            private Range index;
            private Range capacity;

            private PositionalParamSpec(Builder builder) {
                super(builder);
                this.index = builder.index == null ? Range.valueOf("*") : builder.index;
                Range range = this.capacity = builder.capacity == null ? Range.parameterCapacity(this.arity(), this.index) : builder.capacity;
                if (this.toString == null) {
                    this.toString = "positional parameter[" + this.index() + "]";
                }
            }

            public Builder toBuilder() {
                return new Builder(this);
            }

            public boolean isOption() {
                return false;
            }

            public boolean isPositional() {
                return true;
            }

            public String[] description() {
                if (this.messages() == null) {
                    return super.description();
                }
                String[] newValue = this.messages().getStringArray(this.descriptionKey(), null);
                if (newValue != null) {
                    return newValue;
                }
                newValue = this.messages().getStringArray(this.paramLabel() + "[" + this.index() + "]", null);
                if (newValue != null) {
                    return newValue;
                }
                return super.description();
            }

            public Range index() {
                return this.index;
            }

            private Range capacity() {
                return this.capacity;
            }

            public static Builder builder() {
                return new Builder();
            }

            public int hashCode() {
                return super.hashCodeImpl() + 37 * Assert.hashCode(this.capacity) + 37 * Assert.hashCode(this.index);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof PositionalParamSpec)) {
                    return false;
                }
                PositionalParamSpec other = (PositionalParamSpec)obj;
                return super.equalsImpl(other) && Assert.equals(this.capacity, other.capacity) && Assert.equals(this.index, other.index);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Builder
            extends ArgSpec.Builder<Builder> {
                private Range capacity;
                private Range index;

                private Builder() {
                }

                private Builder(PositionalParamSpec original) {
                    super(original);
                    this.index = original.index;
                    this.capacity = original.capacity;
                }

                @Override
                public PositionalParamSpec build() {
                    return new PositionalParamSpec(this);
                }

                @Override
                protected Builder self() {
                    return this;
                }

                public Range index() {
                    return this.index;
                }

                public Builder index(String range) {
                    return this.index(Range.valueOf(range));
                }

                public Builder index(Range index) {
                    this.index = index;
                    return this.self();
                }

                Builder capacity(Range capacity) {
                    this.capacity = capacity;
                    return this.self();
                }
            }
        }

        public static class OptionSpec
        extends ArgSpec {
            static final int DEFAULT_ORDER = -1;
            private String[] names;
            private boolean help;
            private boolean usageHelp;
            private boolean versionHelp;
            private int order;

            public static Builder builder(String name, String ... names) {
                String[] copy = new String[Assert.notNull(names, "names").length + 1];
                copy[0] = Assert.notNull(name, "name");
                System.arraycopy(names, 0, copy, 1, names.length);
                return new Builder(copy);
            }

            public static Builder builder(String[] names) {
                return new Builder(names);
            }

            private OptionSpec(Builder builder) {
                super(builder);
                if (builder.names == null) {
                    throw new InitializationException("OptionSpec names cannot be null. Specify at least one option name.");
                }
                this.names = (String[])builder.names.clone();
                this.help = builder.help;
                this.usageHelp = builder.usageHelp;
                this.versionHelp = builder.versionHelp;
                this.order = builder.order;
                if (this.names.length == 0 || Arrays.asList(this.names).contains("")) {
                    throw new InitializationException("Invalid names: " + Arrays.toString(this.names));
                }
                if (this.toString() == null) {
                    this.toString = "option " + this.longestName();
                }
            }

            public Builder toBuilder() {
                return new Builder(this);
            }

            public boolean isOption() {
                return true;
            }

            public boolean isPositional() {
                return false;
            }

            protected boolean internalShowDefaultValue(boolean usageMessageShowDefaults) {
                return super.internalShowDefaultValue(usageMessageShowDefaults) && !this.help() && !this.versionHelp() && !this.usageHelp();
            }

            public String[] description() {
                if (this.messages() == null) {
                    return super.description();
                }
                String[] newValue = this.messages().getStringArray(this.descriptionKey(), null);
                if (newValue != null) {
                    return newValue;
                }
                for (String name : this.names()) {
                    newValue = this.messages().getStringArray(CommandSpec.stripPrefix(name), null);
                    if (newValue == null) continue;
                    return newValue;
                }
                return super.description();
            }

            public String[] names() {
                return (String[])this.names.clone();
            }

            public String longestName() {
                return Help.ShortestFirst.longestFirst((String[])this.names.clone())[0];
            }

            String shortestName() {
                return Help.ShortestFirst.sort((String[])this.names.clone())[0];
            }

            public int order() {
                return this.order;
            }

            @Deprecated
            public boolean help() {
                return this.help;
            }

            public boolean usageHelp() {
                return this.usageHelp;
            }

            public boolean versionHelp() {
                return this.versionHelp;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof OptionSpec)) {
                    return false;
                }
                OptionSpec other = (OptionSpec)obj;
                boolean result = super.equalsImpl(other) && this.help == other.help && this.usageHelp == other.usageHelp && this.versionHelp == other.versionHelp && this.order == other.order && new HashSet<String>(Arrays.asList(this.names)).equals(new HashSet<String>(Arrays.asList(other.names)));
                return result;
            }

            public int hashCode() {
                return super.hashCodeImpl() + 37 * Assert.hashCode(this.help) + 37 * Assert.hashCode(this.usageHelp) + 37 * Assert.hashCode(this.versionHelp) + 37 * Arrays.hashCode(this.names) + 37 * this.order;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Builder
            extends ArgSpec.Builder<Builder> {
                private String[] names;
                private boolean help;
                private boolean usageHelp;
                private boolean versionHelp;
                private int order = -1;

                private Builder(String[] names) {
                    this.names = names;
                }

                private Builder(OptionSpec original) {
                    super(original);
                    this.names = original.names;
                    this.help = original.help;
                    this.usageHelp = original.usageHelp;
                    this.versionHelp = original.versionHelp;
                    this.order = original.order;
                }

                @Override
                public OptionSpec build() {
                    return new OptionSpec(this);
                }

                @Override
                protected Builder self() {
                    return this;
                }

                public String[] names() {
                    return this.names;
                }

                @Deprecated
                public boolean help() {
                    return this.help;
                }

                public boolean usageHelp() {
                    return this.usageHelp;
                }

                public boolean versionHelp() {
                    return this.versionHelp;
                }

                public int order() {
                    return this.order;
                }

                public Builder names(String ... names) {
                    this.names = (String[])Assert.notNull(names, "names").clone();
                    return this.self();
                }

                public Builder help(boolean help) {
                    this.help = help;
                    return this.self();
                }

                public Builder usageHelp(boolean usageHelp) {
                    this.usageHelp = usageHelp;
                    return this.self();
                }

                public Builder versionHelp(boolean versionHelp) {
                    this.versionHelp = versionHelp;
                    return this.self();
                }

                public Builder order(int order) {
                    this.order = order;
                    return this.self();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class ArgSpec {
            static final String DESCRIPTION_VARIABLE_DEFAULT_VALUE = "${DEFAULT-VALUE}";
            static final String DESCRIPTION_VARIABLE_COMPLETION_CANDIDATES = "${COMPLETION-CANDIDATES}";
            private static final String NO_DEFAULT_VALUE = "__no_default_value__";
            private final boolean hidden;
            private final String paramLabel;
            private final boolean hideParamSyntax;
            private final String[] description;
            private final String descriptionKey;
            private final Help.Visibility showDefaultValue;
            private Messages messages;
            CommandSpec commandSpec;
            private final boolean interactive;
            private final boolean required;
            private final String splitRegex;
            private final Class<?> type;
            private final Class<?>[] auxiliaryTypes;
            private final ITypeConverter<?>[] converters;
            private final Iterable<String> completionCandidates;
            private final String defaultValue;
            private final Object initialValue;
            private final boolean hasInitialValue;
            private final IGetter getter;
            private final ISetter setter;
            private final Range arity;
            private List<String> stringValues = new ArrayList<String>();
            private List<String> originalStringValues = new ArrayList<String>();
            protected String toString;
            private List<Object> typedValues = new ArrayList<Object>();
            Map<Integer, Object> typedValueAtPosition = new TreeMap<Integer, Object>();

            private <T extends Builder<T>> ArgSpec(Builder<T> builder) {
                this.description = ((Builder)builder).description == null ? new String[]{} : ((Builder)builder).description;
                this.descriptionKey = ((Builder)builder).descriptionKey;
                this.splitRegex = ((Builder)builder).splitRegex == null ? "" : ((Builder)builder).splitRegex;
                this.paramLabel = CommandLine.empty(((Builder)builder).paramLabel) ? "PARAM" : ((Builder)builder).paramLabel;
                this.hideParamSyntax = ((Builder)builder).hideParamSyntax;
                this.converters = ((Builder)builder).converters == null ? new ITypeConverter[]{} : ((Builder)builder).converters;
                this.showDefaultValue = ((Builder)builder).showDefaultValue == null ? Help.Visibility.ON_DEMAND : ((Builder)builder).showDefaultValue;
                this.hidden = ((Builder)builder).hidden;
                this.interactive = ((Builder)builder).interactive;
                this.required = ((Builder)builder).required && ((Builder)builder).defaultValue == null;
                this.defaultValue = ((Builder)builder).defaultValue;
                this.initialValue = ((Builder)builder).initialValue;
                this.hasInitialValue = ((Builder)builder).hasInitialValue;
                this.toString = ((Builder)builder).toString;
                this.getter = ((Builder)builder).getter;
                this.setter = ((Builder)builder).setter;
                Range tempArity = ((Builder)builder).arity;
                if (tempArity == null) {
                    tempArity = this.isOption() ? (((Builder)builder).type == null || CommandLine.isBoolean(((Builder)builder).type) ? Range.valueOf("0") : Range.valueOf("1")) : Range.valueOf("1");
                    tempArity = tempArity.unspecified(true);
                }
                this.arity = tempArity;
                this.type = ((Builder)builder).type == null ? (((Builder)builder).auxiliaryTypes == null || ((Builder)builder).auxiliaryTypes.length == 0 ? (this.arity.isVariable || this.arity.max > 1 ? String[].class : (this.arity.max == 1 ? String.class : (this.isOption() ? Boolean.TYPE : String.class))) : ((Builder)builder).auxiliaryTypes[0]) : ((Builder)builder).type;
                this.auxiliaryTypes = ((Builder)builder).auxiliaryTypes == null || ((Builder)builder).auxiliaryTypes.length == 0 ? (this.type.isArray() ? new Class[]{this.type.getComponentType()} : (Collection.class.isAssignableFrom(this.type) ? new Class[]{String.class} : (Map.class.isAssignableFrom(this.type) ? new Class[]{String.class, String.class} : new Class[]{this.type}))) : ((Builder)builder).auxiliaryTypes;
                if (((Builder)builder).completionCandidates == null && this.auxiliaryTypes[0].isEnum()) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (Object c : this.auxiliaryTypes[0].getEnumConstants()) {
                        list.add(c.toString());
                    }
                    this.completionCandidates = Collections.unmodifiableList(list);
                } else {
                    this.completionCandidates = ((Builder)builder).completionCandidates;
                }
                if (this.interactive && (this.arity.min != 1 || this.arity.max != 1)) {
                    throw new InitializationException("Interactive options and positional parameters are only supported for arity=1, not for arity=" + this.arity);
                }
            }

            public boolean required() {
                return this.required;
            }

            public boolean interactive() {
                return this.interactive;
            }

            public String[] description() {
                return (String[])this.description.clone();
            }

            public String descriptionKey() {
                return this.descriptionKey;
            }

            public String[] renderedDescription() {
                String[] desc = this.description();
                if (desc.length == 0) {
                    return desc;
                }
                StringBuilder candidates = new StringBuilder();
                if (this.completionCandidates() != null) {
                    for (String c : this.completionCandidates()) {
                        if (candidates.length() > 0) {
                            candidates.append(", ");
                        }
                        candidates.append(c);
                    }
                }
                String defaultValueString = this.defaultValueString();
                String[] result = new String[desc.length];
                for (int i = 0; i < desc.length; ++i) {
                    result[i] = CommandLine.format(desc[i].replace(DESCRIPTION_VARIABLE_DEFAULT_VALUE, defaultValueString).replace(DESCRIPTION_VARIABLE_COMPLETION_CANDIDATES, candidates.toString()), new Object[0]);
                }
                return result;
            }

            public Range arity() {
                return this.arity;
            }

            public String paramLabel() {
                return this.paramLabel;
            }

            public boolean hideParamSyntax() {
                return this.hideParamSyntax;
            }

            public Class<?>[] auxiliaryTypes() {
                return (Class[])this.auxiliaryTypes.clone();
            }

            public ITypeConverter<?>[] converters() {
                return (ITypeConverter[])this.converters.clone();
            }

            public String splitRegex() {
                return this.splitRegex;
            }

            public boolean hidden() {
                return this.hidden;
            }

            public Class<?> type() {
                return this.type;
            }

            public String defaultValue() {
                return this.defaultValue;
            }

            public Object initialValue() {
                return this.initialValue;
            }

            public boolean hasInitialValue() {
                return this.hasInitialValue;
            }

            public Help.Visibility showDefaultValue() {
                return this.showDefaultValue;
            }

            public String defaultValueString() {
                Object value;
                String fromProvider = this.defaultValueFromProvider();
                String defaultVal = fromProvider == null ? this.defaultValue() : fromProvider;
                Object object = value = defaultVal == null ? this.initialValue() : defaultVal;
                if (value != null && value.getClass().isArray()) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        sb.append(i > 0 ? ", " : "").append(Array.get(value, i));
                    }
                    return sb.insert(0, "[").append("]").toString();
                }
                return String.valueOf(value);
            }

            private String defaultValueFromProvider() {
                String fromProvider = null;
                IDefaultValueProvider defaultValueProvider = null;
                try {
                    defaultValueProvider = this.commandSpec.defaultValueProvider();
                    fromProvider = defaultValueProvider == null ? null : defaultValueProvider.defaultValue(this);
                }
                catch (Exception ex) {
                    new Tracer().info("Error getting default value for %s from %s: %s", this, defaultValueProvider, ex);
                }
                return fromProvider;
            }

            public Iterable<String> completionCandidates() {
                return this.completionCandidates;
            }

            public IGetter getter() {
                return this.getter;
            }

            public ISetter setter() {
                return this.setter;
            }

            public <T> T getValue() throws PicocliException {
                try {
                    return this.getter.get();
                }
                catch (PicocliException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new PicocliException("Could not get value for " + this + ": " + ex, ex);
                }
            }

            public <T> T setValue(T newValue) throws PicocliException {
                try {
                    return this.setter.set(newValue);
                }
                catch (PicocliException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new PicocliException("Could not set value (" + newValue + ") for " + this + ": " + ex, ex);
                }
            }

            @Deprecated
            public <T> T setValue(T newValue, CommandLine commandLine) throws PicocliException {
                return this.setValue(newValue);
            }

            public boolean isMultiValue() {
                return CommandLine.isMultiValue(this.type());
            }

            public abstract boolean isOption();

            public abstract boolean isPositional();

            public List<String> stringValues() {
                return Collections.unmodifiableList(this.stringValues);
            }

            public List<Object> typedValues() {
                return Collections.unmodifiableList(this.typedValues);
            }

            protected void resetStringValues() {
                this.stringValues = new ArrayList<String>();
            }

            public List<String> originalStringValues() {
                return Collections.unmodifiableList(this.originalStringValues);
            }

            protected void resetOriginalStringValues() {
                this.originalStringValues = new ArrayList<String>();
            }

            protected boolean internalShowDefaultValue(boolean usageHelpShowDefaults) {
                if (this.showDefaultValue() == Help.Visibility.ALWAYS) {
                    return true;
                }
                if (this.showDefaultValue() == Help.Visibility.NEVER) {
                    return false;
                }
                if (this.initialValue == null && this.defaultValue() == null && this.defaultValueFromProvider() == null) {
                    return false;
                }
                return usageHelpShowDefaults && !CommandLine.isBoolean(this.type());
            }

            public Messages messages() {
                return this.messages;
            }

            public ArgSpec messages(Messages msgs) {
                this.messages = msgs;
                return this;
            }

            public String toString() {
                return this.toString;
            }

            String[] splitValue(String value, ParserSpec parser, Range arity, int consumed) {
                int limit;
                if (this.splitRegex().length() == 0) {
                    return new String[]{value};
                }
                int n = limit = parser.limitSplit() ? Math.max(arity.max - consumed, 0) : 0;
                if (parser.splitQuotedStrings()) {
                    return this.debug(value.split(this.splitRegex(), limit), "Split (ignoring quotes)", value);
                }
                return this.debug(ArgSpec.splitRespectingQuotedStrings(value, limit, parser, this, this.splitRegex()), "Split", value);
            }

            private String[] debug(String[] result, String msg, String value) {
                Tracer t = new Tracer();
                if (t.isDebug()) {
                    t.debug("%s with regex '%s' resulted in %s parts: %s%n", msg, this.splitRegex(), result.length, Arrays.asList(result));
                }
                return result;
            }

            private static String[] splitRespectingQuotedStrings(String value, int limit, ParserSpec parser, ArgSpec argSpec, String splitRegex) {
                int i;
                StringBuilder splittable = new StringBuilder();
                StringBuilder temp = new StringBuilder();
                StringBuilder current = splittable;
                LinkedList<String> quotedValues = new LinkedList<String>();
                boolean escaping = false;
                boolean inQuote = false;
                int ch = 0;
                block4: for (i = 0; i < value.length(); i += Character.charCount(ch)) {
                    ch = value.codePointAt(i);
                    switch (ch) {
                        case 92: {
                            escaping = !escaping;
                            break;
                        }
                        case 34: {
                            if (escaping) break;
                            inQuote = !inQuote;
                            StringBuilder stringBuilder = current = inQuote ? temp : splittable;
                            if (inQuote) {
                                splittable.appendCodePoint(ch);
                                continue block4;
                            }
                            quotedValues.add(temp.toString());
                            temp.setLength(0);
                            break;
                        }
                        default: {
                            escaping = false;
                        }
                    }
                    current.appendCodePoint(ch);
                }
                if (temp.length() > 0) {
                    new Tracer().warn("Unbalanced quotes in [%s] for %s (value=%s)%n", temp, argSpec, value);
                    quotedValues.add(temp.toString());
                    temp.setLength(0);
                }
                String[] result = splittable.toString().split(splitRegex, limit);
                for (i = 0; i < result.length; ++i) {
                    result[i] = ArgSpec.restoreQuotedValues(result[i], quotedValues, parser);
                }
                if (!quotedValues.isEmpty()) {
                    new Tracer().warn("Unable to respect quotes while splitting value %s for %s (unprocessed remainder: %s)%n", value, argSpec, quotedValues);
                    return value.split(splitRegex, limit);
                }
                return result;
            }

            private static String restoreQuotedValues(String part, Queue<String> quotedValues, ParserSpec parser) {
                StringBuilder result = new StringBuilder();
                boolean escaping = false;
                boolean inQuote = false;
                boolean skip = false;
                int ch = 0;
                for (int i = 0; i < part.length(); i += Character.charCount(ch)) {
                    ch = part.codePointAt(i);
                    switch (ch) {
                        case 92: {
                            escaping = !escaping;
                            break;
                        }
                        case 34: {
                            if (escaping) break;
                            boolean bl = inQuote = !inQuote;
                            if (!inQuote) {
                                result.append(quotedValues.remove());
                            }
                            skip = parser.trimQuotes();
                            break;
                        }
                        default: {
                            escaping = false;
                        }
                    }
                    if (!skip) {
                        result.appendCodePoint(ch);
                    }
                    skip = false;
                }
                return result.toString();
            }

            protected boolean equalsImpl(ArgSpec other) {
                boolean result = Assert.equals(this.defaultValue, other.defaultValue) && Assert.equals(this.type, other.type) && Assert.equals(this.arity, other.arity) && Assert.equals(this.hidden, other.hidden) && Assert.equals(this.paramLabel, other.paramLabel) && Assert.equals(this.hideParamSyntax, other.hideParamSyntax) && Assert.equals(this.required, other.required) && Assert.equals(this.splitRegex, other.splitRegex) && Arrays.equals(this.description, other.description) && Assert.equals(this.descriptionKey, other.descriptionKey) && Arrays.equals(this.auxiliaryTypes, other.auxiliaryTypes);
                return result;
            }

            protected int hashCodeImpl() {
                return 17 + 37 * Assert.hashCode(this.defaultValue) + 37 * Assert.hashCode(this.type) + 37 * Assert.hashCode(this.arity) + 37 * Assert.hashCode(this.hidden) + 37 * Assert.hashCode(this.paramLabel) + 37 * Assert.hashCode(this.hideParamSyntax) + 37 * Assert.hashCode(this.required) + 37 * Assert.hashCode(this.splitRegex) + 37 * Arrays.hashCode(this.description) + 37 * Assert.hashCode(this.descriptionKey) + 37 * Arrays.hashCode(this.auxiliaryTypes);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static abstract class Builder<T extends Builder<T>> {
                private Range arity;
                private String[] description;
                private String descriptionKey;
                private boolean required;
                private boolean interactive;
                private String paramLabel;
                private boolean hideParamSyntax;
                private String splitRegex;
                private boolean hidden;
                private Class<?> type;
                private Class<?>[] auxiliaryTypes;
                private ITypeConverter<?>[] converters;
                private String defaultValue;
                private Object initialValue;
                private boolean hasInitialValue = true;
                private Help.Visibility showDefaultValue;
                private Iterable<String> completionCandidates;
                private String toString;
                private IGetter getter = new ObjectBinding();
                private ISetter setter = (ISetter)((Object)this.getter);

                Builder() {
                }

                Builder(ArgSpec original) {
                    this.arity = original.arity;
                    this.auxiliaryTypes = original.auxiliaryTypes;
                    this.converters = original.converters;
                    this.defaultValue = original.defaultValue;
                    this.description = original.description;
                    this.getter = original.getter;
                    this.setter = original.setter;
                    this.hidden = original.hidden;
                    this.paramLabel = original.paramLabel;
                    this.hideParamSyntax = original.hideParamSyntax;
                    this.required = original.required;
                    this.interactive = original.interactive;
                    this.showDefaultValue = original.showDefaultValue;
                    this.completionCandidates = original.completionCandidates;
                    this.splitRegex = original.splitRegex;
                    this.toString = original.toString;
                    this.type = original.type;
                    this.descriptionKey = original.descriptionKey;
                }

                public abstract ArgSpec build();

                protected abstract T self();

                public boolean required() {
                    return this.required;
                }

                public boolean interactive() {
                    return this.interactive;
                }

                public String[] description() {
                    return this.description;
                }

                public String descriptionKey() {
                    return this.descriptionKey;
                }

                public Range arity() {
                    return this.arity;
                }

                public String paramLabel() {
                    return this.paramLabel;
                }

                public boolean hideParamSyntax() {
                    return this.hideParamSyntax;
                }

                public Class<?>[] auxiliaryTypes() {
                    return this.auxiliaryTypes;
                }

                public ITypeConverter<?>[] converters() {
                    return this.converters;
                }

                public String splitRegex() {
                    return this.splitRegex;
                }

                public boolean hidden() {
                    return this.hidden;
                }

                public Class<?> type() {
                    return this.type;
                }

                public String defaultValue() {
                    return this.defaultValue;
                }

                public Object initialValue() {
                    return this.initialValue;
                }

                public boolean hasInitialValue() {
                    return this.hasInitialValue;
                }

                public Help.Visibility showDefaultValue() {
                    return this.showDefaultValue;
                }

                public Iterable<String> completionCandidates() {
                    return this.completionCandidates;
                }

                public IGetter getter() {
                    return this.getter;
                }

                public ISetter setter() {
                    return this.setter;
                }

                public String toString() {
                    return this.toString;
                }

                public T required(boolean required) {
                    this.required = required;
                    return this.self();
                }

                public T interactive(boolean interactive) {
                    this.interactive = interactive;
                    return this.self();
                }

                public T description(String ... description) {
                    this.description = (String[])Assert.notNull(description, "description").clone();
                    return this.self();
                }

                public T descriptionKey(String descriptionKey) {
                    this.descriptionKey = descriptionKey;
                    return this.self();
                }

                public T arity(String range) {
                    return this.arity(Range.valueOf(range));
                }

                public T arity(Range arity) {
                    this.arity = Assert.notNull(arity, "arity");
                    return this.self();
                }

                public T paramLabel(String paramLabel) {
                    this.paramLabel = Assert.notNull(paramLabel, "paramLabel");
                    return this.self();
                }

                public T hideParamSyntax(boolean hideParamSyntax) {
                    this.hideParamSyntax = hideParamSyntax;
                    return this.self();
                }

                public T auxiliaryTypes(Class<?> ... types) {
                    this.auxiliaryTypes = (Class[])Assert.notNull(types, "types").clone();
                    return this.self();
                }

                public T converters(ITypeConverter<?> ... cs) {
                    this.converters = (ITypeConverter[])Assert.notNull(cs, "type converters").clone();
                    return this.self();
                }

                public T splitRegex(String splitRegex) {
                    this.splitRegex = Assert.notNull(splitRegex, "splitRegex");
                    return this.self();
                }

                public T showDefaultValue(Help.Visibility visibility) {
                    this.showDefaultValue = Assert.notNull(visibility, "visibility");
                    return this.self();
                }

                public T completionCandidates(Iterable<String> completionCandidates) {
                    this.completionCandidates = Assert.notNull(completionCandidates, "completionCandidates");
                    return this.self();
                }

                public T hidden(boolean hidden) {
                    this.hidden = hidden;
                    return this.self();
                }

                public T type(Class<?> propertyType) {
                    this.type = Assert.notNull(propertyType, "type");
                    return this.self();
                }

                public T defaultValue(String defaultValue) {
                    this.defaultValue = ArgSpec.NO_DEFAULT_VALUE.equals(defaultValue) ? null : defaultValue;
                    return this.self();
                }

                public T initialValue(Object initialValue) {
                    this.initialValue = initialValue;
                    return this.self();
                }

                public T hasInitialValue(boolean hasInitialValue) {
                    this.hasInitialValue = hasInitialValue;
                    return this.self();
                }

                public T getter(IGetter getter) {
                    this.getter = getter;
                    return this.self();
                }

                public T setter(ISetter setter) {
                    this.setter = setter;
                    return this.self();
                }

                public T withToString(String toString) {
                    this.toString = toString;
                    return this.self();
                }
            }
        }

        public static class ParserSpec {
            static final String DEFAULT_SEPARATOR = "=";
            private String separator;
            private boolean stopAtUnmatched = false;
            private boolean stopAtPositional = false;
            private String endOfOptionsDelimiter = "--";
            private boolean toggleBooleanFlags = true;
            private boolean overwrittenOptionsAllowed = false;
            private boolean unmatchedArgumentsAllowed = false;
            private boolean expandAtFiles = true;
            private boolean useSimplifiedAtFiles = false;
            private Character atFileCommentChar = Character.valueOf('#');
            private boolean posixClusteredShortOptionsAllowed = true;
            private boolean unmatchedOptionsArePositionalParams = false;
            private boolean limitSplit = false;
            private boolean aritySatisfiedByAttachedOptionParam = false;
            private boolean collectErrors = false;
            private boolean caseInsensitiveEnumValuesAllowed = false;
            private boolean trimQuotes = this.shouldTrimQuotes();
            private boolean splitQuotedStrings = false;

            public String separator() {
                return this.separator == null ? DEFAULT_SEPARATOR : this.separator;
            }

            public boolean stopAtUnmatched() {
                return this.stopAtUnmatched;
            }

            public boolean stopAtPositional() {
                return this.stopAtPositional;
            }

            public String endOfOptionsDelimiter() {
                return this.endOfOptionsDelimiter;
            }

            public boolean toggleBooleanFlags() {
                return this.toggleBooleanFlags;
            }

            public boolean overwrittenOptionsAllowed() {
                return this.overwrittenOptionsAllowed;
            }

            public boolean unmatchedArgumentsAllowed() {
                return this.unmatchedArgumentsAllowed;
            }

            public boolean expandAtFiles() {
                return this.expandAtFiles;
            }

            public Character atFileCommentChar() {
                return this.atFileCommentChar;
            }

            public boolean useSimplifiedAtFiles() {
                String value = System.getProperty("picocli.useSimplifiedAtFiles");
                if (value != null) {
                    return "".equals(value) || Boolean.valueOf(value) != false;
                }
                return this.useSimplifiedAtFiles;
            }

            public boolean posixClusteredShortOptionsAllowed() {
                return this.posixClusteredShortOptionsAllowed;
            }

            public boolean caseInsensitiveEnumValuesAllowed() {
                return this.caseInsensitiveEnumValuesAllowed;
            }

            public boolean trimQuotes() {
                return this.trimQuotes;
            }

            public boolean splitQuotedStrings() {
                return this.splitQuotedStrings;
            }

            public boolean unmatchedOptionsArePositionalParams() {
                return this.unmatchedOptionsArePositionalParams;
            }

            private boolean splitFirst() {
                return this.limitSplit();
            }

            public boolean limitSplit() {
                return this.limitSplit;
            }

            public boolean aritySatisfiedByAttachedOptionParam() {
                return this.aritySatisfiedByAttachedOptionParam;
            }

            public boolean collectErrors() {
                return this.collectErrors;
            }

            public ParserSpec separator(String separator) {
                this.separator = separator;
                return this;
            }

            public ParserSpec stopAtUnmatched(boolean stopAtUnmatched) {
                this.stopAtUnmatched = stopAtUnmatched;
                return this;
            }

            public ParserSpec stopAtPositional(boolean stopAtPositional) {
                this.stopAtPositional = stopAtPositional;
                return this;
            }

            public ParserSpec endOfOptionsDelimiter(String delimiter) {
                this.endOfOptionsDelimiter = Assert.notNull(delimiter, "end-of-options delimiter");
                return this;
            }

            public ParserSpec toggleBooleanFlags(boolean toggleBooleanFlags) {
                this.toggleBooleanFlags = toggleBooleanFlags;
                return this;
            }

            public ParserSpec overwrittenOptionsAllowed(boolean overwrittenOptionsAllowed) {
                this.overwrittenOptionsAllowed = overwrittenOptionsAllowed;
                return this;
            }

            public ParserSpec unmatchedArgumentsAllowed(boolean unmatchedArgumentsAllowed) {
                this.unmatchedArgumentsAllowed = unmatchedArgumentsAllowed;
                return this;
            }

            public ParserSpec expandAtFiles(boolean expandAtFiles) {
                this.expandAtFiles = expandAtFiles;
                return this;
            }

            public ParserSpec atFileCommentChar(Character atFileCommentChar) {
                this.atFileCommentChar = atFileCommentChar;
                return this;
            }

            public ParserSpec useSimplifiedAtFiles(boolean useSimplifiedAtFiles) {
                this.useSimplifiedAtFiles = useSimplifiedAtFiles;
                return this;
            }

            public ParserSpec posixClusteredShortOptionsAllowed(boolean posixClusteredShortOptionsAllowed) {
                this.posixClusteredShortOptionsAllowed = posixClusteredShortOptionsAllowed;
                return this;
            }

            public ParserSpec caseInsensitiveEnumValuesAllowed(boolean caseInsensitiveEnumValuesAllowed) {
                this.caseInsensitiveEnumValuesAllowed = caseInsensitiveEnumValuesAllowed;
                return this;
            }

            public ParserSpec trimQuotes(boolean trimQuotes) {
                this.trimQuotes = trimQuotes;
                return this;
            }

            public ParserSpec splitQuotedStrings(boolean splitQuotedStrings) {
                this.splitQuotedStrings = splitQuotedStrings;
                return this;
            }

            public ParserSpec unmatchedOptionsArePositionalParams(boolean unmatchedOptionsArePositionalParams) {
                this.unmatchedOptionsArePositionalParams = unmatchedOptionsArePositionalParams;
                return this;
            }

            public ParserSpec collectErrors(boolean collectErrors) {
                this.collectErrors = collectErrors;
                return this;
            }

            public ParserSpec aritySatisfiedByAttachedOptionParam(boolean newValue) {
                this.aritySatisfiedByAttachedOptionParam = newValue;
                return this;
            }

            public ParserSpec limitSplit(boolean limitSplit) {
                this.limitSplit = limitSplit;
                return this;
            }

            private boolean shouldTrimQuotes() {
                String value = System.getProperty("picocli.trimQuotes");
                if ("".equals(value)) {
                    value = "true";
                }
                return Boolean.valueOf(value);
            }

            void initSeparator(String value) {
                if (Model.initializable(this.separator, value, DEFAULT_SEPARATOR)) {
                    this.separator = value;
                }
            }

            void updateSeparator(String value) {
                if (Model.isNonDefault(value, DEFAULT_SEPARATOR)) {
                    this.separator = value;
                }
            }

            public String toString() {
                return String.format("posixClusteredShortOptionsAllowed=%s, stopAtPositional=%s, stopAtUnmatched=%s, separator=%s, overwrittenOptionsAllowed=%s, unmatchedArgumentsAllowed=%s, expandAtFiles=%s, atFileCommentChar=%s, useSimplifiedAtFiles=%s, endOfOptionsDelimiter=%s, limitSplit=%s, aritySatisfiedByAttachedOptionParam=%s, toggleBooleanFlags=%s, unmatchedOptionsArePositionalParams=%s, collectErrors=%s,caseInsensitiveEnumValuesAllowed=%s, trimQuotes=%s, splitQuotedStrings=%s", this.posixClusteredShortOptionsAllowed, this.stopAtPositional, this.stopAtUnmatched, this.separator, this.overwrittenOptionsAllowed, this.unmatchedArgumentsAllowed, this.expandAtFiles, this.atFileCommentChar, this.useSimplifiedAtFiles, this.endOfOptionsDelimiter, this.limitSplit, this.aritySatisfiedByAttachedOptionParam, this.toggleBooleanFlags, this.unmatchedOptionsArePositionalParams, this.collectErrors, this.caseInsensitiveEnumValuesAllowed, this.trimQuotes, this.splitQuotedStrings);
            }

            void initFrom(ParserSpec settings) {
                this.separator = settings.separator;
                this.stopAtUnmatched = settings.stopAtUnmatched;
                this.stopAtPositional = settings.stopAtPositional;
                this.endOfOptionsDelimiter = settings.endOfOptionsDelimiter;
                this.toggleBooleanFlags = settings.toggleBooleanFlags;
                this.overwrittenOptionsAllowed = settings.overwrittenOptionsAllowed;
                this.unmatchedArgumentsAllowed = settings.unmatchedArgumentsAllowed;
                this.expandAtFiles = settings.expandAtFiles;
                this.atFileCommentChar = settings.atFileCommentChar;
                this.posixClusteredShortOptionsAllowed = settings.posixClusteredShortOptionsAllowed;
                this.unmatchedOptionsArePositionalParams = settings.unmatchedOptionsArePositionalParams;
                this.limitSplit = settings.limitSplit;
                this.aritySatisfiedByAttachedOptionParam = settings.aritySatisfiedByAttachedOptionParam;
                this.collectErrors = settings.collectErrors;
                this.caseInsensitiveEnumValuesAllowed = settings.caseInsensitiveEnumValuesAllowed;
                this.trimQuotes = settings.trimQuotes;
                this.splitQuotedStrings = settings.splitQuotedStrings;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class UsageMessageSpec {
            public static final String SECTION_KEY_HEADER_HEADING = "headerHeading";
            public static final String SECTION_KEY_HEADER = "header";
            public static final String SECTION_KEY_SYNOPSIS_HEADING = "synopsisHeading";
            public static final String SECTION_KEY_SYNOPSIS = "synopsis";
            public static final String SECTION_KEY_DESCRIPTION_HEADING = "descriptionHeading";
            public static final String SECTION_KEY_DESCRIPTION = "description";
            public static final String SECTION_KEY_PARAMETER_LIST_HEADING = "parameterListHeading";
            public static final String SECTION_KEY_PARAMETER_LIST = "parameterList";
            public static final String SECTION_KEY_OPTION_LIST_HEADING = "optionListHeading";
            public static final String SECTION_KEY_OPTION_LIST = "optionList";
            public static final String SECTION_KEY_COMMAND_LIST_HEADING = "commandListHeading";
            public static final String SECTION_KEY_COMMAND_LIST = "commandList";
            public static final String SECTION_KEY_FOOTER_HEADING = "footerHeading";
            public static final String SECTION_KEY_FOOTER = "footer";
            public static final int DEFAULT_USAGE_WIDTH = 80;
            private static final int MINIMUM_USAGE_WIDTH = 55;
            static final String DEFAULT_SYNOPSIS_HEADING = "Usage: ";
            static final String DEFAULT_COMMAND_LIST_HEADING = "Commands:%n";
            static final char DEFAULT_REQUIRED_OPTION_MARKER = ' ';
            static final Boolean DEFAULT_ABBREVIATE_SYNOPSIS = Boolean.FALSE;
            static final Boolean DEFAULT_SORT_OPTIONS = Boolean.TRUE;
            static final Boolean DEFAULT_SHOW_DEFAULT_VALUES = Boolean.FALSE;
            static final Boolean DEFAULT_HIDDEN = Boolean.FALSE;
            static final String DEFAULT_SINGLE_VALUE = "";
            static final String[] DEFAULT_MULTI_LINE = new String[0];
            private IHelpFactory helpFactory;
            private List<String> sectionKeys = Collections.unmodifiableList(Arrays.asList("headerHeading", "header", "synopsisHeading", "synopsis", "descriptionHeading", "description", "parameterListHeading", "parameterList", "optionListHeading", "optionList", "commandListHeading", "commandList", "footerHeading", "footer"));
            private Map<String, IHelpSectionRenderer> helpSectionRendererMap = this.createHelpSectionRendererMap();
            private String[] description;
            private String[] customSynopsis;
            private String[] header;
            private String[] footer;
            private Boolean abbreviateSynopsis;
            private Boolean sortOptions;
            private Boolean showDefaultValues;
            private Boolean hidden;
            private Character requiredOptionMarker;
            private String headerHeading;
            private String synopsisHeading;
            private String descriptionHeading;
            private String parameterListHeading;
            private String optionListHeading;
            private String commandListHeading;
            private String footerHeading;
            private int width = 80;
            private Messages messages;

            public UsageMessageSpec width(int newValue) {
                if (newValue < 55) {
                    throw new InitializationException("Invalid usage message width " + newValue + ". Minimum value is " + 55);
                }
                this.width = newValue;
                return this;
            }

            private static int getSysPropertyWidthOrDefault(int defaultWidth) {
                String userValue = System.getProperty("picocli.usage.width");
                if (userValue == null) {
                    return defaultWidth;
                }
                try {
                    int width = Integer.parseInt(userValue);
                    if (width < 55) {
                        new Tracer().warn("Invalid picocli.usage.width value %d. Using minimum usage width %d.%n", width, 55);
                        return 55;
                    }
                    return width;
                }
                catch (NumberFormatException ex) {
                    new Tracer().warn("Invalid picocli.usage.width value '%s'. Using usage width %d.%n", userValue, defaultWidth);
                    return defaultWidth;
                }
            }

            public int width() {
                return UsageMessageSpec.getSysPropertyWidthOrDefault(this.width);
            }

            private Map<String, IHelpSectionRenderer> createHelpSectionRendererMap() {
                HashMap<String, IHelpSectionRenderer> result = new HashMap<String, IHelpSectionRenderer>();
                result.put(SECTION_KEY_HEADER_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.headerHeading(new Object[0]);
                    }
                });
                result.put(SECTION_KEY_HEADER, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.header(new Object[0]);
                    }
                });
                result.put(SECTION_KEY_SYNOPSIS_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.synopsisHeading(new Object[0]);
                    }
                });
                result.put(SECTION_KEY_SYNOPSIS, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.synopsis(help.synopsisHeadingLength());
                    }
                });
                result.put(SECTION_KEY_DESCRIPTION_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.descriptionHeading(new Object[0]);
                    }
                });
                result.put(SECTION_KEY_DESCRIPTION, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.description(new Object[0]);
                    }
                });
                result.put(SECTION_KEY_PARAMETER_LIST_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.parameterListHeading(new Object[0]);
                    }
                });
                result.put(SECTION_KEY_PARAMETER_LIST, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.parameterList();
                    }
                });
                result.put(SECTION_KEY_OPTION_LIST_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.optionListHeading(new Object[0]);
                    }
                });
                result.put(SECTION_KEY_OPTION_LIST, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.optionList();
                    }
                });
                result.put(SECTION_KEY_COMMAND_LIST_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.commandListHeading(new Object[0]);
                    }
                });
                result.put(SECTION_KEY_COMMAND_LIST, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.commandList();
                    }
                });
                result.put(SECTION_KEY_FOOTER_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.footerHeading(new Object[0]);
                    }
                });
                result.put(SECTION_KEY_FOOTER, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.footer(new Object[0]);
                    }
                });
                return result;
            }

            public List<String> sectionKeys() {
                return this.sectionKeys;
            }

            public UsageMessageSpec sectionKeys(List<String> keys2) {
                this.sectionKeys = Collections.unmodifiableList(new ArrayList<String>(keys2));
                return this;
            }

            public Map<String, IHelpSectionRenderer> sectionMap() {
                return this.helpSectionRendererMap;
            }

            public UsageMessageSpec sectionMap(Map<String, IHelpSectionRenderer> map) {
                this.helpSectionRendererMap = new HashMap<String, IHelpSectionRenderer>(map);
                return this;
            }

            public IHelpFactory helpFactory() {
                if (this.helpFactory == null) {
                    this.helpFactory = new DefaultHelpFactory();
                }
                return this.helpFactory;
            }

            public UsageMessageSpec helpFactory(IHelpFactory helpFactory) {
                this.helpFactory = Assert.notNull(helpFactory, "helpFactory");
                return this;
            }

            private String str(String localized, String value, String defaultValue) {
                return localized != null ? localized : (value != null ? value : defaultValue);
            }

            private String[] arr(String[] localized, String[] value, String[] defaultValue) {
                return localized != null ? localized : (value != null ? (String[])value.clone() : defaultValue);
            }

            private String resourceStr(String key) {
                return this.messages == null ? null : this.messages.getString(key, null);
            }

            private String[] resourceArr(String key) {
                return this.messages == null ? null : this.messages.getStringArray(key, null);
            }

            public String headerHeading() {
                return this.str(this.resourceStr("usage.headerHeading"), this.headerHeading, DEFAULT_SINGLE_VALUE);
            }

            public String[] header() {
                return this.arr(this.resourceArr("usage.header"), this.header, DEFAULT_MULTI_LINE);
            }

            public String synopsisHeading() {
                return this.str(this.resourceStr("usage.synopsisHeading"), this.synopsisHeading, DEFAULT_SYNOPSIS_HEADING);
            }

            public boolean abbreviateSynopsis() {
                return this.abbreviateSynopsis == null ? DEFAULT_ABBREVIATE_SYNOPSIS : this.abbreviateSynopsis;
            }

            public String[] customSynopsis() {
                return this.arr(this.resourceArr("usage.customSynopsis"), this.customSynopsis, DEFAULT_MULTI_LINE);
            }

            public String descriptionHeading() {
                return this.str(this.resourceStr("usage.descriptionHeading"), this.descriptionHeading, DEFAULT_SINGLE_VALUE);
            }

            public String[] description() {
                return this.arr(this.resourceArr("usage.description"), this.description, DEFAULT_MULTI_LINE);
            }

            public String parameterListHeading() {
                return this.str(this.resourceStr("usage.parameterListHeading"), this.parameterListHeading, DEFAULT_SINGLE_VALUE);
            }

            public String optionListHeading() {
                return this.str(this.resourceStr("usage.optionListHeading"), this.optionListHeading, DEFAULT_SINGLE_VALUE);
            }

            public boolean sortOptions() {
                return this.sortOptions == null ? DEFAULT_SORT_OPTIONS : this.sortOptions;
            }

            public char requiredOptionMarker() {
                return this.requiredOptionMarker == null ? (char)' ' : this.requiredOptionMarker.charValue();
            }

            public boolean showDefaultValues() {
                return this.showDefaultValues == null ? DEFAULT_SHOW_DEFAULT_VALUES : this.showDefaultValues;
            }

            public boolean hidden() {
                return this.hidden == null ? DEFAULT_HIDDEN : this.hidden;
            }

            public String commandListHeading() {
                return this.str(this.resourceStr("usage.commandListHeading"), this.commandListHeading, DEFAULT_COMMAND_LIST_HEADING);
            }

            public String footerHeading() {
                return this.str(this.resourceStr("usage.footerHeading"), this.footerHeading, DEFAULT_SINGLE_VALUE);
            }

            public String[] footer() {
                return this.arr(this.resourceArr("usage.footer"), this.footer, DEFAULT_MULTI_LINE);
            }

            public UsageMessageSpec headerHeading(String headerHeading) {
                this.headerHeading = headerHeading;
                return this;
            }

            public UsageMessageSpec header(String ... header) {
                this.header = header;
                return this;
            }

            public UsageMessageSpec synopsisHeading(String newValue) {
                this.synopsisHeading = newValue;
                return this;
            }

            public UsageMessageSpec abbreviateSynopsis(boolean newValue) {
                this.abbreviateSynopsis = newValue;
                return this;
            }

            public UsageMessageSpec customSynopsis(String ... customSynopsis) {
                this.customSynopsis = customSynopsis;
                return this;
            }

            public UsageMessageSpec descriptionHeading(String newValue) {
                this.descriptionHeading = newValue;
                return this;
            }

            public UsageMessageSpec description(String ... description) {
                this.description = description;
                return this;
            }

            public UsageMessageSpec parameterListHeading(String newValue) {
                this.parameterListHeading = newValue;
                return this;
            }

            public UsageMessageSpec optionListHeading(String newValue) {
                this.optionListHeading = newValue;
                return this;
            }

            public UsageMessageSpec sortOptions(boolean newValue) {
                this.sortOptions = newValue;
                return this;
            }

            public UsageMessageSpec requiredOptionMarker(char newValue) {
                this.requiredOptionMarker = Character.valueOf(newValue);
                return this;
            }

            public UsageMessageSpec showDefaultValues(boolean newValue) {
                this.showDefaultValues = newValue;
                return this;
            }

            public UsageMessageSpec hidden(boolean value) {
                this.hidden = value;
                return this;
            }

            public UsageMessageSpec commandListHeading(String newValue) {
                this.commandListHeading = newValue;
                return this;
            }

            public UsageMessageSpec footerHeading(String newValue) {
                this.footerHeading = newValue;
                return this;
            }

            public UsageMessageSpec footer(String ... footer) {
                this.footer = footer;
                return this;
            }

            public Messages messages() {
                return this.messages;
            }

            public UsageMessageSpec messages(Messages msgs) {
                this.messages = msgs;
                return this;
            }

            void updateFromCommand(Command cmd, CommandSpec commandSpec) {
                ResourceBundle rb;
                if (Model.isNonDefault(cmd.synopsisHeading(), DEFAULT_SYNOPSIS_HEADING)) {
                    this.synopsisHeading = cmd.synopsisHeading();
                }
                if (Model.isNonDefault(cmd.commandListHeading(), DEFAULT_COMMAND_LIST_HEADING)) {
                    this.commandListHeading = cmd.commandListHeading();
                }
                if (Model.isNonDefault(Character.valueOf(cmd.requiredOptionMarker()), Character.valueOf(' '))) {
                    this.requiredOptionMarker = Character.valueOf(cmd.requiredOptionMarker());
                }
                if (Model.isNonDefault(cmd.abbreviateSynopsis(), UsageMessageSpec.DEFAULT_ABBREVIATE_SYNOPSIS)) {
                    this.abbreviateSynopsis = cmd.abbreviateSynopsis();
                }
                if (Model.isNonDefault(cmd.sortOptions(), UsageMessageSpec.DEFAULT_SORT_OPTIONS)) {
                    this.sortOptions = cmd.sortOptions();
                }
                if (Model.isNonDefault(cmd.showDefaultValues(), UsageMessageSpec.DEFAULT_SHOW_DEFAULT_VALUES)) {
                    this.showDefaultValues = cmd.showDefaultValues();
                }
                if (Model.isNonDefault(cmd.hidden(), UsageMessageSpec.DEFAULT_HIDDEN)) {
                    this.hidden = cmd.hidden();
                }
                if (Model.isNonDefault(cmd.customSynopsis(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.customSynopsis = (String[])cmd.customSynopsis().clone();
                }
                if (Model.isNonDefault(cmd.description(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.description = (String[])cmd.description().clone();
                }
                if (Model.isNonDefault(cmd.descriptionHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.descriptionHeading = cmd.descriptionHeading();
                }
                if (Model.isNonDefault(cmd.header(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.header = (String[])cmd.header().clone();
                }
                if (Model.isNonDefault(cmd.headerHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.headerHeading = cmd.headerHeading();
                }
                if (Model.isNonDefault(cmd.footer(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.footer = (String[])cmd.footer().clone();
                }
                if (Model.isNonDefault(cmd.footerHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.footerHeading = cmd.footerHeading();
                }
                if (Model.isNonDefault(cmd.parameterListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.parameterListHeading = cmd.parameterListHeading();
                }
                if (Model.isNonDefault(cmd.optionListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.optionListHeading = cmd.optionListHeading();
                }
                if (Model.isNonDefault(cmd.usageHelpWidth(), 80)) {
                    this.width(cmd.usageHelpWidth());
                }
                ResourceBundle resourceBundle = rb = CommandLine.empty(cmd.resourceBundle()) ? null : ResourceBundle.getBundle(cmd.resourceBundle());
                if (rb != null) {
                    this.messages(new Messages(commandSpec, rb));
                }
            }

            void initFromMixin(UsageMessageSpec mixin, CommandSpec commandSpec) {
                if (Model.initializable(this.synopsisHeading, mixin.synopsisHeading(), DEFAULT_SYNOPSIS_HEADING)) {
                    this.synopsisHeading = mixin.synopsisHeading();
                }
                if (Model.initializable(this.commandListHeading, mixin.commandListHeading(), DEFAULT_COMMAND_LIST_HEADING)) {
                    this.commandListHeading = mixin.commandListHeading();
                }
                if (Model.initializable(this.requiredOptionMarker, Character.valueOf(mixin.requiredOptionMarker()), Character.valueOf(' '))) {
                    this.requiredOptionMarker = Character.valueOf(mixin.requiredOptionMarker());
                }
                if (Model.initializable(this.abbreviateSynopsis, mixin.abbreviateSynopsis(), UsageMessageSpec.DEFAULT_ABBREVIATE_SYNOPSIS)) {
                    this.abbreviateSynopsis = mixin.abbreviateSynopsis();
                }
                if (Model.initializable(this.sortOptions, mixin.sortOptions(), UsageMessageSpec.DEFAULT_SORT_OPTIONS)) {
                    this.sortOptions = mixin.sortOptions();
                }
                if (Model.initializable(this.showDefaultValues, mixin.showDefaultValues(), UsageMessageSpec.DEFAULT_SHOW_DEFAULT_VALUES)) {
                    this.showDefaultValues = mixin.showDefaultValues();
                }
                if (Model.initializable(this.hidden, mixin.hidden(), UsageMessageSpec.DEFAULT_HIDDEN)) {
                    this.hidden = mixin.hidden();
                }
                if (Model.initializable(this.customSynopsis, mixin.customSynopsis(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.customSynopsis = (String[])mixin.customSynopsis().clone();
                }
                if (Model.initializable(this.description, mixin.description(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.description = (String[])mixin.description().clone();
                }
                if (Model.initializable(this.descriptionHeading, mixin.descriptionHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.descriptionHeading = mixin.descriptionHeading();
                }
                if (Model.initializable(this.header, mixin.header(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.header = (String[])mixin.header().clone();
                }
                if (Model.initializable(this.headerHeading, mixin.headerHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.headerHeading = mixin.headerHeading();
                }
                if (Model.initializable(this.footer, mixin.footer(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.footer = (String[])mixin.footer().clone();
                }
                if (Model.initializable(this.footerHeading, mixin.footerHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.footerHeading = mixin.footerHeading();
                }
                if (Model.initializable(this.parameterListHeading, mixin.parameterListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.parameterListHeading = mixin.parameterListHeading();
                }
                if (Model.initializable(this.optionListHeading, mixin.optionListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.optionListHeading = mixin.optionListHeading();
                }
                if (Messages.empty(this.messages)) {
                    this.messages(Messages.copy(commandSpec, mixin.messages()));
                }
            }

            void initFrom(UsageMessageSpec settings, CommandSpec commandSpec) {
                this.description = settings.description;
                this.customSynopsis = settings.customSynopsis;
                this.header = settings.header;
                this.footer = settings.footer;
                this.abbreviateSynopsis = settings.abbreviateSynopsis;
                this.sortOptions = settings.sortOptions;
                this.showDefaultValues = settings.showDefaultValues;
                this.hidden = settings.hidden;
                this.requiredOptionMarker = settings.requiredOptionMarker;
                this.headerHeading = settings.headerHeading;
                this.synopsisHeading = settings.synopsisHeading;
                this.descriptionHeading = settings.descriptionHeading;
                this.parameterListHeading = settings.parameterListHeading;
                this.optionListHeading = settings.optionListHeading;
                this.commandListHeading = settings.commandListHeading;
                this.footerHeading = settings.footerHeading;
                this.width = settings.width;
                this.messages = Messages.copy(commandSpec, settings.messages());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class CommandSpec {
            static final String DEFAULT_COMMAND_NAME = "<main class>";
            static final Boolean DEFAULT_IS_HELP_COMMAND = Boolean.FALSE;
            private final Map<String, CommandLine> commands = new LinkedHashMap<String, CommandLine>();
            private final Map<String, OptionSpec> optionsByNameMap = new LinkedHashMap<String, OptionSpec>();
            private final Map<Character, OptionSpec> posixOptionsByKeyMap = new LinkedHashMap<Character, OptionSpec>();
            private final Map<String, CommandSpec> mixins = new LinkedHashMap<String, CommandSpec>();
            private final List<ArgSpec> requiredArgs = new ArrayList<ArgSpec>();
            private final List<ArgSpec> args = new ArrayList<ArgSpec>();
            private final List<OptionSpec> options = new ArrayList<OptionSpec>();
            private final List<PositionalParamSpec> positionalParameters = new ArrayList<PositionalParamSpec>();
            private final List<UnmatchedArgsBinding> unmatchedArgs = new ArrayList<UnmatchedArgsBinding>();
            private final ParserSpec parser = new ParserSpec();
            private final UsageMessageSpec usageMessage = new UsageMessageSpec();
            private final Object userObject;
            private CommandLine commandLine;
            private CommandSpec parent;
            private String name;
            private Set<String> aliases = new LinkedHashSet<String>();
            private Boolean isHelpCommand;
            private IVersionProvider versionProvider;
            private IDefaultValueProvider defaultValueProvider;
            private String[] version;
            private String toString;

            private CommandSpec(Object userObject) {
                this.userObject = userObject;
            }

            public static CommandSpec create() {
                return CommandSpec.wrapWithoutInspection(null);
            }

            public static CommandSpec wrapWithoutInspection(Object userObject) {
                return new CommandSpec(userObject);
            }

            public static CommandSpec forAnnotatedObject(Object userObject) {
                return CommandSpec.forAnnotatedObject(userObject, new DefaultFactory());
            }

            public static CommandSpec forAnnotatedObject(Object userObject, IFactory factory) {
                return CommandReflection.extractCommandSpec(userObject, factory, true);
            }

            public static CommandSpec forAnnotatedObjectLenient(Object userObject) {
                return CommandSpec.forAnnotatedObjectLenient(userObject, new DefaultFactory());
            }

            public static CommandSpec forAnnotatedObjectLenient(Object userObject, IFactory factory) {
                return CommandReflection.extractCommandSpec(userObject, factory, false);
            }

            void validate() {
                Collections.sort(this.positionalParameters, new PositionalParametersSorter());
                CommandLine.validatePositionalParameters(this.positionalParameters);
                ArrayList<String> wrongUsageHelpAttr = new ArrayList<String>();
                ArrayList<String> wrongVersionHelpAttr = new ArrayList<String>();
                ArrayList<String> usageHelpAttr = new ArrayList<String>();
                ArrayList<String> versionHelpAttr = new ArrayList<String>();
                for (OptionSpec option : this.options()) {
                    if (option.usageHelp()) {
                        usageHelpAttr.add(option.longestName());
                        if (!CommandLine.isBoolean(option.type())) {
                            wrongUsageHelpAttr.add(option.longestName());
                        }
                    }
                    if (!option.versionHelp()) continue;
                    versionHelpAttr.add(option.longestName());
                    if (CommandLine.isBoolean(option.type())) continue;
                    wrongVersionHelpAttr.add(option.longestName());
                }
                String wrongType = "Non-boolean options like %s should not be marked as '%s=true'. Usually a command has one %s boolean flag that triggers display of the %s. Alternatively, consider using @Command(mixinStandardHelpOptions = true) on your command instead.";
                String multiple = "Multiple options %s are marked as '%s=true'. Usually a command has only one %s option that triggers display of the %s. Alternatively, consider using @Command(mixinStandardHelpOptions = true) on your command instead.%n";
                if (!wrongUsageHelpAttr.isEmpty()) {
                    throw new InitializationException(String.format(wrongType, wrongUsageHelpAttr, "usageHelp", "--help", "usage help message"));
                }
                if (!wrongVersionHelpAttr.isEmpty()) {
                    throw new InitializationException(String.format(wrongType, wrongVersionHelpAttr, "versionHelp", "--version", "version information"));
                }
                if (usageHelpAttr.size() > 1) {
                    new Tracer().warn(multiple, usageHelpAttr, "usageHelp", "--help", "usage help message");
                }
                if (versionHelpAttr.size() > 1) {
                    new Tracer().warn(multiple, versionHelpAttr, "versionHelp", "--version", "version information");
                }
            }

            public Object userObject() {
                return this.userObject;
            }

            public CommandLine commandLine() {
                return this.commandLine;
            }

            protected CommandSpec commandLine(CommandLine commandLine) {
                this.commandLine = commandLine;
                for (CommandSpec mixedInSpec : this.mixins.values()) {
                    mixedInSpec.commandLine(commandLine);
                }
                for (CommandLine sub : this.commands.values()) {
                    sub.getCommandSpec().parent(this);
                }
                return this;
            }

            public ParserSpec parser() {
                return this.parser;
            }

            public CommandSpec parser(ParserSpec settings) {
                this.parser.initFrom(settings);
                return this;
            }

            public UsageMessageSpec usageMessage() {
                return this.usageMessage;
            }

            public CommandSpec usageMessage(UsageMessageSpec settings) {
                this.usageMessage.initFrom(settings, this);
                return this;
            }

            public ResourceBundle resourceBundle() {
                return Messages.resourceBundle(this.usageMessage.messages());
            }

            public CommandSpec resourceBundle(ResourceBundle bundle) {
                this.usageMessage().messages(new Messages(this, bundle));
                this.updateArgSpecMessages();
                return this;
            }

            private void updateArgSpecMessages() {
                for (OptionSpec opt : this.options()) {
                    opt.messages(this.usageMessage().messages());
                }
                for (PositionalParamSpec pos : this.positionalParameters()) {
                    pos.messages(this.usageMessage().messages());
                }
            }

            public Map<String, CommandLine> subcommands() {
                return Collections.unmodifiableMap(this.commands);
            }

            public CommandSpec addSubcommand(String name, CommandSpec subcommand) {
                return this.addSubcommand(name, new CommandLine(subcommand));
            }

            public CommandSpec addSubcommand(String name, CommandLine subCommandLine) {
                CommandLine previous;
                Tracer t = new Tracer();
                if (t.isDebug()) {
                    t.debug("Adding subcommand '%s' to '%s'%n", name, this.qualifiedName());
                }
                if ((previous = this.commands.put(name, subCommandLine)) != null && previous != subCommandLine) {
                    throw new InitializationException("Another subcommand named '" + name + "' already exists for command '" + this.name() + "'");
                }
                CommandSpec subSpec = subCommandLine.getCommandSpec();
                if (subSpec.name == null) {
                    subSpec.name(name);
                }
                subSpec.parent(this);
                for (String alias : subSpec.aliases()) {
                    if (t.isDebug()) {
                        t.debug("Adding alias '%s' for subcommand '%s' to '%s'%n", alias, name, this.qualifiedName());
                    }
                    if ((previous = this.commands.put(alias, subCommandLine)) == null || previous == subCommandLine) continue;
                    throw new InitializationException("Alias '" + alias + "' for subcommand '" + name + "' is already used by another subcommand of '" + this.name() + "'");
                }
                subSpec.initResourceBundle(this.resourceBundle());
                return this;
            }

            private void initResourceBundle(ResourceBundle bundle) {
                if (this.resourceBundle() == null) {
                    this.resourceBundle(bundle);
                }
                for (CommandLine sub : this.commands.values()) {
                    sub.getCommandSpec().initResourceBundle(this.resourceBundle());
                }
            }

            public CommandSpec addMethodSubcommands() {
                return this.addMethodSubcommands(new DefaultFactory());
            }

            public CommandSpec addMethodSubcommands(IFactory factory) {
                if (this.userObject instanceof Method) {
                    throw new InitializationException("Cannot discover subcommand methods of this Command Method: " + this.userObject());
                }
                for (CommandLine sub : CommandSpec.createMethodSubcommands(this.userObject().getClass(), factory)) {
                    this.addSubcommand(sub.getCommandName(), sub);
                }
                return this;
            }

            static List<CommandLine> createMethodSubcommands(Class<?> cls, IFactory factory) {
                ArrayList<CommandLine> result = new ArrayList<CommandLine>();
                for (Method method : CommandLine.getCommandMethods(cls, null)) {
                    result.add(new CommandLine(method, factory));
                }
                return result;
            }

            public CommandSpec parent() {
                return this.parent;
            }

            public CommandSpec parent(CommandSpec parent) {
                this.parent = parent;
                return this;
            }

            public CommandSpec add(ArgSpec arg) {
                return arg.isOption() ? this.addOption((OptionSpec)arg) : this.addPositional((PositionalParamSpec)arg);
            }

            public CommandSpec addOption(OptionSpec option) {
                this.args.add(option);
                this.options.add(option);
                for (String name : option.names()) {
                    OptionSpec existing = this.optionsByNameMap.put(name, option);
                    if (existing != null && !existing.equals(option)) {
                        throw DuplicateOptionAnnotationsException.create(name, option, existing);
                    }
                    if (name.length() != 2 || !name.startsWith("-")) continue;
                    this.posixOptionsByKeyMap.put(Character.valueOf(name.charAt(1)), option);
                }
                if (option.required()) {
                    this.requiredArgs.add(option);
                }
                option.messages(this.usageMessage().messages());
                option.commandSpec = this;
                return this;
            }

            public CommandSpec addPositional(PositionalParamSpec positional) {
                this.args.add(positional);
                this.positionalParameters.add(positional);
                if (positional.required()) {
                    this.requiredArgs.add(positional);
                }
                positional.messages(this.usageMessage().messages());
                positional.commandSpec = this;
                return this;
            }

            public CommandSpec addMixin(String name, CommandSpec mixin) {
                this.mixins.put(name, mixin);
                this.parser.initSeparator(mixin.parser.separator());
                this.initName(mixin.name());
                this.initVersion(mixin.version());
                this.initHelpCommand(mixin.helpCommand());
                this.initVersionProvider(mixin.versionProvider());
                this.initDefaultValueProvider(mixin.defaultValueProvider());
                this.usageMessage.initFromMixin(mixin.usageMessage, this);
                for (Map.Entry<String, CommandLine> entry : mixin.subcommands().entrySet()) {
                    this.addSubcommand(entry.getKey(), entry.getValue());
                }
                for (OptionSpec optionSpec : mixin.options()) {
                    this.addOption(optionSpec);
                }
                for (PositionalParamSpec paramSpec : mixin.positionalParameters()) {
                    this.addPositional(paramSpec);
                }
                return this;
            }

            public CommandSpec addUnmatchedArgsBinding(UnmatchedArgsBinding spec) {
                this.unmatchedArgs.add(spec);
                this.parser().unmatchedArgumentsAllowed(true);
                return this;
            }

            public Map<String, CommandSpec> mixins() {
                return Collections.unmodifiableMap(this.mixins);
            }

            public List<OptionSpec> options() {
                return Collections.unmodifiableList(this.options);
            }

            public List<PositionalParamSpec> positionalParameters() {
                return Collections.unmodifiableList(this.positionalParameters);
            }

            public Map<String, OptionSpec> optionsMap() {
                return Collections.unmodifiableMap(this.optionsByNameMap);
            }

            public Map<Character, OptionSpec> posixOptionsMap() {
                return Collections.unmodifiableMap(this.posixOptionsByKeyMap);
            }

            public List<ArgSpec> requiredArgs() {
                return Collections.unmodifiableList(this.requiredArgs);
            }

            public List<UnmatchedArgsBinding> unmatchedArgsBindings() {
                return Collections.unmodifiableList(this.unmatchedArgs);
            }

            public String name() {
                return this.name == null ? DEFAULT_COMMAND_NAME : this.name;
            }

            public String[] aliases() {
                return this.aliases.toArray(new String[0]);
            }

            public Set<String> names() {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                result.add(this.name());
                result.addAll(Arrays.asList(this.aliases()));
                return result;
            }

            public List<ArgSpec> args() {
                return Collections.unmodifiableList(this.args);
            }

            Object[] argValues() {
                IdentityHashMap allMixins = null;
                int argsLength = this.args.size();
                int shift = 0;
                for (Map.Entry<String, CommandSpec> mixinEntry : this.mixins.entrySet()) {
                    if (mixinEntry.getKey().equals("mixinStandardHelpOptions")) {
                        shift = 2;
                        argsLength -= shift;
                        continue;
                    }
                    CommandSpec mixin = mixinEntry.getValue();
                    int mixinArgs = mixin.args.size();
                    argsLength -= mixinArgs - 1;
                    if (allMixins == null) {
                        allMixins = new IdentityHashMap(this.mixins.size());
                    }
                    allMixins.put(mixin.userObject.getClass(), mixin);
                }
                Object[] values = new Object[argsLength];
                if (allMixins == null) {
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = this.args.get(i + shift).getValue();
                    }
                } else {
                    int argIndex = shift;
                    Class<?>[] methodParams = ((Method)this.userObject).getParameterTypes();
                    for (int i = 0; i < methodParams.length; ++i) {
                        Class<?> param = methodParams[i];
                        CommandSpec mixin = (CommandSpec)allMixins.remove(param);
                        if (mixin == null) {
                            values[i] = this.args.get(argIndex++).getValue();
                            continue;
                        }
                        values[i] = mixin.userObject;
                        argIndex += mixin.args.size();
                    }
                }
                return values;
            }

            public String qualifiedName() {
                return this.qualifiedName(" ");
            }

            public String qualifiedName(String separator) {
                String result = this.name();
                if (this.parent() != null) {
                    result = this.parent().qualifiedName(separator) + separator + result;
                }
                return result;
            }

            public String[] version() {
                if (this.versionProvider != null) {
                    try {
                        return this.versionProvider.getVersion();
                    }
                    catch (Exception ex) {
                        String msg = "Could not get version info from " + this.versionProvider + ": " + ex;
                        throw new ExecutionException(this.commandLine, msg, ex);
                    }
                }
                return this.version == null ? UsageMessageSpec.DEFAULT_MULTI_LINE : this.version;
            }

            public IVersionProvider versionProvider() {
                return this.versionProvider;
            }

            public boolean helpCommand() {
                return this.isHelpCommand == null ? DEFAULT_IS_HELP_COMMAND : this.isHelpCommand;
            }

            public boolean mixinStandardHelpOptions() {
                return this.mixins.containsKey("mixinStandardHelpOptions");
            }

            public String toString() {
                return this.toString;
            }

            public CommandSpec name(String name) {
                this.name = name;
                return this;
            }

            public CommandSpec aliases(String ... aliases) {
                this.aliases = new LinkedHashSet<String>(Arrays.asList(aliases == null ? new String[]{} : aliases));
                return this;
            }

            public IDefaultValueProvider defaultValueProvider() {
                return this.defaultValueProvider;
            }

            public CommandSpec defaultValueProvider(IDefaultValueProvider defaultValueProvider) {
                this.defaultValueProvider = defaultValueProvider;
                return this;
            }

            public CommandSpec version(String ... version) {
                this.version = version;
                return this;
            }

            public CommandSpec versionProvider(IVersionProvider versionProvider) {
                this.versionProvider = versionProvider;
                return this;
            }

            public CommandSpec helpCommand(boolean newValue) {
                this.isHelpCommand = newValue;
                return this;
            }

            public CommandSpec mixinStandardHelpOptions(boolean newValue) {
                if (newValue) {
                    CommandSpec mixin = CommandSpec.forAnnotatedObject(new AutoHelpMixin(), new DefaultFactory());
                    this.addMixin("mixinStandardHelpOptions", mixin);
                } else {
                    CommandSpec helpMixin = this.mixins.remove("mixinStandardHelpOptions");
                    if (helpMixin != null) {
                        this.options.removeAll(helpMixin.options);
                        for (OptionSpec option : helpMixin.options()) {
                            for (String name : option.names) {
                                this.optionsByNameMap.remove(name);
                                if (name.length() != 2 || !name.startsWith("-")) continue;
                                this.posixOptionsByKeyMap.remove(Character.valueOf(name.charAt(1)));
                            }
                        }
                    }
                }
                return this;
            }

            public CommandSpec withToString(String newValue) {
                this.toString = newValue;
                return this;
            }

            void initName(String value) {
                if (Model.initializable(this.name, value, DEFAULT_COMMAND_NAME)) {
                    this.name = value;
                }
            }

            void initHelpCommand(boolean value) {
                if (Model.initializable(this.isHelpCommand, value, CommandSpec.DEFAULT_IS_HELP_COMMAND)) {
                    this.isHelpCommand = value;
                }
            }

            void initVersion(String[] value) {
                if (Model.initializable(this.version, value, UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.version = (String[])value.clone();
                }
            }

            void initVersionProvider(IVersionProvider value) {
                if (this.versionProvider == null) {
                    this.versionProvider = value;
                }
            }

            void initDefaultValueProvider(IDefaultValueProvider value) {
                if (this.defaultValueProvider == null) {
                    this.defaultValueProvider = value;
                }
            }

            void initDefaultValueProvider(Class<? extends IDefaultValueProvider> value, IFactory factory) {
                if (Model.initializable(this.defaultValueProvider, value, NoDefaultProvider.class)) {
                    this.defaultValueProvider = DefaultFactory.createDefaultValueProvider(factory, value);
                }
            }

            void updateName(String value) {
                if (Model.isNonDefault(value, DEFAULT_COMMAND_NAME)) {
                    this.name = value;
                }
            }

            void updateHelpCommand(boolean value) {
                if (Model.isNonDefault(value, CommandSpec.DEFAULT_IS_HELP_COMMAND)) {
                    this.isHelpCommand = value;
                }
            }

            void updateVersion(String[] value) {
                if (Model.isNonDefault(value, UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.version = (String[])value.clone();
                }
            }

            void updateVersionProvider(Class<? extends IVersionProvider> value, IFactory factory) {
                if (Model.isNonDefault(value, NoVersionProvider.class)) {
                    this.versionProvider = DefaultFactory.createVersionProvider(factory, value);
                }
            }

            public OptionSpec findOption(char shortName) {
                return CommandSpec.findOption(shortName, this.options());
            }

            public OptionSpec findOption(String name) {
                return CommandSpec.findOption(name, this.options());
            }

            static OptionSpec findOption(char shortName, Iterable<OptionSpec> options) {
                for (OptionSpec option : options) {
                    for (String name : option.names()) {
                        if (name.length() == 2 && name.charAt(0) == '-' && name.charAt(1) == shortName) {
                            return option;
                        }
                        if (name.length() != 1 || name.charAt(0) != shortName) continue;
                        return option;
                    }
                }
                return null;
            }

            static OptionSpec findOption(String name, List<OptionSpec> options) {
                for (OptionSpec option : options) {
                    for (String prefixed : option.names()) {
                        if (!prefixed.equals(name) && !CommandSpec.stripPrefix(prefixed).equals(name)) continue;
                        return option;
                    }
                }
                return null;
            }

            static String stripPrefix(String prefixed) {
                for (int i = 0; i < prefixed.length(); ++i) {
                    if (!Character.isJavaIdentifierPart(prefixed.charAt(i))) continue;
                    return prefixed.substring(i);
                }
                return prefixed;
            }

            List<String> findOptionNamesWithPrefix(String prefix) {
                ArrayList<String> result = new ArrayList<String>();
                for (OptionSpec option : this.options()) {
                    for (String name : option.names()) {
                        if (!CommandSpec.stripPrefix(name).startsWith(prefix)) continue;
                        result.add(name);
                    }
                }
                return result;
            }

            boolean resemblesOption(String arg, Tracer tracer) {
                boolean result;
                if (this.parser().unmatchedOptionsArePositionalParams()) {
                    if (tracer != null && tracer.isDebug()) {
                        tracer.debug("Parser is configured to treat all unmatched options as positional parameter%n", arg);
                    }
                    return false;
                }
                if (arg.length() == 1) {
                    if (tracer != null && tracer.isDebug()) {
                        tracer.debug("Single-character arguments that don't match known options are considered positional parameters%n", arg);
                    }
                    return false;
                }
                if (this.options().isEmpty()) {
                    boolean result2 = arg.startsWith("-");
                    if (tracer != null && tracer.isDebug()) {
                        tracer.debug("'%s' %s an option%n", arg, result2 ? "resembles" : "doesn't resemble");
                    }
                    return result2;
                }
                int count = 0;
                for (String optionName : this.optionsMap().keySet()) {
                    for (int i = 0; i < arg.length() && optionName.length() > i && arg.charAt(i) == optionName.charAt(i); ++i) {
                        ++count;
                    }
                }
                boolean bl = result = count > 0 && count * 10 >= this.optionsMap().size() * 9;
                if (tracer != null && tracer.isDebug()) {
                    tracer.debug("'%s' %s an option: %d matching prefix chars out of %d option names%n", arg, result ? "resembles" : "doesn't resemble", count, this.optionsMap().size());
                }
                return result;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface ISetter {
            public <T> T set(T var1) throws Exception;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IGetter {
            public <T> T get() throws Exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Range
    implements Comparable<Range> {
        public final int min;
        public final int max;
        public final boolean isVariable;
        private final boolean isUnspecified;
        private final String originalValue;

        public Range(int min, int max, boolean variable, boolean unspecified, String originalValue) {
            if (min < 0 || max < 0) {
                throw new InitializationException("Invalid negative range (min=" + min + ", max=" + max + ")");
            }
            if (min > max) {
                throw new InitializationException("Invalid range (min=" + min + ", max=" + max + ")");
            }
            this.min = min;
            this.max = max;
            this.isVariable = variable;
            this.isUnspecified = unspecified;
            this.originalValue = originalValue;
        }

        public static Range optionArity(Field field) {
            return Range.optionArity(new Model.TypedMember(field));
        }

        private static Range optionArity(Model.TypedMember member) {
            return member.isAnnotationPresent(Option.class) ? Range.adjustForType(Range.valueOf(member.getAnnotation(Option.class).arity()), member) : new Range(0, 0, false, true, "0");
        }

        public static Range parameterArity(Field field) {
            return Range.parameterArity(new Model.TypedMember(field));
        }

        private static Range parameterArity(Model.TypedMember member) {
            if (member.isAnnotationPresent(Parameters.class)) {
                return Range.adjustForType(Range.valueOf(member.getAnnotation(Parameters.class).arity()), member);
            }
            return member.isMethodParameter() ? Range.adjustForType(Range.valueOf(""), member) : new Range(0, 0, false, true, "0");
        }

        public static Range parameterIndex(Field field) {
            return Range.parameterIndex(new Model.TypedMember(field));
        }

        private static Range parameterIndex(Model.TypedMember member) {
            if (member.isAnnotationPresent(Parameters.class)) {
                Range result = Range.valueOf(member.getAnnotation(Parameters.class).index());
                if (!result.isUnspecified) {
                    return result;
                }
            }
            if (member.isMethodParameter()) {
                int min = ((Model.MethodParam)member.accessible).position;
                int max = member.isMultiValue() ? Integer.MAX_VALUE : min;
                return new Range(min, max, member.isMultiValue(), false, "");
            }
            return Range.valueOf("*");
        }

        static Range adjustForType(Range result, Model.TypedMember member) {
            return result.isUnspecified ? Range.defaultArity(member) : result;
        }

        public static Range defaultArity(Field field) {
            return Range.defaultArity(new Model.TypedMember(field));
        }

        private static Range defaultArity(Model.TypedMember member) {
            Class<?> type = member.getType();
            if (member.isAnnotationPresent(Option.class)) {
                Class[] typeAttribute = Model.ArgsReflection.inferTypes(type, member.getAnnotation(Option.class).type(), member.getGenericType());
                boolean zeroArgs = CommandLine.isBoolean(type) || CommandLine.isMultiValue(type) && CommandLine.isBoolean(typeAttribute[0]);
                return zeroArgs ? Range.valueOf("0").unspecified(true) : Range.valueOf("1").unspecified(true);
            }
            if (CommandLine.isMultiValue(type)) {
                return Range.valueOf("0..1").unspecified(true);
            }
            return Range.valueOf("1").unspecified(true);
        }

        @Deprecated
        public static Range defaultArity(Class<?> type) {
            return CommandLine.isBoolean(type) ? Range.valueOf("0").unspecified(true) : Range.valueOf("1").unspecified(true);
        }

        private int size() {
            return 1 + this.max - this.min;
        }

        static Range parameterCapacity(Model.TypedMember member) {
            Range arity = Range.parameterArity(member);
            if (!member.isMultiValue()) {
                return arity;
            }
            Range index = Range.parameterIndex(member);
            return Range.parameterCapacity(arity, index);
        }

        private static Range parameterCapacity(Range arity, Range index) {
            if (arity.max == 0) {
                return arity;
            }
            if (index.size() == 1) {
                return arity;
            }
            if (index.isVariable) {
                return Range.valueOf(arity.min + "..*");
            }
            if (arity.size() == 1) {
                return Range.valueOf(arity.min * index.size() + "");
            }
            if (arity.isVariable) {
                return Range.valueOf(arity.min * index.size() + "..*");
            }
            return Range.valueOf(arity.min * index.size() + ".." + arity.max * index.size());
        }

        public static Range valueOf(String range) {
            boolean unspecified = (range = range.trim()).length() == 0 || range.startsWith("..");
            int min = -1;
            int max = -1;
            boolean variable = false;
            int dots = -1;
            dots = range.indexOf("..");
            if (dots >= 0) {
                min = Range.parseInt(range.substring(0, dots), 0);
                max = Range.parseInt(range.substring(dots + 2), Integer.MAX_VALUE);
                variable = max == Integer.MAX_VALUE;
            } else {
                max = Range.parseInt(range, Integer.MAX_VALUE);
                variable = max == Integer.MAX_VALUE;
                min = variable ? 0 : max;
            }
            Range result = new Range(min, max, variable, unspecified, range);
            return result;
        }

        private static int parseInt(String str, int defaultValue) {
            try {
                return Integer.parseInt(str);
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }

        public Range min(int newMin) {
            return new Range(newMin, Math.max(newMin, this.max), this.isVariable, this.isUnspecified, this.originalValue);
        }

        public Range max(int newMax) {
            return new Range(Math.min(this.min, newMax), newMax, this.isVariable, this.isUnspecified, this.originalValue);
        }

        public Range unspecified(boolean unspecified) {
            return new Range(this.min, this.max, this.isVariable, unspecified, this.originalValue);
        }

        public boolean contains(int value) {
            return this.min <= value && this.max >= value;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Range)) {
                return false;
            }
            Range other = (Range)object;
            return other.max == this.max && other.min == this.min && other.isVariable == this.isVariable;
        }

        public int hashCode() {
            return ((629 + this.max) * 37 + this.min) * 37 + (this.isVariable ? 1 : 0);
        }

        public String toString() {
            return this.min == this.max ? String.valueOf(this.min) : this.min + ".." + (this.isVariable ? "*" : Integer.valueOf(this.max));
        }

        @Override
        public int compareTo(Range other) {
            int result = this.min - other.min;
            return result == 0 ? this.max - other.max : result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultFactory
    implements IFactory {
        private DefaultFactory() {
        }

        public <T> T create(Class<T> cls) throws Exception {
            try {
                return cls.newInstance();
            }
            catch (Exception ex) {
                Constructor<T> constructor = cls.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
        }

        private static ITypeConverter<?>[] createConverter(IFactory factory, Class<? extends ITypeConverter<?>>[] classes) {
            ITypeConverter[] result = new ITypeConverter[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                result[i] = DefaultFactory.create(factory, classes[i]);
            }
            return result;
        }

        static IVersionProvider createVersionProvider(IFactory factory, Class<? extends IVersionProvider> cls) {
            return DefaultFactory.create(factory, cls);
        }

        static IDefaultValueProvider createDefaultValueProvider(IFactory factory, Class<? extends IDefaultValueProvider> cls) {
            return DefaultFactory.create(factory, cls);
        }

        static Iterable<String> createCompletionCandidates(IFactory factory, Class<? extends Iterable<String>> cls) {
            return DefaultFactory.create(factory, cls);
        }

        static <T> T create(IFactory factory, Class<T> cls) {
            try {
                return factory.create(cls);
            }
            catch (Exception ex) {
                throw new InitializationException("Could not instantiate " + cls + ": " + ex, ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IFactory {
        public <K> K create(Class<K> var1) throws Exception;
    }

    private static class DefaultHelpFactory
    implements IHelpFactory {
        private DefaultHelpFactory() {
        }

        public Help create(Model.CommandSpec commandSpec, Help.ColorScheme colorScheme) {
            return new Help(commandSpec, colorScheme);
        }
    }

    public static interface IHelpFactory {
        public Help create(Model.CommandSpec var1, Help.ColorScheme var2);
    }

    private static class NoDefaultProvider
    implements IDefaultValueProvider {
        private NoDefaultProvider() {
        }

        public String defaultValue(Model.ArgSpec argSpec) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface IDefaultValueProvider {
        public String defaultValue(Model.ArgSpec var1) throws Exception;
    }

    private static class NoVersionProvider
    implements IVersionProvider {
        private NoVersionProvider() {
        }

        public String[] getVersion() throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    public static interface IVersionProvider {
        public String[] getVersion() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ITypeConverter<K> {
        public K convert(String var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.LOCAL_VARIABLE, ElementType.FIELD, ElementType.PACKAGE, ElementType.METHOD})
    public static @interface Command {
        public String name() default "<main class>";

        public String[] aliases() default {};

        public Class<?>[] subcommands() default {};

        public boolean addMethodSubcommands() default true;

        public String separator() default "=";

        public String[] version() default {};

        public Class<? extends IVersionProvider> versionProvider() default NoVersionProvider.class;

        public boolean mixinStandardHelpOptions() default false;

        public boolean helpCommand() default false;

        public String headerHeading() default "";

        public String[] header() default {};

        public String synopsisHeading() default "Usage: ";

        public boolean abbreviateSynopsis() default false;

        public String[] customSynopsis() default {};

        public String descriptionHeading() default "";

        public String[] description() default {};

        public String parameterListHeading() default "";

        public String optionListHeading() default "";

        public boolean sortOptions() default true;

        public char requiredOptionMarker() default 32;

        public Class<? extends IDefaultValueProvider> defaultValueProvider() default NoDefaultProvider.class;

        public boolean showDefaultValues() default false;

        public String commandListHeading() default "Commands:%n";

        public String footerHeading() default "";

        public String[] footer() default {};

        public boolean hidden() default false;

        public String resourceBundle() default "";

        public int usageHelpWidth() default 80;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Spec {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER})
    public static @interface Mixin {
        public String name() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Unmatched {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ParentCommand {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface Parameters {
        public String index() default "";

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public boolean hideParamSyntax() default false;

        public Class<?>[] type() default {};

        public Class<? extends ITypeConverter<?>>[] converter() default {};

        public String split() default "";

        public boolean hidden() default false;

        public String defaultValue() default "__no_default_value__";

        public Help.Visibility showDefaultValue() default Help.Visibility.ON_DEMAND;

        public Class<? extends Iterable<String>> completionCandidates() default NoCompletionCandidates.class;

        public boolean interactive() default false;

        public String descriptionKey() default "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface Option {
        public String[] names();

        public boolean required() default false;

        @Deprecated
        public boolean help() default false;

        public boolean usageHelp() default false;

        public boolean versionHelp() default false;

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public boolean hideParamSyntax() default false;

        public Class<?>[] type() default {};

        public Class<? extends ITypeConverter<?>>[] converter() default {};

        public String split() default "";

        public boolean hidden() default false;

        public String defaultValue() default "__no_default_value__";

        public Help.Visibility showDefaultValue() default Help.Visibility.ON_DEMAND;

        public Class<? extends Iterable<String>> completionCandidates() default NoCompletionCandidates.class;

        public boolean interactive() default false;

        public String descriptionKey() default "";

        public int order() default -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoCompletionCandidates
    implements Iterable<String> {
        private NoCompletionCandidates() {
        }

        @Override
        public Iterator<String> iterator() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunAll
    extends AbstractParseResultHandler<List<Object>>
    implements IParseResultHandler {
        @Override
        public List<Object> handleParseResult(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(parsedCommands, out, this.err(), ansi)) {
                return this.returnResultOrExit(Collections.emptyList());
            }
            ArrayList result = new ArrayList();
            for (CommandLine parsed : parsedCommands) {
                CommandLine.execute(parsed, result);
            }
            return this.returnResultOrExit(result);
        }

        @Override
        protected List<Object> handle(ParseResult parseResult) throws ExecutionException {
            ArrayList result = new ArrayList();
            CommandLine.execute(parseResult.commandSpec().commandLine(), result);
            while (parseResult.hasSubcommand()) {
                parseResult = parseResult.subcommand();
                CommandLine.execute(parseResult.commandSpec().commandLine(), result);
            }
            return this.returnResultOrExit(result);
        }

        @Override
        protected RunAll self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunLast
    extends AbstractParseResultHandler<List<Object>>
    implements IParseResultHandler {
        @Override
        public List<Object> handleParseResult(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(parsedCommands, out, this.err(), ansi)) {
                return this.returnResultOrExit(Collections.emptyList());
            }
            return this.returnResultOrExit(CommandLine.execute(parsedCommands.get(parsedCommands.size() - 1), new ArrayList()));
        }

        @Override
        protected List<Object> handle(ParseResult parseResult) throws ExecutionException {
            List<CommandLine> parsedCommands = parseResult.asCommandLineList();
            return CommandLine.execute(parsedCommands.get(parsedCommands.size() - 1), new ArrayList());
        }

        @Override
        protected RunLast self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunFirst
    extends AbstractParseResultHandler<List<Object>>
    implements IParseResultHandler {
        @Override
        public List<Object> handleParseResult(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(parsedCommands, out, this.err(), ansi)) {
                return this.returnResultOrExit(Collections.emptyList());
            }
            return this.returnResultOrExit(CommandLine.execute(parsedCommands.get(0), new ArrayList()));
        }

        @Override
        protected List<Object> handle(ParseResult parseResult) throws ExecutionException {
            return CommandLine.execute(parseResult.commandSpec().commandLine(), new ArrayList());
        }

        @Override
        protected RunFirst self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractParseResultHandler<R>
    extends AbstractHandler<R, AbstractParseResultHandler<R>>
    implements IParseResultHandler2<R> {
        @Override
        public R handleParseResult(ParseResult parseResult) throws ExecutionException {
            if (CommandLine.printHelpIfRequested(parseResult.asCommandLineList(), this.out(), this.err(), this.ansi())) {
                return this.returnResultOrExit(null);
            }
            return this.returnResultOrExit(this.handle(parseResult));
        }

        protected abstract R handle(ParseResult var1) throws ExecutionException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultExceptionHandler<R>
    extends AbstractHandler<R, DefaultExceptionHandler<R>>
    implements IExceptionHandler,
    IExceptionHandler2<R> {
        @Override
        public List<Object> handleException(ParameterException ex, PrintStream out, Help.Ansi ansi, String ... args) {
            this.internalHandleParseException(ex, out, ansi, args);
            return Collections.emptyList();
        }

        @Override
        public R handleParseException(ParameterException ex, String[] args) {
            this.internalHandleParseException(ex, this.err(), this.ansi(), args);
            return this.returnResultOrExit(null);
        }

        private void internalHandleParseException(ParameterException ex, PrintStream out, Help.Ansi ansi, String[] args) {
            out.println(ex.getMessage());
            if (!UnmatchedArgumentException.printSuggestions(ex, out)) {
                ex.getCommandLine().usage(out, ansi);
            }
        }

        @Override
        public R handleExecutionException(ExecutionException ex, ParseResult parseResult) {
            return this.throwOrExit(ex);
        }

        @Override
        protected DefaultExceptionHandler<R> self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractHandler<R, T extends AbstractHandler<R, T>> {
        private Help.Ansi ansi = Help.Ansi.AUTO;
        private Integer exitCode;
        private PrintStream out = System.out;
        private PrintStream err = System.err;

        public PrintStream out() {
            return this.out;
        }

        public PrintStream err() {
            return this.err;
        }

        public Help.Ansi ansi() {
            return this.ansi;
        }

        public Integer exitCode() {
            return this.exitCode;
        }

        public boolean hasExitCode() {
            return this.exitCode != null;
        }

        protected R returnResultOrExit(R result) {
            if (this.hasExitCode()) {
                this.exit(this.exitCode());
            }
            return result;
        }

        protected R throwOrExit(ExecutionException ex) {
            if (this.hasExitCode()) {
                ex.printStackTrace(this.err());
                this.exit(this.exitCode());
            }
            throw ex;
        }

        protected void exit(int exitCode) {
            System.exit(exitCode);
        }

        protected abstract T self();

        public T useOut(PrintStream out) {
            this.out = Assert.notNull(out, "out");
            return this.self();
        }

        public T useErr(PrintStream err) {
            this.err = Assert.notNull(err, "err");
            return this.self();
        }

        public T useAnsi(Help.Ansi ansi) {
            this.ansi = Assert.notNull(ansi, "ansi");
            return this.self();
        }

        public T andExit(int exitCode) {
            this.exitCode = exitCode;
            return this.self();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IExceptionHandler2<R> {
        public R handleParseException(ParameterException var1, String[] var2);

        public R handleExecutionException(ExecutionException var1, ParseResult var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static interface IExceptionHandler {
        public List<Object> handleException(ParameterException var1, PrintStream var2, Help.Ansi var3, String ... var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IParseResultHandler2<R> {
        public R handleParseResult(ParseResult var1) throws ExecutionException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static interface IParseResultHandler {
        public List<Object> handleParseResult(List<CommandLine> var1, PrintStream var2, Help.Ansi var3) throws ExecutionException;
    }
}

