/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.orient3;

import com.arcadeanalytics.data.Sprite;
import com.arcadeanalytics.data.SpritePlayer;
import com.arcadeanalytics.provider.DataSourceGraphProvider;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.orient3.OrientDB3DataSourceGraphProvider;
import com.arcadeanalytics.provider.orient3.OrientDB3UtilsKt;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/arcadeanalytics/provider/orient3/OrientDB3DataSourceGraphProvider;", "Lcom/arcadeanalytics/provider/DataSourceGraphProvider;", "()V", "E_COUNT", "", "V_COUNT", "allFields", "Ljava/util/regex/Pattern;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "provide", "", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "player", "Lcom/arcadeanalytics/data/SpritePlayer;", "what", "provideTo", "supportedDataSourceTypes", "", "toSprite", "Lcom/arcadeanalytics/data/Sprite;", "document", "Lcom/orientechnologies/orient/core/record/impl/ODocument;", "arcade-connectors-orientdb3"})
public final class OrientDB3DataSourceGraphProvider
implements DataSourceGraphProvider {
    private final Logger log = LoggerFactory.getLogger(OrientDB3DataSourceGraphProvider.class);
    private final String V_COUNT = "select count(*) as count from V";
    private final String E_COUNT = "select count(*) as count from E";
    private final Pattern allFields;

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        return SetsKt.setOf((Object)"ORIENTDB3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideTo(@NotNull DataSourceInfo dataSource, @NotNull SpritePlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        try {
            this.provide(dataSource, player, "V");
            this.provide(dataSource, player, "E");
        }
        finally {
            player.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void provide(DataSourceInfo dataSource, SpritePlayer player, String what) {
        void fetched;
        void skip;
        Long l;
        Object object;
        Object object2;
        Object object3;
        Closeable closeable = OrientDB3UtilsKt.open(dataSource);
        boolean bl = false;
        Throwable throwable = null;
        try {
            Long l2;
            ODatabaseSession db = (ODatabaseSession)closeable;
            boolean bl2 = false;
            object3 = db.query("select count(*) as count from " + what, new Object[0]);
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                OResultSet result = (OResultSet)object3;
                boolean bl4 = false;
                OResultSet oResultSet = result;
                Intrinsics.checkExpressionValueIsNotNull((Object)oResultSet, (String)"result");
                Object t = ((OResult)SequencesKt.first((Sequence)SequencesKt.asSequence((Iterator)oResultSet))).getProperty("count");
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"result.asSequence().first().getProperty(\"count\")");
                object2 = (Long)t;
                l2 = object2;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object3, (Throwable)throwable2);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"db.query(\"select count(*\u2026ty(\"count\")\n            }");
            object = l2;
            l = object;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"open(dataSource).use { d\u2026)\n            }\n        }");
        long count = ((Number)l).longValue();
        closeable = new Ref.LongRef();
        ((Ref.LongRef)closeable).element = 0L;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = new ORecordId("#-1:-1");
        throwable = new Ref.ObjectRef();
        ((Ref.ObjectRef)throwable).element = (ORID)skip.element;
        this.log.info("start indexing of '{}' from data-source {} - total :: {} ", new Object[]{what, dataSource.getId(), count});
        while (fetched.element < count) {
            void lastORID;
            object = OrientDB3UtilsKt.open(dataSource);
            boolean bl5 = false;
            object3 = null;
            try {
                ODatabaseSession db = (ODatabaseSession)object;
                boolean bl6 = false;
                object2 = db.query("SELECT * FROM " + what + " WHERE @rid > " + (ORID)skip.element + " LIMIT 1000", new Object[0]);
                boolean bl7 = false;
                Throwable throwable5 = null;
                try {
                    OResultSet resultSet = (OResultSet)object2;
                    boolean bl8 = false;
                    OResultSet oResultSet = resultSet;
                    Intrinsics.checkExpressionValueIsNotNull((Object)oResultSet, (String)"resultSet");
                    Sequence $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.onEach((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)oResultSet), (Function1)provide.1.1.1.INSTANCE), (Function1)provide.1.1.2.INSTANCE), (Function1)((Function1)new Function1<OElement, Unit>(this, what, (Ref.ObjectRef)skip, (Ref.ObjectRef)lastORID, player, (Ref.LongRef)fetched){
                        final /* synthetic */ OrientDB3DataSourceGraphProvider this$0;
                        final /* synthetic */ String $what$inlined;
                        final /* synthetic */ Ref.ObjectRef $skip$inlined;
                        final /* synthetic */ Ref.ObjectRef $lastORID$inlined;
                        final /* synthetic */ SpritePlayer $player$inlined;
                        final /* synthetic */ Ref.LongRef $fetched$inlined;
                        {
                            this.this$0 = orientDB3DataSourceGraphProvider;
                            this.$what$inlined = string;
                            this.$skip$inlined = objectRef;
                            this.$lastORID$inlined = objectRef2;
                            this.$player$inlined = spritePlayer;
                            this.$fetched$inlined = longRef;
                            super(1);
                        }

                        public final void invoke(@NotNull OElement elem) {
                            Intrinsics.checkParameterIsNotNull((Object)elem, (String)"elem");
                            ORID oRID = elem.getIdentity();
                            Intrinsics.checkExpressionValueIsNotNull((Object)oRID, (String)"elem.identity");
                            this.$lastORID$inlined.element = oRID;
                        }
                    })), (Function1)provide.1.1.4.INSTANCE), (Function1)((Function1)new Function1<ODocument, Sprite>(this, what, (Ref.ObjectRef)skip, (Ref.ObjectRef)lastORID, player, (Ref.LongRef)fetched){
                        final /* synthetic */ OrientDB3DataSourceGraphProvider this$0;
                        final /* synthetic */ String $what$inlined;
                        final /* synthetic */ Ref.ObjectRef $skip$inlined;
                        final /* synthetic */ Ref.ObjectRef $lastORID$inlined;
                        final /* synthetic */ SpritePlayer $player$inlined;
                        final /* synthetic */ Ref.LongRef $fetched$inlined;
                        {
                            this.this$0 = orientDB3DataSourceGraphProvider;
                            this.$what$inlined = string;
                            this.$skip$inlined = objectRef;
                            this.$lastORID$inlined = objectRef2;
                            this.$player$inlined = spritePlayer;
                            this.$fetched$inlined = longRef;
                            super(1);
                        }

                        @NotNull
                        public final Sprite invoke(@NotNull ODocument doc) {
                            Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
                            return OrientDB3DataSourceGraphProvider.access$toSprite(this.this$0, doc);
                        }
                    }));
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Sprite doc = (Sprite)element$iv;
                        boolean bl9 = false;
                        player.play(doc);
                        long l3 = fetched.element;
                        fetched.element = l3 + 1L;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable5 = throwable6;
                    throw throwable6;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)throwable5);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable7) {
                object3 = throwable7;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object3);
            }
            player.end();
            skip.element = (ORID)lastORID.element;
        }
    }

    private final Sprite toSprite(ODocument document) {
        ORID rid = document.getIdentity();
        Sprite sprite = new Sprite();
        Map<String, Object> map = document.toMap();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"document.toMap()");
        Sprite sprite2 = sprite.load(map);
        OClass oClass = document.getSchemaClass();
        Intrinsics.checkExpressionValueIsNotNull((Object)oClass, (String)"document.schemaClass");
        Collection<OClass> collection = oClass.getAllSuperClasses();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"document.schemaClass\n   \u2026         .allSuperClasses");
        Sprite sprite3 = sprite2.addAll("@class", SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)toSprite.1.INSTANCE))).apply(this.allFields, (Function1)toSprite.2.INSTANCE).remove("@class", (Object)"V").remove("@class", (Object)"E").remove("@rid");
        StringBuilder stringBuilder = new StringBuilder();
        ORID oRID = rid;
        Intrinsics.checkExpressionValueIsNotNull((Object)oRID, (String)"rid");
        return sprite3.add("_a_id", stringBuilder.append(oRID.getClusterId()).append('_').append(rid.getClusterPosition()).toString()).add("_a_type", OrientDB3UtilsKt.type(document));
    }

    public OrientDB3DataSourceGraphProvider() {
        Pattern pattern = Pattern.compile(".*");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\".*\")");
        this.allFields = pattern;
    }

    public static final /* synthetic */ Sprite access$toSprite(OrientDB3DataSourceGraphProvider $this, ODocument document) {
        return $this.toSprite(document);
    }
}

