/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.DoubleLookupContainer;
import com.carrotsearch.hppc.DoubleShortAssociativeContainer;
import com.carrotsearch.hppc.DoubleShortMap;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.cursors.DoubleShortCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import com.carrotsearch.hppc.procedures.DoubleShortProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class DoubleShortOpenHashMap
implements DoubleShortMap,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public double[] keys;
    public short[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    protected int resizeAt;
    protected int lastSlot;
    protected int perturbation;

    public DoubleShortOpenHashMap() {
        this(16);
    }

    public DoubleShortOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DoubleShortOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public DoubleShortOpenHashMap(DoubleShortAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public short put(double key, short value) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                short oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        return 0;
    }

    @Override
    public int putAll(DoubleShortAssociativeContainer container) {
        int count = this.assigned;
        for (DoubleShortCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public int putAll(Iterable<? extends DoubleShortCursor> iterable) {
        int count = this.assigned;
        for (DoubleShortCursor doubleShortCursor : iterable) {
            this.put(doubleShortCursor.key, doubleShortCursor.value);
        }
        return this.assigned - count;
    }

    public boolean putIfAbsent(double key, short value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public short putOrAdd(double key, short putValue, short additionValue) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                this.values[slot] = (short)(this.values[slot] + additionValue);
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, putValue, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = putValue;
        }
        return putValue;
    }

    @Override
    public short addTo(double key, short additionValue) {
        return this.putOrAdd(key, additionValue, additionValue);
    }

    private void expandAndPut(double pendingKey, short pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        double[] oldKeys = this.keys;
        short[] oldValues = this.values;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        double[] keys2 = this.keys;
        short[] values = this.values;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            double k = oldKeys[i];
            short v = oldValues[i];
            int slot = Internals.rehash(k, this.perturbation) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys2[slot] = k;
            values[slot] = v;
        }
    }

    private void allocateBuffers(int capacity) {
        double[] keys2 = new double[capacity];
        short[] values = new short[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys2;
        this.values = values;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = this.computePerturbationValue(capacity);
    }

    protected int computePerturbationValue(int capacity) {
        return HashContainerUtils.PERTURBATIONS[Integer.numberOfLeadingZeros(capacity)];
    }

    @Override
    public short remove(double key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                --this.assigned;
                short v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr], this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public int removeAll(DoubleContainer container) {
        int before = this.assigned;
        for (DoubleCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        int before = this.assigned;
        double[] keys2 = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys2[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public short get(double key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0;
    }

    @Override
    public short getOrDefault(double key, short defaultValue) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return defaultValue;
    }

    public short lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public short lset(short key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        short previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        return this.lastSlot;
    }

    @Override
    public boolean containsKey(double key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                this.lastSlot = slot;
                return true;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (DoubleShortCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            DoubleShortMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof DoubleShortMap && (other = (DoubleShortMap)obj).size() == this.size()) {
                for (DoubleShortCursor c : this) {
                    short v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<DoubleShortCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends DoubleShortProcedure> T forEach(T procedure) {
        double[] keys2 = this.keys;
        short[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys2[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ShortContainer values() {
        return new ValuesContainer();
    }

    public DoubleShortOpenHashMap clone() {
        try {
            DoubleShortOpenHashMap cloned = (DoubleShortOpenHashMap)super.clone();
            cloned.keys = (double[])this.keys.clone();
            cloned.values = (short[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (DoubleShortCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static DoubleShortOpenHashMap from(double[] keys2, short[] values) {
        if (keys2.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleShortOpenHashMap map = new DoubleShortOpenHashMap();
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values[i]);
        }
        return map;
    }

    public static DoubleShortOpenHashMap from(DoubleShortAssociativeContainer container) {
        return new DoubleShortOpenHashMap(container);
    }

    public static DoubleShortOpenHashMap newInstance() {
        return new DoubleShortOpenHashMap();
    }

    public static DoubleShortOpenHashMap newInstanceWithoutPerturbations() {
        return new DoubleShortOpenHashMap(){

            @Override
            protected int computePerturbationValue(int capacity) {
                return 0;
            }
        };
    }

    public static DoubleShortOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new DoubleShortOpenHashMap(initialCapacity, loadFactor);
    }

    public static DoubleShortOpenHashMap newInstanceWithExpectedSize(int expectedSize) {
        return DoubleShortOpenHashMap.newInstanceWithExpectedSize(expectedSize, 0.75f);
    }

    public static DoubleShortOpenHashMap newInstanceWithExpectedSize(int expectedSize, float loadFactor) {
        return DoubleShortOpenHashMap.newInstance((int)((float)expectedSize / loadFactor) + 1, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ShortCursor fetch() {
            int i;
            int max = DoubleShortOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !DoubleShortOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ShortCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleShortOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return DoubleShortOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return DoubleShortOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(short value) {
            boolean[] allocated = DoubleShortOpenHashMap.this.allocated;
            short[] values = DoubleShortOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            boolean[] allocated = DoubleShortOpenHashMap.this.allocated;
            short[] values = DoubleShortOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            boolean[] allocated = DoubleShortOpenHashMap.this.allocated;
            short[] values = DoubleShortOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(short e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            int max = DoubleShortOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !DoubleShortOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleShortOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractDoubleCollection
    implements DoubleLookupContainer {
        private final DoubleShortOpenHashMap owner;

        public KeysContainer() {
            this.owner = DoubleShortOpenHashMap.this;
        }

        @Override
        public boolean contains(double e) {
            return DoubleShortOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            double[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            double[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(double e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<DoubleShortCursor> {
        private final DoubleShortCursor cursor = new DoubleShortCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected DoubleShortCursor fetch() {
            int i;
            int max = DoubleShortOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !DoubleShortOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (DoubleShortCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = DoubleShortOpenHashMap.this.keys[i];
            this.cursor.value = DoubleShortOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

