/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import com.orientechnologies.common.concur.OTimeoutException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class OSharedResourceTimeout {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected int timeout;

    public OSharedResourceTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected void acquireSharedLock() throws OTimeoutException {
        try {
            if (this.timeout == 0) {
                this.lock.readLock().lock();
                return;
            }
            if (this.lock.readLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        this.throwTimeoutException(this.lock.readLock());
    }

    protected void releaseSharedLock() {
        this.lock.readLock().unlock();
    }

    protected void acquireExclusiveLock() throws OTimeoutException {
        try {
            if (this.timeout == 0) {
                this.lock.writeLock().lock();
                return;
            }
            if (this.lock.writeLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        this.throwTimeoutException(this.lock.writeLock());
    }

    protected void releaseExclusiveLock() {
        this.lock.writeLock().unlock();
    }

    private void throwTimeoutException(Lock lock) {
        String owner = this.extractLockOwnerStackTrace(lock);
        throw new OTimeoutException("Timeout on acquiring exclusive lock against resource of class: " + this.getClass() + " with timeout=" + this.timeout + (owner != null ? "\n" + owner : ""));
    }

    private String extractLockOwnerStackTrace(Lock lock) {
        try {
            StackTraceElement[] stackTrace;
            Field syncField = lock.getClass().getDeclaredField("sync");
            syncField.setAccessible(true);
            Object sync = syncField.get(lock);
            Method getOwner = sync.getClass().getSuperclass().getDeclaredMethod("getOwner", new Class[0]);
            getOwner.setAccessible(true);
            Thread owner = (Thread)getOwner.invoke(sync, new Object[0]);
            if (owner == null) {
                return null;
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.append("Owner thread : ").append(owner.toString()).append("\n");
            for (StackTraceElement traceElement : stackTrace = owner.getStackTrace()) {
                printWriter.println("\tat " + traceElement);
            }
            printWriter.flush();
            return stringWriter.toString();
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException ignore) {
            return null;
        }
    }
}

