/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.common.exception.OErrorCode;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class OError37Response
implements OBinaryResponse {
    private OErrorCode code;
    private int errorIdentifier;
    private Map<String, String> messages;
    private byte[] verbose;

    public OError37Response(OErrorCode code, int errorIdentifier, Map<String, String> messages, byte[] verbose) {
        this.code = code;
        this.errorIdentifier = errorIdentifier;
        this.messages = messages;
        this.verbose = verbose;
    }

    public OError37Response() {
    }

    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        int code = network.readInt();
        this.errorIdentifier = network.readInt();
        this.code = OErrorCode.getErrorCode(code);
        this.messages = new HashMap<String, String>();
        while (network.readByte() == 1) {
            String key = network.readString();
            String value = network.readString();
            this.messages.put(key, value);
        }
        this.verbose = network.readBytes();
    }

    @Override
    public void write(OChannelDataOutput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        channel.writeInt(this.code.getCode());
        channel.writeInt(this.errorIdentifier);
        for (Map.Entry<String, String> entry : this.messages.entrySet()) {
            channel.writeByte((byte)1);
            channel.writeString(entry.getKey());
            channel.writeString(entry.getValue());
        }
        channel.writeByte((byte)0);
        channel.writeBytes(this.verbose);
    }

    public int getErrorIdentifier() {
        return this.errorIdentifier;
    }

    public OErrorCode getCode() {
        return this.code;
    }

    public Map<String, String> getMessages() {
        return this.messages;
    }

    public byte[] getVerbose() {
        return this.verbose;
    }
}

