/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OSharedContextEmbedded;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.List;

public class DistributedQueryContext {
    String queryId;
    ODatabase db;
    OResultSet resultSet;

    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public ODatabase getDb() {
        return this.db;
    }

    public void setDb(ODatabase db) {
        this.db = db;
    }

    public OResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(OResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public List<OResult> fetchNextPage() {
        ODatabaseDocumentInternal prev = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            this.db.activateOnCurrentThread();
            this.resultSet.close();
            this.db.close();
        }
        finally {
            if (prev == null) {
                ODatabaseRecordThreadLocal.instance().remove();
            } else {
                ODatabaseRecordThreadLocal.instance().set(prev);
            }
        }
        return null;
    }

    public void close() {
        ODatabaseDocumentInternal prev = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            this.db.activateOnCurrentThread();
            this.resultSet.close();
            this.db.close();
            ((OSharedContextEmbedded)((ODatabaseInternal)this.db).getSharedContext()).getActiveDistributedQueries().remove(this.queryId);
        }
        finally {
            if (prev == null) {
                ODatabaseRecordThreadLocal.instance().remove();
            } else {
                ODatabaseRecordThreadLocal.instance().set(prev);
            }
        }
    }
}

