/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCommandCacheHook;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OScriptExecutor;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OHookReplacedRecordThreadLocal;
import com.orientechnologies.orient.core.db.OLiveQueryMonitor;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OSharedContextEmbedded;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import com.orientechnologies.orient.core.db.document.OQueryLifecycleListener;
import com.orientechnologies.orient.core.db.record.OClassTrigger;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibraryImpl;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.security.OImmutableUser;
import com.orientechnologies.orient.core.metadata.security.ORestrictedAccessHook;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryProxy;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.query.live.OLiveQueryMonitorEmbedded;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OEdgeDelegate;
import com.orientechnologies.orient.core.record.impl.OVertexDelegate;
import com.orientechnologies.orient.core.schedule.OScheduledEvent;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.executor.LiveQueryListenerImpl;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSetLifecycleDecorator;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OMicroTransaction;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.function.Consumer;

public class ODatabaseDocumentEmbedded
extends ODatabaseDocumentAbstract
implements OQueryLifecycleListener {
    private OrientDBConfig config;
    private OStorage storage;

    public ODatabaseDocumentEmbedded(OStorage storage) {
        this.activateOnCurrentThread();
        try {
            this.status = ODatabase.STATUS.CLOSED;
            this.url = storage.getURL();
            this.storage = storage;
            this.componentsFactory = storage.getComponentsFactory();
            this.unmodifiableHooks = Collections.unmodifiableMap(this.hooks);
            this.localCache = new OLocalRecordCache();
            this.init();
            this.databaseOwner = this;
        }
        catch (Exception t) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw OException.wrapException(new ODatabaseException("Error on opening database "), t);
        }
    }

    @Override
    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        throw new UnsupportedOperationException("Use OrientDB");
    }

    public void init(OrientDBConfig config) {
        this.activateOnCurrentThread();
        this.config = config;
        this.applyAttributes(config);
        this.applyListeners(config);
        try {
            this.status = ODatabase.STATUS.OPEN;
            if (this.initialized) {
                return;
            }
            ORecordSerializerFactory serializerFactory = ORecordSerializerFactory.instance();
            String serializeName = this.getStorage().getConfiguration().getRecordSerializer();
            if (serializeName == null) {
                throw new ODatabaseException("Impossible to open database from version before 2.x use export import instead");
            }
            this.serializer = serializerFactory.getFormat(serializeName);
            if (this.serializer == null) {
                throw new ODatabaseException("RecordSerializer with name '" + serializeName + "' not found ");
            }
            if (this.getStorage().getConfiguration().getRecordSerializerVersion() > this.serializer.getMinSupportedVersion()) {
                throw new ODatabaseException("Persistent record serializer version is not support by the current implementation");
            }
            this.localCache.startup();
            this.loadMetadata();
            this.installHooksEmbedded();
            if (this.getMetadata().getCommandCache().isEnabled()) {
                this.registerHook(new OCommandCacheHook(this), ORecordHook.HOOK_POSITION.REGULAR);
            }
            this.user = null;
            this.initialized = true;
        }
        catch (OException e) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw e;
        }
        catch (Exception e) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw OException.wrapException(new ODatabaseException("Cannot open database url=" + this.getURL()), e);
        }
    }

    public void internalOpen(String iUserName, String iUserPassword) {
        this.internalOpen(iUserName, iUserPassword, true);
    }

    public void internalOpen(String iUserName, String iUserPassword, boolean checkPassword) {
        try {
            OSecurity security = this.metadata.getSecurity();
            if (this.user == null || this.user.getVersion() != security.getVersion() || !this.user.getName().equalsIgnoreCase(iUserName)) {
                OUser usr = checkPassword ? security.authenticate(iUserName, iUserPassword) : security.getUser(iUserName);
                this.user = usr != null ? new OImmutableUser(security.getVersion(), usr) : null;
                this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_READ, new Object[0]);
            }
        }
        catch (OException e) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw e;
        }
        catch (Exception e) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw OException.wrapException(new ODatabaseException("Cannot open database url=" + this.getURL()), e);
        }
    }

    private void applyListeners(OrientDBConfig config) {
        if (config != null) {
            for (ODatabaseListener listener : config.getListeners()) {
                this.registerListener(listener);
            }
        }
    }

    @Override
    @Deprecated
    public <DB extends ODatabase> DB open(OToken iToken) {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    @Override
    public <DB extends ODatabase> DB create() {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    public void internalCreate(OrientDBConfig config) {
        this.status = ODatabase.STATUS.OPEN;
        this.applyAttributes(config);
        this.applyListeners(config);
        this.metadata = new OMetadataDefault(this);
        this.installHooksEmbedded();
        this.createMetadata();
        if (this.getMetadata().getCommandCache().isEnabled()) {
            this.registerHook(new OCommandCacheHook(this), ORecordHook.HOOK_POSITION.REGULAR);
        }
    }

    public void callOnCreateListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onCreate(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onCreate(this);
            }
            catch (Exception exception) {}
        }
    }

    protected void createMetadata() {
        OSharedContext shared = this.getStorage().getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextEmbedded shared = new OSharedContextEmbedded(ODatabaseDocumentEmbedded.this.getStorage());
                return shared;
            }
        });
        this.metadata.init(shared);
        ((OSharedContextEmbedded)shared).create(this);
    }

    @Override
    protected void loadMetadata() {
        this.metadata = new OMetadataDefault(this);
        this.sharedContext = this.getStorage().getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextEmbedded shared = new OSharedContextEmbedded(ODatabaseDocumentEmbedded.this.getStorage());
                return shared;
            }
        });
        this.metadata.init(this.sharedContext);
        this.sharedContext.load(this);
    }

    private void applyAttributes(OrientDBConfig config) {
        if (config != null) {
            for (Map.Entry<ODatabase.ATTRIBUTES, Object> attrs : config.getAttributes().entrySet()) {
                this.set(attrs.getKey(), attrs.getValue());
            }
        }
    }

    @Override
    public <DB extends ODatabase> DB set(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        this.checkIfActive();
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = OIOUtils.getStringContent(iValue != null ? iValue.toString() : null);
        OStorage storage = this.getStorage();
        switch (iAttribute) {
            case STATUS: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("DB status can't be null");
                }
                this.setStatus(ODatabase.STATUS.valueOf(stringValue.toUpperCase(Locale.ENGLISH)));
                break;
            }
            case DEFAULTCLUSTERID: {
                if (iValue == null) break;
                if (iValue instanceof Number) {
                    storage.setDefaultClusterId(((Number)iValue).intValue());
                    break;
                }
                storage.setDefaultClusterId(storage.getClusterIdByName(iValue.toString()));
                break;
            }
            case TYPE: {
                throw new IllegalArgumentException("Database type cannot be changed at run-time");
            }
            case DATEFORMAT: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("date format is null");
                }
                new SimpleDateFormat(stringValue).format(new Date());
                storage.setDateFormat(stringValue);
                break;
            }
            case DATETIMEFORMAT: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("date format is null");
                }
                new SimpleDateFormat(stringValue).format(new Date());
                storage.setDateTimeFormat(stringValue);
                break;
            }
            case TIMEZONE: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("Timezone can't be null");
                }
                TimeZone timeZoneValue = TimeZone.getTimeZone(stringValue.toUpperCase(Locale.ENGLISH));
                if (timeZoneValue.equals(TimeZone.getTimeZone("GMT"))) {
                    timeZoneValue = TimeZone.getTimeZone(stringValue);
                }
                storage.setTimeZone(timeZoneValue);
                break;
            }
            case LOCALECOUNTRY: {
                storage.setLocaleCountry(stringValue);
                break;
            }
            case LOCALELANGUAGE: {
                storage.setLocaleLanguage(stringValue);
                break;
            }
            case CHARSET: {
                storage.setCharset(stringValue);
                break;
            }
            case CUSTOM: {
                int indx;
                int n = indx = stringValue != null ? stringValue.indexOf(61) : -1;
                if (indx < 0) {
                    if ("clear".equalsIgnoreCase(stringValue)) {
                        this.clearCustomInternal();
                        break;
                    }
                    throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
                }
                String customName = stringValue.substring(0, indx).trim();
                String customValue = stringValue.substring(indx + 1).trim();
                if (customValue.isEmpty()) {
                    this.removeCustomInternal(customName);
                    break;
                }
                this.setCustomInternal(customName, customValue);
                break;
            }
            case CLUSTERSELECTION: {
                storage.setClusterSelection(stringValue);
                break;
            }
            case MINIMUMCLUSTERS: {
                if (iValue != null) {
                    if (iValue instanceof Number) {
                        storage.setMinimumClusters(((Number)iValue).intValue());
                        break;
                    }
                    storage.setMinimumClusters(Integer.parseInt(stringValue));
                    break;
                }
                storage.setMinimumClusters(1);
                break;
            }
            case CONFLICTSTRATEGY: {
                storage.setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(stringValue));
                break;
            }
            case VALIDATION: {
                storage.setValidation(Boolean.parseBoolean(stringValue));
                break;
            }
            default: {
                throw new IllegalArgumentException("Option '" + (Object)((Object)iAttribute) + "' not supported on alter database");
            }
        }
        return (DB)this;
    }

    private void clearCustomInternal() {
        this.getStorage().clearProperties();
    }

    private void removeCustomInternal(String iName) {
        this.setCustomInternal(iName, null);
    }

    private void setCustomInternal(String iName, String iValue) {
        OStorage storage = this.getStorage();
        if (iValue == null || "null".equalsIgnoreCase(iValue)) {
            storage.removeProperty(iName);
        } else {
            storage.setProperty(iName, iValue);
        }
    }

    @Override
    public <DB extends ODatabase> DB setCustom(String name, Object iValue) {
        this.checkIfActive();
        if ("clear".equalsIgnoreCase(name) && iValue == null) {
            this.clearCustomInternal();
        } else {
            String customValue;
            String customName = name;
            String string = customValue = iValue == null ? null : "" + iValue;
            if (customName == null || customValue.isEmpty()) {
                this.removeCustomInternal(customName);
            } else {
                this.setCustomInternal(customName, customValue);
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase> DB create(String incrementalBackupPath) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    @Override
    public <DB extends ODatabase> DB create(Map<OGlobalConfiguration, Object> iInitialSettings) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    @Override
    public void drop() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    @Override
    public ODatabaseDocumentInternal copy() {
        ODatabaseDocumentEmbedded database = new ODatabaseDocumentEmbedded(this.storage);
        database.init(this.config);
        String user = this.getUser() != null ? this.getUser().getName() : null;
        database.internalOpen(user, null, false);
        database.callOnOpenListeners();
        this.activateOnCurrentThread();
        return database;
    }

    @Override
    public boolean exists() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    @Override
    public boolean isClosed() {
        return this.status == ODatabase.STATUS.CLOSED || this.storage.isClosed();
    }

    public void rebuildIndexes() {
        if (this.metadata.getIndexManager().autoRecreateIndexesAfterCrash()) {
            this.metadata.getIndexManager().recreateIndexes();
        }
    }

    protected void installHooksEmbedded() {
        this.hooks.clear();
    }

    @Override
    public OStorage getStorage() {
        return this.storage;
    }

    @Override
    public void replaceStorage(OStorage iNewStorage) {
        this.storage = iNewStorage;
    }

    @Override
    public OResultSet query(String query, Object[] args) {
        this.checkOpenness();
        this.checkIfActive();
        OStatement statement = OSQLEngine.parse(query, this);
        if (!statement.isIdempotent()) {
            throw new OCommandExecutionException("Cannot execute query on non idempotent statement: " + query);
        }
        OResultSet original = statement.execute((ODatabase)this, args, true);
        OLocalResultSetLifecycleDecorator result = new OLocalResultSetLifecycleDecorator(original);
        this.queryStarted(result.getQueryId(), result);
        result.addLifecycleListener(this);
        return result;
    }

    @Override
    public OResultSet query(String query, Map args) {
        this.checkOpenness();
        this.checkIfActive();
        OStatement statement = OSQLEngine.parse(query, this);
        if (!statement.isIdempotent()) {
            throw new OCommandExecutionException("Cannot execute query on non idempotent statement: " + query);
        }
        OResultSet original = statement.execute((ODatabase)this, args, true);
        OLocalResultSetLifecycleDecorator result = new OLocalResultSetLifecycleDecorator(original);
        this.queryStarted(result.getQueryId(), result);
        result.addLifecycleListener(this);
        return result;
    }

    @Override
    public OResultSet command(String query, Object[] args) {
        OLocalResultSetLifecycleDecorator result;
        this.checkOpenness();
        this.checkIfActive();
        OStatement statement = OSQLEngine.parse(query, this);
        OResultSet original = statement.execute((ODatabase)this, args, true);
        if (!statement.isIdempotent()) {
            OInternalResultSet prefetched = new OInternalResultSet();
            original.forEachRemaining((Consumer<? super OResult>)((Consumer<OResult>)x -> prefetched.add((OResult)x)));
            original.close();
            result = new OLocalResultSetLifecycleDecorator(prefetched);
        } else {
            result = new OLocalResultSetLifecycleDecorator(original);
            this.queryStarted(result.getQueryId(), result);
            result.addLifecycleListener(this);
        }
        return result;
    }

    @Override
    public OResultSet command(String query, Map args) {
        OLocalResultSetLifecycleDecorator result;
        this.checkOpenness();
        this.checkIfActive();
        OStatement statement = OSQLEngine.parse(query, this);
        OResultSet original = statement.execute((ODatabase)this, args, true);
        if (!statement.isIdempotent()) {
            OInternalResultSet prefetched = new OInternalResultSet();
            original.forEachRemaining((Consumer<? super OResult>)((Consumer<OResult>)x -> prefetched.add((OResult)x)));
            original.close();
            result = new OLocalResultSetLifecycleDecorator(prefetched);
        } else {
            result = new OLocalResultSetLifecycleDecorator(original);
            this.queryStarted(result.getQueryId(), result);
            result.addLifecycleListener(this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OResultSet execute(String language, String script, Object ... args) {
        OResultSet original;
        this.checkOpenness();
        this.checkIfActive();
        OScriptExecutor executor = OCommandManager.instance().getScriptExecutor(language);
        ((OAbstractPaginatedStorage)this.storage.getUnderlying()).pauseConfigurationUpdateNotifications();
        try {
            original = executor.execute((ODatabaseDocumentInternal)this, script, args);
        }
        finally {
            ((OAbstractPaginatedStorage)this.storage.getUnderlying()).fireConfigurationUpdateNotifications();
        }
        OLocalResultSetLifecycleDecorator result = new OLocalResultSetLifecycleDecorator(original);
        this.queryStarted(result.getQueryId(), result);
        result.addLifecycleListener(this);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OResultSet execute(String language, String script, Map<String, ?> args) {
        OResultSet original;
        this.checkOpenness();
        this.checkIfActive();
        OScriptExecutor executor = OCommandManager.instance().getScriptExecutor(language);
        ((OAbstractPaginatedStorage)this.storage.getUnderlying()).pauseConfigurationUpdateNotifications();
        try {
            original = executor.execute((ODatabaseDocumentInternal)this, script, args);
        }
        finally {
            ((OAbstractPaginatedStorage)this.storage.getUnderlying()).fireConfigurationUpdateNotifications();
        }
        OLocalResultSetLifecycleDecorator result = new OLocalResultSetLifecycleDecorator(original);
        this.queryStarted(result.getQueryId(), result);
        result.addLifecycleListener(this);
        return result;
    }

    public OLocalResultSetLifecycleDecorator query(OExecutionPlan plan, Map<Object, Object> params) {
        this.checkOpenness();
        this.checkIfActive();
        OBasicCommandContext ctx = new OBasicCommandContext();
        ctx.setDatabase(this);
        ctx.setInputParameters(params);
        OLocalResultSet result = new OLocalResultSet((OInternalExecutionPlan)plan);
        OLocalResultSetLifecycleDecorator decorator = new OLocalResultSetLifecycleDecorator(result);
        this.queryStarted(decorator.getQueryId(), decorator);
        decorator.addLifecycleListener(this);
        return decorator;
    }

    public OrientDBConfig getConfig() {
        return this.config;
    }

    @Override
    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Object ... args) {
        this.checkOpenness();
        this.checkIfActive();
        LiveQueryListenerImpl queryListener = new LiveQueryListenerImpl(listener, query, (ODatabaseDocument)this, args);
        ODatabaseDocumentInternal dbCopy = this.copy();
        this.activateOnCurrentThread();
        OLiveQueryMonitorEmbedded monitor = new OLiveQueryMonitorEmbedded(queryListener.getToken(), dbCopy);
        return monitor;
    }

    @Override
    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Map<String, ?> args) {
        this.checkOpenness();
        this.checkIfActive();
        LiveQueryListenerImpl queryListener = new LiveQueryListenerImpl(listener, query, (ODatabaseDocument)this, args);
        ODatabaseDocumentInternal dbCopy = this.copy();
        this.activateOnCurrentThread();
        OLiveQueryMonitorEmbedded monitor = new OLiveQueryMonitorEmbedded(queryListener.getToken(), dbCopy);
        return monitor;
    }

    @Override
    public void recycle(ORecord record) {
        throw new UnsupportedOperationException();
    }

    protected OMicroTransaction beginMicroTransaction() {
        OAbstractPaginatedStorage abstractPaginatedStorage = (OAbstractPaginatedStorage)this.getStorage().getUnderlying();
        if (this.microTransaction == null) {
            this.microTransaction = new OMicroTransaction(abstractPaginatedStorage, this);
        }
        this.microTransaction.begin();
        return this.microTransaction;
    }

    public static void deInit(OAbstractPaginatedStorage storage) {
        OSharedContext sharedContext = (OSharedContext)storage.removeResource(OSharedContext.class.getName());
        if (sharedContext != null) {
            sharedContext.close();
        }
    }

    @Override
    public int addBlobCluster(String iClusterName, Object ... iParameters) {
        int id = !this.existsCluster(iClusterName) ? this.addCluster(iClusterName, iParameters) : this.getClusterIdByName(iClusterName);
        this.getMetadata().getSchema().addBlobCluster(id);
        return id;
    }

    @Override
    public void executeDeleteRecord(OIdentifiable record, int iVersion, boolean iRequired, ODatabase.OPERATION_MODE iMode, boolean prohibitTombstones) {
        this.checkOpenness();
        this.checkIfActive();
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot delete record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return;
        }
        if ((record = record.getRecord()) == null) {
            return;
        }
        OMicroTransaction microTx = this.beginMicroTransaction();
        try {
            microTx.deleteRecord((ORecord)record.getRecord(), iMode);
        }
        catch (Exception e) {
            this.endMicroTransaction(false);
            throw e;
        }
        this.endMicroTransaction(true);
    }

    @Override
    public <RET extends ORecord> RET executeSaveRecord(ORecord record, String clusterName, int ver, ODatabase.OPERATION_MODE mode, boolean forceCreate, ORecordCallback<? extends Number> recordCreatedCallback, ORecordCallback<Integer> recordUpdatedCallback) {
        this.checkOpenness();
        this.checkIfActive();
        if (!record.isDirty()) {
            return (RET)record;
        }
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot create record because it has no identity. Probably is not a regular record or contains projections of fields rather than a full record");
        }
        OMicroTransaction microTx = this.beginMicroTransaction();
        try {
            microTx.saveRecord(record, clusterName, mode, forceCreate, recordCreatedCallback, recordUpdatedCallback);
        }
        catch (Exception e) {
            this.endMicroTransaction(false);
            throw e;
        }
        this.endMicroTransaction(true);
        return (RET)record;
    }

    private void endMicroTransaction(boolean success) {
        block8: {
            assert (this.microTransaction != null);
            try {
                if (success) {
                    try {
                        this.microTransaction.commit();
                        OLiveQueryHook.notifyForTxChanges(this);
                        OLiveQueryHookV2.notifyForTxChanges(this);
                        break block8;
                    }
                    catch (Exception e) {
                        this.microTransaction.rollbackAfterFailedCommit();
                        OLiveQueryHook.removePendingDatabaseOps(this);
                        OLiveQueryHookV2.removePendingDatabaseOps(this);
                        throw e;
                    }
                }
                this.microTransaction.rollback();
                OLiveQueryHook.removePendingDatabaseOps(this);
                OLiveQueryHookV2.removePendingDatabaseOps(this);
            }
            finally {
                if (!this.microTransaction.isActive()) {
                    this.microTransaction = null;
                }
            }
        }
    }

    public ODatabaseDocumentAbstract delete(ORecord record) {
        this.checkOpenness();
        if (record == null) {
            throw new ODatabaseException("Cannot delete null document");
        }
        if (record instanceof OVertex) {
            OVertexDelegate.deleteLinks((OVertex)record);
        } else if (record instanceof OEdge) {
            OEdgeDelegate.deleteLinks((OEdge)record);
        }
        if (record instanceof ODocument && ((ODocument)record).getClassName() != null) {
            this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_DELETE, (Object)((ODocument)record).getClassName());
        }
        try {
            this.currentTx.deleteRecord(record, ODatabase.OPERATION_MODE.SYNCHRONOUS);
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            if (record instanceof ODocument) {
                throw OException.wrapException(new ODatabaseException("Error on deleting record " + record.getIdentity() + " of class '" + ((ODocument)record).getClassName() + "'"), e);
            }
            throw OException.wrapException(new ODatabaseException("Error on deleting record " + record.getIdentity()), e);
        }
        return this;
    }

    @Override
    public OIdentifiable beforeCreateOperations(OIdentifiable id, String iClusterName) {
        ODocument doc;
        OImmutableClass clazz;
        this.checkClusterSecurity(ORole.PERMISSION_CREATE, id, iClusterName);
        ORecordHook.RESULT triggerChanged = null;
        boolean changed = false;
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass(this, doc = (ODocument)id)) != null) {
            if (clazz.isScheduler()) {
                this.getSharedContext().getScheduler().initScheduleRecord(doc);
                changed = true;
            }
            if (clazz.isOuser()) {
                changed = OUser.encodePassword(doc);
            }
            if (clazz.isTriggered()) {
                triggerChanged = OClassTrigger.onRecordBeforeCreate(doc, this);
            }
            if (clazz.isRestricted()) {
                changed = ORestrictedAccessHook.onRecordBeforeCreate(doc, this);
            }
            if (clazz.isFunction()) {
                OFunctionLibraryImpl.validateFunctionRecord(doc);
            }
        }
        ORecordHook.RESULT res = this.callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, id);
        if (changed || res == ORecordHook.RESULT.RECORD_CHANGED || triggerChanged == ORecordHook.RESULT.RECORD_CHANGED) {
            if (id instanceof ODocument) {
                ((ODocument)id).validate();
            }
            return id;
        }
        if (res == ORecordHook.RESULT.RECORD_REPLACED || triggerChanged == ORecordHook.RESULT.RECORD_REPLACED) {
            ORecord replaced = (ORecord)OHookReplacedRecordThreadLocal.INSTANCE.get();
            if (replaced instanceof ODocument) {
                ((ODocument)replaced).validate();
            }
            return replaced;
        }
        return null;
    }

    @Override
    public OIdentifiable beforeUpdateOperations(OIdentifiable id, String iClusterName) {
        ORecordHook.RESULT res;
        ODocument doc;
        OImmutableClass clazz;
        this.checkClusterSecurity(ORole.PERMISSION_UPDATE, id, iClusterName);
        ORecordHook.RESULT triggerChanged = null;
        boolean changed = false;
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass(this, doc = (ODocument)id)) != null) {
            if (clazz.isScheduler()) {
                this.getSharedContext().getScheduler().handleUpdateSchedule(doc);
                changed = true;
            }
            if (clazz.isOuser()) {
                changed = OUser.encodePassword(doc);
            }
            if (clazz.isTriggered()) {
                triggerChanged = OClassTrigger.onRecordBeforeUpdate(doc, this);
            }
            if (clazz.isRestricted() && !ORestrictedAccessHook.isAllowed(this, doc, ORestrictedOperation.ALLOW_UPDATE, true)) {
                throw new OSecurityException("Cannot update record " + doc.getIdentity() + ": the resource has restricted access");
            }
            if (clazz.isFunction()) {
                OFunctionLibraryImpl.validateFunctionRecord(doc);
            }
        }
        if ((res = this.callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, id)) == ORecordHook.RESULT.RECORD_CHANGED || triggerChanged == ORecordHook.RESULT.RECORD_CHANGED) {
            if (id instanceof ODocument) {
                ((ODocument)id).validate();
            }
            return id;
        }
        if (res == ORecordHook.RESULT.RECORD_REPLACED || triggerChanged == ORecordHook.RESULT.RECORD_REPLACED) {
            ORecord replaced = (ORecord)OHookReplacedRecordThreadLocal.INSTANCE.get();
            if (replaced instanceof ODocument) {
                ((ODocument)replaced).validate();
            }
            return replaced;
        }
        if (changed) {
            return id;
        }
        return null;
    }

    @Override
    public void beforeDeleteOperations(OIdentifiable id, String iClusterName) {
        ODocument doc;
        OImmutableClass clazz;
        this.checkClusterSecurity(ORole.PERMISSION_DELETE, id, iClusterName);
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass(this, doc = (ODocument)id)) != null) {
            if (clazz.isTriggered()) {
                OClassTrigger.onRecordBeforeDelete(doc, this);
            }
            if (clazz.isRestricted() && !ORestrictedAccessHook.isAllowed(this, doc, ORestrictedOperation.ALLOW_DELETE, true)) {
                throw new OSecurityException("Cannot delete record " + doc.getIdentity() + ": the resource has restricted access");
            }
        }
        this.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, id);
    }

    @Override
    public void afterCreateOperations(OIdentifiable id) {
        if (id instanceof ODocument) {
            ODocument doc = (ODocument)id;
            OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(this, doc);
            if (clazz != null) {
                OClassIndexManager.checkIndexesAfterCreate(doc, this);
                if (clazz.isFunction()) {
                    this.getSharedContext().getFunctionLibrary().createdFunction(doc);
                    Orient.instance().getScriptManager().close(this.getName());
                }
                if (clazz.isOuser() || clazz.isOrole()) {
                    this.getMetadata().getSecurity().incrementVersion();
                }
                if (clazz.isSequence()) {
                    ((OSequenceLibraryProxy)this.getMetadata().getSequenceLibrary()).getDelegate().onSequenceCreated(this, doc);
                }
                if (clazz.isScheduler()) {
                    this.getMetadata().getScheduler().scheduleEvent(new OScheduledEvent(doc));
                }
                if (clazz.isTriggered()) {
                    OClassTrigger.onRecordAfterCreate(doc, this);
                }
            }
            OLiveQueryHook.addOp(doc, (byte)3, this);
            OLiveQueryHookV2.addOp(doc, (byte)3, this);
        }
        this.callbackHooks(ORecordHook.TYPE.AFTER_CREATE, id);
    }

    @Override
    public void afterUpdateOperations(OIdentifiable id) {
        if (id instanceof ODocument) {
            ODocument doc = (ODocument)id;
            OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(this, doc);
            if (clazz != null) {
                OClassIndexManager.checkIndexesAfterUpdate((ODocument)id, this);
                if (clazz.isFunction()) {
                    this.getSharedContext().getFunctionLibrary().updatedFunction(doc);
                    Orient.instance().getScriptManager().close(this.getName());
                }
                if (clazz.isOuser() || clazz.isOrole()) {
                    this.getMetadata().getSecurity().incrementVersion();
                }
                if (clazz.isSequence()) {
                    ((OSequenceLibraryProxy)this.getMetadata().getSequenceLibrary()).getDelegate().onSequenceUpdated(this, doc);
                }
                if (clazz.isTriggered()) {
                    OClassTrigger.onRecordAfterUpdate(doc, this);
                }
            }
            OLiveQueryHook.addOp(doc, (byte)1, this);
            OLiveQueryHookV2.addOp(doc, (byte)1, this);
        }
        this.callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, id);
    }

    @Override
    public void afterDeleteOperations(OIdentifiable id) {
        if (id instanceof ODocument) {
            ODocument doc = (ODocument)id;
            OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(this, doc);
            if (clazz != null) {
                OClassIndexManager.checkIndexesAfterDelete(doc, this);
                if (clazz.isFunction()) {
                    this.getSharedContext().getFunctionLibrary().droppedFunction(doc);
                    Orient.instance().getScriptManager().close(this.getName());
                }
                if (clazz.isOuser() || clazz.isOrole()) {
                    this.getMetadata().getSecurity().incrementVersion();
                }
                if (clazz.isSequence()) {
                    ((OSequenceLibraryProxy)this.getMetadata().getSequenceLibrary()).getDelegate().onSequenceDropped(this, doc);
                }
                if (clazz.isScheduler()) {
                    String eventName = (String)doc.field("name");
                    this.getSharedContext().getScheduler().removeEventInternal(eventName);
                }
                if (clazz.isTriggered()) {
                    OClassTrigger.onRecordAfterDelete(doc, this);
                }
            }
            OLiveQueryHook.addOp(doc, (byte)2, this);
            OLiveQueryHookV2.addOp(doc, (byte)2, this);
        }
        this.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, id);
    }

    @Override
    public void afterReadOperations(OIdentifiable identifiable) {
        ODocument doc;
        OImmutableClass clazz;
        if (identifiable instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass(this, doc = (ODocument)identifiable)) != null && clazz.isTriggered()) {
            OClassTrigger.onRecordAfterRead(doc, this);
        }
        this.callbackHooks(ORecordHook.TYPE.AFTER_READ, identifiable);
    }

    @Override
    public boolean beforeReadOperations(OIdentifiable identifiable) {
        ODocument doc;
        OImmutableClass clazz;
        if (identifiable instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass(this, doc = (ODocument)identifiable)) != null) {
            ORecordHook.RESULT val;
            if (clazz.isTriggered() && (val = OClassTrigger.onRecordBeforeRead(doc, this)) == ORecordHook.RESULT.SKIP) {
                return true;
            }
            if (clazz.isRestricted() && !ORestrictedAccessHook.isAllowed(this, doc, ORestrictedOperation.ALLOW_READ, false)) {
                return true;
            }
        }
        return this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, identifiable) == ORecordHook.RESULT.SKIP;
    }

    @Override
    protected void afterCommitOperations() {
        super.afterCommitOperations();
        OLiveQueryHook.notifyForTxChanges(this);
        OLiveQueryHookV2.notifyForTxChanges(this);
    }

    @Override
    protected void afterRollbackOperations() {
        super.afterRollbackOperations();
        OLiveQueryHook.removePendingDatabaseOps(this);
        OLiveQueryHookV2.removePendingDatabaseOps(this);
    }
}

