/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OResettable;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.Iterator;

public class OLazyRecordIterator
implements OLazyIterator<OIdentifiable>,
OResettable {
    private final ORecord sourceRecord;
    private final Iterable<? extends OIdentifiable> source;
    private Iterator<? extends OIdentifiable> underlying;
    private final boolean autoConvert2Record;

    public OLazyRecordIterator(Iterator<? extends OIdentifiable> iIterator, boolean iConvertToRecord) {
        this.sourceRecord = null;
        this.underlying = iIterator;
        this.autoConvert2Record = iConvertToRecord;
        this.source = null;
    }

    public OLazyRecordIterator(ORecord iSourceRecord, Iterator<? extends OIdentifiable> iIterator, boolean iConvertToRecord) {
        this.sourceRecord = iSourceRecord;
        this.underlying = iIterator;
        this.autoConvert2Record = iConvertToRecord;
        this.source = null;
    }

    public OLazyRecordIterator(Iterable<? extends OIdentifiable> iSource, boolean iConvertToRecord) {
        this.sourceRecord = null;
        this.autoConvert2Record = iConvertToRecord;
        this.source = iSource;
        this.underlying = iSource.iterator();
    }

    @Override
    public OIdentifiable next() {
        OIdentifiable value = this.underlying.next();
        if (value == null) {
            return null;
        }
        if (value instanceof ORecordId && this.autoConvert2Record && ODatabaseRecordThreadLocal.instance().isDefined()) {
            try {
                Object rec = ((ORecordId)value).getRecord();
                if (this.sourceRecord != null && rec != null) {
                    ORecordInternal.track(this.sourceRecord, rec);
                }
                if (this.underlying instanceof OLazyIterator) {
                    ((OLazyIterator)this.underlying).update(rec);
                }
                value = rec;
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error on iterating record collection", e, new Object[0]);
                value = null;
            }
        }
        return value;
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public OIdentifiable update(OIdentifiable iValue) {
        if (this.underlying instanceof OLazyIterator) {
            OIdentifiable old = ((OLazyIterator)this.underlying).update(iValue);
            if (this.sourceRecord != null && !old.equals(iValue)) {
                this.sourceRecord.setDirty();
            }
            return old;
        }
        throw new UnsupportedOperationException("Underlying iterator not supports lazy updates (Interface OLazyIterator");
    }

    @Override
    public void remove() {
        this.underlying.remove();
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    @Override
    public void reset() {
        if (this.underlying instanceof OResettable) {
            ((OResettable)((Object)this.underlying)).reset();
        } else if (this.source != null) {
            this.underlying = this.source.iterator();
        }
    }
}

