/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.engine.memory;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.engine.OEngineAbstract;
import com.orientechnologies.orient.core.engine.OMemoryAndLocalPaginatedEnginesInitializer;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.memory.ODirectMemoryStorage;
import java.util.Map;

public class OEngineMemory
extends OEngineAbstract {
    public static final String NAME = "memory";

    @Override
    public OStorage createStorage(String url, Map<String, String> configuration, long maxWalSegSize, int storageId) {
        try {
            return new ODirectMemoryStorage(url, url, this.getMode(configuration), storageId);
        }
        catch (Exception e) {
            String message = "Error on opening in memory storage: " + url;
            OLogManager.instance().error(this, message, e, new Object[0]);
            throw OException.wrapException(new ODatabaseException(message), e);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getNameFromPath(String dbPath) {
        return OIOUtils.getRelativePathIfAny(dbPath, null);
    }

    @Override
    public void startup() {
        OMemoryAndLocalPaginatedEnginesInitializer.INSTANCE.initialize();
        super.startup();
    }
}

