/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.OIndexUpdateAction;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OIndexRIDContainer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OMixedIndexRIDContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public abstract class OIndexMultiValues
extends OIndexAbstract<Collection<ORID>> {
    OIndexMultiValues(String name, String type, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata, int binaryFormatVersion) {
        super(name, type, algorithm, valueContainerAlgorithm, metadata, version, storage, binaryFormatVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ORID> get(Object key) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            Collection values;
            while (true) {
                try {
                    values = (Collection)this.storage.getIndexValue(this.indexId, key);
                }
                catch (OInvalidIndexEngineIdException ignore) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
            if (values == null) {
                List<ORID> list = Collections.emptyList();
                return list;
            }
            Collection collection = values;
            return collection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(Object key) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            Collection values;
            while (true) {
                try {
                    values = (Collection)this.storage.getIndexValue(this.indexId, key);
                }
                catch (OInvalidIndexEngineIdException ignore) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
            if (values == null) {
                long l = 0L;
                return l;
            }
            long l = values.size();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexMultiValues put(Object key, OIdentifiable singleValue) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            if (!singleValue.getIdentity().isValid()) {
                singleValue.getRecord().save();
            }
            ORID identity = singleValue.getIdentity();
            if (this.apiVersion == 0) {
                this.doPutV0(key, identity);
            } else if (this.apiVersion == 1) {
                this.doPutV1(key, identity);
            } else {
                throw new IllegalStateException("Invalid API version, " + this.apiVersion);
            }
            OIndexMultiValues oIndexMultiValues = this;
            return oIndexMultiValues;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private void doPutV0(Object key, ORID identity) {
        OIndexKeyUpdater<Object> creator = (oldValue, bonsayFileId) -> {
            Set<OIdentifiable> toUpdate = (Set<OIdentifiable>)oldValue;
            if (toUpdate == null) {
                if ("SBTREEBONSAISET".equals(this.valueContainerAlgorithm)) {
                    toUpdate = this.binaryFormatVersion >= 13 ? new OMixedIndexRIDContainer(this.getName(), bonsayFileId) : new OIndexRIDContainer(this.getName(), true, bonsayFileId);
                } else {
                    throw new IllegalStateException("MVRBTree is not supported any more");
                }
            }
            if (toUpdate instanceof OIndexRIDContainer) {
                boolean isTree = !((OIndexRIDContainer)toUpdate).isEmbedded();
                toUpdate.add(identity);
                if (isTree) {
                    return OIndexUpdateAction.nothing();
                }
                return OIndexUpdateAction.changed(toUpdate);
            }
            if (toUpdate instanceof OMixedIndexRIDContainer) {
                OMixedIndexRIDContainer ridContainer = (OMixedIndexRIDContainer)toUpdate;
                boolean embeddedWasUpdated = ridContainer.addEntry(identity);
                if (!embeddedWasUpdated) {
                    return OIndexUpdateAction.nothing();
                }
                return OIndexUpdateAction.changed(toUpdate);
            }
            if (toUpdate.add(identity)) {
                return OIndexUpdateAction.changed(toUpdate);
            }
            return OIndexUpdateAction.nothing();
        };
        while (true) {
            try {
                this.storage.updateIndexEntry(this.indexId, key, creator);
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    private void doPutV1(Object key, ORID identity) {
        while (true) {
            try {
                this.storage.putRidIndexEntry(this.indexId, key, identity);
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    @Override
    public boolean remove(Object key, OIdentifiable value) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            if (this.apiVersion == 0) {
                boolean bl = this.doRemoveV0(key, value);
                return bl;
            }
            if (this.apiVersion == 1) {
                boolean bl = this.doRemoveV1(key, value);
                return bl;
            }
            throw new IllegalStateException("Invalid API version, " + this.apiVersion);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private boolean doRemoveV0(Object key, OIdentifiable value) {
        Set values;
        while (true) {
            try {
                values = (Set)this.storage.getIndexValue(this.indexId, key);
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        if (values == null) {
            return false;
        }
        OModifiableBoolean removed = new OModifiableBoolean(false);
        EntityRemover creator = new EntityRemover(value, removed);
        while (true) {
            try {
                this.storage.updateIndexEntry(this.indexId, key, creator);
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        return removed.getValue();
    }

    private boolean doRemoveV1(Object key, OIdentifiable value) {
        while (true) {
            try {
                return this.storage.removeRidIndexEntry(this.indexId, key, value.getIdentity());
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OIndexMultiValues)super.create(indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, this.determineValueSerializer());
    }

    @Override
    protected OBinarySerializer determineValueSerializer() {
        if (this.binaryFormatVersion >= 13) {
            return this.storage.getComponentsFactory().binarySerializerFactory.getObjectSerializer((byte)23);
        }
        return this.storage.getComponentsFactory().binarySerializerFactory.getObjectSerializer((byte)21);
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesBetween(this.indexId, fromKey, fromInclusive, toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesMajor(this.indexId, fromKey, fromInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesMinor(this.indexId, toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys2, boolean ascSortOrder) {
        final ArrayList sortedKeys = new ArrayList(keys2);
        Comparator<Object> comparator = ascSortOrder ? ODefaultComparator.INSTANCE : Collections.reverseOrder(ODefaultComparator.INSTANCE);
        sortedKeys.sort(comparator);
        return new OIndexAbstractCursor(){
            private final Iterator<?> keysIterator;
            private Iterator<ORID> currentIterator;
            private Object currentKey;
            {
                this.keysIterator = sortedKeys.iterator();
                this.currentIterator = OEmptyIterator.IDENTIFIABLE_INSTANCE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (this.currentIterator == null) {
                    return null;
                }
                Object key = null;
                if (!this.currentIterator.hasNext()) {
                    Collection result = null;
                    block5: while (this.keysIterator.hasNext() && (result == null || result.isEmpty())) {
                        key = this.keysIterator.next();
                        key = OIndexMultiValues.this.getCollatingValue(key);
                        OIndexMultiValues.this.acquireSharedLock();
                        try {
                            while (true) {
                                try {
                                    result = (Collection)OIndexMultiValues.this.storage.getIndexValue(OIndexMultiValues.this.indexId, key);
                                    continue block5;
                                }
                                catch (OInvalidIndexEngineIdException ignore) {
                                    OIndexMultiValues.this.doReloadIndexEngine();
                                    continue;
                                }
                                break;
                            }
                        }
                        finally {
                            OIndexMultiValues.this.releaseSharedLock();
                        }
                    }
                    if (result == null || result.isEmpty()) {
                        this.currentIterator = null;
                        return null;
                    }
                    this.currentKey = key;
                    this.currentIterator = result.iterator();
                }
                final OIdentifiable resultValue = this.currentIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return currentKey;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return resultValue;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException("setValue");
                    }
                };
            }
        };
    }

    @Override
    public long getSize() {
        this.acquireSharedLock();
        while (true) {
            try {
                long l = this.storage.getIndexSize(this.indexId, MultiValuesTransformer.INSTANCE);
                return l;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getKeySize() {
        this.acquireSharedLock();
        while (true) {
            try {
                long l = this.storage.getIndexSize(this.indexId, null);
                return l;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor cursor() {
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.getIndexCursor(this.indexId, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor descCursor() {
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.getIndexDescCursor(this.indexId, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static class EntityRemover
    implements OIndexKeyUpdater<Object> {
        private final OIdentifiable value;
        private final OModifiableBoolean removed;

        EntityRemover(OIdentifiable value, OModifiableBoolean removed) {
            this.value = value;
            this.removed = removed;
        }

        @Override
        public OIndexUpdateAction<Object> update(Object persistentValue, AtomicLong bonsayFileId) {
            Set values = (Set)persistentValue;
            if (this.value == null) {
                this.removed.setValue(true);
                return OIndexUpdateAction.remove();
            }
            if (values.remove(this.value)) {
                this.removed.setValue(true);
                if (values.isEmpty()) {
                    return OIndexUpdateAction.remove();
                }
                return OIndexUpdateAction.changed(values);
            }
            return OIndexUpdateAction.changed(values);
        }
    }

    private static final class MultiValuesTransformer
    implements OBaseIndexEngine.ValuesTransformer {
        private static final MultiValuesTransformer INSTANCE = new MultiValuesTransformer();

        private MultiValuesTransformer() {
        }

        @Override
        public Collection<ORID> transformFromValue(Object value) {
            return (Collection)value;
        }
    }
}

