/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassAbstractDelegate;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OPropertyRemote;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.List;

public class OClassRemote
extends OClassImpl {
    protected OClassRemote(OSchemaShared iOwner, String iName) {
        super(iOwner, iName);
    }

    protected OClassRemote(OSchemaShared iOwner, String iName, int[] iClusterIds) {
        super(iOwner, iName, iClusterIds);
    }

    protected OClassRemote(OSchemaShared iOwner, ODocument iDocument, String iName) {
        super(iOwner, iDocument, iName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OProperty addProperty(String propertyName, OType type, OType linkedType, OClass linkedClass, boolean unsafe) {
        if (type == null) {
            throw new OSchemaException("Property type not defined.");
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new OSchemaException("Property name is null or empty");
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        this.validatePropertyName(propertyName);
        if (database.getTransaction().isActive()) {
            throw new OSchemaException("Cannot create property '" + propertyName + "' inside a transaction");
        }
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (linkedType != null) {
            OPropertyImpl.checkLinkTypeSupport(type);
        }
        if (linkedClass != null) {
            OPropertyImpl.checkSupportLinkedClass(type);
        }
        this.acquireSchemaWriteLock();
        try {
            StringBuilder cmd = new StringBuilder("create property ");
            cmd.append('`');
            cmd.append(this.name);
            cmd.append('`');
            cmd.append('.');
            cmd.append('`');
            cmd.append(propertyName);
            cmd.append('`');
            cmd.append(' ');
            cmd.append(type.name);
            if (linkedType != null) {
                cmd.append(' ');
                cmd.append(linkedType.name);
            } else if (linkedClass != null) {
                cmd.append(' ');
                cmd.append('`');
                cmd.append(linkedClass.getName());
                cmd.append('`');
            }
            if (unsafe) {
                cmd.append(" unsafe ");
            }
            database.command(cmd.toString(), new Object[0]).close();
            this.reload();
            OProperty oProperty = this.getProperty(propertyName);
            return oProperty;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClassImpl setEncryption(String iValue) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter class `%s` encryption %s", this.name, iValue);
            database.command(cmd, new Object[0]);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setClusterSelection(String value) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter class `%s` clusterselection '%s'", this.name, value);
            database.command(cmd, new Object[0]).close();
            OClassRemote oClassRemote = this;
            return oClassRemote;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClassImpl setCustom(String name, String value) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter class `%s` custom %s = ?", this.getName(), name);
            database.command(cmd, value).close();
            OClassRemote oClassRemote = this;
            return oClassRemote;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public void clearCustom() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter class `%s` custom clear", this.getName());
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setSuperClasses(List<? extends OClass> classes) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (classes != null) {
            ArrayList<OClass> toCheck = new ArrayList<OClass>(classes);
            toCheck.add(this);
            OClassRemote.checkParametersConflict(toCheck);
        }
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            StringBuilder sb = new StringBuilder();
            if (classes != null && classes.size() > 0) {
                for (OClass oClass : classes) {
                    sb.append('`').append(oClass.getName()).append("`,");
                }
                sb.deleteCharAt(sb.length() - 1);
            } else {
                sb.append("null");
            }
            String cmd = String.format("alter class `%s` superclasses %s", this.name, sb);
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass addSuperClass(OClass superClass) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.checkParametersConflict(superClass);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter class `%s` superclass +`%s`", this.name, superClass != null ? superClass.getName() : null);
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass removeSuperClass(OClass superClass) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter class `%s` superclass -`%s`", this.name, superClass != null ? superClass.getName() : null);
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setName(String name) {
        if (this.getName().equals(name)) {
            return this;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid(name);
        OClass oClass = database.getMetadata().getSchema().getClass(name);
        if (oClass != null) {
            String error = String.format("Cannot rename class %s to %s. A Class with name %s exists", this.name, name, name);
            throw new OSchemaException(error);
        }
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in class name '" + name + "'");
        }
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter class `%s` name `%s`", this.name, name);
            database.command(cmd, new Object[0]);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setShortName(String shortName) {
        if (shortName != null && (shortName = shortName.trim()).isEmpty()) {
            shortName = null;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter class `%s` shortname `%s`", this.name, shortName);
            database.command(cmd, new Object[0]);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    protected OPropertyImpl createPropertyInstance(ODocument p) {
        return new OPropertyRemote((OClassImpl)this, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass truncateCluster(String clusterName) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_DELETE, (Object)this.name);
        this.acquireSchemaReadLock();
        try {
            String cmd = String.format("truncate cluster %s", clusterName);
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaReadLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setStrictMode(boolean isStrict) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter class `%s` strictmode %s", this.name, isStrict);
            database.command(cmd, new Object[0]);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setDescription(String iDescription) {
        if (iDescription != null && (iDescription = iDescription.trim()).isEmpty()) {
            iDescription = null;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter class `%s` description ?", this.name);
            database.command(cmd, iDescription).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass addClusterId(int clusterId) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.isAbstract()) {
            throw new OSchemaException("Impossible to associate a cluster to an abstract class class");
        }
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter class `%s` addcluster %d", this.name, clusterId);
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass removeClusterId(int clusterId) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.clusterIds.length == 1 && clusterId == this.clusterIds[0]) {
            throw new ODatabaseException(" Impossible to remove the last cluster of class '" + this.getName() + "' drop the class instead");
        }
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter class `%s` removecluster %d", this.name, clusterId);
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public void dropProperty(String propertyName) {
        ODatabaseDocumentInternal database = this.getDatabase();
        if (database.getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop a property inside a transaction");
        }
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (!this.properties.containsKey(propertyName)) {
                throw new OSchemaException("Property '" + propertyName + "' not found in class " + this.name + "'");
            }
            database.command("drop property " + this.name + '.' + propertyName, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass addCluster(String clusterNameOrId) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.isAbstract()) {
            throw new OSchemaException("Impossible to associate a cluster to an abstract class class");
        }
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter class `%s` addcluster `%s`", this.name, clusterNameOrId);
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setOverSize(float overSize) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter class `%s` oversize %s", this.name, new Float(overSize).toString());
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setAbstract(boolean isAbstract) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter class `%s` abstract %s", this.name, isAbstract);
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    protected OClass removeBaseClassInternal(OClass baseClass) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            if (this.subclasses == null) {
                OClassRemote oClassRemote = this;
                return oClassRemote;
            }
            if (this.subclasses.remove(baseClass)) {
                this.removePolymorphicClusterIds((OClassImpl)baseClass);
            }
            OClassRemote oClassRemote = this;
            return oClassRemote;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    protected void setSuperClassesInternal(List<? extends OClass> classes) {
        ArrayList<OClassImpl> newSuperClasses = new ArrayList<OClassImpl>();
        for (OClass oClass : classes) {
            OClassImpl cls = oClass instanceof OClassAbstractDelegate ? (OClassImpl)((OClassAbstractDelegate)oClass).delegate : (OClassImpl)oClass;
            if (newSuperClasses.contains(cls)) {
                throw new OSchemaException("Duplicated superclass '" + cls.getName() + "'");
            }
            newSuperClasses.add(cls);
        }
        ArrayList toAddList = new ArrayList(newSuperClasses);
        toAddList.removeAll(this.superClasses);
        ArrayList arrayList = new ArrayList(this.superClasses);
        arrayList.removeAll(newSuperClasses);
        for (OClassImpl toRemove : arrayList) {
            toRemove.removeBaseClassInternal(this);
        }
        for (OClassImpl addTo : toAddList) {
            addTo.addBaseClass(this);
        }
        this.superClasses.clear();
        this.superClasses.addAll(newSuperClasses);
    }

    @Override
    public void setDefaultClusterId(int defaultClusterId) {
        ODatabaseDocumentInternal database = this.getDatabase();
        String clusterName = database.getClusterNameById(defaultClusterId);
        if (clusterName == null) {
            throw new OSchemaException("Cluster with id '" + defaultClusterId + "' does not exist");
        }
        String cmd = String.format("alter class `%s` DEFAULTCLUSTER `%s`", this.name, clusterName);
        database.command(cmd, new Object[0]).close();
    }
}

