/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OShortSerializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;

public class OCompactedLinkSerializer
implements OBinarySerializer<OIdentifiable> {
    public static final byte ID = 22;
    public static final OCompactedLinkSerializer INSTANCE = new OCompactedLinkSerializer();

    @Override
    public int getObjectSize(OIdentifiable rid, Object ... hints) {
        ORID r = rid.getIdentity();
        int size = 3;
        int zeroBits = Long.numberOfLeadingZeros(r.getClusterPosition());
        int zerosTillFullByte = zeroBits & 7;
        int numberSize = 8 - (zeroBits - zerosTillFullByte) / 8;
        return size += numberSize;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return stream[startPosition + 2] + 1 + 2;
    }

    @Override
    public void serialize(OIdentifiable rid, byte[] stream, int startPosition, Object ... hints) {
        ORID r = rid.getIdentity();
        int zeroBits = Long.numberOfLeadingZeros(r.getClusterPosition());
        int zerosTillFullByte = zeroBits & 7;
        int numberSize = 8 - (zeroBits - zerosTillFullByte) / 8;
        OBinaryProtocol.short2bytes((short)r.getClusterId(), stream, startPosition);
        stream[startPosition += 2] = (byte)numberSize;
        ++startPosition;
        long clusterPosition = r.getClusterPosition();
        for (int i = 0; i < numberSize; ++i) {
            stream[startPosition + i] = (byte)(0xFFL & clusterPosition);
            clusterPosition >>>= 8;
        }
    }

    @Override
    public OIdentifiable deserialize(byte[] stream, int startPosition) {
        short cluster = OBinaryProtocol.bytes2short(stream, startPosition);
        int numberSize = stream[startPosition += 2];
        ++startPosition;
        long position = 0L;
        for (int i = 0; i < numberSize; ++i) {
            position |= (long)((0xFF & stream[startPosition + i]) << i * 8);
        }
        return new ORecordId(cluster, position);
    }

    @Override
    public byte getId() {
        return 22;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }

    @Override
    public void serializeNativeObject(OIdentifiable rid, byte[] stream, int startPosition, Object ... hints) {
        ORID r = rid.getIdentity();
        OShortSerializer.INSTANCE.serializeNative((short)r.getClusterId(), stream, startPosition, new Object[0]);
        int zeroBits = Long.numberOfLeadingZeros(r.getClusterPosition());
        int zerosTillFullByte = zeroBits & 7;
        int numberSize = 8 - (zeroBits - zerosTillFullByte) / 8;
        stream[startPosition += 2] = (byte)numberSize;
        ++startPosition;
        long clusterPosition = r.getClusterPosition();
        for (int i = 0; i < numberSize; ++i) {
            stream[startPosition + i] = (byte)(0xFFL & clusterPosition);
            clusterPosition >>>= 8;
        }
    }

    @Override
    public OIdentifiable deserializeNativeObject(byte[] stream, int startPosition) {
        short cluster = OShortSerializer.INSTANCE.deserializeNativeObject(stream, startPosition);
        int numberSize = stream[startPosition += 2];
        ++startPosition;
        long position = 0L;
        for (int i = 0; i < numberSize; ++i) {
            position |= (long)((0xFF & stream[startPosition + i]) << i * 8);
        }
        return new ORecordId(cluster, position);
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return stream[startPosition + 2] + 1 + 2;
    }

    @Override
    public OIdentifiable preprocess(OIdentifiable value, Object ... hints) {
        return value.getIdentity();
    }

    @Override
    public void serializeInByteBufferObject(OIdentifiable rid, ByteBuffer buffer, Object ... hints) {
        ORID r = rid.getIdentity();
        buffer.putShort((short)r.getClusterId());
        int zeroBits = Long.numberOfLeadingZeros(r.getClusterPosition());
        int zerosTillFullByte = zeroBits & 7;
        int numberSize = 8 - (zeroBits - zerosTillFullByte) / 8;
        buffer.put((byte)numberSize);
        byte[] number = new byte[numberSize];
        long clusterPosition = r.getClusterPosition();
        for (int i = 0; i < numberSize; ++i) {
            number[i] = (byte)(0xFFL & clusterPosition);
            clusterPosition >>>= 8;
        }
        buffer.put(number);
    }

    @Override
    public OIdentifiable deserializeFromByteBufferObject(ByteBuffer buffer) {
        short cluster = buffer.getShort();
        int numberSize = buffer.get();
        byte[] number = new byte[numberSize];
        buffer.get(number);
        long position = 0L;
        for (int i = 0; i < numberSize; ++i) {
            position |= (long)((0xFF & number[i]) << i * 8);
        }
        return new ORecordId(cluster, position);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return buffer.get(buffer.position() + 2) + 1 + 2;
    }

    @Override
    public OIdentifiable deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        short cluster = walChanges.getShortValue(buffer, offset);
        int numberSize = walChanges.getByteValue(buffer, offset += 2);
        byte[] number = walChanges.getBinaryValue(buffer, ++offset, numberSize);
        long position = 0L;
        for (int i = 0; i < numberSize; ++i) {
            position |= (long)((0xFF & number[i]) << i * 8);
        }
        return new ORecordId(cluster, position);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return walChanges.getByteValue(buffer, offset + 2) + 1 + 2;
    }
}

