/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordFlat;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinaryV0;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinaryV1;
import java.util.Base64;

public class ORecordSerializerBinary
implements ORecordSerializer {
    public static final String NAME = "ORecordSerializerBinary";
    public static final ORecordSerializerBinary INSTANCE = new ORecordSerializerBinary();
    private static final byte CURRENT_RECORD_VERSION = 0;
    private ODocumentSerializer[] serializerByVersion;
    private final byte currentSerializerVersion;

    private void init() {
        this.serializerByVersion = new ODocumentSerializer[2];
        this.serializerByVersion[0] = new ORecordSerializerBinaryV0();
        this.serializerByVersion[1] = new ORecordSerializerBinaryV1();
    }

    public ORecordSerializerBinary(byte serializerVersion) {
        this.currentSerializerVersion = serializerVersion;
        this.init();
    }

    public ORecordSerializerBinary() {
        this.currentSerializerVersion = 0;
        this.init();
    }

    public int getNumberOfSupportedVersions() {
        return this.serializerByVersion.length;
    }

    @Override
    public int getCurrentVersion() {
        return this.currentSerializerVersion;
    }

    @Override
    public int getMinSupportedVersion() {
        return this.currentSerializerVersion;
    }

    public ODocumentSerializer getSerializer(int iVersion) {
        return this.serializerByVersion[iVersion];
    }

    public ODocumentSerializer getCurrentSerializer() {
        return this.serializerByVersion[this.currentSerializerVersion];
    }

    public String toString() {
        return NAME;
    }

    @Override
    public ORecord fromStream(byte[] iSource, ORecord iRecord, String[] iFields) {
        if (iSource == null || iSource.length == 0) {
            return iRecord;
        }
        if (iRecord == null) {
            iRecord = new ODocument();
        } else {
            if (iRecord instanceof OBlob) {
                iRecord.fromStream(iSource);
                return iRecord;
            }
            if (iRecord instanceof ORecordFlat) {
                iRecord.fromStream(iSource);
                return iRecord;
            }
        }
        BytesContainer container = new BytesContainer(iSource).skip(1);
        try {
            if (iFields != null && iFields.length > 0) {
                this.serializerByVersion[iSource[0]].deserializePartial((ODocument)iRecord, container, iFields);
            } else {
                this.serializerByVersion[iSource[0]].deserialize((ODocument)iRecord, container);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            OLogManager.instance().warn((Object)this, "Error deserializing record with id %s send this data for debugging: %s ", iRecord.getIdentity().toString(), Base64.getEncoder().encodeToString(iSource));
            throw e;
        }
        return iRecord;
    }

    @Override
    public byte[] toStream(ORecord iSource, boolean iOnlyDelta) {
        if (iSource instanceof OBlob) {
            return iSource.toStream();
        }
        if (iSource instanceof ORecordFlat) {
            return iSource.toStream();
        }
        BytesContainer container = new BytesContainer();
        int pos = container.alloc(1);
        container.bytes[pos] = this.currentSerializerVersion;
        this.serializerByVersion[this.currentSerializerVersion].serialize((ODocument)iSource, container, false);
        return container.fitBytes();
    }

    @Override
    public String[] getFieldNamesEmbedded(ODocument reference, byte[] iSource, int offset, int serializerVersion) {
        if (iSource == null || iSource.length == 0) {
            return new String[0];
        }
        BytesContainer container = new BytesContainer(iSource);
        container.skip(offset);
        try {
            return this.serializerByVersion[serializerVersion].getFieldNames(reference, container, this.serializerByVersion[serializerVersion].isSerializingClassNameForEmbedded());
        }
        catch (RuntimeException e) {
            OLogManager.instance().warn((Object)this, "Error deserializing record to get field-names, send this data for debugging: %s ", Base64.getEncoder().encodeToString(iSource));
            throw e;
        }
    }

    @Override
    public String[] getFieldNamesRoot(ODocument reference, byte[] iSource) {
        if (iSource == null || iSource.length == 0) {
            return new String[0];
        }
        BytesContainer container = new BytesContainer(iSource).skip(1);
        try {
            return this.serializerByVersion[iSource[0]].getFieldNames(reference, container, this.serializerByVersion[iSource[0]].isSerializingClassNameByDefault());
        }
        catch (RuntimeException e) {
            OLogManager.instance().warn((Object)this, "Error deserializing record to get field-names, send this data for debugging: %s ", Base64.getEncoder().encodeToString(iSource));
            throw e;
        }
    }

    @Override
    public byte[] writeClassOnly(ORecord iSource) {
        BytesContainer container = new BytesContainer();
        int pos = container.alloc(1);
        container.bytes[pos] = this.currentSerializerVersion;
        this.serializerByVersion[this.currentSerializerVersion].serializeWithClassName((ODocument)iSource, container, true);
        return container.fitBytes();
    }

    @Override
    public boolean getSupportBinaryEvaluate() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private <RET> RET deserializeField(byte[] record, int offset, String iFieldName, boolean isEmbedded, int serializerVersion) {
        BytesContainer bytes = new BytesContainer(record);
        int wantedSerializerVersion = serializerVersion;
        if (!isEmbedded && offset == 0) {
            wantedSerializerVersion = record[0];
            bytes = bytes.skip(1);
        } else if (isEmbedded) {
            bytes.skip(offset);
        }
        return this.serializerByVersion[wantedSerializerVersion].deserializeFieldTyped(bytes, iFieldName, isEmbedded, wantedSerializerVersion);
    }

    @Override
    public <RET> RET deserializeFieldFromRoot(byte[] record, String iFieldName) {
        return this.deserializeField(record, 0, iFieldName, false, -1);
    }

    @Override
    public <RET> RET deserializeFieldFromEmbedded(byte[] record, int offset, String iFieldName, int serializerVersion) {
        return this.deserializeField(record, offset, iFieldName, true, serializerVersion);
    }
}

