/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.string;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.fetch.OFetchPlan;
import com.orientechnologies.orient.core.fetch.json.OJSONFetchContext;
import com.orientechnologies.orient.core.fetch.json.OJSONFetchListener;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordStringable;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ORecordSerializerJSON
extends ORecordSerializerStringAbstract {
    public static final String NAME = "json";
    public static final ORecordSerializerJSON INSTANCE = new ORecordSerializerJSON();
    public static final String ATTRIBUTE_FIELD_TYPES = "@fieldTypes";
    public static final char[] PARAMETER_SEPARATOR = new char[]{':', ','};
    public static final int INITIAL_SIZE = 5000;
    private static final Long MAX_INT = Integer.MAX_VALUE;
    private static final Long MIN_INT = Integer.MIN_VALUE;
    private static final Double MAX_FLOAT = 3.4028234663852886E38;
    private static final Double MIN_FLOAT = 1.4E-45f;

    @Override
    public <RET> RET deserializeFieldFromRoot(byte[] record, String iFieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <RET> RET deserializeFieldFromEmbedded(byte[] record, int offset, String iFieldName, int serializerVersion) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getCurrentVersion() {
        return 0;
    }

    @Override
    public int getMinSupportedVersion() {
        return 0;
    }

    public ORecord fromString(String iSource, ORecord iRecord, String[] iFields, boolean needReload) {
        return this.fromString(iSource, iRecord, iFields, null, needReload);
    }

    @Override
    public ORecord fromString(String iSource, ORecord iRecord, String[] iFields) {
        return this.fromString(iSource, iRecord, iFields, null, false);
    }

    public ORecord fromString(String iSource, ORecord iRecord, String[] iFields, String iOptions, boolean needReload) {
        List<String> fields;
        iSource = this.unwrapSource(iSource);
        String className = null;
        boolean noMap = false;
        if (iOptions != null) {
            String[] format;
            for (String f : format = iOptions.split(",")) {
                if (!f.equalsIgnoreCase("noMap")) continue;
                noMap = true;
            }
        }
        if (iRecord != null) {
            iRecord.clear();
        }
        if ((fields = OStringSerializerHelper.smartSplit(iSource, PARAMETER_SEPARATOR, 0, -1, true, true, false, false, ' ', '\n', '\r', '\t')).size() % 2 != 0) {
            throw new OSerializationException("Error on unmarshalling JSON content: wrong format \"" + iSource + "\". Use <field> : <value>");
        }
        Map<String, Character> fieldTypes = null;
        if (fields != null && fields.size() > 0) {
            String fieldValueAsString;
            String fieldValue;
            int i;
            for (i = 0; i < fields.size(); i += 2) {
                String fieldName = OIOUtils.getStringContent(fields.get(i));
                fieldValue = fields.get(i + 1);
                fieldValueAsString = OIOUtils.getStringContent(fieldValue);
                if (fieldName.equals(ATTRIBUTE_FIELD_TYPES) && iRecord instanceof ODocument) {
                    fieldTypes = this.loadFieldTypes(fieldTypes, fieldValueAsString);
                    continue;
                }
                if (fieldName.equals("@type")) {
                    if (iRecord != null && ORecordInternal.getRecordType(iRecord) == fieldValueAsString.charAt(0)) continue;
                    iRecord = Orient.instance().getRecordFactoryManager().newInstance((byte)fieldValueAsString.charAt(0), -1, ODatabaseRecordThreadLocal.instance().getIfDefined());
                    continue;
                }
                if (needReload && fieldName.equals("@rid") && iRecord instanceof ODocument) {
                    ORecord localRecord;
                    if (fieldValue == null || fieldValue.length() <= 0 || (localRecord = (ORecord)ODatabaseRecordThreadLocal.instance().get().load(new ORecordId(fieldValueAsString))) == null) continue;
                    iRecord = localRecord;
                    continue;
                }
                if (!fieldName.equals("@class") || !(iRecord instanceof ODocument)) continue;
                className = "null".equals(fieldValueAsString) ? null : fieldValueAsString;
                ODocumentInternal.fillClassNameIfNeeded((ODocument)iRecord, className);
            }
            if (iRecord == null) {
                iRecord = new ODocument();
            }
            try {
                for (i = 0; i < fields.size(); i += 2) {
                    String fieldName = OIOUtils.getStringContent(fields.get(i));
                    fieldValue = fields.get(i + 1);
                    fieldValueAsString = OIOUtils.getStringContent(fieldValue);
                    if (fieldName.equals("@rid")) {
                        ORecordInternal.setIdentity(iRecord, new ORecordId(fieldValueAsString));
                        continue;
                    }
                    if (fieldName.equals("@version")) {
                        ORecordInternal.setVersion(iRecord, Integer.parseInt(fieldValue));
                        continue;
                    }
                    if (fieldName.equals("@class") || fieldName.equals("@type") || fieldName.equals(ATTRIBUTE_FIELD_TYPES) && iRecord instanceof ODocument) continue;
                    if (fieldName.equals("value") && !(iRecord instanceof ODocument)) {
                        if ("null".equals(fieldValue)) {
                            iRecord.fromStream(OCommonConst.EMPTY_BYTE_ARRAY);
                            continue;
                        }
                        if (iRecord instanceof OBlob) {
                            iRecord.fromStream(Base64.getDecoder().decode(fieldValueAsString));
                            continue;
                        }
                        if (iRecord instanceof ORecordStringable) {
                            ((ORecordStringable)((Object)iRecord)).value(fieldValueAsString);
                            continue;
                        }
                        throw new IllegalArgumentException("unsupported type of record");
                    }
                    if (!(iRecord instanceof ODocument)) continue;
                    ODocument doc = (ODocument)iRecord;
                    OType type = this.determineType(doc, fieldName);
                    Object v = this.getValue(doc, fieldName, fieldValue, fieldValueAsString, type, null, fieldTypes, noMap, iOptions);
                    if (v != null) {
                        String className1;
                        Object first;
                        if (v instanceof Collection && !((Collection)v).isEmpty()) {
                            if (v instanceof ORecordLazyMultiValue) {
                                ((ORecordLazyMultiValue)v).setAutoConvertToRecord(false);
                            }
                            if (type == null && (first = ((Collection)v).iterator().next()) != null && first instanceof ORecord && !((ORecord)first).getIdentity().isValid()) {
                                OType oType = type = v instanceof Set ? OType.EMBEDDEDSET : OType.EMBEDDEDLIST;
                            }
                            if (type != null) {
                                doc.setProperty(fieldName, v, type);
                                continue;
                            }
                        } else if (v instanceof Map && !((Map)v).isEmpty()) {
                            first = ((Map)v).values().iterator().next();
                            if (first != null && first instanceof ORecord && !((ORecord)first).getIdentity().isValid()) {
                                doc.setProperty(fieldName, v, OType.EMBEDDEDMAP);
                                continue;
                            }
                        } else if (v instanceof ODocument && type != null && type.isLink() && (className1 = ((ODocument)v).getClassName()) != null && className1.length() > 0) {
                            ((ODocument)v).save();
                        }
                    }
                    if (type == null && fieldTypes != null && fieldTypes.containsKey(fieldName)) {
                        type = ORecordSerializerStringAbstract.getType(fieldValue, fieldTypes.get(fieldName).charValue());
                    }
                    if (v instanceof OTrackedSet) {
                        if (OMultiValue.getFirstValue((Set)v) instanceof OIdentifiable) {
                            type = OType.LINKSET;
                        }
                    } else if (v instanceof OTrackedList && OMultiValue.getFirstValue((List)v) instanceof OIdentifiable) {
                        type = OType.LINKLIST;
                    }
                    if (type != null) {
                        doc.setProperty(fieldName, v, type);
                        continue;
                    }
                    doc.setProperty(fieldName, v);
                }
                if (className != null) {
                    ((ODocument)iRecord).setClassName(className);
                }
            }
            catch (Exception e) {
                if (iRecord.getIdentity().isValid()) {
                    throw OException.wrapException(new OSerializationException("Error on unmarshalling JSON content for record " + iRecord.getIdentity()), e);
                }
                throw OException.wrapException(new OSerializationException("Error on unmarshalling JSON content for record: " + iSource), e);
            }
        }
        return iRecord;
    }

    @Override
    public byte[] writeClassOnly(ORecord iSource) {
        return new byte[0];
    }

    @Override
    public StringBuilder toString(ORecord iRecord, StringBuilder iOutput, String iFormat, boolean iOnlyDelta, boolean autoDetectCollectionType) {
        try {
            StringWriter buffer = new StringWriter(5000);
            OJSONWriter json = new OJSONWriter(buffer, iFormat);
            FormatSettings settings = new FormatSettings(iFormat);
            json.beginObject();
            OJSONFetchContext context = new OJSONFetchContext(json, settings);
            context.writeSignature(json, iRecord);
            if (iRecord instanceof ODocument) {
                OFetchPlan fp = OFetchHelper.buildFetchPlan(settings.fetchPlan);
                OFetchHelper.fetch(iRecord, null, fp, new OJSONFetchListener(), context, iFormat);
            } else if (iRecord instanceof ORecordStringable) {
                ORecordStringable record = (ORecordStringable)((Object)iRecord);
                json.writeAttribute(settings.indentLevel, true, "value", record.value());
            } else if (iRecord instanceof OBlob) {
                OBlob record = (OBlob)iRecord;
                json.writeAttribute(settings.indentLevel, true, "value", Base64.getEncoder().encodeToString(record.toStream()));
            } else {
                throw new OSerializationException("Error on marshalling record of type '" + iRecord.getClass() + "' to JSON. The record type cannot be exported to JSON");
            }
            json.endObject(settings.indentLevel, true);
            iOutput.append(buffer);
            return iOutput;
        }
        catch (IOException e) {
            throw OException.wrapException(new OSerializationException("Error on marshalling of record to JSON"), e);
        }
    }

    public String toString() {
        return NAME;
    }

    private OType determineType(ODocument doc, String fieldName) {
        OProperty prop;
        OType type = null;
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(doc);
        if (cls != null && (prop = cls.getProperty(fieldName)) != null) {
            type = prop.getType();
        }
        return type;
    }

    private Map<String, Character> loadFieldTypes(Map<String, Character> fieldTypes, String fieldValueAsString) {
        String[] fieldTypesParts = fieldValueAsString.split(",");
        if (fieldTypesParts.length > 0) {
            fieldTypes = new HashMap<String, Character>();
            for (String f : fieldTypesParts) {
                String[] part = f.split("=");
                if (part.length != 2) continue;
                fieldTypes.put(part[0], Character.valueOf(part[1].charAt(0)));
            }
        }
        return fieldTypes;
    }

    private String unwrapSource(String iSource) {
        if (iSource == null) {
            throw new OSerializationException("Error on unmarshalling JSON content: content is null");
        }
        if (!(iSource = iSource.trim()).startsWith("{") || !iSource.endsWith("}")) {
            throw new OSerializationException("Error on unmarshalling JSON content '" + iSource + "': content must be between { }");
        }
        iSource = iSource.substring(1, iSource.length() - 1).trim();
        return iSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getValue(ODocument iRecord, String iFieldName, String iFieldValue, String iFieldValueAsString, OType iType, OType iLinkedType, Map<String, Character> iFieldTypes, boolean iNoMap, String iOptions) {
        block40: {
            Character c;
            block41: {
                OProperty p;
                if (iFieldValue.equals("null")) {
                    return null;
                }
                if (iFieldName != null && ODocumentInternal.getImmutableSchemaClass(iRecord) != null && (p = ODocumentInternal.getImmutableSchemaClass(iRecord).getProperty(iFieldName)) != null) {
                    iType = p.getType();
                    iLinkedType = p.getLinkedType();
                }
                if (iType == null && iFieldTypes != null && iFieldTypes.containsKey(iFieldName)) {
                    iType = ORecordSerializerStringAbstract.getType(iFieldValue, iFieldTypes.get(iFieldName).charValue());
                }
                if (iFieldValue.startsWith("{") && iFieldValue.endsWith("}")) {
                    return this.getValueAsObjectOrMap(iRecord, iFieldValue, iType, iLinkedType, iFieldTypes, iNoMap, iOptions);
                }
                if (iFieldValue.startsWith("[") && iFieldValue.endsWith("]")) {
                    return this.getValueAsCollection(iRecord, iFieldValue, iType, iLinkedType, iFieldTypes, iNoMap, iOptions);
                }
                if (iType != null && iType != OType.ANY) break block40;
                if (iFieldValue.charAt(0) == '\"' || iFieldValue.charAt(0) == '\'') break block41;
                if (iFieldValue.equalsIgnoreCase("false") || iFieldValue.equalsIgnoreCase("true")) {
                    iType = OType.BOOLEAN;
                    break block40;
                } else {
                    c = null;
                    if (iFieldTypes != null && (c = iFieldTypes.get(iFieldName)) != null) {
                        iType = ORecordSerializerStringAbstract.getType(iFieldValue + c);
                    }
                    if (c == null && !iFieldValue.isEmpty()) {
                        if (ORecordId.isA(iFieldValue)) {
                            iType = OType.LINK;
                            break block40;
                        } else {
                            if (iFieldValue.matches(".*[\\.Ee].*")) {
                                return new Double(OIOUtils.getStringContent(iFieldValue));
                            }
                            Long v = new Long(OIOUtils.getStringContent(iFieldValue));
                            if (!this.canBeTrunkedToInt(v)) return v;
                            return v.intValue();
                        }
                    }
                }
                break block40;
            }
            if (iFieldValue.startsWith("{") && iFieldValue.endsWith("}")) {
                iType = OType.EMBEDDED;
            } else {
                if (ORecordId.isA(iFieldValueAsString)) {
                    iType = OType.LINK;
                }
                if (iFieldTypes != null && (c = iFieldTypes.get(iFieldName)) != null) {
                    iType = ORecordSerializerStringAbstract.getType(iFieldValueAsString, c.charValue());
                }
                if (iType == null) {
                    iType = OType.STRING;
                }
            }
        }
        if (iType == null) {
            return iFieldValueAsString;
        }
        switch (iType) {
            case STRING: {
                return this.decodeJSON(iFieldValueAsString);
            }
            case LINK: {
                int pos = iFieldValueAsString.indexOf(64);
                if (pos <= -1) return new ORecordId(iFieldValueAsString);
                return new ODocument(iFieldValueAsString.substring(1, pos), new ORecordId(iFieldValueAsString.substring(pos + 1)));
            }
            case EMBEDDED: {
                return this.fromString(iFieldValueAsString);
            }
            case DATE: {
                if (iFieldValueAsString == null) return null;
                if (iFieldValueAsString.equals("")) {
                    return null;
                }
                try {
                    return Long.parseLong(iFieldValueAsString);
                }
                catch (NumberFormatException e) {
                    try {
                        return ODateHelper.getDateFormatInstance().parseObject(iFieldValueAsString);
                    }
                    catch (ParseException ex) {
                        OLogManager.instance().error(this, "Exception is suppressed, original exception is ", e, new Object[0]);
                        throw OException.wrapException(new OSerializationException("Unable to unmarshall date (format=" + ODateHelper.getDateFormat() + ") : " + iFieldValueAsString), ex);
                    }
                }
            }
            case DATETIME: {
                if (iFieldValueAsString == null) return null;
                if (iFieldValueAsString.equals("")) {
                    return null;
                }
                try {
                    return Long.parseLong(iFieldValueAsString);
                }
                catch (NumberFormatException e) {
                    try {
                        return ODateHelper.getDateTimeFormatInstance().parseObject(iFieldValueAsString);
                    }
                    catch (ParseException ex) {
                        OLogManager.instance().error(this, "Exception is suppressed, original exception is ", e, new Object[0]);
                        throw OException.wrapException(new OSerializationException("Unable to unmarshall datetime (format=" + ODateHelper.getDateTimeFormat() + ") : " + iFieldValueAsString), ex);
                    }
                }
            }
            case BINARY: {
                return OStringSerializerHelper.fieldTypeFromStream(iRecord, iType, iFieldValueAsString);
            }
            case CUSTOM: {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(iFieldValueAsString));
                    ObjectInputStream input = new ObjectInputStream(bais);
                    return input.readObject();
                }
                catch (IOException e) {
                    throw OException.wrapException(new OSerializationException("Error on custom field deserialization"), e);
                }
                catch (ClassNotFoundException e) {
                    throw OException.wrapException(new OSerializationException("Error on custom field deserialization"), e);
                }
            }
        }
        return OStringSerializerHelper.fieldTypeFromStream(iRecord, iType, iFieldValue);
    }

    private boolean canBeTrunkedToInt(Long v) {
        return v > 0L ? v.compareTo(MAX_INT) <= 0 : v.compareTo(MIN_INT) >= 0;
    }

    private boolean canBeTrunkedToFloat(Double v) {
        return v > 0.0 ? v.compareTo(MAX_FLOAT) <= 0 : v.compareTo(MIN_FLOAT) >= 0;
    }

    private Object getValueAsObjectOrMap(ODocument iRecord, String iFieldValue, OType iType, OType iLinkedType, Map<String, Character> iFieldTypes, boolean iNoMap, String iOptions) {
        String[] fields = OStringParser.getWords(iFieldValue.substring(1, iFieldValue.length() - 1), ":,", true);
        if (fields == null || fields.length == 0) {
            if (iNoMap) {
                ODocument res = new ODocument();
                ODocumentInternal.addOwner(res, iRecord);
                return res;
            }
            return new HashMap();
        }
        if (iNoMap || this.hasTypeField(fields)) {
            return this.getValueAsRecord(iRecord, iFieldValue, iType, iOptions, fields);
        }
        return this.getValueAsMap(iRecord, iFieldValue, iLinkedType, iFieldTypes, false, iOptions, fields);
    }

    private Object getValueAsMap(ODocument iRecord, String iFieldValue, OType iLinkedType, Map<String, Character> iFieldTypes, boolean iNoMap, String iOptions, String[] fields) {
        if (fields.length % 2 == 1) {
            throw new OSerializationException("Bad JSON format on map. Expected pairs of field:value but received '" + iFieldValue + "'");
        }
        LinkedHashMap<String, Object> embeddedMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < fields.length; i += 2) {
            String iFieldName = fields[i];
            if (iFieldName.length() >= 2) {
                iFieldName = iFieldName.substring(1, iFieldName.length() - 1);
            }
            iFieldValue = fields[i + 1];
            String valueAsString = OIOUtils.getStringContent(iFieldValue);
            embeddedMap.put(iFieldName, this.getValue(iRecord, null, iFieldValue, valueAsString, iLinkedType, null, iFieldTypes, iNoMap, iOptions));
        }
        return embeddedMap;
    }

    private Object getValueAsRecord(ODocument iRecord, String iFieldValue, OType iType, String iOptions, String[] fields) {
        ORecordId rid = new ORecordId(OIOUtils.getStringContent(this.getFieldValue("@rid", fields)));
        boolean shouldReload = rid.isTemporary();
        ODocument recordInternal = (ODocument)this.fromString(iFieldValue, new ODocument(), null, iOptions, shouldReload);
        if (this.shouldBeDeserializedAsEmbedded(recordInternal, iType)) {
            ODocumentInternal.addOwner(recordInternal, iRecord);
        } else {
            ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().getIfDefined();
            if (rid.isPersistent() && database != null) {
                ODocument documentToMerge = (ODocument)database.load(rid);
                documentToMerge.merge(recordInternal, false, false);
                return documentToMerge;
            }
        }
        return recordInternal;
    }

    private Object getValueAsCollection(ODocument iRecord, String iFieldValue, OType iType, OType iLinkedType, Map<String, Character> iFieldTypes, boolean iNoMap, String iOptions) {
        iFieldValue = iFieldValue.substring(1, iFieldValue.length() - 1);
        if (iType == OType.LINKBAG) {
            final ORidBag bag = new ORidBag();
            this.parseCollection(iRecord, iFieldValue, iType, OType.LINK, iFieldTypes, iNoMap, iOptions, new CollectionItemVisitor(){

                @Override
                public void visitItem(Object item) {
                    bag.add((OIdentifiable)item);
                }
            });
            return bag;
        }
        if (iType == OType.LINKSET) {
            return this.getValueAsLinkedCollection(new ORecordLazySet(iRecord), iRecord, iFieldValue, iType, iLinkedType, iFieldTypes, iNoMap, iOptions);
        }
        if (iType == OType.LINKLIST) {
            return this.getValueAsLinkedCollection(new ORecordLazyList(iRecord), iRecord, iFieldValue, iType, iLinkedType, iFieldTypes, iNoMap, iOptions);
        }
        if (iType == OType.EMBEDDEDSET) {
            return this.getValueAsEmbeddedCollection(new OTrackedSet<Object>(iRecord), iRecord, iFieldValue, iType, iLinkedType, iFieldTypes, iNoMap, iOptions);
        }
        return this.getValueAsEmbeddedCollection(new OTrackedList<Object>(iRecord), iRecord, iFieldValue, iType, iLinkedType, iFieldTypes, iNoMap, iOptions);
    }

    private Object getValueAsLinkedCollection(final Collection<OIdentifiable> collection, ODocument iRecord, String iFieldValue, OType iType, OType iLinkedType, Map<String, Character> iFieldTypes, boolean iNoMap, String iOptions) {
        this.parseCollection(iRecord, iFieldValue, iType, iLinkedType, iFieldTypes, iNoMap, iOptions, new CollectionItemVisitor(){

            @Override
            public void visitItem(Object item) {
                collection.add((OIdentifiable)item);
            }
        });
        return collection;
    }

    private Object getValueAsEmbeddedCollection(final Collection<Object> collection, ODocument iRecord, String iFieldValue, OType iType, OType iLinkedType, Map<String, Character> iFieldTypes, boolean iNoMap, String iOptions) {
        this.parseCollection(iRecord, iFieldValue, iType, iLinkedType, iFieldTypes, iNoMap, iOptions, new CollectionItemVisitor(){

            @Override
            public void visitItem(Object item) {
                collection.add(item);
            }
        });
        return collection;
    }

    private void parseCollection(ODocument iRecord, String iFieldValue, OType iType, OType iLinkedType, Map<String, Character> iFieldTypes, boolean iNoMap, String iOptions, CollectionItemVisitor visitor) {
        if (!iFieldValue.isEmpty()) {
            for (String item : OStringSerializerHelper.smartSplit(iFieldValue, ',', new char[0])) {
                String itemValue = item.trim();
                if (itemValue.length() == 0) continue;
                Object collectionItem = this.getValue(iRecord, null, itemValue, OIOUtils.getStringContent(itemValue), iLinkedType, null, iFieldTypes, iNoMap, iOptions);
                if (this.shouldBeDeserializedAsEmbedded(collectionItem, iType)) {
                    ODocumentInternal.addOwner((ODocument)collectionItem, iRecord);
                }
                visitor.visitItem(collectionItem);
            }
        }
    }

    private boolean shouldBeDeserializedAsEmbedded(Object record, OType iType) {
        return record instanceof ODocument && !((ODocument)record).getIdentity().isTemporary() && !((ODocument)record).getIdentity().isPersistent() && (iType == null || !iType.isLink());
    }

    private String decodeJSON(String iFieldValueAsString) {
        if (iFieldValueAsString == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(iFieldValueAsString.length());
        boolean quoting = false;
        for (char c : iFieldValueAsString.toCharArray()) {
            if (quoting) {
                if (c != '\\' && c != '\"' && c != '/') {
                    builder.append('\\');
                }
                builder.append(c);
                quoting = false;
                continue;
            }
            if (c == '\\') {
                quoting = true;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private boolean hasTypeField(String[] fields) {
        return this.hasField("@type", fields);
    }

    private boolean hasField(String field, String[] fields) {
        return this.getFieldValue(field, fields) != null;
    }

    private String getFieldValue(String field, String[] fields) {
        String doubleQuotes = "\"" + field + "\"";
        String singleQuotes = "'" + field + "'";
        for (int i = 0; i < fields.length; i += 2) {
            if (!fields[i].equals(doubleQuotes) && !fields[i].equals(singleQuotes)) continue;
            return fields[i + 1];
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getFieldNamesEmbedded(ODocument reference, byte[] iSource, int offset, int serializerVersion) {
        return this.getFieldNamesRoot(reference, iSource);
    }

    public static class FormatSettings {
        public boolean includeVer;
        public boolean includeType;
        public boolean includeId;
        public boolean includeClazz;
        public boolean attribSameRow;
        public boolean alwaysFetchEmbeddedDocuments;
        public int indentLevel;
        public String fetchPlan = null;
        public boolean keepTypes = true;
        public boolean dateAsLong = false;
        public boolean prettyPrint = false;

        public FormatSettings(String iFormat) {
            if (iFormat == null) {
                this.includeType = true;
                this.includeVer = true;
                this.includeId = true;
                this.includeClazz = true;
                this.attribSameRow = true;
                this.indentLevel = 0;
                this.fetchPlan = "";
                this.keepTypes = true;
                this.alwaysFetchEmbeddedDocuments = true;
            } else {
                this.includeType = false;
                this.includeVer = false;
                this.includeId = false;
                this.includeClazz = false;
                this.attribSameRow = false;
                this.alwaysFetchEmbeddedDocuments = false;
                this.indentLevel = 0;
                this.keepTypes = false;
                if (iFormat != null && !iFormat.isEmpty()) {
                    String[] format;
                    for (String f : format = iFormat.split(",")) {
                        if (f.equals("type")) {
                            this.includeType = true;
                            continue;
                        }
                        if (f.equals("rid")) {
                            this.includeId = true;
                            continue;
                        }
                        if (f.equals("version")) {
                            this.includeVer = true;
                            continue;
                        }
                        if (f.equals("class")) {
                            this.includeClazz = true;
                            continue;
                        }
                        if (f.equals("attribSameRow")) {
                            this.attribSameRow = true;
                            continue;
                        }
                        if (f.startsWith("indent")) {
                            this.indentLevel = Integer.parseInt(f.substring(f.indexOf(58) + 1));
                            continue;
                        }
                        if (f.startsWith("fetchPlan")) {
                            this.fetchPlan = f.substring(f.indexOf(58) + 1);
                            continue;
                        }
                        if (f.startsWith("keepTypes")) {
                            this.keepTypes = true;
                            continue;
                        }
                        if (f.startsWith("alwaysFetchEmbedded")) {
                            this.alwaysFetchEmbeddedDocuments = true;
                            continue;
                        }
                        if (f.startsWith("dateAsLong")) {
                            this.dateAsLong = true;
                            continue;
                        }
                        if (f.startsWith("prettyPrint")) {
                            this.prettyPrint = true;
                            continue;
                        }
                        if (f.startsWith("graph") || f.startsWith("shallow")) continue;
                        throw new IllegalArgumentException("Unrecognized JSON formatting option: " + f);
                    }
                }
            }
        }
    }

    private static interface CollectionItemVisitor {
        public void visitItem(Object var1);
    }
}

