/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestAbstract;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OStatementCache;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class OCommandExecutorSQLAbstract
extends OCommandExecutorAbstract {
    public static final String KEYWORD_FROM = "FROM";
    public static final String KEYWORD_LET = "LET";
    public static final String KEYWORD_WHERE = "WHERE";
    public static final String KEYWORD_LIMIT = "LIMIT";
    public static final String KEYWORD_SKIP = "SKIP";
    public static final String KEYWORD_OFFSET = "OFFSET";
    public static final String KEYWORD_TIMEOUT = "TIMEOUT";
    public static final String KEYWORD_LOCK = "LOCK";
    public static final String KEYWORD_RETURN = "RETURN";
    public static final String KEYWORD_KEY = "key";
    public static final String KEYWORD_RID = "rid";
    public static final String CLUSTER_PREFIX = "CLUSTER:";
    public static final String CLASS_PREFIX = "CLASS:";
    public static final String INDEX_PREFIX = "INDEX:";
    public static final String KEYWORD_UNSAFE = "UNSAFE";
    public static final String INDEX_VALUES_PREFIX = "INDEXVALUES:";
    public static final String INDEX_VALUES_ASC_PREFIX = "INDEXVALUESASC:";
    public static final String INDEX_VALUES_DESC_PREFIX = "INDEXVALUESDESC:";
    public static final String DICTIONARY_PREFIX = "DICTIONARY:";
    public static final String METADATA_PREFIX = "METADATA:";
    public static final String METADATA_SCHEMA = "SCHEMA";
    public static final String METADATA_INDEXMGR = "INDEXMANAGER";
    public static final String METADATA_STORAGE = "STORAGE";
    public static final String METADATA_DATABASE = "DATABASE";
    public static final String DEFAULT_PARAM_USER = "$user";
    protected long timeoutMs = OGlobalConfiguration.COMMAND_TIMEOUT.getValueAsLong();
    protected OCommandContext.TIMEOUT_STRATEGY timeoutStrategy = OCommandContext.TIMEOUT_STRATEGY.EXCEPTION;
    protected OStatement preParsedStatement;

    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.REPLICATE;
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    @Override
    protected void throwSyntaxErrorException(String iText) {
        throw new OCommandSQLParsingException(iText + ". Use " + this.getSyntax(), this.parserText, this.parserGetPreviousPosition());
    }

    protected void throwParsingException(String iText) {
        throw new OCommandSQLParsingException(iText, this.parserText, this.parserGetPreviousPosition());
    }

    protected void throwParsingException(String iText, Exception e) {
        throw OException.wrapException(new OCommandSQLParsingException(iText, this.parserText, this.parserGetPreviousPosition()), e);
    }

    protected boolean parseTimeout(String w) throws OCommandSQLParsingException {
        if (!w.equals(KEYWORD_TIMEOUT)) {
            return false;
        }
        String word = this.parserNextWord(true);
        try {
            this.timeoutMs = Long.parseLong(word);
        }
        catch (NumberFormatException ignore) {
            this.throwParsingException("Invalid TIMEOUT value set to '" + word + "' but it should be a valid long. Example: " + KEYWORD_TIMEOUT + " 3000");
        }
        if (this.timeoutMs < 0L) {
            this.throwParsingException("Invalid TIMEOUT: value set minor than ZERO. Example: TIMEOUT 10000");
        }
        if ((word = this.parserNextWord(true)) != null) {
            if (word.equals(OCommandContext.TIMEOUT_STRATEGY.EXCEPTION.toString())) {
                this.timeoutStrategy = OCommandContext.TIMEOUT_STRATEGY.EXCEPTION;
            } else if (word.equals(OCommandContext.TIMEOUT_STRATEGY.RETURN.toString())) {
                this.timeoutStrategy = OCommandContext.TIMEOUT_STRATEGY.RETURN;
            } else {
                this.parserGoBack();
            }
        }
        return true;
    }

    protected String parseLock() throws OCommandSQLParsingException {
        String lockStrategy = this.parserNextWord(true);
        if (!(lockStrategy.equalsIgnoreCase("DEFAULT") || lockStrategy.equalsIgnoreCase("NONE") || lockStrategy.equalsIgnoreCase("RECORD"))) {
            this.throwParsingException("Invalid LOCK value set to '" + lockStrategy + "' but it should be NONE (default) or RECORD. Example: " + KEYWORD_LOCK + " RECORD");
        }
        return lockStrategy;
    }

    protected Set<String> getInvolvedClustersOfClasses(Collection<String> iClassNames) {
        ODatabaseDocumentInternal db = OCommandExecutorSQLAbstract.getDatabase();
        HashSet<String> clusters = new HashSet<String>();
        for (String clazz : iClassNames) {
            OClass cls = ((OMetadataInternal)db.getMetadata()).getImmutableSchemaSnapshot().getClass(clazz);
            if (cls == null) continue;
            for (int clId : cls.getPolymorphicClusterIds()) {
                if (clId <= -1 || !this.checkClusterAccess(db, db.getClusterNameById(clId))) continue;
                clusters.add(db.getClusterNameById(clId).toLowerCase(Locale.ENGLISH));
            }
        }
        return clusters;
    }

    protected Set<String> getInvolvedClustersOfClusters(Collection<String> iClusterNames) {
        ODatabaseDocumentInternal db = OCommandExecutorSQLAbstract.getDatabase();
        HashSet<String> clusters = new HashSet<String>();
        for (String cluster : iClusterNames) {
            String c = cluster.toLowerCase(Locale.ENGLISH);
            if (!this.checkClusterAccess(db, c)) continue;
            clusters.add(c);
        }
        return clusters;
    }

    protected Set<String> getInvolvedClustersOfIndex(String iIndexName) {
        OClass cls;
        String clazz;
        ODatabaseDocumentInternal db = OCommandExecutorSQLAbstract.getDatabase();
        HashSet<String> clusters = new HashSet<String>();
        OMetadataInternal metadata = db.getMetadata();
        OIndex<?> idx = metadata.getIndexManager().getIndex(iIndexName);
        if (idx != null && idx.getDefinition() != null && (clazz = idx.getDefinition().getClassName()) != null && (cls = metadata.getImmutableSchemaSnapshot().getClass(clazz)) != null) {
            for (int clId : cls.getClusterIds()) {
                String clName = db.getClusterNameById(clId);
                if (clName == null) continue;
                clusters.add(clName.toLowerCase(Locale.ENGLISH));
            }
        }
        return clusters;
    }

    protected boolean checkClusterAccess(ODatabaseDocument db, String iClusterName) {
        return db.getUser() == null || db.getUser().checkIfAllowed(ORule.ResourceGeneric.CLUSTER, iClusterName, this.getSecurityOperationType()) != null;
    }

    protected void bindDefaultContextVariables() {
        if (this.context != null && OCommandExecutorSQLAbstract.getDatabase() != null && OCommandExecutorSQLAbstract.getDatabase().getUser() != null) {
            this.context.setVariable(DEFAULT_PARAM_USER, OCommandExecutorSQLAbstract.getDatabase().getUser().getIdentity());
        }
    }

    protected String preParse(String queryText, OCommandRequest iRequest) {
        boolean strict = OCommandExecutorSQLAbstract.getDatabase().getStorage().getConfiguration().isStrictSql();
        if (strict) {
            try {
                OStatement result;
                this.preParsedStatement = result = OStatementCache.get(queryText, OCommandExecutorSQLAbstract.getDatabase());
                if (iRequest instanceof OCommandRequestAbstract) {
                    Map<Object, Object> params = ((OCommandRequestAbstract)iRequest).getParameters();
                    StringBuilder builder = new StringBuilder();
                    result.toString(params, builder);
                    return builder.toString();
                }
                return result.toString();
            }
            catch (OCommandSQLParsingException sqlx) {
                throw sqlx;
            }
            catch (Exception e) {
                this.throwParsingException("Error parsing query: \n" + queryText + "\n" + e.getMessage(), e);
            }
        }
        return queryText;
    }

    protected String decodeClassName(String s) {
        return OClassImpl.decodeClassName(s);
    }
}

