/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORestrictedAccessHook;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.query.live.OLiveQueryListener;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSelect;
import com.orientechnologies.orient.core.sql.query.OLegacyResultSet;
import com.orientechnologies.orient.core.sql.query.OLiveResultListener;
import java.util.Map;
import java.util.Random;

public class OCommandExecutorSQLLiveSelect
extends OCommandExecutorSQLSelect
implements OLiveQueryListener {
    public static final String KEYWORD_LIVE_SELECT = "LIVE SELECT";
    private ODatabaseDocument execDb;
    private int token;
    private static final Random random = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Map<Object, Object> iArgs) {
        try {
            final ODatabaseDocumentInternal db = OCommandExecutorSQLLiveSelect.getDatabase();
            this.execInSeparateDatabase(new OCallable(){

                public Object call(Object iArgument) {
                    return OCommandExecutorSQLLiveSelect.this.execDb = db.copy();
                }
            });
            Random random = OCommandExecutorSQLLiveSelect.random;
            synchronized (random) {
                this.token = OCommandExecutorSQLLiveSelect.random.nextInt();
            }
            this.subscribeToLiveQuery(this.token, db);
            this.bindDefaultContextVariables();
            if (iArgs != null) {
                for (Map.Entry object : iArgs.entrySet()) {
                    this.context.setVariable(object.getKey().toString(), object.getValue());
                }
            }
            if (this.timeoutMs > 0L) {
                this.getContext().beginExecution(this.timeoutMs, this.timeoutStrategy);
            }
            ODocument result = new ODocument();
            result.field("token", this.token);
            ((OLegacyResultSet)this.getResult()).add(result);
            Object object = this.getResult();
            return object;
        }
        finally {
            if (this.request != null && this.request.getResultListener() != null) {
                this.request.getResultListener().end();
            }
        }
    }

    private void subscribeToLiveQuery(Integer token, ODatabaseInternal db) {
        OLiveQueryHook.subscribe(token, this, db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLiveResult(final ORecordOperation iOp) {
        ODatabaseDocumentInternal oldThreadLocal = ODatabaseRecordThreadLocal.instance().getIfDefined();
        this.execDb.activateOnCurrentThread();
        try {
            ORecord value = iOp.getRecord();
            if (!this.matchesTarget(value)) {
                return;
            }
            if (!this.matchesFilters(value)) {
                return;
            }
            if (!this.checkSecurity(value)) {
                return;
            }
        }
        finally {
            if (oldThreadLocal == null) {
                ODatabaseRecordThreadLocal.instance().remove();
            } else {
                ODatabaseRecordThreadLocal.instance().set(oldThreadLocal);
            }
        }
        final OCommandResultListener listener = this.request.getResultListener();
        if (listener instanceof OLiveResultListener) {
            this.execInSeparateDatabase(new OCallable(){

                public Object call(Object iArgument) {
                    OCommandExecutorSQLLiveSelect.this.execDb.activateOnCurrentThread();
                    ((OLiveResultListener)((Object)listener)).onLiveResult(OCommandExecutorSQLLiveSelect.this.token, iOp);
                    return null;
                }
            });
        }
    }

    protected void execInSeparateDatabase(OCallable iCallback) {
        ODatabaseDocumentInternal prevDb = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            iCallback.call(null);
        }
        finally {
            if (prevDb != null) {
                ODatabaseRecordThreadLocal.instance().set(prevDb);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    private boolean checkSecurity(OIdentifiable value) {
        try {
            this.execDb.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)((ODocument)value.getRecord()).getClassName());
        }
        catch (OSecurityException ignore) {
            return false;
        }
        return ORestrictedAccessHook.isAllowed((ODatabaseDocumentInternal)this.execDb, (ODocument)value.getRecord(), ORestrictedOperation.ALLOW_READ, false);
    }

    private boolean matchesFilters(OIdentifiable value) {
        if (this.compiledFilter == null || this.compiledFilter.getRootCondition() == null) {
            return true;
        }
        if (!(value instanceof ODocument)) {
            value = value.getRecord();
        }
        return !Boolean.FALSE.equals(this.compiledFilter.evaluate((ODocument)value, (ODocument)value, this.getContext()));
    }

    private boolean matchesTarget(OIdentifiable value) {
        String clusterName;
        if (!(value instanceof ODocument)) {
            return false;
        }
        String className = ((ODocument)value).getClassName();
        if (className == null) {
            return false;
        }
        OClass docClass = this.execDb.getMetadata().getSchema().getClass(className);
        if (docClass == null) {
            return false;
        }
        if (this.parsedTarget.getTargetClasses() != null) {
            for (String string : this.parsedTarget.getTargetClasses().keySet()) {
                if (!docClass.isSubClassOf(string)) continue;
                return true;
            }
        }
        if (this.parsedTarget.getTargetRecords() != null) {
            for (OIdentifiable oIdentifiable : this.parsedTarget.getTargetRecords()) {
                if (!oIdentifiable.getIdentity().equals(value.getIdentity())) continue;
                return true;
            }
        }
        if (this.parsedTarget.getTargetClusters() != null && (clusterName = this.execDb.getClusterNameById(value.getIdentity().getClusterId())) != null) {
            for (String cluster : this.parsedTarget.getTargetClusters().keySet()) {
                if (!clusterName.equalsIgnoreCase(cluster)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onLiveResultEnd() {
        if (this.request.getResultListener() instanceof OLiveResultListener) {
            ((OLiveResultListener)((Object)this.request.getResultListener())).onUnsubscribe(this.token);
        }
        if (this.execDb != null) {
            ODatabaseDocumentInternal oldThreadDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
            this.execDb.activateOnCurrentThread();
            this.execDb.close();
            if (oldThreadDB == null) {
                ODatabaseRecordThreadLocal.instance().remove();
            } else {
                ODatabaseRecordThreadLocal.instance().set(oldThreadDB);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCommandExecutorSQLSelect parse(OCommandRequest iRequest) {
        OCommandRequestText requestText = (OCommandRequestText)iRequest;
        String originalText = requestText.getText();
        String remainingText = requestText.getText().trim().substring(5).trim();
        requestText.setText(remainingText);
        try {
            OCommandExecutorSQLSelect oCommandExecutorSQLSelect = super.parse(iRequest);
            return oCommandExecutorSQLSelect;
        }
        finally {
            requestText.setText(originalText);
        }
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }
}

