/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OBatch;
import java.util.Map;
import java.util.Optional;

public class BatchStep
extends AbstractExecutionStep {
    Integer batchSize;
    int count = 0;

    public BatchStep(OBatch batch, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.batchSize = batch.evaluate(ctx);
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet prevResult = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return prevResult.hasNext();
            }

            @Override
            public OResult next() {
                ODatabase db;
                OResult res = prevResult.next();
                if (BatchStep.this.count % BatchStep.this.batchSize == 0 && (db = ctx.getDatabase()).getTransaction().isActive()) {
                    db.commit();
                    db.begin();
                }
                ++BatchStep.this.count;
                return res;
            }

            @Override
            public void close() {
                BatchStep.this.getPrev().get().close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ BATCH COMMIT EVERY " + this.batchSize);
        return result.toString();
    }
}

