/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultSet;

public class SubQueryStep
extends AbstractExecutionStep {
    private final OInternalExecutionPlan subExecuitonPlan;
    private final OCommandContext childCtx;
    private boolean sameContextAsParent = false;

    public SubQueryStep(OInternalExecutionPlan subExecutionPlan, OCommandContext ctx, OCommandContext subCtx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.subExecuitonPlan = subExecutionPlan;
        this.childCtx = subCtx;
        this.sameContextAsParent = ctx == this.childCtx;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return this.subExecuitonPlan.fetchNext(nRecords);
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        StringBuilder builder = new StringBuilder();
        String ind = OExecutionStepInternal.getIndent(depth, indent);
        builder.append(ind);
        builder.append("+ FETCH FROM SUBQUERY \n");
        builder.append(this.subExecuitonPlan.prettyPrint(depth + 1, indent));
        return builder.toString();
    }

    @Override
    public boolean canBeCached() {
        return this.sameContextAsParent && this.subExecuitonPlan.canBeCached();
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new SubQueryStep(this.subExecuitonPlan.copy(ctx), ctx, ctx, this.profilingEnabled);
    }
}

