/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandPredicate;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemFieldAll;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemFieldAny;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorAnd;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorNot;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorOr;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OSQLPredicate
extends OBaseParser
implements OCommandPredicate {
    protected Set<OProperty> properties = new HashSet<OProperty>();
    protected OSQLFilterCondition rootCondition;
    protected List<String> recordTransformed;
    protected List<OSQLFilterItemParameter> parameterItems;
    protected int braces;
    protected OCommandContext context;

    public OSQLPredicate() {
    }

    public OSQLPredicate(String iText) {
        this.text(iText);
    }

    @Override
    protected void throwSyntaxErrorException(String iText) {
        String syntax = this.getSyntax();
        if (syntax.equals("?")) {
            throw new OCommandSQLParsingException(iText, this.parserText, this.parserGetPreviousPosition());
        }
        throw new OCommandSQLParsingException(iText + ". Use " + syntax, this.parserText, this.parserGetPreviousPosition());
    }

    protected String upperCase(String text) {
        StringBuilder result = new StringBuilder(text.length());
        for (char c : text.toCharArray()) {
            String upper = ("" + c).toUpperCase(Locale.ENGLISH);
            if (upper.length() > 1) {
                result.append(c);
                continue;
            }
            result.append(upper);
        }
        return result.toString();
    }

    public OSQLPredicate text(String iText) {
        if (iText == null) {
            throw new OCommandSQLParsingException("Query text is null");
        }
        try {
            this.parserText = iText;
            this.parserTextUpperCase = this.upperCase(this.parserText);
            this.parserSetCurrentPosition(0);
            this.parserSkipWhiteSpaces();
            this.rootCondition = (OSQLFilterCondition)this.extractConditions(null);
            this.optimize();
        }
        catch (OQueryParsingException e) {
            if (e.getText() == null) {
                throw OException.wrapException(new OQueryParsingException("Error on parsing query", this.parserText, this.parserGetCurrentPosition()), e);
            }
            throw e;
        }
        catch (Exception t) {
            throw OException.wrapException(new OQueryParsingException("Error on parsing query", this.parserText, this.parserGetCurrentPosition()), t);
        }
        return this;
    }

    public Object evaluate() {
        return this.evaluate(null, null, null);
    }

    public Object evaluate(OCommandContext iContext) {
        return this.evaluate(null, null, iContext);
    }

    @Override
    public Object evaluate(OIdentifiable iRecord, ODocument iCurrentResult, OCommandContext iContext) {
        if (this.rootCondition == null) {
            return true;
        }
        return this.rootCondition.evaluate(iRecord, iCurrentResult, iContext);
    }

    protected Object extractConditions(OSQLFilterCondition iParentCondition) {
        boolean inBraces;
        int oldPosition = this.parserGetCurrentPosition();
        this.parserNextWord(true, " )=><,\r\n");
        String word = this.parserGetLastWord();
        boolean bl = inBraces = word.length() > 0 && word.charAt(0) == '(';
        if (word.length() > 0 && (word.equalsIgnoreCase("SELECT") || word.equalsIgnoreCase("TRAVERSE"))) {
            StringBuilder embedded = new StringBuilder(256);
            OStringSerializerHelper.getEmbedded(this.parserText, oldPosition - 1, -1, embedded);
            this.parserSetCurrentPosition(oldPosition + embedded.length() + 1);
            return new OSQLSynchQuery(embedded.toString());
        }
        this.parserSetCurrentPosition(oldPosition);
        OSQLFilterCondition currentCondition = this.extractCondition();
        while (this.parserSkipWhiteSpaces()) {
            if (!this.parserIsEnded() && this.parserGetCurrentChar() == ')') {
                return currentCondition;
            }
            OQueryOperator nextOperator = this.extractConditionOperator();
            if (nextOperator == null) {
                return currentCondition;
            }
            if (nextOperator.precedence > currentCondition.getOperator().precedence) {
                OSQLFilterCondition subCondition = new OSQLFilterCondition(currentCondition.right, nextOperator);
                currentCondition.right = subCondition;
                subCondition.right = this.extractConditionItem(false, 1);
                continue;
            }
            OSQLFilterCondition parentCondition = new OSQLFilterCondition(currentCondition, nextOperator);
            parentCondition.right = this.extractConditions(parentCondition);
            currentCondition = parentCondition;
        }
        currentCondition.inBraces = inBraces;
        return currentCondition;
    }

    protected OSQLFilterCondition extractCondition() {
        Object right;
        OQueryOperator oper;
        if (!this.parserSkipWhiteSpaces()) {
            return null;
        }
        Object left = this.extractConditionItem(true, 1);
        if (left != null && this.checkForEnd(left.toString())) {
            return null;
        }
        if (left instanceof OQueryOperator && ((OQueryOperator)left).isUnary()) {
            oper = (OQueryOperator)left;
            left = this.extractConditionItem(false, 1);
            right = null;
        } else {
            oper = this.extractConditionOperator();
            if (oper instanceof OQueryOperatorNot) {
                oper = new OQueryOperatorNot(this.extractConditionOperator());
            }
            right = oper instanceof OQueryOperatorAnd || oper instanceof OQueryOperatorOr ? this.extractCondition() : (oper != null ? this.extractConditionItem(false, oper.expectedRightWords) : null);
        }
        return new OSQLFilterCondition(left, oper, right);
    }

    protected boolean checkForEnd(String iWord) {
        if (iWord != null && (iWord.equals("ORDER") || iWord.equals("LIMIT") || iWord.equals("SKIP") || iWord.equals("OFFSET"))) {
            this.parserMoveCurrentPosition(iWord.length() * -1);
            return true;
        }
        return false;
    }

    private OQueryOperator extractConditionOperator() {
        if (!this.parserSkipWhiteSpaces()) {
            return null;
        }
        if (this.parserGetCurrentChar() == ')') {
            return null;
        }
        OQueryOperator[] operators = OSQLEngine.getInstance().getRecordOperators();
        String[] candidateOperators = new String[operators.length];
        for (int i = 0; i < candidateOperators.length; ++i) {
            candidateOperators[i] = operators[i].keyword;
        }
        int operatorPos = this.parserNextChars(true, false, candidateOperators);
        if (operatorPos == -1) {
            this.parserGoBack();
            return null;
        }
        OQueryOperator op = operators[operatorPos];
        if (op.expectsParameters) {
            this.parserGoBack();
            this.parserNextWord(true, " 0123456789'\"");
            String word = this.parserGetLastWord();
            ArrayList<String> params = new ArrayList<String>();
            if (word.length() > op.keyword.length() && word.charAt(op.keyword.length()) == '(') {
                int paramBeginPos = this.parserGetCurrentPosition() - (word.length() - op.keyword.length());
                this.parserSetCurrentPosition(OStringSerializerHelper.getParameters(this.parserText, paramBeginPos, -1, params));
            } else if (!word.equals(op.keyword)) {
                throw new OQueryParsingException("Malformed usage of operator '" + op.toString() + "'. Parsed operator is: " + word);
            }
            try {
                return op.configure(params);
            }
            catch (Exception e) {
                throw OException.wrapException(new OQueryParsingException("Syntax error using the operator '" + op.toString() + "'. Syntax is: " + op.getSyntax()), e);
            }
        }
        this.parserMoveCurrentPosition(1);
        return op;
    }

    private Object extractConditionItem(boolean iAllowOperator, int iExpectedWords) {
        Object[] result = new Object[iExpectedWords];
        for (int i = 0; i < iExpectedWords; ++i) {
            int openParenthesis;
            int lastPosition;
            this.parserNextWord(false, " =><,\r\n");
            String word = this.parserGetLastWord();
            if (word.length() == 0) break;
            word = word.replaceAll("\\\\", "\\\\\\\\");
            String uWord = word.toUpperCase(Locale.ENGLISH);
            int n = lastPosition = this.parserIsEnded() ? this.parserText.length() : this.parserGetCurrentPosition();
            if (word.length() > 0 && word.charAt(0) == '(') {
                ++this.braces;
                this.parserSetCurrentPosition(lastPosition - word.length() + 1);
                Object subCondition = this.extractConditions(null);
                if (!this.parserSkipWhiteSpaces() || this.parserGetCurrentChar() == ')') {
                    --this.braces;
                    this.parserMoveCurrentPosition(1);
                }
                if (subCondition instanceof OSQLFilterCondition) {
                    ((OSQLFilterCondition)subCondition).inBraces = true;
                }
                result[i] = subCondition;
                continue;
            }
            if (word.charAt(0) == '[') {
                this.parserSetCurrentPosition(lastPosition - this.getLastWordLength());
                ArrayList<String> stringItems = new ArrayList<String>();
                this.parserSetCurrentPosition(OStringSerializerHelper.getCollection(this.parserText, this.parserGetCurrentPosition(), stringItems));
                result[i] = this.convertCollectionItems(stringItems);
                this.parserMoveCurrentPosition(1);
                continue;
            }
            if (uWord.startsWith("ALL(")) {
                result[i] = new OSQLFilterItemFieldAll(this, word, null);
                continue;
            }
            if (uWord.startsWith("ANY(")) {
                result[i] = new OSQLFilterItemFieldAny(this, word, null);
                continue;
            }
            if (uWord.equals("NOT")) {
                if (iAllowOperator) {
                    return new OQueryOperatorNot();
                }
                this.parserNextWord(false, " )=><,\r\n");
                String nextWord = this.parserGetLastWord();
                if (nextWord.length() > 0 && (word = word + " " + nextWord).endsWith(")")) {
                    word = word.substring(0, word.length() - 1);
                }
            } else if (uWord.equals("AND")) {
                result[i] = word;
            }
            while (word.endsWith(")") && (openParenthesis = word.indexOf(40)) == -1) {
                word = word.substring(0, word.length() - 1);
                this.parserMoveCurrentPosition(-1);
            }
            word = word.replaceAll("\\\\\\\\", "\\\\");
            result[i] = OSQLHelper.parseValue(this, this, word, this.context);
        }
        return iExpectedWords == 1 ? result[0] : result;
    }

    private List<Object> convertCollectionItems(List<String> stringItems) {
        ArrayList<Object> coll = new ArrayList<Object>();
        for (String s : stringItems) {
            coll.add(OSQLHelper.parseValue(this, this, s, this.context));
        }
        return coll;
    }

    public OSQLFilterCondition getRootCondition() {
        return this.rootCondition;
    }

    public String toString() {
        if (this.rootCondition != null) {
            return "Parsed: " + this.rootCondition.toString();
        }
        return "Unparsed: " + this.parserText;
    }

    public void bindParameters(Map<Object, Object> iArgs) {
        if (this.parameterItems == null || iArgs == null || iArgs.size() == 0) {
            return;
        }
        for (int i = 0; i < this.parameterItems.size(); ++i) {
            OSQLFilterItemParameter value = this.parameterItems.get(i);
            if ("?".equals(value.getName())) {
                value.setValue(iArgs.get(i));
                continue;
            }
            value.setValue(iArgs.get(value.getName()));
        }
    }

    public OSQLFilterItemParameter addParameter(String iName) {
        String name;
        if (iName.charAt(0) == ':') {
            name = iName.substring(1);
            if (!OStringSerializerHelper.isAlphanumeric(name)) {
                throw new OQueryParsingException("Parameter name '" + name + "' is invalid, only alphanumeric characters are allowed");
            }
        } else {
            name = iName;
        }
        OSQLFilterItemParameter param = new OSQLFilterItemParameter(name);
        if (this.parameterItems == null) {
            this.parameterItems = new ArrayList<OSQLFilterItemParameter>();
        }
        this.parameterItems.add(param);
        return param;
    }

    public void setRootCondition(OSQLFilterCondition iCondition) {
        this.rootCondition = iCondition;
    }

    protected void optimize() {
        if (this.rootCondition != null) {
            this.computePrefetchFieldList(this.rootCondition, new HashSet<String>());
        }
    }

    protected Set<String> computePrefetchFieldList(OSQLFilterCondition iCondition, Set<String> iFields) {
        Object left = iCondition.getLeft();
        Object right = iCondition.getRight();
        if (left instanceof OSQLFilterItemField) {
            ((OSQLFilterItemField)left).setPreLoadedFields(iFields);
            iFields.add(((OSQLFilterItemField)left).getRoot());
        } else if (left instanceof OSQLFilterCondition) {
            this.computePrefetchFieldList((OSQLFilterCondition)left, iFields);
        }
        if (right instanceof OSQLFilterItemField) {
            ((OSQLFilterItemField)right).setPreLoadedFields(iFields);
            iFields.add(((OSQLFilterItemField)right).getRoot());
        } else if (right instanceof OSQLFilterCondition) {
            this.computePrefetchFieldList((OSQLFilterCondition)right, iFields);
        }
        return iFields;
    }
}

