/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.AggregationContext;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OArrayConcatExpressionElement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OArrayConcatExpression
extends SimpleNode {
    List<OArrayConcatExpressionElement> childExpressions = new ArrayList<OArrayConcatExpressionElement>();

    public OArrayConcatExpression(int id) {
        super(id);
    }

    public OArrayConcatExpression(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public List<OArrayConcatExpressionElement> getChildExpressions() {
        return this.childExpressions;
    }

    public void setChildExpressions(List<OArrayConcatExpressionElement> childExpressions) {
        this.childExpressions = childExpressions;
    }

    public Object apply(Object left, Object right) {
        if (left == null && right == null) {
            return null;
        }
        if (right == null) {
            if (OMultiValue.isMultiValue(left)) {
                return left;
            }
            return Collections.singletonList(left);
        }
        if (left == null) {
            if (OMultiValue.isMultiValue(right)) {
                return right;
            }
            return Collections.singletonList(right);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (OMultiValue.isMultiValue(left)) {
            Iterator<Object> leftIter = OMultiValue.getMultiValueIterator(left);
            while (leftIter.hasNext()) {
                result.add(leftIter.next());
            }
        } else {
            result.add(left);
        }
        if (OMultiValue.isMultiValue(right)) {
            Iterator<Object> rigthIter = OMultiValue.getMultiValueIterator(right);
            while (rigthIter.hasNext()) {
                result.add(rigthIter.next());
            }
        } else {
            result.add(right);
        }
        return result;
    }

    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        Object result = this.childExpressions.get(0).execute(iCurrentRecord, ctx);
        for (int i = 1; i < this.childExpressions.size(); ++i) {
            result = this.apply(result, this.childExpressions.get(i).execute(iCurrentRecord, ctx));
        }
        return result;
    }

    public Object execute(OResult iCurrentRecord, OCommandContext ctx) {
        Object result = this.childExpressions.get(0).execute(iCurrentRecord, ctx);
        for (int i = 1; i < this.childExpressions.size(); ++i) {
            result = this.apply(result, this.childExpressions.get(i).execute(iCurrentRecord, ctx));
        }
        return result;
    }

    public boolean isEarlyCalculated(OCommandContext ctx) {
        for (OArrayConcatExpressionElement element : this.childExpressions) {
            if (element.isEarlyCalculated(ctx)) continue;
            return false;
        }
        return true;
    }

    protected boolean supportsBasicCalculation() {
        for (OArrayConcatExpressionElement expr : this.childExpressions) {
            if (expr.supportsBasicCalculation()) continue;
            return false;
        }
        return true;
    }

    public boolean needsAliases(Set<String> aliases) {
        for (OArrayConcatExpressionElement expr : this.childExpressions) {
            if (!expr.needsAliases(aliases)) continue;
            return true;
        }
        return false;
    }

    public boolean isAggregate() {
        for (OArrayConcatExpressionElement expr : this.childExpressions) {
            if (!expr.isAggregate()) continue;
            return true;
        }
        return false;
    }

    public SimpleNode splitForAggregation(AggregateProjectionSplit aggregateProj) {
        if (this.isAggregate()) {
            throw new OCommandExecutionException("Cannot use aggregate functions in array concatenation");
        }
        return this;
    }

    public AggregationContext getAggregationContext(OCommandContext ctx) {
        throw new UnsupportedOperationException("array concatenation expressions do not allow plain aggregation");
    }

    @Override
    public OArrayConcatExpression copy() {
        OArrayConcatExpression result = new OArrayConcatExpression(-1);
        this.childExpressions.forEach(x -> oArrayConcatExpression.childExpressions.add(x.copy()));
        return result;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        for (OArrayConcatExpressionElement expr : this.childExpressions) {
            expr.extractSubQueries(collector);
        }
    }

    public boolean refersToParent() {
        for (OArrayConcatExpressionElement expr : this.childExpressions) {
            if (!expr.refersToParent()) continue;
            return true;
        }
        return false;
    }

    public List<String> getMatchPatternInvolvedAliases() {
        ArrayList<String> result = new ArrayList<String>();
        for (OArrayConcatExpressionElement exp : this.childExpressions) {
            List<String> x = exp.getMatchPatternInvolvedAliases();
            if (x == null) continue;
            result.addAll(x);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        for (int i = 0; i < this.childExpressions.size(); ++i) {
            if (i > 0) {
                builder.append(" || ");
            }
            this.childExpressions.get(i).toString(params, builder);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OArrayConcatExpression that = (OArrayConcatExpression)o;
        return this.childExpressions != null ? this.childExpressions.equals(that.childExpressions) : that.childExpressions == null;
    }

    public int hashCode() {
        return this.childExpressions != null ? this.childExpressions.hashCode() : 0;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.childExpressions != null) {
            result.setProperty("childExpressions", this.childExpressions.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("childExpressions") != null) {
            List ser = (List)fromResult.getProperty("childExpressions");
            this.childExpressions = new ArrayList<OArrayConcatExpressionElement>();
            for (OResult r : ser) {
                OArrayConcatExpressionElement exp = new OArrayConcatExpressionElement(-1);
                exp.deserialize(r);
                this.childExpressions.add(exp);
            }
        }
    }

    public boolean isCacheable() {
        for (OArrayConcatExpressionElement exp : this.childExpressions) {
            if (exp.isCacheable()) continue;
            return false;
        }
        return true;
    }
}

