/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OContainsCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OExpression right;
    protected OBooleanExpression condition;

    public OContainsCondition(int id) {
        super(id);
    }

    public OContainsCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean execute(Object left, Object right) {
        if (left instanceof Collection) {
            if (right instanceof Collection) {
                if (((Collection)((Object)right)).size() == 1) {
                    Object propValue;
                    Object item = ((Collection)((Object)right)).iterator().next();
                    if (item instanceof OResult && ((OResult)item).getPropertyNames().size() == 1 && ((Collection)((Object)left)).contains(propValue = ((OResult)item).getProperty(((OResult)item).getPropertyNames().iterator().next()))) {
                        return true;
                    }
                    if (((Collection)((Object)left)).contains(item)) {
                        return true;
                    }
                    if (item instanceof OResult) {
                        item = ((OResult)item).getElement().orElse(null);
                    }
                    if (item instanceof OIdentifiable && ((Collection)((Object)left)).contains(item)) {
                        return true;
                    }
                }
                return OMultiValue.contains(left, right);
            }
            if (right instanceof Iterable) {
                right = ((Iterable)((Object)right)).iterator();
            }
            if (right instanceof Iterator) {
                Iterator<Object> iterator = right;
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (((Collection)((Object)left)).contains(next)) continue;
                    return false;
                }
            }
            for (Object o : (Collection)((Object)left)) {
                if (!OQueryOperatorEquals.equals(o, right)) continue;
                return true;
            }
            return false;
        }
        if (left instanceof Iterable) {
            left = ((Iterable)((Object)left)).iterator();
        }
        if (left instanceof Iterator) {
            if (!(right instanceof Iterable)) {
                right = Collections.singleton(right);
            }
            right = ((Iterable)((Object)right)).iterator();
            Iterator leftIterator = left;
            Iterator rightIterator = right;
            while (rightIterator.hasNext()) {
                Object leftItem = rightIterator.next();
                boolean found = false;
                while (leftIterator.hasNext()) {
                    Object rightItem = leftIterator.next();
                    if (leftItem == null || !leftItem.equals(rightItem)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        Object leftValue = this.left.execute(currentRecord, ctx);
        if (this.right != null) {
            Object rightValue = this.right.execute(currentRecord, ctx);
            return this.execute(leftValue, rightValue);
        }
        if (!OMultiValue.isMultiValue(leftValue)) {
            return false;
        }
        Iterator<Object> iter = OMultiValue.getMultiValueIterator(leftValue);
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof OIdentifiable && this.condition.evaluate((OIdentifiable)item, ctx)) {
                return true;
            }
            if (!(item instanceof OResult) || !this.condition.evaluate((OResult)item, ctx)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        Object leftValue = this.left.execute(currentRecord, ctx);
        if (this.right != null) {
            Object rightValue = this.right.execute(currentRecord, ctx);
            return this.execute(leftValue, rightValue);
        }
        if (leftValue instanceof OResult) {
            return this.condition.evaluate((OResult)leftValue, ctx);
        }
        if (leftValue instanceof Map) {
            OResultInternal res = new OResultInternal();
            for (Map.Entry o : ((Map)leftValue).entrySet()) {
                res.setProperty((String)o.getKey(), o.getValue());
            }
            return this.condition.evaluate(res, ctx);
        }
        if (!OMultiValue.isMultiValue(leftValue)) {
            return false;
        }
        Iterator<Object> iter = OMultiValue.getMultiValueIterator(leftValue);
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof OIdentifiable && this.condition.evaluate((OIdentifiable)item, ctx)) {
                return true;
            }
            if (item instanceof OResult && this.condition.evaluate((OResult)item, ctx)) {
                return true;
            }
            if (!(item instanceof Map)) continue;
            OResultInternal res = new OResultInternal();
            ((Map)item).entrySet().forEach(x -> res.setProperty((String)x.getKey(), x.getValue()));
            if (!this.condition.evaluate(res, ctx)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        builder.append(" CONTAINS ");
        if (this.right != null) {
            this.right.toString(params, builder);
        } else if (this.condition != null) {
            builder.append("(");
            this.condition.toString(params, builder);
            builder.append(")");
        }
    }

    @Override
    public boolean supportsBasicCalculation() {
        if (!this.left.supportsBasicCalculation()) {
            return false;
        }
        if (!this.right.supportsBasicCalculation()) {
            return false;
        }
        return this.condition.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int total = 0;
        if (this.condition != null) {
            total += this.condition.getNumberOfExternalCalculations();
        }
        if (!this.left.supportsBasicCalculation()) {
            ++total;
        }
        if (this.right != null && !this.right.supportsBasicCalculation()) {
            ++total;
        }
        return total;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.condition != null) {
            result.addAll(this.condition.getExternalCalculationConditions());
        }
        if (!this.left.supportsBasicCalculation()) {
            result.add(this.left);
        }
        if (this.right != null && !this.right.supportsBasicCalculation()) {
            result.add(this.right);
        }
        return result;
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        if (this.left != null && this.left.needsAliases(aliases)) {
            return true;
        }
        if (this.right != null && this.right.needsAliases(aliases)) {
            return true;
        }
        return this.condition != null && this.condition.needsAliases(aliases);
    }

    @Override
    public OContainsCondition copy() {
        OContainsCondition result = new OContainsCondition(-1);
        result.left = this.left == null ? null : this.left.copy();
        result.right = this.right == null ? null : this.right.copy();
        result.condition = this.condition == null ? null : this.condition.copy();
        return result;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        if (this.left != null) {
            this.left.extractSubQueries(collector);
        }
        if (this.right != null) {
            this.right.extractSubQueries(collector);
        }
        if (this.condition != null) {
            this.condition.extractSubQueries(collector);
        }
    }

    @Override
    public boolean refersToParent() {
        if (this.left != null && this.left.refersToParent()) {
            return true;
        }
        if (this.right != null && this.right.refersToParent()) {
            return true;
        }
        return this.condition != null && this.condition.refersToParent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OContainsCondition that = (OContainsCondition)o;
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        if (this.right != null ? !this.right.equals(that.right) : that.right != null) {
            return false;
        }
        return !(this.condition != null ? !this.condition.equals(that.condition) : that.condition != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        List<String> leftX = this.left == null ? null : this.left.getMatchPatternInvolvedAliases();
        List<String> rightX = this.right == null ? null : this.right.getMatchPatternInvolvedAliases();
        List<String> conditionX = this.condition == null ? null : this.condition.getMatchPatternInvolvedAliases();
        ArrayList<String> result = new ArrayList<String>();
        if (leftX != null) {
            result.addAll(leftX);
        }
        if (rightX != null) {
            result.addAll(rightX);
        }
        if (conditionX != null) {
            result.addAll(conditionX);
        }
        return result.size() == 0 ? null : result;
    }

    @Override
    public boolean isCacheable() {
        if (this.left != null && !this.left.isCacheable()) {
            return false;
        }
        if (this.right != null && !this.right.isCacheable()) {
            return false;
        }
        return this.condition == null || this.condition.isCacheable();
    }
}

