/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class OCreateClusterStatement
extends ODDLStatement {
    protected OIdentifier name;
    protected boolean ifNotExists = false;
    protected OInteger id;
    protected boolean blob = false;

    public OCreateClusterStatement(int id) {
        super(id);
    }

    public OCreateClusterStatement(OrientSql p, int id) {
        super(p, id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        String existingName;
        ODatabase db = ctx.getDatabase();
        int existingId = db.getClusterIdByName(this.name.getStringValue());
        if (existingId >= 0) {
            if (!this.ifNotExists) throw new OCommandExecutionException("Cluster " + this.name.getStringValue() + " already exists");
            return new OInternalResultSet();
        }
        if (this.id != null && (existingName = db.getClusterNameById(this.id.getValue().intValue())) != null) {
            if (!this.ifNotExists) throw new OCommandExecutionException("Cluster " + this.id.getValue() + " already exists");
            return new OInternalResultSet();
        }
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "create cluster");
        result.setProperty("clusterName", this.name.getStringValue());
        int requestedId = this.id == null ? -1 : this.id.getValue().intValue();
        int finalId = -1;
        if (this.blob) {
            if (requestedId != -1) throw new OCommandExecutionException("Request id not supported by blob cluster creation.");
            finalId = db.addBlobCluster(this.name.getStringValue(), new Object[0]);
            result.setProperty("finalId", finalId);
        } else if (requestedId == -1) {
            finalId = db.addCluster(this.name.getStringValue(), new Object[0]);
        } else {
            result.setProperty("requestedId", requestedId);
            finalId = db.addCluster(this.name.getStringValue(), requestedId, (Object[])null);
        }
        result.setProperty("finalId", finalId);
        OInternalResultSet rs = new OInternalResultSet();
        rs.add(result);
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("CREATE ");
        if (this.blob) {
            builder.append("BLOB ");
        }
        builder.append("CLUSTER ");
        this.name.toString(params, builder);
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        if (this.id != null) {
            builder.append(" ID ");
            this.id.toString(params, builder);
        }
    }

    @Override
    public OCreateClusterStatement copy() {
        OCreateClusterStatement result = new OCreateClusterStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.ifNotExists = this.ifNotExists;
        result.id = this.id == null ? null : this.id.copy();
        result.blob = this.blob;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCreateClusterStatement that = (OCreateClusterStatement)o;
        if (this.ifNotExists != that.ifNotExists) {
            return false;
        }
        if (this.blob != that.blob) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.ifNotExists ? 1 : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.blob ? 1 : 0);
        return result;
    }
}

