/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.enterprise.OEnterpriseEndpoint;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;

public class OHaSetStatement
extends OSimpleExecStatement {
    OIdentifier operation;
    OExpression key;
    OExpression value;

    public OHaSetStatement(int id) {
        super(id);
    }

    public OHaSetStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        ODatabaseInternal db;
        OEnterpriseEndpoint ee;
        Object value;
        OInternalResultSet result = new OInternalResultSet();
        String operation = this.operation.getStringValue();
        Object key = this.key.execute(new OResultInternal(), ctx);
        if (key == null) {
            key = this.key.getDefaultAlias();
        }
        if ((value = this.value.execute(new OResultInternal(), ctx)) == null && (value = this.value.getDefaultAlias()).equals("null")) {
            value = null;
        }
        if ((ee = (db = (ODatabaseInternal)ctx.getDatabase()).getEnterpriseEndpoint()) == null) {
            throw new OCommandExecutionException("HA SET statements are only supported in OrientDB Enterprise Edition");
        }
        if (operation.equalsIgnoreCase("status")) {
            String finalResult;
            try {
                ee.haSetDbStatus((ODatabaseDocument)((Object)db), String.valueOf(key), String.valueOf(value));
                finalResult = "OK";
            }
            catch (UnsupportedOperationException e) {
                finalResult = e.getMessage();
            }
            OResultInternal item = new OResultInternal();
            item.setProperty("operation", "ha set status");
            item.setProperty("result", finalResult);
            result.add(item);
        } else if (operation.equalsIgnoreCase("owner")) {
            String finalResult;
            try {
                ee.haSetOwner((ODatabaseDocument)((Object)db), String.valueOf(key), String.valueOf(value));
                finalResult = "OK";
            }
            catch (UnsupportedOperationException e) {
                finalResult = e.getMessage();
            }
            OResultInternal item = new OResultInternal();
            item.setProperty("operation", "ha set owner");
            item.setProperty("result", finalResult);
            result.add(item);
        } else if (operation.equalsIgnoreCase("role")) {
            String finalResult;
            try {
                ee.haSetRole((ODatabaseDocument)((Object)db), String.valueOf(key), String.valueOf(value));
                finalResult = "OK";
            }
            catch (UnsupportedOperationException e) {
                finalResult = e.getMessage();
            }
            OResultInternal item = new OResultInternal();
            item.setProperty("operation", "ha set role");
            item.setProperty("result", finalResult);
            result.add(item);
        }
        return result;
    }
}

