/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.OForEachExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdateExecutionPlan;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OForEachBlock;
import com.orientechnologies.orient.core.sql.parser.OIfStatement;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OReturnStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.WhileStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OWhileBlock
extends OStatement {
    protected OBooleanExpression condition;
    protected List<OStatement> statements = new ArrayList<OStatement>();

    public OWhileBlock(int id) {
        super(id);
    }

    public OWhileBlock(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx, boolean usePlanCache) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        ctx.setInputParameters(params);
        OUpdateExecutionPlan executionPlan = usePlanCache ? this.createExecutionPlan(ctx, false) : (OUpdateExecutionPlan)this.createExecutionPlanNoCache(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx, boolean usePlanCache) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        OUpdateExecutionPlan executionPlan = usePlanCache ? this.createExecutionPlan(ctx, false) : (OUpdateExecutionPlan)this.createExecutionPlanNoCache(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OUpdateExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OForEachExecutionPlan plan = new OForEachExecutionPlan(ctx);
        plan.chain(new WhileStep(this.condition, this.statements, ctx, enableProfiling));
        return plan;
    }

    @Override
    public OStatement copy() {
        OWhileBlock result = new OWhileBlock(-1);
        result.condition = this.condition.copy();
        result.statements = this.statements.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean containsReturn() {
        for (OStatement stm : this.statements) {
            if (stm instanceof OReturnStatement) {
                return true;
            }
            if (stm instanceof OForEachBlock && ((OForEachBlock)stm).containsReturn()) {
                return true;
            }
            if (stm instanceof OIfStatement && ((OIfStatement)stm).containsReturn()) {
                return true;
            }
            if (!(stm instanceof OWhileBlock) || !((OWhileBlock)stm).containsReturn()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OWhileBlock that = (OWhileBlock)o;
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        return this.statements != null ? this.statements.equals(that.statements) : that.statements == null;
    }

    public int hashCode() {
        int result = this.condition != null ? this.condition.hashCode() : 0;
        result = 31 * result + (this.statements != null ? this.statements.hashCode() : 0);
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("WHILE (");
        this.condition.toString(params, builder);
        builder.append(") {\n");
        for (OStatement stm : this.statements) {
            stm.toString(params, builder);
            builder.append("\n");
        }
        builder.append("}");
    }
}

