/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.chm.LRUList;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.util.concurrent.atomic.AtomicInteger;

public class OCacheEntryImpl
implements OCacheEntry {
    private static final int FROZEN = -1;
    private static final int DEAD = -2;
    private OCachePointer dataPointer;
    private final long fileId;
    private final long pageIndex;
    private final AtomicInteger usagesCount = new AtomicInteger();
    private final AtomicInteger state = new AtomicInteger();
    private OCacheEntry next;
    private OCacheEntry prev;
    private LRUList container;

    public OCacheEntryImpl(long fileId, long pageIndex, OCachePointer dataPointer) {
        this.fileId = fileId;
        this.pageIndex = pageIndex;
        this.dataPointer = dataPointer;
    }

    @Override
    public OCachePointer getCachePointer() {
        return this.dataPointer;
    }

    @Override
    public void clearCachePointer() {
        this.dataPointer = null;
    }

    @Override
    public void setCachePointer(OCachePointer cachePointer) {
        this.dataPointer = cachePointer;
    }

    @Override
    public long getFileId() {
        return this.fileId;
    }

    @Override
    public long getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void acquireExclusiveLock() {
        this.dataPointer.acquireExclusiveLock();
    }

    @Override
    public void releaseExclusiveLock() {
        this.dataPointer.releaseExclusiveLock();
    }

    @Override
    public void acquireSharedLock() {
        this.dataPointer.acquireSharedLock();
    }

    @Override
    public void releaseSharedLock() {
        this.dataPointer.releaseSharedLock();
    }

    @Override
    public int getUsagesCount() {
        return this.usagesCount.get();
    }

    @Override
    public void incrementUsages() {
        this.usagesCount.incrementAndGet();
    }

    @Override
    public boolean isLockAcquiredByCurrentThread() {
        return this.dataPointer.isLockAcquiredByCurrentThread();
    }

    @Override
    public void decrementUsages() {
        this.usagesCount.decrementAndGet();
    }

    @Override
    public OWALChanges getChanges() {
        return null;
    }

    @Override
    public OLogSequenceNumber getEndLSN() {
        return this.dataPointer.getEndLSN();
    }

    @Override
    public void setEndLSN(OLogSequenceNumber endLSN) {
        this.dataPointer.setEndLSN(endLSN);
    }

    @Override
    public boolean acquireEntry() {
        int state = this.state.get();
        while (state >= 0) {
            if (this.state.compareAndSet(state, state + 1)) {
                return true;
            }
            state = this.state.get();
        }
        return false;
    }

    @Override
    public void releaseEntry() {
        int state = this.state.get();
        while (true) {
            if (state <= 0) {
                throw new IllegalStateException("Cache entry " + this.fileId + ":" + this.pageIndex + " has invalid state " + state);
            }
            if (this.state.compareAndSet(state, state - 1)) {
                return;
            }
            state = this.state.get();
        }
    }

    @Override
    public boolean isReleased() {
        return this.state.get() == 0;
    }

    @Override
    public boolean isAlive() {
        return this.state.get() >= 0;
    }

    @Override
    public boolean freeze() {
        int state = this.state.get();
        while (state == 0) {
            if (this.state.compareAndSet(state, -1)) {
                return true;
            }
            state = this.state.get();
        }
        return false;
    }

    @Override
    public boolean isFrozen() {
        return this.state.get() == -1;
    }

    @Override
    public void makeDead() {
        int state = this.state.get();
        while (state == -1) {
            if (this.state.compareAndSet(state, -2)) {
                return;
            }
            state = this.state.get();
        }
        throw new IllegalStateException("Cache entry " + this.fileId + ":" + this.pageIndex + " has invalid state " + state);
    }

    @Override
    public boolean isDead() {
        return this.state.get() == -2;
    }

    @Override
    public OCacheEntry getNext() {
        return this.next;
    }

    @Override
    public OCacheEntry getPrev() {
        return this.prev;
    }

    @Override
    public void setPrev(OCacheEntry prev) {
        this.prev = prev;
    }

    @Override
    public void setNext(OCacheEntry next) {
        this.next = next;
    }

    @Override
    public void setContainer(LRUList lruList) {
        this.container = lruList;
    }

    @Override
    public LRUList getContainer() {
        return this.container;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCacheEntryImpl that = (OCacheEntryImpl)o;
        if (this.fileId != that.fileId) {
            return false;
        }
        return this.pageIndex == that.pageIndex;
    }

    public int hashCode() {
        int result = (int)(this.fileId ^ this.fileId >>> 32);
        result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
        return result;
    }

    public String toString() {
        return "OCacheEntryImpl{dataPointer=" + this.dataPointer + ", fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + ", usagesCount=" + this.usagesCount + '}';
    }
}

