/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTree;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.OMultiValueEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;

final class Bucket<K>
extends ODurablePage {
    private static final int EMBEDDED_ITEMS_THRESHOLD = 64;
    private static final int RID_SIZE = 10;
    private static final int SINGLE_ELEMENT_LINKED_ITEM_SIZE = 15;
    private static final int FREE_POINTER_OFFSET = 28;
    private static final int SIZE_OFFSET = 32;
    private static final int IS_LEAF_OFFSET = 36;
    private static final int LEFT_SIBLING_OFFSET = 37;
    private static final int RIGHT_SIBLING_OFFSET = 45;
    private static final int POSITIONS_ARRAY_OFFSET = 53;
    private final boolean isLeaf;
    private final OBinarySerializer<K> keySerializer;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final OEncryption encryption;
    private final OSBTree<OMultiValueEntry, Byte> multiContainer;

    Bucket(OCacheEntry cacheEntry, boolean isLeaf, OBinarySerializer<K> keySerializer, OEncryption encryption, OSBTree<OMultiValueEntry, Byte> multiContainer) {
        super(cacheEntry);
        this.isLeaf = isLeaf;
        this.keySerializer = keySerializer;
        this.encryption = encryption;
        this.multiContainer = multiContainer;
        this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
        this.setIntValue(32, 0);
        this.setByteValue(36, (byte)(isLeaf ? 1 : 0));
        this.setLongValue(37, -1L);
        this.setLongValue(45, -1L);
    }

    Bucket(OCacheEntry cacheEntry, OBinarySerializer<K> keySerializer, OEncryption encryption, OSBTree<OMultiValueEntry, Byte> multiContainer) {
        super(cacheEntry);
        this.encryption = encryption;
        this.isLeaf = this.getByteValue(36) > 0;
        this.keySerializer = keySerializer;
        this.multiContainer = multiContainer;
    }

    boolean isEmpty() {
        return this.size() == 0;
    }

    int find(K key) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            K midVal = this.getKey(mid);
            int cmp = this.comparator.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    /*
     * WARNING - void declaration
     */
    int remove(int entryIndex) throws IOException {
        int entrySize;
        int keySize;
        int entryPosition;
        assert (this.isLeaf);
        int position = entryPosition = this.getIntValue(53 + entryIndex * 4);
        int nextItem = this.getIntValue(position);
        byte embeddedEntriesCount = this.getByteValue(position += 4);
        int entriesCount = this.getIntValue(++position);
        long mId = this.getLongValue(position += 4);
        position += 8;
        if (entriesCount > embeddedEntriesCount) {
            ArrayList<Object> entriesToRemove = new ArrayList<Object>(entriesCount - embeddedEntriesCount);
            OSBTree.OSBTreeCursor<OMultiValueEntry, Byte> cursor = this.multiContainer.iterateEntriesBetween(new OMultiValueEntry(mId, 0, 0L), true, new OMultiValueEntry(mId + 1L, 0, 0L), false, true);
            Map.Entry<OMultiValueEntry, Byte> mapEntry = cursor.next(-1);
            while (mapEntry != null) {
                OMultiValueEntry mEntry = mapEntry.getKey();
                entriesToRemove.add(mEntry);
                mapEntry = cursor.next(-1);
            }
            for (OMultiValueEntry oMultiValueEntry : entriesToRemove) {
                this.multiContainer.remove(oMultiValueEntry);
            }
        }
        position += 10;
        if (this.encryption == null) {
            keySize = this.getObjectSizeInDirectMemory(this.keySerializer, position);
        } else {
            int encryptedSize = this.getIntValue(position);
            keySize = encryptedSize + 4;
        }
        if (nextItem == -1) {
            this.removeMainEntry(entryIndex, entryPosition, keySize);
            return 1;
        }
        ArrayList<Integer> itemsToRemove = new ArrayList<Integer>(8);
        ArrayList<Integer> itemsToRemoveSize = new ArrayList<Integer>(8);
        int n = entrySize = 17 + keySize + 10;
        while (nextItem > 0) {
            int arraySize = 0xFF & this.getByteValue(nextItem + 4);
            int itemSize = arraySize * 10 + 4 + 1;
            var13_17 += itemSize;
            itemsToRemove.add(nextItem);
            itemsToRemoveSize.add(itemSize);
            nextItem = this.getIntValue(nextItem);
        }
        int size = this.getIntValue(32);
        TreeMap<Integer, Integer> entries = new TreeMap<Integer, Integer>();
        ConcurrentSkipListMap<Integer, Integer> nexts = new ConcurrentSkipListMap<Integer, Integer>();
        int currentPositionOffset = 53;
        for (int i = 0; i < size; ++i) {
            if (i != entryIndex) {
                int currentEntryPosition = this.getIntValue(currentPositionOffset);
                int currentNextPosition = this.getIntValue(currentEntryPosition);
                entries.put(currentEntryPosition, currentPositionOffset);
                if (currentNextPosition > 0) {
                    nexts.put(currentNextPosition, currentEntryPosition);
                }
            }
            currentPositionOffset += 4;
        }
        int freeSpacePointer = this.getIntValue(28);
        int clearedSpace = 0;
        int counter = 0;
        Iterator iterator = itemsToRemove.iterator();
        while (iterator.hasNext()) {
            int itemToRemove = (Integer)iterator.next();
            int itemSize = (Integer)itemsToRemoveSize.get(counter);
            if (itemToRemove > freeSpacePointer) {
                void var13_17;
                this.moveData(freeSpacePointer, freeSpacePointer + itemSize, itemToRemove - freeSpacePointer);
                void diff = var13_17 - clearedSpace;
                SortedMap entriesRefToCorrect = entries.headMap(itemToRemove);
                for (Map.Entry entry : entriesRefToCorrect.entrySet()) {
                    int currentEntryOffset = (Integer)entry.getValue();
                    int currentEntryPosition = entry.getKey();
                    this.setIntValue(currentEntryOffset, currentEntryPosition + diff);
                }
                entriesRefToCorrect.clear();
                SortedMap linkRefToCorrect = nexts.headMap((Object)itemToRemove);
                for (Map.Entry entry3 : linkRefToCorrect.entrySet()) {
                    int[] lastEntry;
                    int first = (Integer)entry3.getKey();
                    int currentEntryPosition = (Integer)entry3.getValue();
                    if (first < itemToRemove) {
                        if (currentEntryPosition > 0) {
                            int itemsBefore;
                            int updatedEntryPosition = currentEntryPosition < itemToRemove ? (counter >= (itemsBefore = -Collections.binarySearch(itemsToRemove, currentEntryPosition) - 1) ? currentEntryPosition + itemsToRemoveSize.subList(itemsBefore, counter + 1).stream().mapToInt(Integer::intValue).sum() : currentEntryPosition) : currentEntryPosition;
                            this.setIntValue(updatedEntryPosition, first + diff);
                        } else {
                            int compositeEntryPosition = -currentEntryPosition;
                            int prevCounter = compositeEntryPosition >>> 16;
                            int prevEntryPosition = compositeEntryPosition & 0xFFFF;
                            int updatedEntryPosition = prevEntryPosition + itemsToRemoveSize.subList(prevCounter + 1, counter + 1).stream().mapToInt(Integer::intValue).sum();
                            this.setIntValue(updatedEntryPosition, first + diff);
                        }
                    }
                    if ((lastEntry = this.incrementalUpdateAllLinkedListReferences(first, itemSize, itemToRemove, (int)diff))[1] <= 0) continue;
                    nexts.put(lastEntry[1], -(counter << 16 | lastEntry[0]));
                }
                linkRefToCorrect.clear();
            }
            clearedSpace += ((Integer)itemsToRemoveSize.get(counter)).intValue();
            ++counter;
            freeSpacePointer += itemSize;
        }
        if (entryPosition > freeSpacePointer) {
            this.moveData(freeSpacePointer, freeSpacePointer + entrySize, entryPosition - freeSpacePointer);
            int diff = entrySize;
            SortedMap entriesRefToCorrect = entries.headMap(entryPosition);
            for (Map.Entry entry : entriesRefToCorrect.entrySet()) {
                int currentEntryOffset = (Integer)entry.getValue();
                int currentEntryPosition = entry.getKey();
                this.setIntValue(currentEntryOffset, currentEntryPosition + diff);
            }
            SortedMap linkRefToCorrect = nexts.headMap((Object)entryPosition);
            for (Map.Entry entry : linkRefToCorrect.entrySet()) {
                int first = (Integer)entry.getKey();
                int n2 = (Integer)entry.getValue();
                if (n2 > 0) {
                    int itemsBefore = -Collections.binarySearch(itemsToRemove, n2) - 1;
                    int updatedEntryPosition = itemsToRemove.size() > itemsBefore ? n2 + itemsToRemoveSize.subList(itemsBefore, itemsToRemove.size()).stream().mapToInt(Integer::intValue).sum() : n2;
                    if (n2 < entryPosition) {
                        updatedEntryPosition += entrySize;
                    }
                    this.setIntValue(updatedEntryPosition, first + diff);
                } else {
                    int compositeEntryPosition = -n2;
                    int prevCounter = compositeEntryPosition >>> 16;
                    int prevEntryPosition = compositeEntryPosition & 0xFFFF;
                    int updatedEntryPosition = entrySize + itemsToRemoveSize.subList(prevCounter + 1, itemsToRemove.size()).stream().mapToInt(Integer::intValue).sum() + prevEntryPosition;
                    this.setIntValue(updatedEntryPosition, first + diff);
                }
                this.updateAllLinkedListReferences(first, entryPosition, diff);
            }
        }
        this.setIntValue(28, freeSpacePointer += entrySize);
        if (entryIndex < size) {
            this.moveData(53 + (entryIndex + 1) * 4, 53 + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(32, --size);
        return entriesCount;
    }

    private void removeMainEntry(int entryIndex, int entryPosition, int keySize) {
        int size = this.getIntValue(32);
        if (entryIndex < size - 1) {
            this.moveData(53 + (entryIndex + 1) * 4, 53 + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(32, --size);
        int freePointer = this.getIntValue(28);
        int entrySize = 27 + keySize;
        boolean moved = false;
        if (size > 0 && entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
            moved = true;
        }
        this.setIntValue(28, freePointer + entrySize);
        if (moved) {
            int currentPositionOffset = 53;
            for (int i = 0; i < size; ++i) {
                int updatedEntryPosition;
                int currentEntryPosition = this.getIntValue(currentPositionOffset);
                if (currentEntryPosition < entryPosition) {
                    updatedEntryPosition = currentEntryPosition + entrySize;
                    this.setIntValue(currentPositionOffset, updatedEntryPosition);
                } else {
                    updatedEntryPosition = currentEntryPosition;
                }
                int nextItem = this.getIntValue(updatedEntryPosition);
                if (nextItem > 0 && nextItem < entryPosition) {
                    this.setIntValue(updatedEntryPosition, nextItem + entrySize);
                    this.updateAllLinkedListReferences(nextItem, entryPosition, entrySize);
                }
                currentPositionOffset += 4;
            }
        }
    }

    boolean remove(int entryIndex, ORID value) throws IOException {
        Byte removed;
        int entryPosition;
        assert (this.isLeaf);
        int position = entryPosition = this.getIntValue(53 + entryIndex * 4);
        int nextItem = this.getIntValue(position);
        int embeddedEntriesCountPosition = position += 4;
        byte embeddedEntriesCount = this.getByteValue(position);
        int entriesCountPosition = ++position;
        int entriesCount = this.getIntValue(entriesCountPosition);
        long mId = this.getLongValue(position += 4);
        position += 8;
        if (nextItem == -1) {
            int keySize;
            int clusterIdPosition = position;
            short clusterId = this.getShortValue(clusterIdPosition);
            long clusterPosition = this.getLongValue(position += 2);
            position += 8;
            if (this.encryption == null) {
                keySize = this.getObjectSizeInDirectMemory(this.keySerializer, position);
            } else {
                int encryptedSize = this.getIntValue(position);
                keySize = encryptedSize + 4;
            }
            if (clusterId != value.getClusterId()) {
                Byte removed2;
                if (entriesCount > embeddedEntriesCount && (removed2 = this.multiContainer.remove(new OMultiValueEntry(mId, value.getClusterId(), value.getClusterPosition()))) != null) {
                    if (entriesCount == 1) {
                        this.removeMainEntry(entryIndex, entryPosition, keySize);
                    } else {
                        this.setIntValue(entriesCountPosition, entriesCount - 1);
                    }
                    return true;
                }
                return false;
            }
            if (clusterPosition == value.getClusterPosition()) {
                if (entriesCount > 1) {
                    this.setShortValue(clusterIdPosition, (short)-1);
                    assert (embeddedEntriesCount == 1);
                    this.setByteValue(embeddedEntriesCountPosition, (byte)(embeddedEntriesCount - 1));
                    this.setIntValue(entriesCountPosition, entriesCount - 1);
                } else {
                    this.removeMainEntry(entryIndex, entryPosition, keySize);
                }
                return true;
            }
        } else {
            short clusterId = this.getShortValue(position);
            long clusterPosition = this.getLongValue(position += 2);
            if (clusterId == value.getClusterId() && clusterPosition == value.getClusterPosition()) {
                int nextNextItem = this.getIntValue(nextItem);
                int nextItemSize = 0xFF & this.getByteValue(nextItem + 4);
                byte[] nextValue = this.getBinaryValue(nextItem + 4 + 1, 10);
                assert (nextItemSize > 0);
                int freePointer = this.getIntValue(28);
                if (nextItemSize == 1) {
                    this.setIntValue(entryPosition, nextNextItem);
                    this.setIntValue(28, freePointer + 4 + 10 + 1);
                } else {
                    this.setByteValue(nextItem + 4, (byte)(nextItemSize - 1));
                    this.setIntValue(28, freePointer + 10);
                }
                this.setBinaryValue(entryPosition + 8 + 1 + 8, nextValue);
                if (nextItem > freePointer || nextItemSize > 1) {
                    if (nextItemSize == 1) {
                        this.moveData(freePointer, freePointer + 15, nextItem - freePointer);
                    } else {
                        this.moveData(freePointer, freePointer + 10, nextItem + 4 + 1 - freePointer);
                    }
                    int diff = nextItemSize > 1 ? 10 : 15;
                    int size = this.getIntValue(32);
                    int currentPositionOffset = 53;
                    for (int i = 0; i < size; ++i) {
                        int updatedEntryPosition;
                        int currentEntryPosition = this.getIntValue(currentPositionOffset);
                        if (currentEntryPosition < nextItem) {
                            updatedEntryPosition = currentEntryPosition + diff;
                            this.setIntValue(currentPositionOffset, updatedEntryPosition);
                        } else {
                            updatedEntryPosition = currentEntryPosition;
                        }
                        int currentNextItem = this.getIntValue(updatedEntryPosition);
                        if (currentNextItem > 0 && currentNextItem < nextItem + diff) {
                            this.setIntValue(updatedEntryPosition, currentNextItem + diff);
                            this.updateAllLinkedListReferences(currentNextItem, nextItem + diff, diff);
                        }
                        currentPositionOffset += 4;
                    }
                }
                this.setByteValue(embeddedEntriesCountPosition, (byte)(embeddedEntriesCount - 1));
                this.setIntValue(entriesCountPosition, entriesCount - 1);
                return true;
            }
            int prevItem = entryPosition;
            while (nextItem > 0) {
                int nextNextItem = this.getIntValue(nextItem);
                int nextItemSize = 0xFF & this.getByteValue(nextItem + 4);
                if (nextItemSize == 1) {
                    clusterId = this.getShortValue(nextItem + 4 + 1);
                    clusterPosition = this.getLongValue(nextItem + 4 + 1 + 2);
                    if (clusterId == value.getClusterId() && clusterPosition == value.getClusterPosition()) {
                        this.setIntValue(prevItem, nextNextItem);
                        int freePointer = this.getIntValue(28);
                        this.setIntValue(28, freePointer + 15);
                        if (nextItem > freePointer) {
                            this.moveData(freePointer, freePointer + 15, nextItem - freePointer);
                            int size = this.getIntValue(32);
                            int currentPositionOffset = 53;
                            for (int i = 0; i < size; ++i) {
                                int updatedEntryPosition;
                                int currentEntryPosition = this.getIntValue(currentPositionOffset);
                                if (currentEntryPosition < nextItem) {
                                    updatedEntryPosition = currentEntryPosition + 15;
                                    this.setIntValue(currentPositionOffset, updatedEntryPosition);
                                } else {
                                    updatedEntryPosition = currentEntryPosition;
                                }
                                int currentNextItem = this.getIntValue(updatedEntryPosition);
                                if (currentNextItem > 0 && currentNextItem < nextItem) {
                                    this.setIntValue(updatedEntryPosition, currentNextItem + 15);
                                    this.updateAllLinkedListReferences(currentNextItem, nextItem, 15);
                                }
                                currentPositionOffset += 4;
                            }
                        }
                        this.setByteValue(embeddedEntriesCountPosition, (byte)(embeddedEntriesCount - 1));
                        this.setIntValue(entriesCountPosition, entriesCount - 1);
                        return true;
                    }
                } else {
                    for (int i = 0; i < nextItemSize; ++i) {
                        clusterId = this.getShortValue(nextItem + 4 + 1 + i * 10);
                        clusterPosition = this.getLongValue(nextItem + 4 + 2 + 1 + i * 10);
                        if (clusterId != value.getClusterId() || clusterPosition != value.getClusterPosition()) continue;
                        int freePointer = this.getIntValue(28);
                        this.setIntValue(28, freePointer + 10);
                        this.setByteValue(nextItem + 4, (byte)(nextItemSize - 1));
                        this.moveData(freePointer, freePointer + 10, nextItem + 4 + 1 + i * 10 - freePointer);
                        int size = this.getIntValue(32);
                        int currentPositionOffset = 53;
                        for (int n = 0; n < size; ++n) {
                            int updatedEntryPosition;
                            int currentEntryPosition = this.getIntValue(currentPositionOffset);
                            if (currentEntryPosition < nextItem) {
                                updatedEntryPosition = currentEntryPosition + 10;
                                this.setIntValue(currentPositionOffset, updatedEntryPosition);
                            } else {
                                updatedEntryPosition = currentEntryPosition;
                            }
                            int currentNextItem = this.getIntValue(updatedEntryPosition);
                            if (currentNextItem > 0 && currentNextItem < nextItem + 10) {
                                this.setIntValue(updatedEntryPosition, currentNextItem + 10);
                                this.updateAllLinkedListReferences(currentNextItem, nextItem + 10, 10);
                            }
                            currentPositionOffset += 4;
                        }
                        this.setByteValue(embeddedEntriesCountPosition, (byte)(embeddedEntriesCount - 1));
                        this.setIntValue(entriesCountPosition, entriesCount - 1);
                        return true;
                    }
                }
                prevItem = nextItem;
                nextItem = nextNextItem;
            }
        }
        if (mId > 0L && (removed = this.multiContainer.remove(new OMultiValueEntry(mId, value.getClusterId(), value.getClusterPosition()))) != null) {
            this.setIntValue(entriesCountPosition, entriesCount - 1);
            return true;
        }
        return false;
    }

    private void updateAllLinkedListReferences(int firstItem, int boundary, int diffSize) {
        int nextItem;
        int currentItem = firstItem + diffSize;
        while ((nextItem = this.getIntValue(currentItem)) > 0 && nextItem < boundary) {
            this.setIntValue(currentItem, nextItem + diffSize);
            currentItem = nextItem + diffSize;
        }
    }

    private int[] incrementalUpdateAllLinkedListReferences(int firstItem, int itemSize, int boundary, int diffSize) {
        int nextItem;
        int currentItem = firstItem + itemSize;
        while ((nextItem = this.getIntValue(currentItem)) > 0 && nextItem < boundary) {
            this.setIntValue(currentItem, nextItem + diffSize);
            currentItem = nextItem + itemSize;
        }
        return new int[]{currentItem, nextItem};
    }

    public int size() {
        return this.getIntValue(32);
    }

    LeafEntry getLeafEntry(int entryIndex) {
        byte[] key;
        assert (this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        int nextItem = this.getIntValue(entryPosition);
        byte embeddedEntriesCount = this.getByteValue(entryPosition += 4);
        int entriesCount = this.getIntValue(++entryPosition);
        long mId = this.getLongValue(entryPosition += 4);
        ArrayList<ORID> values = new ArrayList<ORID>(entriesCount);
        short clusterId = this.getShortValue(entryPosition += 8);
        entryPosition += 2;
        if (clusterId >= 0) {
            long clusterPosition = this.getLongValue(entryPosition);
            entryPosition += 8;
            values.add(new ORecordId(clusterId, clusterPosition));
        } else {
            entryPosition += 8;
        }
        if (this.encryption == null) {
            int keySize = this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
            key = this.getBinaryValue(entryPosition, keySize);
        } else {
            int encryptionSize = this.getIntValue(entryPosition);
            key = this.getBinaryValue(entryPosition, encryptionSize + 4);
        }
        while (nextItem > 0) {
            int nextNextItem = this.getIntValue(nextItem);
            int nextItemSize = 0xFF & this.getByteValue(nextItem + 4);
            for (int i = 0; i < nextItemSize; ++i) {
                clusterId = this.getShortValue(nextItem + 4 + 1 + i * 10);
                long clusterPosition = this.getLongValue(nextItem + 2 + 4 + 1 + i * 10);
                values.add(new ORecordId(clusterId, clusterPosition));
            }
            nextItem = nextNextItem;
        }
        assert (values.size() == embeddedEntriesCount);
        if (values.size() < entriesCount) {
            OSBTree.OSBTreeCursor<OMultiValueEntry, Byte> cursor = this.multiContainer.iterateEntriesBetween(new OMultiValueEntry(mId, 0, 0L), true, new OMultiValueEntry(mId + 1L, 0, 0L), false, true);
            Map.Entry<OMultiValueEntry, Byte> mapEntry = cursor.next(-1);
            while (mapEntry != null) {
                OMultiValueEntry mEntry = mapEntry.getKey();
                values.add(new ORecordId(mEntry.clusterId, mEntry.clusterPosition));
                mapEntry = cursor.next(-1);
            }
        }
        assert (values.size() == entriesCount);
        return new LeafEntry(key, mId, values);
    }

    NonLeafEntry getNonLeafEntry(int entryIndex) {
        byte[] key;
        assert (!this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        int leftChild = this.getIntValue(entryPosition);
        int rightChild = this.getIntValue(entryPosition += 4);
        entryPosition += 4;
        if (this.encryption == null) {
            int keySize = this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
            key = this.getBinaryValue(entryPosition, keySize);
        } else {
            int encryptionSize = this.getIntValue(entryPosition);
            key = this.getBinaryValue(entryPosition, encryptionSize + 4);
        }
        return new NonLeafEntry(key, leftChild, rightChild);
    }

    int getLeft(int entryIndex) {
        assert (!this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        return this.getIntValue(entryPosition);
    }

    int getRight(int entryIndex) {
        assert (!this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        return this.getIntValue(entryPosition + 4);
    }

    List<ORID> getValues(int entryIndex) {
        assert (this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        int nextItem = this.getIntValue(entryPosition);
        byte embeddedEntriesCount = this.getByteValue(entryPosition += 4);
        int entriesCount = this.getIntValue(++entryPosition);
        long mId = this.getLongValue(entryPosition += 4);
        ArrayList<ORID> results = new ArrayList<ORID>(entriesCount);
        short clusterId = this.getShortValue(entryPosition += 8);
        entryPosition += 2;
        if (clusterId >= 0) {
            long clusterPosition = this.getLongValue(entryPosition);
            results.add(new ORecordId(clusterId, clusterPosition));
        }
        while (nextItem > 0) {
            int nextNextItem = this.getIntValue(nextItem);
            int nextItemSize = 0xFF & this.getByteValue(nextItem + 4);
            for (int i = 0; i < nextItemSize; ++i) {
                clusterId = this.getShortValue(nextItem + 4 + 1 + i * 10);
                long clusterPosition = this.getLongValue(nextItem + 4 + 2 + 1 + i * 10);
                results.add(new ORecordId(clusterId, clusterPosition));
            }
            nextItem = nextNextItem;
        }
        assert (results.size() == embeddedEntriesCount);
        if (results.size() < entriesCount) {
            OSBTree.OSBTreeCursor<OMultiValueEntry, Byte> cursor = this.multiContainer.iterateEntriesBetween(new OMultiValueEntry(mId, 0, 0L), true, new OMultiValueEntry(mId + 1L, 0, 0L), false, true);
            Map.Entry<OMultiValueEntry, Byte> mapEntry = cursor.next(-1);
            while (mapEntry != null) {
                OMultiValueEntry mEntry = mapEntry.getKey();
                results.add(new ORecordId(mEntry.clusterId, mEntry.clusterPosition));
                mapEntry = cursor.next(-1);
            }
        }
        assert (results.size() == entriesCount);
        return results;
    }

    public K getKey(int index) {
        int entryPosition = this.getIntValue(index * 4 + 53);
        entryPosition = !this.isLeaf ? (entryPosition += 8) : (entryPosition += 27);
        if (this.encryption == null) {
            return this.deserializeFromDirectMemory(this.keySerializer, entryPosition);
        }
        int encryptedSize = this.getIntValue(entryPosition);
        byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptedSize);
        byte[] serializedKey = this.encryption.decrypt(encryptedKey);
        return this.keySerializer.deserializeNativeObject(serializedKey, 0);
    }

    byte[] getRawKey(int index) {
        int entryPosition = this.getIntValue(index * 4 + 53);
        entryPosition = !this.isLeaf ? (entryPosition += 8) : (entryPosition += 27);
        if (this.encryption == null) {
            int keySize = this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
            return this.getBinaryValue(entryPosition, keySize);
        }
        int encryptedSize = this.getIntValue(entryPosition);
        return this.getBinaryValue(entryPosition, encryptedSize + 4);
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void addAll(List<Entry> entries) throws IOException {
        if (!this.isLeaf) {
            for (int i = 0; i < entries.size(); ++i) {
                NonLeafEntry entry = (NonLeafEntry)entries.get(i);
                this.addNonLeafEntry(i, entry.key, entry.leftChild, entry.rightChild, false);
            }
        } else {
            for (int i = 0; i < entries.size(); ++i) {
                LeafEntry entry = (LeafEntry)entries.get(i);
                byte[] key = entry.key;
                List<ORID> values = entry.values;
                this.addNewLeafEntry(i, key, values.get(0), entry.mId);
                if (values.size() <= 1) continue;
                this.appendNewLeafEntries(i, values.subList(1, values.size()));
            }
        }
        this.setIntValue(32, entries.size());
    }

    public void shrink(int newSize) throws IOException {
        if (this.isLeaf) {
            ArrayList<LeafEntry> entries = new ArrayList<LeafEntry>(newSize);
            for (int i = 0; i < newSize; ++i) {
                entries.add(this.getLeafEntry(i));
            }
            this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
            int index = 0;
            for (LeafEntry entry : entries) {
                byte[] key = entry.key;
                List<ORID> values = entry.values;
                this.addNewLeafEntry(index, key, values.get(0), entry.mId);
                if (values.size() > 1) {
                    this.appendNewLeafEntries(index, values.subList(1, values.size()));
                }
                ++index;
            }
            this.setIntValue(32, newSize);
        } else {
            ArrayList<NonLeafEntry> entries = new ArrayList<NonLeafEntry>(newSize);
            for (int i = 0; i < newSize; ++i) {
                entries.add(this.getNonLeafEntry(i));
            }
            this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
            int index = 0;
            for (NonLeafEntry entry : entries) {
                this.addNonLeafEntry(index, entry.key, entry.leftChild, entry.rightChild, false);
                ++index;
            }
            this.setIntValue(32, newSize);
        }
    }

    boolean addNewLeafEntry(int index, byte[] serializedKey, ORID value, long mId) {
        assert (this.isLeaf);
        int entrySize = 27 + serializedKey.length;
        int size = this.getIntValue(32);
        int freePointer = this.getIntValue(28);
        if (freePointer - entrySize < (size + 1) * 4 + 53) {
            return false;
        }
        if (index <= size - 1) {
            this.moveData(53 + index * 4, 53 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(28, freePointer -= entrySize);
        this.setIntValue(53 + index * 4, freePointer);
        this.setIntValue(32, size + 1);
        freePointer += this.setIntValue(freePointer, -1);
        freePointer += this.setByteValue(freePointer, (byte)1);
        freePointer += this.setIntValue(freePointer, 1);
        freePointer += this.setLongValue(freePointer, mId);
        freePointer += this.setShortValue(freePointer, (short)value.getClusterId());
        freePointer += this.setLongValue(freePointer, value.getClusterPosition());
        this.setBinaryValue(freePointer, serializedKey);
        return true;
    }

    boolean appendNewLeafEntry(int index, ORID value) throws IOException {
        assert (this.isLeaf);
        int entryPosition = this.getIntValue(index * 4 + 53);
        int nextItem = this.getIntValue(entryPosition);
        byte embeddedEntriesCount = this.getByteValue(entryPosition + 4);
        int entriesCount = this.getIntValue(entryPosition + 1 + 4);
        if (embeddedEntriesCount < 64) {
            int size;
            int itemSize = 15;
            int freePointer = this.getIntValue(28);
            if (freePointer - 15 < (size = this.getIntValue(32)) * 4 + 53) {
                return false;
            }
            this.setIntValue(entryPosition, freePointer -= 15);
            freePointer += this.setIntValue(freePointer, nextItem);
            freePointer += this.setByteValue(freePointer, (byte)1);
            freePointer += this.setShortValue(freePointer, (short)value.getClusterId());
            this.setLongValue(freePointer, value.getClusterPosition());
            this.setIntValue(28, freePointer -= 15);
            this.setByteValue(entryPosition + 4, (byte)(embeddedEntriesCount + 1));
        } else {
            long mid = this.getLongValue(entryPosition + 8 + 1);
            this.multiContainer.put(new OMultiValueEntry(mid, value.getClusterId(), value.getClusterPosition()), (byte)1);
        }
        this.setIntValue(entryPosition + 1 + 4, entriesCount + 1);
        return true;
    }

    private void appendNewLeafEntries(int index, List<ORID> values) throws IOException {
        assert (this.isLeaf);
        int entryPosition = this.getIntValue(index * 4 + 53);
        byte embeddedEntriesCount = this.getByteValue(entryPosition + 4);
        int entriesCount = this.getIntValue(entryPosition + 4 + 1);
        int listSize = 0;
        if (embeddedEntriesCount < 64) {
            listSize = Math.min(values.size(), 64 - entriesCount);
            int itemSize = 4 + 10 * listSize + 1;
            int freePointer = this.getIntValue(28);
            this.setIntValue(28, freePointer -= itemSize);
            int nextItem = this.getIntValue(entryPosition);
            this.setIntValue(entryPosition, freePointer);
            freePointer += this.setIntValue(freePointer, nextItem);
            freePointer += this.setByteValue(freePointer, (byte)listSize);
            for (int i = 0; i < listSize; ++i) {
                ORID rid = values.get(i);
                freePointer += this.setShortValue(freePointer, (short)rid.getClusterId());
                freePointer += this.setLongValue(freePointer, rid.getClusterPosition());
            }
            this.setByteValue(entryPosition + 4, (byte)(embeddedEntriesCount + listSize));
        }
        if (values.size() > listSize) {
            long mId = this.getLongValue(entryPosition + 1 + 8);
            for (int i = listSize; i < values.size(); ++i) {
                ORID rid = values.get(i);
                this.multiContainer.put(new OMultiValueEntry(mId, rid.getClusterId(), rid.getClusterPosition()), (byte)1);
            }
        }
        this.setIntValue(entryPosition + 1 + 4, entriesCount + values.size());
    }

    boolean addNonLeafEntry(int index, byte[] serializedKey, int leftChild, int rightChild, boolean updateNeighbors) {
        assert (!this.isLeaf);
        int entrySize = serializedKey.length + 8;
        int size = this.size();
        int freePointer = this.getIntValue(28);
        if (freePointer - entrySize < (size + 1) * 4 + 53) {
            return false;
        }
        if (index <= size - 1) {
            this.moveData(53 + index * 4, 53 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(28, freePointer -= entrySize);
        this.setIntValue(53 + index * 4, freePointer);
        this.setIntValue(32, size + 1);
        freePointer += this.setIntValue(freePointer, leftChild);
        freePointer += this.setIntValue(freePointer, rightChild);
        this.setBinaryValue(freePointer, serializedKey);
        if (updateNeighbors && ++size > 1) {
            if (index < size - 1) {
                int nextEntryPosition = this.getIntValue(53 + (index + 1) * 4);
                this.setIntValue(nextEntryPosition, rightChild);
            }
            if (index > 0) {
                int prevEntryPosition = this.getIntValue(53 + (index - 1) * 4);
                this.setIntValue(prevEntryPosition + 4, leftChild);
            }
        }
        return true;
    }

    void setLeftSibling(long pageIndex) {
        this.setLongValue(37, pageIndex);
    }

    public long getLeftSibling() {
        return this.getLongValue(37);
    }

    void setRightSibling(long pageIndex) {
        this.setLongValue(45, pageIndex);
    }

    public long getRightSibling() {
        return this.getLongValue(45);
    }

    static final class NonLeafEntry
    extends Entry {
        final int leftChild;
        final int rightChild;

        NonLeafEntry(byte[] key, int leftChild, int rightChild) {
            super(key);
            this.leftChild = leftChild;
            this.rightChild = rightChild;
        }
    }

    static final class LeafEntry
    extends Entry {
        final long mId;
        final List<ORID> values;

        LeafEntry(byte[] key, long mId, List<ORID> values) {
            super(key);
            this.mId = mId;
            this.values = values;
        }
    }

    static class Entry {
        final byte[] key;

        Entry(byte[] key) {
            this.key = key;
        }
    }
}

