/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.types.OModifiableLong;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.exception.OTooBigIndexKeyException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.iterator.OEmptyMapEntryIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTree;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.OCellBTreeMultiValue;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.Bucket;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.MultiValueEntrySerializer;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.OCellBTreeMultiValueException;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.OEntryPoint;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.OMultiValueEntry;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.ONullBucket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class OCellBTreeMultiValueV2<K>
extends ODurableComponent
implements OCellBTreeMultiValue<K> {
    private static final int M_ID_BATCH_SIZE = 131072;
    private static final int MAX_KEY_SIZE = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
    private static final OAlwaysLessKey ALWAYS_LESS_KEY = new OAlwaysLessKey();
    private static final OAlwaysGreaterKey ALWAYS_GREATER_KEY = new OAlwaysGreaterKey();
    private static final int MAX_PATH_LENGTH = OGlobalConfiguration.SBTREE_MAX_DEPTH.getValueAsInteger();
    private static final int ENTRY_POINT_INDEX = 0;
    private static final long ROOT_INDEX = 1L;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final String nullFileExtension;
    private final String containerExtension;
    private long fileId;
    private long nullBucketFileId;
    private int keySize;
    private OBinarySerializer<K> keySerializer;
    private OType[] keyTypes;
    private OEncryption encryption;
    private OSBTree<OMultiValueEntry, Byte> multiContainer;
    private final OModifiableLong mIdCounter = new OModifiableLong();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCellBTreeMultiValueV2(String name, String dataFileExtension, String nullFileExtension, String containerExtension, OAbstractPaginatedStorage storage) {
        super(storage, name, dataFileExtension, name + dataFileExtension);
        this.acquireExclusiveLock();
        try {
            this.nullFileExtension = nullFileExtension;
            this.containerExtension = containerExtension;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(OBinarySerializer<K> keySerializer, OType[] keyTypes, int keySize, OEncryption encryption) throws IOException {
        assert (keySerializer != null);
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                this.keySize = keySize;
                this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
                this.encryption = encryption;
                this.keySerializer = keySerializer;
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                this.nullBucketFileId = this.addFile(atomicOperation, this.getName() + this.nullFileExtension);
                OCacheEntry entryPointCacheEntry = this.addPage(atomicOperation, this.fileId);
                try {
                    OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
                    entryPoint.init();
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
                }
                OCacheEntry rootCacheEntry = this.addPage(atomicOperation, this.fileId);
                try {
                    Bucket<K> rootBucket = new Bucket<K>(rootCacheEntry, true, keySerializer, encryption, this.multiContainer);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, rootCacheEntry);
                }
                OCacheEntry nullBucketEntry = this.addPage(atomicOperation, this.nullBucketFileId);
                try {
                    ONullBucket nullBucket = new ONullBucket(nullBucketEntry, this.multiContainer);
                    nullBucket.init(this.incrementMId(atomicOperation));
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, nullBucketEntry);
                }
                this.multiContainer = new OSBTree(this.getName(), this.containerExtension, null, this.storage);
                this.multiContainer.create(MultiValueEntrySerializer.INSTANCE, OByteSerializer.INSTANCE, null, 1, false, null);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<ORID> get(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 36[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, ORID value) throws IOException {
        block17: {
            boolean rollback = false;
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            try {
                this.acquireExclusiveLock();
                try {
                    if (key != null) {
                        boolean isNew;
                        int insertionIndex;
                        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
                        byte[] serializedKey = this.keySerializer.serializeNativeAsWhole(key, (Object[])this.keyTypes);
                        if (this.keySize > MAX_KEY_SIZE) {
                            throw new OTooBigIndexKeyException("Key size is more than allowed, operation was canceled. Current key size " + this.keySize + ", allowed  " + MAX_KEY_SIZE, this.getName());
                        }
                        UpdateBucketSearchResult bucketSearchResult = this.findBucketForUpdate(key, atomicOperation);
                        OCacheEntry keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false, true);
                        Bucket<K> keyBucket = new Bucket<K>(keyBucketCacheEntry, this.keySerializer, this.encryption, this.multiContainer);
                        byte[] keyToInsert = this.serializeKey(serializedKey);
                        if (bucketSearchResult.itemIndex >= 0) {
                            insertionIndex = bucketSearchResult.itemIndex;
                            isNew = false;
                        } else {
                            insertionIndex = -bucketSearchResult.itemIndex - 1;
                            isNew = true;
                        }
                        while (!this.addEntry(keyBucket, insertionIndex, isNew, keyToInsert, value, atomicOperation)) {
                            bucketSearchResult = this.splitBucket(keyBucket, keyBucketCacheEntry, bucketSearchResult.path, bucketSearchResult.insertionIndexes, insertionIndex, key, atomicOperation);
                            insertionIndex = bucketSearchResult.itemIndex;
                            long pageIndex = bucketSearchResult.getLastPathItem();
                            if (pageIndex != keyBucketCacheEntry.getPageIndex()) {
                                this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                                keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
                            }
                            keyBucket = new Bucket<K>(keyBucketCacheEntry, this.keySerializer, this.encryption, this.multiContainer);
                        }
                        this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                        this.updateSize(1L, atomicOperation);
                        break block17;
                    }
                    OCacheEntry nullCacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
                    try {
                        ONullBucket nullBucket = new ONullBucket(nullCacheEntry, this.multiContainer);
                        nullBucket.addValue(value);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, nullCacheEntry);
                    }
                    this.updateSize(1L, atomicOperation);
                }
                finally {
                    this.releaseExclusiveLock();
                }
            }
            catch (IOException | RuntimeException e) {
                rollback = true;
                throw e;
            }
            finally {
                this.endAtomicOperation(rollback);
            }
        }
    }

    private boolean addEntry(Bucket<K> bucketMultiValue, int index, boolean isNew, byte[] key, ORID value, OAtomicOperation atomicOperation) throws IOException {
        long newCounter = this.incrementMId(atomicOperation);
        if (isNew) {
            return bucketMultiValue.addNewLeafEntry(index, key, value, newCounter);
        }
        return bucketMultiValue.appendNewLeafEntry(index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrementMId(OAtomicOperation atomicOperation) throws IOException {
        long idCounter = this.mIdCounter.getValue();
        if ((idCounter & 0x1FFFFL) == 0L) {
            OCacheEntry cacheEntryPoint = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
            try {
                OEntryPoint entryPoint = new OEntryPoint(cacheEntryPoint);
                entryPoint.setEntryId(idCounter + 131072L);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntryPoint);
            }
        }
        this.mIdCounter.setValue(idCounter + 1L);
        return idCounter + 1L;
    }

    @Override
    public void close() {
        this.acquireExclusiveLock();
        try {
            this.readCache.closeFile(this.fileId, true, this.writeCache);
            this.readCache.closeFile(this.nullBucketFileId, true, this.writeCache);
            this.multiContainer.close();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(true);
        try {
            this.acquireExclusiveLock();
            try {
                OCacheEntry entryPointCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
                try {
                    OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
                    entryPoint.init();
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
                }
                OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 1L, false, true);
                try {
                    Bucket<K> rootBucket = new Bucket<K>(cacheEntry, true, this.keySerializer, this.encryption, this.multiContainer);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, cacheEntry);
                }
                OCacheEntry nullBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
                try {
                    ONullBucket nullBucket = new ONullBucket(nullBucketCacheEntry, this.multiContainer);
                    nullBucket.clear();
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, nullBucketCacheEntry);
                }
                this.multiContainer.clear();
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    @Override
    public void delete() throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                this.deleteFile(atomicOperation, this.fileId);
                this.deleteFile(atomicOperation, this.nullBucketFileId);
                this.multiContainer.delete();
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteWithoutLoad() throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                if (this.isFileExists(atomicOperation, this.getFullName())) {
                    long fileId = this.openFile(atomicOperation, this.getFullName());
                    this.deleteFile(atomicOperation, fileId);
                }
                if (this.isFileExists(atomicOperation, this.getName() + this.nullFileExtension)) {
                    long nullFileId = this.openFile(atomicOperation, this.getName() + this.nullFileExtension);
                    this.deleteFile(atomicOperation, nullFileId);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(String name, int keySize, OType[] keyTypes, OBinarySerializer<K> keySerializer, OEncryption encryption) {
        this.acquireExclusiveLock();
        try {
            OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
            this.fileId = this.openFile(atomicOperation, this.getFullName());
            this.nullBucketFileId = this.openFile(atomicOperation, name + this.nullFileExtension);
            this.keySize = keySize;
            this.keyTypes = keyTypes;
            this.encryption = encryption;
            this.keySerializer = keySerializer;
            this.multiContainer = new OSBTree(this.getName(), this.containerExtension, null, this.storage);
            this.multiContainer.load(this.getName(), MultiValueEntrySerializer.INSTANCE, OByteSerializer.INSTANCE, null, 1, false, null);
            OCacheEntry entryPointCacheEntry = this.loadPageForRead(atomicOperation, this.fileId, 0L, false);
            try {
                OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
                this.mIdCounter.setValue(entryPoint.getEntryId());
            }
            finally {
                this.releasePageFromRead(atomicOperation, entryPointCacheEntry);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OCellBTreeMultiValueException("Exception during loading of sbtree " + name, this), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key) throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(true);
        try {
            int removed;
            block35: {
                boolean bl;
                BucketSearchResult bucketSearchResult;
                block36: {
                    this.acquireExclusiveLock();
                    if (key == null) break block35;
                    bucketSearchResult = this.findBucket(key = this.keySerializer.preprocess(key, (Object[])this.keyTypes), atomicOperation);
                    if (bucketSearchResult.itemIndex >= 0) break block36;
                    boolean bl2 = false;
                    this.releaseExclusiveLock();
                    return bl2;
                }
                try {
                    int size;
                    int removed2;
                    Bucket<K> bucket;
                    long pageIndex = bucketSearchResult.pageIndex;
                    int itemIndex = bucketSearchResult.itemIndex;
                    long leftSibling = -1L;
                    long rightSibling = -1L;
                    OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
                    try {
                        bucket = new Bucket<K>(cacheEntry, this.keySerializer, this.encryption, this.multiContainer);
                        removed2 = bucket.remove(itemIndex);
                        if (itemIndex == 0) {
                            leftSibling = bucket.getLeftSibling();
                        }
                        if (itemIndex == bucket.size() - 1) {
                            rightSibling = bucket.getRightSibling();
                        }
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                    while (leftSibling >= 0L) {
                        cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, leftSibling, false, true);
                        try {
                            bucket = new Bucket<K>(cacheEntry, this.keySerializer, this.encryption, this.multiContainer);
                            size = bucket.size();
                            if (size > 0) {
                                if (bucket.getKey(size - 1).equals(key)) {
                                    removed2 += bucket.remove(size - 1);
                                    if (size <= 1) {
                                        leftSibling = bucket.getLeftSibling();
                                        continue;
                                    }
                                    leftSibling = -1L;
                                    continue;
                                }
                                leftSibling = -1L;
                                continue;
                            }
                            leftSibling = bucket.getLeftSibling();
                        }
                        finally {
                            this.releasePageFromWrite(atomicOperation, cacheEntry);
                        }
                    }
                    while (rightSibling >= 0L) {
                        cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, rightSibling, false, true);
                        try {
                            bucket = new Bucket<K>(cacheEntry, this.keySerializer, this.encryption, this.multiContainer);
                            size = bucket.size();
                            if (size > 0) {
                                if (bucket.getKey(0).equals(key)) {
                                    removed2 += bucket.remove(0);
                                    if (size <= 1) {
                                        rightSibling = bucket.getRightSibling();
                                        continue;
                                    }
                                    rightSibling = -1L;
                                    continue;
                                }
                                rightSibling = -1L;
                                continue;
                            }
                            rightSibling = bucket.getRightSibling();
                        }
                        finally {
                            this.releasePageFromWrite(atomicOperation, cacheEntry);
                        }
                    }
                    if (removed2 > 0) {
                        this.updateSize(-removed2, atomicOperation);
                    }
                    bl = removed2 > 0;
                }
                catch (Throwable throwable) {
                    try {
                        this.releaseExclusiveLock();
                        throw throwable;
                    }
                    catch (IOException | RuntimeException e) {
                        rollback = true;
                        throw e;
                    }
                }
                this.releaseExclusiveLock();
                return bl;
            }
            OCacheEntry nullCacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
            try {
                ONullBucket nullBucket = new ONullBucket(nullCacheEntry, this.multiContainer);
                removed = nullBucket.remove();
            }
            finally {
                this.releasePageFromWrite(atomicOperation, nullCacheEntry);
            }
            this.updateSize(-removed, atomicOperation);
            boolean bl = removed > 0;
            this.releaseExclusiveLock();
            return bl;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key, ORID value) throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(true);
        try {
            boolean removed;
            block38: {
                this.acquireExclusiveLock();
                try {
                    if (key != null) {
                        int size;
                        Bucket<K> bucket;
                        BucketSearchResult bucketSearchResult = this.findBucket(key = this.keySerializer.preprocess(key, (Object[])this.keyTypes), atomicOperation);
                        if (bucketSearchResult.itemIndex < 0) {
                            boolean bl = false;
                            return bl;
                        }
                        long pageIndex = bucketSearchResult.pageIndex;
                        int itemIndex = bucketSearchResult.itemIndex;
                        long leftSibling = -1L;
                        long rightSibling = -1L;
                        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
                        try {
                            bucket = new Bucket<K>(cacheEntry, this.keySerializer, this.encryption, this.multiContainer);
                            removed = bucket.remove(itemIndex, value);
                            if (!removed) {
                                if (itemIndex == 0) {
                                    leftSibling = bucket.getLeftSibling();
                                }
                                if (itemIndex == bucket.size() - 1) {
                                    rightSibling = bucket.getRightSibling();
                                }
                            }
                        }
                        finally {
                            this.releasePageFromWrite(atomicOperation, cacheEntry);
                        }
                        while (!removed && leftSibling >= 0L) {
                            cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, leftSibling, false, true);
                            try {
                                bucket = new Bucket<K>(cacheEntry, this.keySerializer, this.encryption, this.multiContainer);
                                size = bucket.size();
                                if (size > 0) {
                                    if (bucket.remove(size - 1, value)) {
                                        removed = true;
                                    }
                                    if (removed) continue;
                                    if (size <= 1) {
                                        leftSibling = bucket.getLeftSibling();
                                        continue;
                                    }
                                    leftSibling = -1L;
                                    continue;
                                }
                                leftSibling = bucket.getLeftSibling();
                            }
                            finally {
                                this.releasePageFromWrite(atomicOperation, cacheEntry);
                            }
                        }
                        while (!removed && rightSibling >= 0L) {
                            cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, rightSibling, false, true);
                            try {
                                bucket = new Bucket<K>(cacheEntry, this.keySerializer, this.encryption, this.multiContainer);
                                size = bucket.size();
                                if (size > 0) {
                                    if (bucket.remove(0, value)) {
                                        removed = true;
                                    }
                                    if (removed) continue;
                                    if (size <= 1) {
                                        rightSibling = bucket.getRightSibling();
                                        continue;
                                    }
                                    rightSibling = -1L;
                                    continue;
                                }
                                rightSibling = bucket.getRightSibling();
                            }
                            finally {
                                this.releasePageFromWrite(atomicOperation, cacheEntry);
                            }
                        }
                        if (removed) {
                            this.updateSize(-1L, atomicOperation);
                        }
                        break block38;
                    }
                    OCacheEntry nullBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
                    try {
                        ONullBucket nullBucket = new ONullBucket(nullBucketCacheEntry, this.multiContainer);
                        removed = nullBucket.removeValue(value);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, nullBucketCacheEntry);
                    }
                    if (removed) {
                        this.updateSize(-1L, atomicOperation);
                    }
                }
                finally {
                    this.releaseExclusiveLock();
                }
            }
            boolean bl = removed;
            return bl;
        }
        catch (IOException | RuntimeException e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesMinor(K key, boolean inclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> oCellBTreeCursor;
                this.acquireSharedLock();
                try {
                    if (ascSortOrder) break block8;
                    oCellBTreeCursor = this.iterateEntriesMinorDesc(key, inclusive);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oCellBTreeCursor;
            }
            OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> oCellBTreeCursor = this.iterateEntriesMinorAsc(key, inclusive);
            this.releaseSharedLock();
            return oCellBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesMajor(K key, boolean inclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> oCellBTreeCursor;
                this.acquireSharedLock();
                try {
                    if (!ascSortOrder) break block8;
                    oCellBTreeCursor = this.iterateEntriesMajorAsc(key, inclusive);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oCellBTreeCursor;
            }
            OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> oCellBTreeCursor = this.iterateEntriesMajorDesc(key, inclusive);
            this.releaseSharedLock();
            return oCellBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public K firstKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public K lastKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCellBTreeMultiValue.OCellBTreeKeyCursor<K> keyCursor() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            BucketSearchResult searchResult;
            block10: {
                OCellBTreeMultiValue.OCellBTreeKeyCursor<Object> oCellBTreeKeyCursor;
                this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    searchResult = this.firstItem(atomicOperation);
                    if (searchResult != null) break block10;
                    oCellBTreeKeyCursor = prefetchSize -> null;
                }
                catch (Throwable throwable) {
                    try {
                        this.releaseSharedLock();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw OException.wrapException(new OCellBTreeMultiValueException("Error during finding first key in sbtree [" + this.getName() + "]", this), e);
                    }
                }
                this.releaseSharedLock();
                return oCellBTreeKeyCursor;
            }
            OCellBTreeFullKeyCursor oCellBTreeFullKeyCursor = new OCellBTreeFullKeyCursor(searchResult.pageIndex);
            this.releaseSharedLock();
            return oCellBTreeFullKeyCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> oCellBTreeCursor;
                this.acquireSharedLock();
                try {
                    if (!ascSortOrder) break block8;
                    oCellBTreeCursor = this.iterateEntriesBetweenAscOrder(keyFrom, fromInclusive, keyTo, toInclusive);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oCellBTreeCursor;
            }
            OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> oCellBTreeCursor = this.iterateEntriesBetweenDescOrder(keyFrom, fromInclusive, keyTo, toInclusive);
            this.releaseSharedLock();
            return oCellBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public void acquireAtomicExclusiveLock() {
        this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSize(long diffSize, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry entryPointCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
            entryPoint.setTreeSize(entryPoint.getTreeSize() + diffSize);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
        }
    }

    private OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesMinorDesc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorDesc(key, inclusive);
        return new OCellBTreeCursorBackward(null, key, false, inclusive);
    }

    private OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesMinorAsc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorAsc(key, inclusive);
        return new OCellBTreeCursorForward(null, key, false, inclusive);
    }

    private K enhanceCompositeKeyMinorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMinorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesMajorAsc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMajorAsc(key, inclusive);
        return new OCellBTreeCursorForward(key, null, inclusive, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesMajorDesc(K key, boolean inclusive) {
        this.acquireSharedLock();
        try {
            key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
            key = this.enhanceCompositeKeyMajorDesc(key, inclusive);
            OCellBTreeCursorBackward oCellBTreeCursorBackward = new OCellBTreeCursorBackward(key, null, inclusive, false);
            return oCellBTreeCursorBackward;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private K enhanceCompositeKeyMajorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMajorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult firstItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 1L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        int itemIndex = 0;
        try {
            Bucket<K> bucket = new Bucket<K>(cacheEntry, this.keySerializer, this.encryption, this.multiContainer);
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (bucket.isEmpty() || itemIndex > bucket.size()) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex + 1;
                    } else {
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        bucketIndex = itemIndex < bucket.size() ? (long)bucket.getLeft(itemIndex) : (long)bucket.getRight(itemIndex - 1);
                        itemIndex = 0;
                    }
                } else {
                    BucketSearchResult bucketSearchResult;
                    if (!bucket.isEmpty()) {
                        bucketSearchResult = new BucketSearchResult(0, bucketIndex);
                        return bucketSearchResult;
                    }
                    if (path.isEmpty()) {
                        bucketSearchResult = null;
                        return bucketSearchResult;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex + 1;
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new Bucket<K>(cacheEntry, this.keySerializer, this.encryption, this.multiContainer);
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult lastItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 1L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        Bucket<K> bucket = new Bucket<K>(cacheEntry, this.keySerializer, this.encryption, this.multiContainer);
        int itemIndex = bucket.size() - 1;
        try {
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (itemIndex < -1) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex - 1;
                    } else {
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        bucketIndex = itemIndex > -1 ? (long)bucket.getRight(itemIndex) : (long)bucket.getLeft(0);
                        itemIndex = Bucket.MAX_PAGE_SIZE_BYTES + 1;
                    }
                } else {
                    BucketSearchResult bucketSearchResult;
                    if (!bucket.isEmpty()) {
                        bucketSearchResult = new BucketSearchResult(bucket.size() - 1, bucketIndex);
                        return bucketSearchResult;
                    }
                    if (path.isEmpty()) {
                        bucketSearchResult = null;
                        return bucketSearchResult;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex - 1;
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new Bucket<K>(cacheEntry, this.keySerializer, this.encryption, this.multiContainer);
                if (itemIndex != Bucket.MAX_PAGE_SIZE_BYTES + 1) continue;
                itemIndex = bucket.size() - 1;
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    private OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesBetweenAscOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenAsc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenAsc(keyTo, toInclusive);
        return new OCellBTreeCursorForward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesBetweenDescOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenDesc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenDesc(keyTo, toInclusive);
        return new OCellBTreeCursorBackward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private K enhanceToCompositeKeyBetweenAsc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenAsc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    private K enhanceToCompositeKeyBetweenDesc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenDesc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    private UpdateBucketSearchResult splitBucket(Bucket<K> bucketToSplit, OCacheEntry entryToSplit, List<Long> path, List<Integer> insertionIndexes, int keyIndex, K keyToInsert, OAtomicOperation atomicOperation) throws IOException {
        int startRightIndex;
        boolean splitLeaf = bucketToSplit.isLeaf();
        int bucketSize = bucketToSplit.size();
        int indexToSplit = bucketSize >>> 1;
        byte[] serializedSeparationKey = bucketToSplit.getRawKey(indexToSplit);
        ArrayList<Bucket.Entry> rightEntries = new ArrayList<Bucket.Entry>(indexToSplit);
        int n = startRightIndex = splitLeaf ? indexToSplit : indexToSplit + 1;
        if (splitLeaf) {
            for (int i = startRightIndex; i < bucketSize; ++i) {
                rightEntries.add(bucketToSplit.getLeafEntry(i));
            }
        } else {
            for (int i = startRightIndex; i < bucketSize; ++i) {
                rightEntries.add(bucketToSplit.getNonLeafEntry(i));
            }
        }
        if (entryToSplit.getPageIndex() != 1L) {
            return this.splitNonRootBucket(path, insertionIndexes, keyIndex, keyToInsert, entryToSplit.getPageIndex(), bucketToSplit, splitLeaf, indexToSplit, serializedSeparationKey, rightEntries, atomicOperation);
        }
        return this.splitRootBucket(keyIndex, keyToInsert, entryToSplit, bucketToSplit, splitLeaf, indexToSplit, serializedSeparationKey, rightEntries, atomicOperation);
    }

    private byte[] serializeKey(byte[] serializedKey) {
        byte[] keyToInsert;
        if (this.encryption == null) {
            keyToInsert = serializedKey;
        } else {
            byte[] encryptedKey = this.encryption.encrypt(serializedKey);
            keyToInsert = new byte[4 + encryptedKey.length];
            OIntegerSerializer.INSTANCE.serializeNative(encryptedKey.length, keyToInsert, 0, new Object[0]);
            System.arraycopy(encryptedKey, 0, keyToInsert, 4, encryptedKey.length);
        }
        return keyToInsert;
    }

    private K deserializeKey(byte[] serializedKey) {
        if (this.encryption == null) {
            return this.keySerializer.deserializeNativeObject(serializedKey, 0);
        }
        byte[] decrypted = this.encryption.decrypt(serializedKey, 4, serializedKey.length - 4);
        return this.keySerializer.deserializeNativeObject(decrypted, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateBucketSearchResult splitNonRootBucket(List<Long> path, List<Integer> insertionIndexes, int keyIndex, K keyToInsert, long pageIndex, Bucket<K> bucketToSplit, boolean splitLeaf, int indexToSplit, byte[] serializedSeparationKey, List<Bucket.Entry> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rightBucketEntry;
        OCacheEntry entryPointCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
            int pageSize = entryPoint.getPagesSize();
            if ((long)pageSize < this.getFilledUpTo(atomicOperation, this.fileId) - 1L) {
                rightBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageSize + 1, false, false);
                entryPoint.setPagesSize(pageSize + 1);
            } else {
                assert ((long)pageSize == this.getFilledUpTo(atomicOperation, this.fileId) - 1L);
                rightBucketEntry = this.addPage(atomicOperation, this.fileId);
                entryPoint.setPagesSize((int)rightBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
        }
        K separationKey = null;
        try {
            Bucket<K> newRightBucket = new Bucket<K>(rightBucketEntry, splitLeaf, this.keySerializer, this.encryption, this.multiContainer);
            newRightBucket.addAll(rightEntries);
            assert (bucketToSplit.size() > 1);
            bucketToSplit.shrink(indexToSplit);
            if (splitLeaf) {
                long rightSiblingPageIndex = bucketToSplit.getRightSibling();
                newRightBucket.setRightSibling(rightSiblingPageIndex);
                newRightBucket.setLeftSibling(pageIndex);
                bucketToSplit.setRightSibling(rightBucketEntry.getPageIndex());
                if (rightSiblingPageIndex >= 0L) {
                    OCacheEntry rightSiblingBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, rightSiblingPageIndex, false, true);
                    Bucket<K> rightSiblingBucket = new Bucket<K>(rightSiblingBucketEntry, this.keySerializer, this.encryption, this.multiContainer);
                    try {
                        rightSiblingBucket.setLeftSibling(rightBucketEntry.getPageIndex());
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, rightSiblingBucketEntry);
                    }
                }
            }
            long parentIndex = path.get(path.size() - 2);
            OCacheEntry parentCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false, true);
            try {
                Bucket<K> parentBucket = new Bucket<K>(parentCacheEntry, this.keySerializer, this.encryption, this.multiContainer);
                int insertionIndex = insertionIndexes.get(insertionIndexes.size() - 2);
                while (!parentBucket.addNonLeafEntry(insertionIndex, serializedSeparationKey, (int)pageIndex, (int)rightBucketEntry.getPageIndex(), true)) {
                    if (separationKey == null) {
                        separationKey = this.deserializeKey(serializedSeparationKey);
                    }
                    UpdateBucketSearchResult bucketSearchResult = this.splitBucket(parentBucket, parentCacheEntry, path.subList(0, path.size() - 1), insertionIndexes.subList(0, insertionIndexes.size() - 1), insertionIndex, separationKey, atomicOperation);
                    parentIndex = bucketSearchResult.getLastPathItem();
                    insertionIndex = bucketSearchResult.itemIndex;
                    if (parentIndex != parentCacheEntry.getPageIndex()) {
                        this.releasePageFromWrite(atomicOperation, parentCacheEntry);
                        parentCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false, true);
                    }
                    parentBucket = new Bucket<K>(parentCacheEntry, this.keySerializer, this.encryption, this.multiContainer);
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, parentCacheEntry);
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        ArrayList<Integer> resultInsertionIndexes = new ArrayList<Integer>(insertionIndexes.subList(0, insertionIndexes.size() - 1));
        if (keyIndex < indexToSplit) {
            return OCellBTreeMultiValueV2.addToTheLeftNonRootBucket(keyIndex, pageIndex, resultPath, resultInsertionIndexes);
        }
        if (keyIndex > indexToSplit) {
            return OCellBTreeMultiValueV2.addToTheRightNonRootBucket(keyIndex, splitLeaf, indexToSplit, rightBucketEntry.getPageIndex(), resultPath, resultInsertionIndexes);
        }
        if (splitLeaf && keyToInsert.equals(separationKey != null ? separationKey : (K)this.deserializeKey(serializedSeparationKey))) {
            return OCellBTreeMultiValueV2.addToTheRightNonRootBucket(keyIndex, true, indexToSplit, rightBucketEntry.getPageIndex(), resultPath, resultInsertionIndexes);
        }
        return OCellBTreeMultiValueV2.addToTheLeftNonRootBucket(keyIndex, pageIndex, resultPath, resultInsertionIndexes);
    }

    private static UpdateBucketSearchResult addToTheRightNonRootBucket(int keyIndex, boolean splitLeaf, int indexToSplit, long rightPageIndex, ArrayList<Long> resultPath, ArrayList<Integer> resultItemPointers) {
        int parentIndex = resultItemPointers.size() - 1;
        resultItemPointers.set(parentIndex, resultItemPointers.get(parentIndex) + 1);
        resultPath.add(rightPageIndex);
        if (splitLeaf) {
            resultItemPointers.add(keyIndex - indexToSplit);
            return new UpdateBucketSearchResult(resultItemPointers, resultPath, keyIndex - indexToSplit);
        }
        int insertionIndex = keyIndex - indexToSplit - 1;
        resultItemPointers.add(insertionIndex);
        return new UpdateBucketSearchResult(resultItemPointers, resultPath, insertionIndex);
    }

    private static UpdateBucketSearchResult addToTheLeftNonRootBucket(int keyIndex, long pageIndex, ArrayList<Long> resultPath, ArrayList<Integer> resultItemPointers) {
        resultPath.add(pageIndex);
        resultItemPointers.add(keyIndex);
        return new UpdateBucketSearchResult(resultItemPointers, resultPath, keyIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateBucketSearchResult splitRootBucket(int keyIndex, K keyToInsert, OCacheEntry bucketEntry, Bucket<K> bucketToSplit, boolean splitLeaf, int indexToSplit, byte[] serializedSeparationKey, List<Bucket.Entry> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rightBucketEntry;
        OCacheEntry leftBucketEntry;
        ArrayList<Bucket.Entry> leftEntries = new ArrayList<Bucket.Entry>(indexToSplit);
        if (splitLeaf) {
            if (bucketToSplit.size() > 1) {
                for (int i = 0; i < indexToSplit; ++i) {
                    leftEntries.add(bucketToSplit.getLeafEntry(i));
                }
            } else {
                Bucket.LeafEntry currentEntry = bucketToSplit.getLeafEntry(0);
                List<ORID> values = currentEntry.values;
                long mId = this.incrementMId(atomicOperation);
                Bucket.LeafEntry newEntry = new Bucket.LeafEntry(currentEntry.key, mId, currentEntry.values.subList(values.size() / 2, values.size()));
                leftEntries.add(newEntry);
            }
        } else {
            for (int i = 0; i < indexToSplit; ++i) {
                leftEntries.add(bucketToSplit.getNonLeafEntry(i));
            }
        }
        OCacheEntry entryPointCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
            int pageSize = entryPoint.getPagesSize();
            int filledUpTo = (int)this.getFilledUpTo(atomicOperation, this.fileId);
            if (pageSize < filledUpTo - 1) {
                leftBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, ++pageSize, false, false);
            } else {
                assert (pageSize == filledUpTo - 1);
                leftBucketEntry = this.addPage(atomicOperation, this.fileId);
                pageSize = (int)leftBucketEntry.getPageIndex();
            }
            if (pageSize < filledUpTo) {
                rightBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, ++pageSize, false, false);
                ++pageSize;
            } else {
                assert (pageSize == filledUpTo);
                rightBucketEntry = this.addPage(atomicOperation, this.fileId);
                pageSize = (int)rightBucketEntry.getPageIndex();
            }
            entryPoint.setPagesSize(pageSize);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
        }
        try {
            Bucket<K> newLeftBucket = new Bucket<K>(leftBucketEntry, splitLeaf, this.keySerializer, this.encryption, this.multiContainer);
            newLeftBucket.addAll(leftEntries);
            if (splitLeaf) {
                newLeftBucket.setRightSibling(rightBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, leftBucketEntry);
        }
        try {
            Bucket<K> newRightBucket = new Bucket<K>(rightBucketEntry, splitLeaf, this.keySerializer, this.encryption, this.multiContainer);
            newRightBucket.addAll(rightEntries);
            if (splitLeaf) {
                newRightBucket.setLeftSibling(leftBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
        bucketToSplit = new Bucket<K>(bucketEntry, false, this.keySerializer, this.encryption, this.multiContainer);
        bucketToSplit.addNonLeafEntry(0, serializedSeparationKey, (int)leftBucketEntry.getPageIndex(), (int)rightBucketEntry.getPageIndex(), true);
        ArrayList<Long> resultPath = new ArrayList<Long>(8);
        resultPath.add(1L);
        ArrayList<Integer> itemPointers = new ArrayList<Integer>(8);
        if (keyIndex < indexToSplit) {
            return OCellBTreeMultiValueV2.addToTheLeftRootBucket(keyIndex, leftBucketEntry, resultPath, itemPointers);
        }
        if (keyIndex > indexToSplit) {
            return OCellBTreeMultiValueV2.addToTheRightRootBucket(keyIndex, splitLeaf, indexToSplit, rightBucketEntry, resultPath, itemPointers);
        }
        if (splitLeaf && keyToInsert.equals(this.deserializeKey(serializedSeparationKey))) {
            return OCellBTreeMultiValueV2.addToTheRightRootBucket(keyIndex, true, indexToSplit, rightBucketEntry, resultPath, itemPointers);
        }
        return OCellBTreeMultiValueV2.addToTheLeftRootBucket(keyIndex, leftBucketEntry, resultPath, itemPointers);
    }

    private static UpdateBucketSearchResult addToTheRightRootBucket(int keyIndex, boolean splitLeaf, int indexToSplit, OCacheEntry rightBucketEntry, ArrayList<Long> resultPath, ArrayList<Integer> itemPointers) {
        resultPath.add(rightBucketEntry.getPageIndex());
        itemPointers.add(0);
        if (splitLeaf) {
            itemPointers.add(keyIndex - indexToSplit);
            return new UpdateBucketSearchResult(itemPointers, resultPath, keyIndex - indexToSplit);
        }
        int itemPointer = keyIndex - indexToSplit - 1;
        itemPointers.add(itemPointer);
        return new UpdateBucketSearchResult(itemPointers, resultPath, itemPointer);
    }

    private static UpdateBucketSearchResult addToTheLeftRootBucket(int keyIndex, OCacheEntry leftBucketEntry, ArrayList<Long> resultPath, ArrayList<Integer> itemPointers) {
        itemPointers.add(-1);
        itemPointers.add(keyIndex);
        resultPath.add(leftBucketEntry.getPageIndex());
        return new UpdateBucketSearchResult(itemPointers, resultPath, keyIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult findBucket(K key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 1L;
        int depth = 0;
        while (true) {
            if (++depth > MAX_PATH_LENGTH) {
                throw new OCellBTreeMultiValueException("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query.", this);
            }
            OCacheEntry bucketEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                Bucket<K> keyBucket = new Bucket<K>(bucketEntry, this.keySerializer, this.encryption, this.multiContainer);
                int index = keyBucket.find(key);
                if (keyBucket.isLeaf()) {
                    BucketSearchResult bucketSearchResult = new BucketSearchResult(index, pageIndex);
                    return bucketSearchResult;
                }
                if (index >= 0) {
                    pageIndex = keyBucket.getRight(index);
                    continue;
                }
                int insertionIndex = -index - 1;
                if (insertionIndex >= keyBucket.size()) {
                    pageIndex = keyBucket.getRight(insertionIndex - 1);
                    continue;
                }
                pageIndex = keyBucket.getLeft(insertionIndex);
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, bucketEntry);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateBucketSearchResult findBucketForUpdate(K key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 1L;
        ArrayList<Long> path = new ArrayList<Long>(8);
        ArrayList<Integer> insertionIndexes = new ArrayList<Integer>(8);
        while (true) {
            if (path.size() > MAX_PATH_LENGTH) {
                throw new OCellBTreeMultiValueException("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query.", this);
            }
            path.add(pageIndex);
            OCacheEntry bucketEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                Bucket<K> keyBucket = new Bucket<K>(bucketEntry, this.keySerializer, this.encryption, this.multiContainer);
                int index = keyBucket.find(key);
                if (keyBucket.isLeaf()) {
                    insertionIndexes.add(index);
                    UpdateBucketSearchResult updateBucketSearchResult = new UpdateBucketSearchResult(insertionIndexes, path, index);
                    return updateBucketSearchResult;
                }
                if (index >= 0) {
                    pageIndex = keyBucket.getRight(index);
                    insertionIndexes.add(index + 1);
                    continue;
                }
                int insertionIndex = -index - 1;
                pageIndex = insertionIndex >= keyBucket.size() ? (long)keyBucket.getRight(insertionIndex - 1) : (long)keyBucket.getLeft(insertionIndex);
                insertionIndexes.add(insertionIndex);
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, bucketEntry);
                continue;
            }
            break;
        }
    }

    private K enhanceCompositeKey(K key, PartialSearchMode partialSearchMode) {
        if (!(key instanceof OCompositeKey)) {
            return key;
        }
        OCompositeKey compositeKey = (OCompositeKey)key;
        if (this.keySize != 1 && compositeKey.getKeys().size() != this.keySize && !partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            OCompositeKey fullKey = new OCompositeKey(compositeKey);
            int itemsToAdd = this.keySize - fullKey.getKeys().size();
            Comparable<Comparable<?>> keyItem = partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY) ? ALWAYS_GREATER_KEY : ALWAYS_LESS_KEY;
            for (int i = 0; i < itemsToAdd; ++i) {
                fullKey.addKey(keyItem);
            }
            return (K)fullKey;
        }
        return key;
    }

    static /* synthetic */ OAtomicOperationsManager access$2500(OCellBTreeMultiValueV2 x0) {
        return x0.atomicOperationsManager;
    }

    static /* synthetic */ void access$2600(OCellBTreeMultiValueV2 x0) {
        x0.acquireSharedLock();
    }

    static /* synthetic */ BucketSearchResult access$2700(OCellBTreeMultiValueV2 x0, Object x1, OAtomicOperation x2) throws IOException {
        return x0.findBucket(x1, x2);
    }

    static /* synthetic */ BucketSearchResult access$2800(OCellBTreeMultiValueV2 x0, OAtomicOperation x1) throws IOException {
        return x0.firstItem(x1);
    }

    static /* synthetic */ OCacheEntry access$2900(OCellBTreeMultiValueV2 x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ OCacheEntry access$3000(OCellBTreeMultiValueV2 x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$3100(OCellBTreeMultiValueV2 x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ Comparator access$3200(OCellBTreeMultiValueV2 x0) {
        return x0.comparator;
    }

    static /* synthetic */ void access$3300(OCellBTreeMultiValueV2 x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ void access$3400(OCellBTreeMultiValueV2 x0) {
        x0.releaseSharedLock();
    }

    static /* synthetic */ OAtomicOperationsManager access$3500(OCellBTreeMultiValueV2 x0) {
        return x0.atomicOperationsManager;
    }

    static /* synthetic */ OAtomicOperationsManager access$3600(OCellBTreeMultiValueV2 x0) {
        return x0.atomicOperationsManager;
    }

    static /* synthetic */ void access$3700(OCellBTreeMultiValueV2 x0) {
        x0.acquireSharedLock();
    }

    static /* synthetic */ BucketSearchResult access$3800(OCellBTreeMultiValueV2 x0, OAtomicOperation x1) throws IOException {
        return x0.lastItem(x1);
    }

    static /* synthetic */ OCacheEntry access$3900(OCellBTreeMultiValueV2 x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ OCacheEntry access$4000(OCellBTreeMultiValueV2 x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$4100(OCellBTreeMultiValueV2 x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ void access$4200(OCellBTreeMultiValueV2 x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ void access$4300(OCellBTreeMultiValueV2 x0) {
        x0.releaseSharedLock();
    }

    static /* synthetic */ OAtomicOperationsManager access$4400(OCellBTreeMultiValueV2 x0) {
        return x0.atomicOperationsManager;
    }

    private final class OCellBTreeCursorBackward
    implements OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> {
        private final K fromKey;
        private K toKey;
        private final boolean fromKeyInclusive;
        private boolean toKeyInclusive;
        private final List<Map.Entry<K, ORID>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, ORID>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OCellBTreeCursorBackward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (toKey == null) {
                this.toKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public Map.Entry<K, ORID> next(int prefetchSize) {
            block38: {
                if (this.dataCacheIterator == null) {
                    return null;
                }
                if (this.dataCacheIterator.hasNext()) {
                    entry = this.dataCacheIterator.next();
                    this.toKey = entry.getKey();
                    this.toKeyInclusive = false;
                    return entry;
                }
                this.dataCache.clear();
                if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                    prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
                }
                OCellBTreeMultiValueV2.access$3600(OCellBTreeMultiValueV2.this).acquireReadLock(OCellBTreeMultiValueV2.this);
                try {
                    OCellBTreeMultiValueV2.access$3700(OCellBTreeMultiValueV2.this);
                    try {
                        atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                        bucketSearchResult = this.toKey != null ? OCellBTreeMultiValueV2.access$2700(OCellBTreeMultiValueV2.this, this.toKey, atomicOperation) : OCellBTreeMultiValueV2.access$3800(OCellBTreeMultiValueV2.this, atomicOperation);
                        if (bucketSearchResult == null) {
                            this.dataCacheIterator = null;
                            var4_6 = null;
                            return var4_6;
                        }
                        pageIndex = BucketSearchResult.access$100(bucketSearchResult);
                        itemIndex = BucketSearchResult.access$000(bucketSearchResult) >= 0 ? (this.toKeyInclusive != false ? BucketSearchResult.access$000(bucketSearchResult) : BucketSearchResult.access$000(bucketSearchResult) - 1) : -BucketSearchResult.access$000(bucketSearchResult) - 2;
                        firstTry = true;
                        lastKey = null;
                        block16: while (true) {
                            if (pageIndex == -1L) {
                                break;
                            }
                            cacheEntry = OCellBTreeMultiValueV2.access$3900(OCellBTreeMultiValueV2.this, atomicOperation, OCellBTreeMultiValueV2.access$1400(OCellBTreeMultiValueV2.this), pageIndex, false);
                            try {
                                bucket = new Bucket<K>(cacheEntry, OCellBTreeMultiValueV2.access$1800(OCellBTreeMultiValueV2.this), OCellBTreeMultiValueV2.access$1900(OCellBTreeMultiValueV2.this), OCellBTreeMultiValueV2.access$2000(OCellBTreeMultiValueV2.this));
                                if (firstTry && this.toKey != null && this.toKeyInclusive && BucketSearchResult.access$000(bucketSearchResult) == 0) {
                                    rightSibling = (int)bucket.getRightSibling();
                                    while (rightSibling > 0) {
                                        siblingCacheEntry = OCellBTreeMultiValueV2.access$4000(OCellBTreeMultiValueV2.this, atomicOperation, OCellBTreeMultiValueV2.access$1400(OCellBTreeMultiValueV2.this), rightSibling, false);
                                        siblingBucket = new Bucket<K>(siblingCacheEntry, OCellBTreeMultiValueV2.access$1800(OCellBTreeMultiValueV2.this), OCellBTreeMultiValueV2.access$1900(OCellBTreeMultiValueV2.this), OCellBTreeMultiValueV2.access$2000(OCellBTreeMultiValueV2.this));
                                        bucketSize = siblingBucket.size();
                                        if (bucketSize == 0) {
                                            rightSibling = (int)siblingBucket.getRightSibling();
                                            continue;
                                        }
                                        if (bucketSize == 1) {
                                            key = siblingBucket.getKey(0);
                                            if (key.equals(this.fromKey)) {
                                                lastKey = key;
                                                for (final ORID rid : siblingBucket.getValues(0)) {
                                                    this.dataCache.add(new Map.Entry<K, ORID>(){

                                                        @Override
                                                        public K getKey() {
                                                            return key;
                                                        }

                                                        @Override
                                                        public ORID getValue() {
                                                            return rid;
                                                        }

                                                        @Override
                                                        public ORID setValue(ORID value) {
                                                            throw new UnsupportedOperationException("setValue");
                                                        }
                                                    });
                                                }
                                                rightSibling = (int)siblingBucket.getRightSibling();
                                                continue;
                                            }
                                            rightSibling = -1;
                                            continue;
                                        }
                                        key = siblingBucket.getKey(0);
                                        if (key.equals(this.fromKey)) {
                                            lastKey = key;
                                            for (final ORID rid : siblingBucket.getValues(0)) {
                                                this.dataCache.add(new Map.Entry<K, ORID>(){

                                                    @Override
                                                    public K getKey() {
                                                        return key;
                                                    }

                                                    @Override
                                                    public ORID getValue() {
                                                        return rid;
                                                    }

                                                    @Override
                                                    public ORID setValue(ORID value) {
                                                        throw new UnsupportedOperationException("setValue");
                                                    }
                                                });
                                            }
                                            rightSibling = -1;
                                        } else {
                                            rightSibling = -1;
                                        }
                                        OCellBTreeMultiValueV2.access$4100(OCellBTreeMultiValueV2.this, atomicOperation, siblingCacheEntry);
                                    }
                                }
                                firstTry = false;
                                block20: while (true) {
                                    if (itemIndex >= bucket.size()) {
                                        itemIndex = bucket.size() - 1;
                                    }
                                    if (itemIndex < 0) {
                                        pageIndex = bucket.getLeftSibling();
                                        itemIndex = 0x7FFFFFFF;
                                        continue block16;
                                    }
                                    leafEntry = bucket.getLeafEntry(itemIndex);
                                    --itemIndex;
                                    key = OCellBTreeMultiValueV2.access$2100(OCellBTreeMultiValueV2.this, leafEntry.key);
                                    if (this.dataCache.size() < prefetchSize || lastKey != null && lastKey.equals(key)) {
                                        if (this.toKey != null && (this.toKeyInclusive == false ? OCellBTreeMultiValueV2.access$3200(OCellBTreeMultiValueV2.this).compare(key, this.toKey) >= 0 : OCellBTreeMultiValueV2.access$3200(OCellBTreeMultiValueV2.this).compare(key, this.toKey) > 0)) continue;
                                        if (this.fromKey == null || !(this.fromKeyInclusive != false ? OCellBTreeMultiValueV2.access$3200(OCellBTreeMultiValueV2.this).compare(key, this.fromKey) < 0 : OCellBTreeMultiValueV2.access$3200(OCellBTreeMultiValueV2.this).compare(key, this.fromKey) <= 0)) {
                                            lastKey = key;
                                            var13_16 = leafEntry.values.iterator();
                                            while (true) {
                                                if (var13_16.hasNext()) ** break;
                                                continue block20;
                                                rid = var13_16.next();
                                                this.dataCache.add(new Map.Entry<K, ORID>(){

                                                    @Override
                                                    public K getKey() {
                                                        return key;
                                                    }

                                                    @Override
                                                    public ORID getValue() {
                                                        return rid;
                                                    }

                                                    @Override
                                                    public ORID setValue(ORID value) {
                                                        throw new UnsupportedOperationException("setValue");
                                                    }
                                                });
                                            }
                                        }
                                    }
                                    break block38;
                                    break;
                                }
                            }
                            finally {
                                OCellBTreeMultiValueV2.access$4200(OCellBTreeMultiValueV2.this, atomicOperation, cacheEntry);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        OCellBTreeMultiValueV2.access$4300(OCellBTreeMultiValueV2.this);
                    }
                }
                catch (IOException e) {
                    throw OException.wrapException(new OCellBTreeMultiValueException("Error during element iteration", OCellBTreeMultiValueV2.this), e);
                }
                finally {
                    OCellBTreeMultiValueV2.access$4400(OCellBTreeMultiValueV2.this).releaseReadLock(OCellBTreeMultiValueV2.this);
                }
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return null;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            entry = this.dataCacheIterator.next();
            this.toKey = entry.getKey();
            this.toKeyInclusive = false;
            return entry;
        }
    }

    private final class OCellBTreeCursorForward
    implements OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> {
        private K fromKey;
        private final K toKey;
        private boolean fromKeyInclusive;
        private final boolean toKeyInclusive;
        private final List<Map.Entry<K, ORID>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, ORID>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OCellBTreeCursorForward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (fromKey == null) {
                this.fromKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public Map.Entry<K, ORID> next(int prefetchSize) {
            block41: {
                if (this.dataCacheIterator == null) {
                    return null;
                }
                if (this.dataCacheIterator.hasNext()) {
                    entry = this.dataCacheIterator.next();
                    this.fromKey = entry.getKey();
                    this.fromKeyInclusive = false;
                    return entry;
                }
                this.dataCache.clear();
                if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                    prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
                }
                if (prefetchSize == 0) {
                    prefetchSize = 1;
                }
                OCellBTreeMultiValueV2.access$2500(OCellBTreeMultiValueV2.this).acquireReadLock(OCellBTreeMultiValueV2.this);
                try {
                    OCellBTreeMultiValueV2.access$2600(OCellBTreeMultiValueV2.this);
                    try {
                        atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                        bucketSearchResult = this.fromKey != null ? OCellBTreeMultiValueV2.access$2700(OCellBTreeMultiValueV2.this, this.fromKey, atomicOperation) : OCellBTreeMultiValueV2.access$2800(OCellBTreeMultiValueV2.this, atomicOperation);
                        if (bucketSearchResult == null) {
                            this.dataCacheIterator = null;
                            var4_6 = null;
                            return var4_6;
                        }
                        pageIndex = BucketSearchResult.access$100(bucketSearchResult);
                        itemIndex = BucketSearchResult.access$000(bucketSearchResult) >= 0 ? (this.fromKeyInclusive != false ? BucketSearchResult.access$000(bucketSearchResult) : BucketSearchResult.access$000(bucketSearchResult) + 1) : -BucketSearchResult.access$000(bucketSearchResult) - 1;
                        lastKey = null;
                        firstTry = true;
                        block16: while (true) {
                            if (pageIndex == -1L) {
                                break;
                            }
                            cacheEntry = OCellBTreeMultiValueV2.access$2900(OCellBTreeMultiValueV2.this, atomicOperation, OCellBTreeMultiValueV2.access$1400(OCellBTreeMultiValueV2.this), pageIndex, false);
                            try {
                                bucket = new Bucket<K>(cacheEntry, OCellBTreeMultiValueV2.access$1800(OCellBTreeMultiValueV2.this), OCellBTreeMultiValueV2.access$1900(OCellBTreeMultiValueV2.this), OCellBTreeMultiValueV2.access$2000(OCellBTreeMultiValueV2.this));
                                if (firstTry && this.fromKey != null && this.fromKeyInclusive && BucketSearchResult.access$000(bucketSearchResult) == 0) {
                                    leftSibling = (int)bucket.getLeftSibling();
                                    while (leftSibling > 0) {
                                        siblingCacheEntry = OCellBTreeMultiValueV2.access$3000(OCellBTreeMultiValueV2.this, atomicOperation, OCellBTreeMultiValueV2.access$1400(OCellBTreeMultiValueV2.this), leftSibling, false);
                                        siblingBucket = new Bucket<K>(siblingCacheEntry, OCellBTreeMultiValueV2.access$1800(OCellBTreeMultiValueV2.this), OCellBTreeMultiValueV2.access$1900(OCellBTreeMultiValueV2.this), OCellBTreeMultiValueV2.access$2000(OCellBTreeMultiValueV2.this));
                                        bucketSize = siblingBucket.size();
                                        if (bucketSize == 0) {
                                            leftSibling = (int)siblingBucket.getLeftSibling();
                                        } else if (bucketSize == 1) {
                                            key = siblingBucket.getKey(0);
                                            if (key.equals(this.fromKey)) {
                                                lastKey = key;
                                                for (final ORID rid : siblingBucket.getValues(0)) {
                                                    this.dataCache.add(new Map.Entry<K, ORID>(){

                                                        @Override
                                                        public K getKey() {
                                                            return key;
                                                        }

                                                        @Override
                                                        public ORID getValue() {
                                                            return rid;
                                                        }

                                                        @Override
                                                        public ORID setValue(ORID value) {
                                                            throw new UnsupportedOperationException("setValue");
                                                        }
                                                    });
                                                }
                                                leftSibling = (int)siblingBucket.getLeftSibling();
                                            } else {
                                                leftSibling = -1;
                                            }
                                        } else {
                                            key = siblingBucket.getKey(bucketSize - 1);
                                            if (key.equals(this.fromKey)) {
                                                lastKey = key;
                                                for (final ORID rid : siblingBucket.getValues(0)) {
                                                    this.dataCache.add(new Map.Entry<K, ORID>(){

                                                        @Override
                                                        public K getKey() {
                                                            return key;
                                                        }

                                                        @Override
                                                        public ORID getValue() {
                                                            return rid;
                                                        }

                                                        @Override
                                                        public ORID setValue(ORID value) {
                                                            throw new UnsupportedOperationException("setValue");
                                                        }
                                                    });
                                                }
                                                leftSibling = -1;
                                            } else {
                                                leftSibling = -1;
                                            }
                                        }
                                        OCellBTreeMultiValueV2.access$3100(OCellBTreeMultiValueV2.this, atomicOperation, siblingCacheEntry);
                                    }
                                }
                                firstTry = false;
                                block20: while (true) {
                                    if (itemIndex >= bucket.size()) {
                                        pageIndex = bucket.getRightSibling();
                                        itemIndex = 0;
                                        continue block16;
                                    }
                                    leafEntry = bucket.getLeafEntry(itemIndex);
                                    ++itemIndex;
                                    key = OCellBTreeMultiValueV2.access$2100(OCellBTreeMultiValueV2.this, leafEntry.key);
                                    if (this.dataCache.size() < prefetchSize || lastKey != null && lastKey.equals(key)) {
                                        if (this.fromKey != null && (this.fromKeyInclusive == false ? OCellBTreeMultiValueV2.access$3200(OCellBTreeMultiValueV2.this).compare(key, this.fromKey) <= 0 : OCellBTreeMultiValueV2.access$3200(OCellBTreeMultiValueV2.this).compare(key, this.fromKey) < 0)) continue;
                                        if (this.toKey == null || !(this.toKeyInclusive != false ? OCellBTreeMultiValueV2.access$3200(OCellBTreeMultiValueV2.this).compare(key, this.toKey) > 0 : OCellBTreeMultiValueV2.access$3200(OCellBTreeMultiValueV2.this).compare(key, this.toKey) >= 0)) {
                                            lastKey = key;
                                            var13_16 = leafEntry.values.iterator();
                                            while (true) {
                                                if (var13_16.hasNext()) ** break;
                                                continue block20;
                                                rid = var13_16.next();
                                                this.dataCache.add(new Map.Entry<K, ORID>(){

                                                    @Override
                                                    public K getKey() {
                                                        return key;
                                                    }

                                                    @Override
                                                    public ORID getValue() {
                                                        return rid;
                                                    }

                                                    @Override
                                                    public ORID setValue(ORID value) {
                                                        throw new UnsupportedOperationException("setValue");
                                                    }
                                                });
                                            }
                                        }
                                    }
                                    break block41;
                                    break;
                                }
                            }
                            finally {
                                OCellBTreeMultiValueV2.access$3300(OCellBTreeMultiValueV2.this, atomicOperation, cacheEntry);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        OCellBTreeMultiValueV2.access$3400(OCellBTreeMultiValueV2.this);
                    }
                }
                catch (IOException e) {
                    throw OException.wrapException(new OCellBTreeMultiValueException("Error during element iteration", OCellBTreeMultiValueV2.this), e);
                }
                finally {
                    OCellBTreeMultiValueV2.access$3500(OCellBTreeMultiValueV2.this).releaseReadLock(OCellBTreeMultiValueV2.this);
                }
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return null;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            entry = this.dataCacheIterator.next();
            this.fromKey = entry.getKey();
            this.fromKeyInclusive = false;
            return entry;
        }
    }

    public final class OCellBTreeFullKeyCursor
    implements OCellBTreeMultiValue.OCellBTreeKeyCursor<K> {
        private long pageIndex;
        private int itemIndex;
        private List<K> keysCache = new ArrayList();
        private Iterator<K> keysIterator = new OEmptyIterator();

        OCellBTreeFullKeyCursor(long startPageIndex) {
            this.pageIndex = startPageIndex;
            this.itemIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K next(int prefetchSize) {
            if (this.keysIterator == null) {
                return null;
            }
            if (this.keysIterator.hasNext()) {
                return this.keysIterator.next();
            }
            this.keysCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            if (prefetchSize == 0) {
                prefetchSize = 1;
            }
            OCellBTreeMultiValueV2.this.atomicOperationsManager.acquireReadLock(OCellBTreeMultiValueV2.this);
            try {
                OCellBTreeMultiValueV2.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    while (this.keysCache.size() < prefetchSize) {
                        block25: {
                            if (this.pageIndex == -1L) {
                                break;
                            }
                            OCacheEntry entryPointCacheEntry = OCellBTreeMultiValueV2.this.loadPageForRead(atomicOperation, OCellBTreeMultiValueV2.this.fileId, 0L, false);
                            try {
                                OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
                                if (this.pageIndex < (long)(entryPoint.getPagesSize() + 1)) break block25;
                                this.pageIndex = -1L;
                                break;
                            }
                            finally {
                                OCellBTreeMultiValueV2.this.releasePageFromRead(atomicOperation, entryPointCacheEntry);
                            }
                        }
                        OCacheEntry cacheEntry = OCellBTreeMultiValueV2.this.loadPageForRead(atomicOperation, OCellBTreeMultiValueV2.this.fileId, this.pageIndex, false);
                        try {
                            Bucket bucket = new Bucket(cacheEntry, OCellBTreeMultiValueV2.this.keySerializer, OCellBTreeMultiValueV2.this.encryption, OCellBTreeMultiValueV2.this.multiContainer);
                            int bucketSize = bucket.size();
                            if (this.itemIndex >= bucketSize) {
                                this.pageIndex = bucket.getRightSibling();
                                this.itemIndex = 0;
                                continue;
                            }
                            while (this.itemIndex < bucketSize && this.keysCache.size() < prefetchSize) {
                                this.keysCache.add(OCellBTreeMultiValueV2.this.deserializeKey(bucket.getRawKey(this.itemIndex)));
                                ++this.itemIndex;
                            }
                        }
                        finally {
                            OCellBTreeMultiValueV2.this.releasePageFromRead(atomicOperation, cacheEntry);
                        }
                    }
                }
                finally {
                    OCellBTreeMultiValueV2.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OCellBTreeMultiValueException("Error during element iteration", OCellBTreeMultiValueV2.this), e);
            }
            finally {
                OCellBTreeMultiValueV2.this.atomicOperationsManager.releaseReadLock(OCellBTreeMultiValueV2.this);
            }
            if (this.keysCache.isEmpty()) {
                this.keysCache = null;
                return null;
            }
            this.keysIterator = this.keysCache.iterator();
            return this.keysIterator.next();
        }
    }

    private static final class PagePathItemUnit {
        private final long pageIndex;
        private final int itemIndex;

        private PagePathItemUnit(long pageIndex, int itemIndex) {
            this.pageIndex = pageIndex;
            this.itemIndex = itemIndex;
        }
    }

    private static final class UpdateBucketSearchResult {
        private final List<Integer> insertionIndexes;
        private final ArrayList<Long> path;
        private final int itemIndex;

        private UpdateBucketSearchResult(List<Integer> insertionIndexes, ArrayList<Long> path, int itemIndex) {
            this.insertionIndexes = insertionIndexes;
            this.path = path;
            this.itemIndex = itemIndex;
        }

        final long getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }
    }

    private static final class BucketSearchResult {
        private final int itemIndex;
        private final long pageIndex;

        private BucketSearchResult(int itemIndex, long pageIndex) {
            this.itemIndex = itemIndex;
            this.pageIndex = pageIndex;
        }
    }

    private static enum PartialSearchMode {
        NONE,
        HIGHEST_BOUNDARY,
        LOWEST_BOUNDARY;

    }
}

