/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.ridbag.sbtree;

import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.Change;

public class DiffChange
implements Change {
    public static final byte TYPE = 0;
    private int delta;

    DiffChange(int delta) {
        this.delta = delta;
    }

    @Override
    public void increment() {
        ++this.delta;
    }

    @Override
    public void decrement() {
        --this.delta;
    }

    @Override
    public int applyTo(Integer value) {
        int result = value == null ? this.delta : value + this.delta;
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    @Override
    public byte getType() {
        return 0;
    }

    @Override
    public int getValue() {
        return this.delta;
    }

    @Override
    public boolean isUndefined() {
        return this.delta < 0;
    }

    @Override
    public void applyDiff(int delta) {
        this.delta += delta;
    }

    @Override
    public int serialize(byte[] stream, int offset) {
        OByteSerializer.INSTANCE.serializeLiteral((byte)0, stream, offset);
        OIntegerSerializer.INSTANCE.serializeLiteral(this.delta, stream, offset + 1);
        return 5;
    }
}

