/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OTokenSecurityException;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OClientSessions;
import com.orientechnologies.orient.server.OHashToken;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OTokenHandler;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import com.orientechnologies.orient.server.plugin.OServerPluginHelper;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSocket;

public class OClientConnectionManager {
    private static final long TIMEOUT_PUSH = 3000L;
    protected final ConcurrentMap<Integer, OClientConnection> connections = new ConcurrentHashMap<Integer, OClientConnection>();
    protected AtomicInteger connectionSerial = new AtomicInteger(0);
    protected final ConcurrentMap<OHashToken, OClientSessions> sessions = new ConcurrentHashMap<OHashToken, OClientSessions>();
    protected final TimerTask timerTask;
    private OServer server;

    public OClientConnectionManager(OServer server) {
        int delay = OGlobalConfiguration.SERVER_CHANNEL_CLEAN_DELAY.getValueAsInteger();
        this.timerTask = Orient.instance().scheduleTask(() -> {
            try {
                this.cleanExpiredConnections();
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Error on client connection purge task", e, new Object[0]);
            }
        }, delay, (long)delay);
        Orient.instance().getProfiler().registerHookValue("server.connections.actives", "Number of active network connections", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            @Override
            public Object getValue() {
                return (long)OClientConnectionManager.this.connections.size();
            }
        });
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanExpiredConnections() {
        Iterator iterator = this.connections.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((OClientConnection)entry.getValue()).tryAcquireForExpire()) continue;
            try {
                Socket socket = ((OClientConnection)entry.getValue()).getProtocol() == null || ((OClientConnection)entry.getValue()).getProtocol().getChannel() == null ? null : ((OClientConnection)entry.getValue()).getProtocol().getChannel().socket;
                if (socket == null || socket.isClosed() || socket.isInputShutdown()) {
                    OLogManager.instance().debug((Object)this, "[OClientConnectionManager] found and removed pending closed channel %d (%s)", entry.getKey(), socket);
                    try {
                        OCommandRequestText command = ((OClientConnection)entry.getValue()).getData().command;
                        if (command != null && command.isIdempotent()) {
                            ((OClientConnection)entry.getValue()).getProtocol().sendShutdown();
                            ((OClientConnection)entry.getValue()).getProtocol().interrupt();
                        }
                        this.removeConnectionFromSession((OClientConnection)entry.getValue());
                        ((OClientConnection)entry.getValue()).close();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error during close of connection for close channel", e, new Object[0]);
                    }
                    iterator.remove();
                    continue;
                }
                if (!Boolean.TRUE.equals(((OClientConnection)entry.getValue()).getTokenBased()) || ((OClientConnection)entry.getValue()).getToken() == null || ((OClientConnection)entry.getValue()).getToken().isNowValid() || ((OClientConnection)entry.getValue()).getToken().getIsValid()) continue;
                this.removeConnectionFromSession((OClientConnection)entry.getValue());
                ((OClientConnection)entry.getValue()).close();
                iterator.remove();
            }
            finally {
                ((OClientConnection)entry.getValue()).release();
            }
        }
        this.server.getPushManager().cleanPushSockets();
    }

    public OClientConnection connect(ONetworkProtocol iProtocol) {
        OClientConnection connection = new OClientConnection(this.connectionSerial.incrementAndGet(), iProtocol);
        this.connections.put(connection.getId(), connection);
        OLogManager.instance().config(this, "Remote client connected from: " + connection, new Object[0]);
        OServerPluginHelper.invokeHandlerCallbackOnClientConnection(iProtocol.getServer(), connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClientConnection connect(ONetworkProtocol iProtocol, OClientConnection connection, byte[] tokenBytes, OTokenHandler handler) {
        OClientSessions session;
        OToken token;
        try {
            token = handler.parseBinaryToken(tokenBytes);
        }
        catch (Exception e) {
            throw OException.wrapException(new OTokenSecurityException("Error on token parsing"), e);
        }
        ConcurrentMap<OHashToken, OClientSessions> concurrentMap = this.sessions;
        synchronized (concurrentMap) {
            session = new OClientSessions(tokenBytes, token);
            this.sessions.put(new OHashToken(tokenBytes), session);
        }
        connection.setTokenBytes(tokenBytes);
        connection.setTokenBased(true);
        connection.setToken(token);
        session.addConnection(connection);
        OLogManager.instance().config(this, "Remote client connected from: " + connection, new Object[0]);
        OServerPluginHelper.invokeHandlerCallbackOnClientConnection(iProtocol.getServer(), connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClientConnection reConnect(ONetworkProtocol iProtocol, byte[] tokenBytes, OToken token) {
        OClientSessions sess;
        OClientConnection connection = new OClientConnection(this.connectionSerial.incrementAndGet(), iProtocol);
        this.connections.put(connection.getId(), connection);
        OHashToken key = new OHashToken(tokenBytes);
        ConcurrentMap<OHashToken, OClientSessions> concurrentMap = this.sessions;
        synchronized (concurrentMap) {
            sess = (OClientSessions)this.sessions.get(key);
            if (sess == null) {
                sess = new OClientSessions(tokenBytes, token);
                this.sessions.put(new OHashToken(tokenBytes), sess);
            }
        }
        connection.setTokenBytes(tokenBytes);
        connection.setTokenBased(true);
        connection.setToken(token);
        sess.addConnection(connection);
        OServerPluginHelper.invokeHandlerCallbackOnClientConnection(iProtocol.getServer(), connection);
        return connection;
    }

    public OClientConnection getConnection(int iChannelId, ONetworkProtocol protocol) {
        OClientConnection connection = (OClientConnection)this.connections.get(iChannelId);
        if (connection != null) {
            connection.setProtocol(protocol);
        }
        return connection;
    }

    public OClientConnection getConnection(String iAddress) {
        for (OClientConnection conn : this.connections.values()) {
            if (!iAddress.equals(conn.getRemoteAddress())) continue;
            return conn;
        }
        return null;
    }

    public void kill(int iChannelId) {
        this.kill((OClientConnection)this.connections.get(iChannelId));
    }

    public void kill(OClientConnection connection) {
        if (connection != null) {
            ONetworkProtocol protocol = connection.getProtocol();
            try {
                protocol.interrupt();
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error during interruption of binary protocol", e, new Object[0]);
            }
            this.disconnect(connection);
            protocol.sendShutdown();
        }
    }

    public boolean has(int id) {
        return this.connections.containsKey(id);
    }

    public void interrupt(int iChannelId) {
        ONetworkProtocol protocol;
        OClientConnection connection = (OClientConnection)this.connections.get(iChannelId);
        if (connection != null && (protocol = connection.getProtocol()) != null) {
            protocol.softShutdown();
        }
    }

    public boolean disconnect(int iChannelId) {
        OLogManager.instance().debug((Object)this, "Disconnecting connection with id=%d", iChannelId);
        OClientConnection connection = (OClientConnection)this.connections.remove(iChannelId);
        if (connection != null) {
            OServerPluginHelper.invokeHandlerCallbackOnClientDisconnection(this.server, connection);
            connection.close();
            this.removeConnectionFromSession(connection);
            for (Map.Entry entry : this.connections.entrySet()) {
                if (!((OClientConnection)entry.getValue()).getProtocol().equals(connection.getProtocol())) continue;
                OLogManager.instance().debug((Object)this, "Disconnected connection with id=%d but are present other active channels", iChannelId);
                return false;
            }
            OLogManager.instance().debug((Object)this, "Disconnected connection with id=%d, no other active channels found", iChannelId);
            return true;
        }
        OLogManager.instance().debug((Object)this, "Cannot find connection with id=%d", iChannelId);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnectionFromSession(OClientConnection connection) {
        if (connection.getProtocol() instanceof ONetworkProtocolBinary) {
            byte[] tokenBytes = connection.getTokenBytes();
            OHashToken hashToken = new OHashToken(tokenBytes);
            ConcurrentMap<OHashToken, OClientSessions> concurrentMap = this.sessions;
            synchronized (concurrentMap) {
                OClientSessions sess = (OClientSessions)this.sessions.get(hashToken);
                if (sess != null) {
                    sess.removeConnection(connection);
                    if (!sess.isActive()) {
                        this.sessions.remove(hashToken);
                    }
                }
            }
        }
    }

    public void disconnect(OClientConnection iConnection) {
        OLogManager.instance().debug((Object)this, "Disconnecting connection %s...", iConnection);
        OServerPluginHelper.invokeHandlerCallbackOnClientDisconnection(this.server, iConnection);
        this.removeConnectionFromSession(iConnection);
        iConnection.close();
        int totalRemoved = 0;
        for (Map.Entry<Integer, OClientConnection> entry : new HashMap<Integer, OClientConnection>(this.connections).entrySet()) {
            OClientConnection conn = entry.getValue();
            if (conn == null || !conn.equals(iConnection)) continue;
            this.connections.remove(entry.getKey());
            ++totalRemoved;
        }
        OLogManager.instance().debug((Object)this, "Disconnected connection %s found %d channels", iConnection, totalRemoved);
    }

    public List<OClientConnection> getConnections() {
        return new ArrayList<OClientConnection>(this.connections.values());
    }

    public int getTotal() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushDistribCfg2Clients(ODocument iConfig) {
        if (iConfig == null) {
            return;
        }
        HashSet<String> pushed = new HashSet<String>();
        for (OClientConnection c : this.connections.values()) {
            if (!c.getData().supportsLegacyPushMessages) continue;
            try {
                String remoteAddress = c.getRemoteAddress();
                if (pushed.contains(remoteAddress)) {
                }
            }
            catch (Exception e) {}
            continue;
            if (!(c.getProtocol() instanceof ONetworkProtocolBinary) || c.getData().getSerializationImpl() == null) continue;
            ONetworkProtocolBinary p = (ONetworkProtocolBinary)c.getProtocol();
            OChannelBinary channel = p.getChannel();
            ORecordSerializer ser = ORecordSerializerFactory.instance().getFormat(c.getData().getSerializationImpl());
            if (ser == null) {
                return;
            }
            byte[] content = ser.toStream(iConfig, false);
            try {
                if (channel.tryAcquireWriteLock(3000L)) {
                    try {
                        channel.writeByte((byte)3);
                        channel.writeInt(Integer.MIN_VALUE);
                        channel.writeByte((byte)80);
                        channel.writeBytes(content);
                        channel.flush();
                        pushed.add(c.getRemoteAddress());
                        OLogManager.instance().debug((Object)this, "Sent updated cluster configuration to the remote client %s", c.getRemoteAddress());
                        continue;
                    }
                    finally {
                        channel.releaseWriteLock();
                        continue;
                    }
                }
                OLogManager.instance().info((Object)this, "Timeout on sending updated cluster configuration to the remote client %s", c.getRemoteAddress());
            }
            catch (Exception e) {
                OLogManager.instance().warn((Object)this, "Cannot push cluster configuration to the client %s", e, c.getRemoteAddress());
            }
        }
    }

    public void shutdown() {
        this.timerTask.cancel();
        ArrayList<ONetworkProtocol> toWait = new ArrayList<ONetworkProtocol>();
        for (Map.Entry entry : this.connections.entrySet()) {
            ONetworkProtocol protocol = ((OClientConnection)entry.getValue()).getProtocol();
            if (protocol != null) {
                protocol.sendShutdown();
            }
            OLogManager.instance().debug((Object)this, "Sending shutdown to thread %s", protocol);
            OCommandRequestText command = ((OClientConnection)entry.getValue()).getData().command;
            if (command != null && command.isIdempotent()) {
                protocol.interrupt();
                continue;
            }
            if (protocol instanceof ONetworkProtocolBinary && ((ONetworkProtocolBinary)protocol).getRequestType() == 1) continue;
            Socket socket = protocol == null || protocol.getChannel() == null ? null : protocol.getChannel().socket;
            if (socket != null && !socket.isClosed() && !socket.isInputShutdown()) {
                try {
                    OLogManager.instance().debug((Object)this, "Closing input socket of thread %s", protocol);
                    if (!(socket instanceof SSLSocket)) {
                        socket.shutdownInput();
                    }
                }
                catch (IOException e) {
                    OLogManager.instance().debug((Object)this, "Error on closing connection of %s client during shutdown", e, ((OClientConnection)entry.getValue()).getRemoteAddress());
                }
            }
            if (!protocol.isAlive()) continue;
            if (protocol instanceof ONetworkProtocolBinary && ((ONetworkProtocolBinary)protocol).getRequestType() == -1) {
                try {
                    OLogManager.instance().debug((Object)this, "Closing socket of thread %s", protocol);
                    protocol.getChannel().close();
                }
                catch (Exception e) {
                    OLogManager.instance().debug((Object)this, "Error during chanel close at shutdown", e, new Object[0]);
                }
                OLogManager.instance().debug((Object)this, "Sending interrupt signal to thread %s", protocol);
                protocol.interrupt();
            }
            toWait.add(protocol);
        }
        for (ONetworkProtocol protocol : toWait) {
            try {
                protocol.join(this.server.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.SERVER_CHANNEL_CLEAN_DELAY));
                if (!protocol.isAlive()) continue;
                protocol.interrupt();
                protocol.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void killAllChannels() {
        for (Map.Entry entry : this.connections.entrySet()) {
            try {
                ONetworkProtocol protocol = ((OClientConnection)entry.getValue()).getProtocol();
                protocol.getChannel().close();
                Socket socket = protocol == null || protocol.getChannel() == null ? null : protocol.getChannel().socket;
                if (socket == null || socket.isClosed() || socket.isInputShutdown() || socket instanceof SSLSocket) continue;
                socket.shutdownInput();
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Error on killing connection to %s client", e, ((OClientConnection)entry.getValue()).getRemoteAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClientSessions getSession(OClientConnection connection) {
        OHashToken key = new OHashToken(connection.getTokenBytes());
        ConcurrentMap<OHashToken, OClientSessions> concurrentMap = this.sessions;
        synchronized (concurrentMap) {
            return (OClientSessions)this.sessions.get(key);
        }
    }
}

