/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.cluster.OPaginatedCluster;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.task.ODistributedDatabaseDeltaSyncException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class OIncrementalServerSync {
    private static final byte[] EMPTY_CONTENT = new byte[0];

    public void importDelta(OServer serverInstance, String databaseName, final InputStream in, final String iNode) throws IOException {
        final String nodeName = serverInstance.getDistributedManager().getLocalNodeName();
        final ODatabaseDocumentInternal db = serverInstance.openDatabase(databaseName);
        try {
            OScenarioThreadLocal.executeAsDistributed((Callable<? extends Object>)new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public Object call() throws Exception {
                    db.activateOnCurrentThread();
                    totalRecords = 0L;
                    totalCreated = 0L;
                    totalUpdated = 0L;
                    totalDeleted = 0L;
                    totalHoles = 0L;
                    totalSkipped = 0L;
                    ODistributedServerLog.info((Object)this, nodeName, iNode, ODistributedServerLog.DIRECTION.IN, "Started import of delta for database '" + db.getName() + "'", new Object[0]);
                    lastLap = System.currentTimeMillis();
                    try {
                        input = new DataInputStream(in);
                        try {
                            records = input.readLong();
                            block20: for (i = 0L; i < records; ++i) {
                                block26: {
                                    block25: {
                                        clusterId = input.readInt();
                                        clusterPos = input.readLong();
                                        deleted = input.readBoolean();
                                        rid = new ORecordId(clusterId, clusterPos);
                                        ++totalRecords;
                                        cluster = (OPaginatedCluster)db.getStorage().getUnderlying().getClusterById(rid.getClusterId());
                                        recordStatus = cluster.getRecordStatus(rid.getClusterPosition());
                                        newRecord = null;
                                        if (!deleted) break block25;
                                        ODistributedServerLog.debug((Object)this, nodeName, iNode, ODistributedServerLog.DIRECTION.IN, "DELTA <- deleting %s", new Object[]{rid});
                                        switch (2.$SwitchMap$com$orientechnologies$orient$core$storage$cluster$OPaginatedCluster$RECORD_STATUS[recordStatus.ordinal()]) {
                                            case 1: {
                                                ++totalSkipped;
                                                continue block20;
                                            }
                                            case 2: 
                                            case 3: {
                                                db.delete(rid);
                                                ** GOTO lbl37
                                            }
                                            case 4: {
                                                ++totalSkipped;
                                            }
lbl37:
                                            // 3 sources

                                            default: {
                                                ++totalDeleted;
                                                break;
                                            }
                                        }
                                        break block26;
                                    }
                                    recordVersion = input.readInt();
                                    recordType = input.readByte();
                                    recordSize = input.readInt();
                                    recordContent = new byte[recordSize];
                                    input.readFully(recordContent);
                                    switch (2.$SwitchMap$com$orientechnologies$orient$core$storage$cluster$OPaginatedCluster$RECORD_STATUS[recordStatus.ordinal()]) {
                                        case 1: {
                                            ++totalSkipped;
                                            continue block20;
                                        }
                                        case 2: 
                                        case 3: {
                                            newRecord = Orient.instance().getRecordFactoryManager().newInstance(recordType, rid.getClusterId(), null);
                                            ORecordInternal.fill(newRecord, rid, ORecordVersionHelper.setRollbackMode(recordVersion), recordContent, true);
                                            loadedRecord = rid.getRecord();
                                            if (loadedRecord instanceof ODocument) {
                                                loadedDocument = (ODocument)loadedRecord;
                                                loadedDocument.merge((ODocument)newRecord, false, false);
                                                ORecordInternal.setVersion(loadedRecord, ORecordVersionHelper.setRollbackMode(recordVersion));
                                                loadedDocument.setDirty();
                                                newRecord = loadedDocument;
                                            }
                                            newRecord.save();
                                            ODistributedServerLog.debug((Object)this, nodeName, iNode, ODistributedServerLog.DIRECTION.IN, "DELTA <- updating rid=%s type=%d size=%d v=%d content=%s", new Object[]{rid, (int)recordType, recordSize, recordVersion, newRecord});
                                            ++totalUpdated;
                                            ** GOTO lbl106
                                        }
                                        case 4: {
                                            do {
                                                newRecord = Orient.instance().getRecordFactoryManager().newInstance(recordType, rid.getClusterId(), null);
                                                ORecordInternal.fill(newRecord, new ORecordId(rid.getClusterId(), -1L), recordVersion - 1, recordContent, true);
                                                try {
                                                    newRecord.save();
                                                }
                                                catch (ORecordNotFoundException e) {
                                                    ODistributedServerLog.info((Object)this, nodeName, iNode, ODistributedServerLog.DIRECTION.IN, "DELTA <- error on saving record (not found) rid=%s type=%d size=%d v=%d content=%s", new Object[]{rid, (int)recordType, recordSize, recordVersion, newRecord});
                                                }
                                                catch (ORecordDuplicatedException e) {
                                                    ODistributedServerLog.info((Object)this, nodeName, iNode, ODistributedServerLog.DIRECTION.IN, "DELTA <- error on saving record (duplicated %s) rid=%s type=%d size=%d v=%d content=%s", new Object[]{e.getRid(), rid, (int)recordType, recordSize, recordVersion, newRecord});
                                                    duplicatedRecord = (ORecord)db.load(e.getRid(), (String)null, true);
                                                    if (duplicatedRecord != null) break;
                                                    doc = (ODocument)newRecord;
                                                    index = db.getMetadata().getIndexManager().getIndex(e.getIndexName());
                                                    fields = index.getDefinition().getFields();
                                                    values = new ArrayList<RET>(fields.size());
                                                    for (String f : fields) {
                                                        values.add(doc.field(f));
                                                    }
                                                    keyValue = index.getDefinition().createValue(values);
                                                    index.remove(keyValue, e.getRid());
                                                    newRecord.save();
                                                }
                                                if (newRecord.getIdentity().getClusterPosition() >= clusterPos) continue;
                                                ODistributedServerLog.debug((Object)this, nodeName, iNode, ODistributedServerLog.DIRECTION.IN, "DELTA <- creating hole rid=%s", new Object[]{newRecord.getIdentity()});
                                                newRecord.delete();
                                                ++totalHoles;
                                            } while (newRecord.getIdentity().getClusterPosition() < clusterPos);
                                            ODistributedServerLog.debug((Object)this, nodeName, iNode, ODistributedServerLog.DIRECTION.IN, "DELTA <- creating rid=%s type=%d size=%d v=%d content=%s", new Object[]{rid, (int)recordType, recordSize, recordVersion, newRecord});
                                            ++totalCreated;
                                        }
lbl106:
                                        // 3 sources

                                        default: {
                                            if (!newRecord.getIdentity().isPersistent() || newRecord.getIdentity().equals(rid)) break;
                                            throw new ODistributedDatabaseDeltaSyncException("Error on synchronization of records, rids are different: saved " + newRecord.getIdentity() + ", but it should be " + rid);
                                        }
                                    }
                                }
                                if ((now = System.currentTimeMillis()) - lastLap <= 2000L) continue;
                                ODistributedServerLog.info((Object)this, nodeName, iNode, ODistributedServerLog.DIRECTION.IN, "- %,d total entries: %,d created, %,d updated, %,d deleted, %,d holes, %,d skipped...", new Object[]{totalRecords, totalCreated, totalUpdated, totalDeleted, totalHoles, totalSkipped});
                                lastLap = now;
                            }
                            db.getMetadata().reload();
                        }
                        finally {
                            input.close();
                        }
                    }
                    catch (Exception e) {
                        ODistributedServerLog.error((Object)this, nodeName, iNode, ODistributedServerLog.DIRECTION.IN, "Error on installing database delta '%s' on local server", e, new Object[]{db.getName()});
                        throw OException.wrapException(new ODistributedException("Error on installing database delta '" + db.getName() + "' on local server"), e);
                    }
                    ODistributedServerLog.info((Object)this, nodeName, iNode, ODistributedServerLog.DIRECTION.IN, "Installed database delta for '%s'. %d total entries: %d created, %d updated, %d deleted, %d holes, %,d skipped", new Object[]{db.getName(), totalRecords, totalCreated, totalUpdated, totalDeleted, totalHoles, totalSkipped});
                    return null;
                }
            });
            db.activateOnCurrentThread();
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, nodeName, iNode, ODistributedServerLog.DIRECTION.IN, "Error while applying changes of database delta sync on '%s': forcing full database sync...", e, db.getName());
            throw OException.wrapException(new ODistributedDatabaseDeltaSyncException("Error while applying changes of database delta sync on '" + db.getName() + "': forcing full database sync..."), e);
        }
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$com$orientechnologies$orient$core$storage$cluster$OPaginatedCluster$RECORD_STATUS;

        static {
            $SwitchMap$com$orientechnologies$orient$core$storage$cluster$OPaginatedCluster$RECORD_STATUS = new int[OPaginatedCluster.RECORD_STATUS.values().length];
            try {
                2.$SwitchMap$com$orientechnologies$orient$core$storage$cluster$OPaginatedCluster$RECORD_STATUS[OPaginatedCluster.RECORD_STATUS.REMOVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$orientechnologies$orient$core$storage$cluster$OPaginatedCluster$RECORD_STATUS[OPaginatedCluster.RECORD_STATUS.ALLOCATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$orientechnologies$orient$core$storage$cluster$OPaginatedCluster$RECORD_STATUS[OPaginatedCluster.RECORD_STATUS.PRESENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$orientechnologies$orient$core$storage$cluster$OPaginatedCluster$RECORD_STATUS[OPaginatedCluster.RECORD_STATUS.NOT_EXISTENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

