/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.proxy;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.server.distributed.impl.proxy.OProxyServerListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class OProxyChannel
extends Thread {
    private final OProxyServerListener listener;
    private final Socket sourceSocket;
    private final int localPort;
    private final String remoteHost;
    private final int remotePort;
    private final InetSocketAddress sourceAddress;
    Thread responseThread;
    ServerSocket localSocket;
    Socket targetSocket;
    InputStream sourceInput;
    OutputStream sourceOutput;
    InputStream targetInput;
    OutputStream targetOutput;
    boolean running = true;
    protected long requestCount = 0L;
    protected long responseCount = 0L;

    public OProxyChannel(OProxyServerListener listener, Socket sourceSocket, int localPort, int remotePort) {
        this.listener = listener;
        this.sourceSocket = sourceSocket;
        this.localPort = localPort;
        this.remoteHost = listener.getServer().getRemoteHost();
        this.remotePort = remotePort;
        this.sourceAddress = (InetSocketAddress)sourceSocket.getRemoteSocketAddress();
        OLogManager.instance().info((Object)this, "Proxy server: created channel %s:%d->[localhost:%d]->%s:%d", this.sourceAddress.getHostName(), this.sourceAddress.getPort(), localPort, listener.getServer().getRemoteHost(), remotePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                if (this.listener.getServer().readTimeout > 0) {
                    this.sourceSocket.setSoTimeout(this.listener.getServer().readTimeout);
                }
                this.sourceInput = this.sourceSocket.getInputStream();
                this.sourceOutput = this.sourceSocket.getOutputStream();
                this.targetSocket = this.listener.connectTargetServer();
                if (this.listener.getServer().readTimeout > 0) {
                    this.targetSocket.setSoTimeout(this.listener.getServer().readTimeout);
                }
                this.targetInput = this.targetSocket.getInputStream();
                this.targetOutput = this.targetSocket.getOutputStream();
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Proxy server: error on connecting to the remote server %s:%d", e, this.remoteHost, this.remotePort);
                this.shutdown();
                return;
            }
            this.createResponseThread();
            try {
                byte[] request = new byte[this.listener.getServer().bufferSize];
                while (this.running) {
                    int bytesRead = 0;
                    try {
                        bytesRead = this.sourceInput.read(request);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        // empty catch block
                    }
                    if (bytesRead < 1) continue;
                    ++this.requestCount;
                    this.listener.getServer().onMessage(true, this.localPort, this.remotePort, request, bytesRead);
                    this.targetOutput.write(request, 0, bytesRead);
                    this.targetOutput.flush();
                    if (this.listener.getServer().tracing.equalsIgnoreCase("none")) continue;
                    OLogManager.instance().info((Object)this, "Proxy channel: REQUEST(%d) %s:%d->[localhost:%d]->%s:%d = %d[%s]", this.requestCount, this.sourceAddress.getHostName(), this.sourceAddress.getPort(), this.localPort, this.remoteHost, this.remotePort, bytesRead, this.formatBytes(request, bytesRead));
                }
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Proxy channel: error on reading request from port %d", e, this.localPort);
            }
        }
        finally {
            this.shutdown();
        }
    }

    public void shutdown() {
        this.running = false;
        if (this.localSocket != null) {
            try {
                this.localSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.sourceInput != null) {
            try {
                this.sourceInput.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.sourceOutput != null) {
            try {
                this.sourceOutput.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.sourceSocket != null) {
            try {
                this.sourceSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.targetSocket != null) {
            try {
                this.targetSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.targetOutput != null) {
            try {
                this.targetOutput.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.responseThread != null) {
            try {
                this.responseThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void sendShutdown() {
        this.interrupt();
        this.shutdown();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void createResponseThread() {
        this.responseThread = new Thread(){

            @Override
            public void run() {
                try {
                    byte[] response = new byte[((OProxyChannel)OProxyChannel.this).listener.getServer().bufferSize];
                    while (OProxyChannel.this.running) {
                        int bytesRead = 0;
                        try {
                            bytesRead = OProxyChannel.this.targetInput.read(response);
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            // empty catch block
                        }
                        if (bytesRead < 1) continue;
                        ++OProxyChannel.this.responseCount;
                        OProxyChannel.this.listener.getServer().onMessage(false, OProxyChannel.this.localPort, OProxyChannel.this.remotePort, response, bytesRead);
                        OProxyChannel.this.sourceOutput.write(response, 0, bytesRead);
                        OProxyChannel.this.sourceOutput.flush();
                        if (((OProxyChannel)OProxyChannel.this).listener.getServer().tracing.equalsIgnoreCase("none")) continue;
                        OLogManager.instance().info((Object)this, "Proxy channel: RESPONSE(%d) %s:%d->[localhost:%d]->%s:%d = %d[%s]", OProxyChannel.this.responseCount, OProxyChannel.this.remoteHost, OProxyChannel.this.remotePort, OProxyChannel.this.localPort, OProxyChannel.this.sourceAddress.getHostName(), OProxyChannel.this.sourceAddress.getPort(), bytesRead, OProxyChannel.this.formatBytes(response, bytesRead));
                    }
                }
                catch (IOException e) {
                    OLogManager.instance().error(this, "Proxy channel: error on reading request from port %s:%d", e, OProxyChannel.this.remoteHost, OProxyChannel.this.remotePort);
                    OProxyChannel.this.running = false;
                }
            }
        };
        this.responseThread.start();
    }

    private String formatBytes(byte[] request, int total) {
        if ("none".equalsIgnoreCase(this.listener.getServer().tracing)) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < total; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            if ("byte".equalsIgnoreCase(this.listener.getServer().tracing)) {
                buffer.append(request[i]);
                continue;
            }
            if (!"hex".equalsIgnoreCase(this.listener.getServer().tracing)) continue;
            buffer.append(String.format("0x%x", request[i]));
        }
        return buffer.toString();
    }
}

