/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OGossipTask
extends OAbstractRemoteTask {
    public static final int FACTORYID = 16;
    private long timestamp = System.currentTimeMillis();
    private String lockManagerServer;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");

    public OGossipTask() {
    }

    public OGossipTask(String lockManagerServer) {
        this.lockManagerServer = lockManagerServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(ODistributedRequestId msgId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (ODistributedServerLog.isDebugEnabled()) {
            SimpleDateFormat simpleDateFormat = dateFormat;
            synchronized (simpleDateFormat) {
                ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Received gossip message (sourceTimeStamp=%s lockManagerServer=%s)", dateFormat.format(new Date(this.timestamp)), this.lockManagerServer);
            }
        }
        return this.lockManagerServer;
    }

    @Override
    public int[] getPartitionKey() {
        return FAST_NOLOCK;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    @Override
    public boolean isUsingDatabase() {
        return false;
    }

    @Override
    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.UNION;
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeUTF(this.lockManagerServer);
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.timestamp = in.readLong();
        this.lockManagerServer = in.readUTF();
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_HEARTBEAT_TIMEOUT.getValueAsLong();
    }

    @Override
    public long getSynchronousTimeout(int iSynchNodes) {
        return this.getDistributedTimeout();
    }

    @Override
    public long getTotalTimeout(int iTotalNodes) {
        return this.getDistributedTimeout();
    }

    @Override
    public String getName() {
        return "gossip";
    }

    @Override
    public int getFactoryId() {
        return 16;
    }

    @Override
    public boolean isNodeOnlineRequired() {
        return false;
    }

    @Override
    public String toString() {
        return this.getName() + " timestamp: " + this.timestamp + " lockManagerServer: " + this.lockManagerServer;
    }
}

