/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.task.OAbstractReadRecordTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OReadRecordIfNotLatestTask
extends OAbstractReadRecordTask {
    public static final int FACTORYID = 2;
    protected int recordVersion;

    public OReadRecordIfNotLatestTask() {
        this.lockRecords = false;
    }

    @Override
    public OReadRecordIfNotLatestTask init(ORecordId rid, int recordVersion) {
        super.init(rid);
        this.recordVersion = recordVersion;
        this.lockRecords = false;
        return this;
    }

    @Override
    public Object executeRecordTask(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        Object record = database.loadIfVersionIsNotLatest(this.rid, this.recordVersion, null, true);
        if (record == null) {
            return null;
        }
        return new ORawBuffer((ORecord)record);
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        super.toStream(out);
        out.writeInt(this.recordVersion);
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        super.fromStream(in, factory);
        this.recordVersion = in.readInt();
    }

    @Override
    public String getName() {
        return "record_read_if_not_latest";
    }

    @Override
    public int getFactoryId() {
        return 2;
    }
}

