/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.task.OTxTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class ORepairClusterTask
extends OTxTask {
    public static final int FACTORYID = 18;
    private int clusterId;

    public ORepairClusterTask init(int clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        Iterator iterator;
        String clusterName = database.getClusterNameById(this.clusterId);
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Repair cluster: repairing cluster '%s' db=%s (reqId=%s)...", clusterName, database.getName(), requestId);
        ODatabaseRecordThreadLocal.instance().set(database);
        ODistributedDatabase ddb = iManager.getMessageService().getDatabase(database.getName());
        ODistributedTxContext reqContext = ddb.registerTxContext(requestId);
        try {
            ODistributedConfiguration dCfg = iManager.getDatabaseConfiguration(database.getName());
            reqContext.lock(new ORecordId(this.clusterId, -1L));
            for (OAbstractRecordReplicatedTask task : this.tasks) {
                if (!task.checkForClusterAvailability(iManager.getLocalNodeName(), dCfg)) {
                    String taskResult = "_non_local_cluster";
                    continue;
                }
                task.setLockRecords(false);
                task.checkRecordExists();
                task.execute(requestId, iServer, iManager, database);
                reqContext.addUndoTask(task.getUndoTask(iManager, requestId, null));
            }
            iterator = null;
            ddb.popTxContext(requestId);
        }
        catch (Exception e) {
            Exception exception;
            try {
                ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Repair cluster: rolling back transaction db=%s (reqId=%s error=%s)...", database.getName(), requestId, e);
                reqContext.unlock();
                exception = e;
                ddb.popTxContext(requestId);
            }
            catch (Throwable throwable) {
                ddb.popTxContext(requestId);
                reqContext.destroy();
                ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Repair cluster: transaction completed db=%s (reqId=%s)...", database.getName(), requestId);
                throw throwable;
            }
            reqContext.destroy();
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Repair cluster: transaction completed db=%s (reqId=%s)...", database.getName(), requestId);
            return exception;
        }
        reqContext.destroy();
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Repair cluster: transaction completed db=%s (reqId=%s)...", database.getName(), requestId);
        return iterator;
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        super.toStream(out);
        out.writeInt(this.clusterId);
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        super.fromStream(in, factory);
        this.clusterId = in.readInt();
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    @Override
    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.UNION;
    }

    @Override
    public String getName() {
        return "repair_cluster";
    }

    @Override
    public int getFactoryId() {
        return 18;
    }

    @Override
    public ORemoteTask getUndoTask(ODistributedServerManager dManager, ODistributedRequestId reqId, List<String> servers) {
        return null;
    }

    @Override
    public ORemoteTask getFixTask(ODistributedRequest iRequest, ORemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse, String executorNodeName, ODistributedServerManager dManager) {
        return null;
    }
}

