/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ORequestDatabaseConfigurationTask
extends OAbstractRemoteTask {
    public static final int FACTORYID = 27;
    private String databaseName;

    public ORequestDatabaseConfigurationTask() {
    }

    public ORequestDatabaseConfigurationTask(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public Object execute(ODistributedRequestId msgId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedConfiguration cfg = iManager.getDatabaseConfiguration(this.databaseName);
        if (cfg != null) {
            return cfg.getDocument();
        }
        return null;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    @Override
    public boolean isUsingDatabase() {
        return false;
    }

    @Override
    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.UNION;
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        out.writeUTF(this.databaseName);
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.databaseName = in.readUTF();
    }

    @Override
    public boolean isNodeOnlineRequired() {
        return false;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_HEARTBEAT_TIMEOUT.getValueAsLong();
    }

    @Override
    public String getName() {
        return "req_db_cfg";
    }

    @Override
    public int getFactoryId() {
        return 27;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

