/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkDistributed;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.OTransactionOptimisticDistributed;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase1TaskResult;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionResultPayload;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxConcurrentCreation;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxConcurrentModification;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxException;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxKeyLockTimeout;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxRecordLockTimeout;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxSuccess;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxUniqueIndex;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedKeyLockedException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OTransactionPhase1Task
extends OAbstractReplicatedTask {
    public static final int FACTORYID = 43;
    private volatile boolean hasResponse;
    private OLogSequenceNumber lastLSN;
    private List<ORecordOperation> ops;
    private List<ORecordOperationRequest> operations;
    private OCommandDistributedReplicateRequest.QUORUM_TYPE quorumType = OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    private transient int retryCount = 0;

    public OTransactionPhase1Task() {
        this.ops = new ArrayList<ORecordOperation>();
        this.operations = new ArrayList<ORecordOperationRequest>();
    }

    public OTransactionPhase1Task(List<ORecordOperation> ops) {
        this.ops = ops;
        this.operations = new ArrayList<ORecordOperationRequest>();
        this.genOps(ops);
    }

    public void genOps(List<ORecordOperation> ops) {
        for (ORecordOperation txEntry : ops) {
            if (txEntry.type == 0) continue;
            ORecordOperationRequest request = new ORecordOperationRequest();
            request.setType(txEntry.type);
            request.setVersion(txEntry.getRecord().getVersion());
            request.setId(txEntry.getRecord().getIdentity());
            request.setRecordType(ORecordInternal.getRecordType(txEntry.getRecord()));
            switch (txEntry.type) {
                case 1: 
                case 3: {
                    request.setRecord(ORecordSerializerNetworkDistributed.INSTANCE.toStream(txEntry.getRecord(), false));
                    request.setContentChanged(ORecordInternal.isContentChanged(txEntry.getRecord()));
                    break;
                }
            }
            this.operations.add(request);
        }
    }

    @Override
    public String getName() {
        return "TxPhase1";
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return this.quorumType;
    }

    @Override
    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        OTransactionOptimisticDistributed tx;
        OTransactionResultPayload res1;
        if (iManager != null) {
            iManager.messageBeforeOp("prepare1Phase", requestId);
        }
        this.convert(database);
        if (iManager != null) {
            iManager.messageAfterOp("prepare1Phase", requestId);
        }
        if ((res1 = OTransactionPhase1Task.executeTransaction(requestId, (ODatabaseDocumentDistributed)database, tx = new OTransactionOptimisticDistributed(database, this.ops), false, this.retryCount)) == null) {
            ++this.retryCount;
            ((ODatabaseDocumentDistributed)database).getStorageDistributed().getLocalDistributedDatabase().reEnqueue(requestId.getNodeId(), requestId.getMessageId(), database.getName(), this, this.retryCount);
            this.hasResponse = false;
            return null;
        }
        this.hasResponse = true;
        return new OTransactionPhase1TaskResult(res1);
    }

    @Override
    public boolean hasResponse() {
        return this.hasResponse;
    }

    public static OTransactionResultPayload executeTransaction(ODistributedRequestId requestId, ODatabaseDocumentDistributed database, OTransactionInternal tx, boolean local, int retryCount) {
        OTransactionResultPayload payload;
        try {
            if (!database.beginDistributedTx(requestId, tx, local, retryCount)) {
                return null;
            }
            payload = new OTxSuccess();
        }
        catch (OConcurrentModificationException ex) {
            payload = new OTxConcurrentModification((ORecordId)ex.getRid(), ex.getEnhancedDatabaseVersion());
        }
        catch (ODistributedRecordLockedException ex) {
            payload = new OTxRecordLockTimeout(ex.getNode(), ex.getRid());
        }
        catch (ODistributedKeyLockedException ex) {
            payload = new OTxKeyLockTimeout(ex.getNode(), ex.getKey());
        }
        catch (ORecordDuplicatedException ex) {
            payload = new OTxUniqueIndex((ORecordId)ex.getRid(), ex.getIndexName(), ex.getKey());
        }
        catch (OConcurrentCreateException ex) {
            payload = new OTxConcurrentCreation(ex.getActualRid(), ex.getExpectedRid());
        }
        catch (RuntimeException ex) {
            payload = new OTxException(ex);
        }
        return payload;
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            ORecordOperationRequest req = OMessageHelper.readTransactionEntry(in);
            this.operations.add(req);
        }
        this.lastLSN = new OLogSequenceNumber(in);
        if (this.lastLSN.getSegment() == -1L && this.lastLSN.getSegment() == -1L) {
            this.lastLSN = null;
        }
    }

    private void convert(ODatabaseDocumentInternal database) {
        for (ORecordOperationRequest req : this.operations) {
            byte type = req.getType();
            if (type == 0) continue;
            ORecord record = null;
            switch (type) {
                case 1: 
                case 3: {
                    record = ORecordSerializerNetworkDistributed.INSTANCE.fromStream(req.getRecord(), null, null);
                    ORecordInternal.setRecordSerializer(record, database.getSerializer());
                    break;
                }
                case 2: {
                    record = (ORecord)database.getRecord(req.getId());
                    if (record != null) break;
                    record = Orient.instance().getRecordFactoryManager().newInstance(req.getRecordType(), req.getId().getClusterId(), database);
                }
            }
            ORecordInternal.setIdentity(record, (ORecordId)req.getId());
            ORecordInternal.setVersion(record, req.getVersion());
            ORecordOperation op = new ORecordOperation(record, type);
            this.ops.add(op);
        }
        this.operations.clear();
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        out.writeInt(this.operations.size());
        for (ORecordOperationRequest operation : this.operations) {
            OMessageHelper.writeTransactionEntry(out, operation);
        }
        if (this.lastLSN == null) {
            new OLogSequenceNumber(-1L, -1L).toStream(out);
        } else {
            this.lastLSN.toStream(out);
        }
    }

    @Override
    public int getFactoryId() {
        return 43;
    }

    public void init(OTransactionInternal operations) {
        for (Map.Entry<String, OTransactionIndexChanges> indexOp : operations.getIndexOperations().entrySet()) {
            if (!indexOp.getValue().resolveAssociatedIndex(indexOp.getKey(), operations.getDatabase().getMetadata().getIndexManager()).isUnique()) continue;
            this.quorumType = OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE_ALL_MASTERS;
            break;
        }
        this.ops = new ArrayList<ORecordOperation>(operations.getRecordOperations());
        this.genOps(this.ops);
    }

    public void setLastLSN(OLogSequenceNumber lastLSN) {
        this.lastLSN = lastLSN;
    }

    @Override
    public OLogSequenceNumber getLastLSN() {
        return this.lastLSN;
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    @Override
    public int[] getPartitionKey() {
        if (this.operations.size() > 0) {
            return this.operations.stream().mapToInt(x -> x.getId().getClusterId()).toArray();
        }
        return this.ops.stream().mapToInt(x -> x.getRID().getClusterId()).toArray();
    }

    @Override
    public long getDistributedTimeout() {
        return super.getDistributedTimeout() + (long)(this.operations.size() / 10);
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public List<ORecordOperationRequest> getOperations() {
        return this.operations;
    }

    public List<ORecordOperation> getOps() {
        return this.ops;
    }
}

