/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.sql;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLFactory;
import com.orientechnologies.orient.server.distributed.sql.OCommandExecutorSQLHARemoveServer;
import com.orientechnologies.orient.server.distributed.sql.OCommandExecutorSQLHAStatus;
import com.orientechnologies.orient.server.distributed.sql.OCommandExecutorSQLHASyncCluster;
import com.orientechnologies.orient.server.distributed.sql.OCommandExecutorSQLHASyncDatabase;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ODistributedCommandExecutorSQLFactory
implements OCommandExecutorSQLFactory {
    private static final Map<String, Class<? extends OCommandExecutorSQLAbstract>> COMMANDS;

    @Override
    public Set<String> getCommandNames() {
        return COMMANDS.keySet();
    }

    @Override
    public OCommandExecutorSQLAbstract createCommand(String name) throws OCommandExecutionException {
        Class<? extends OCommandExecutorSQLAbstract> clazz = COMMANDS.get(name);
        if (clazz == null) {
            throw new OCommandExecutionException("Unknown command name :" + name);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException("Error in creation of command " + name + "(). Probably there is not an empty constructor or the constructor generates errors"), e);
        }
    }

    static {
        HashMap<String, Class> commands = new HashMap<String, Class>();
        commands.put("HA SYNC DATABASE", OCommandExecutorSQLHASyncDatabase.class);
        commands.put("HA SYNC CLUSTER", OCommandExecutorSQLHASyncCluster.class);
        commands.put("HA REMOVE SERVER", OCommandExecutorSQLHARemoveServer.class);
        commands.put("HA STATUS", OCommandExecutorSQLHAStatus.class);
        COMMANDS = Collections.unmodifiableMap(commands);
    }
}

