/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.plugin;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.server.plugin.OServerPlugin;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class OServerPluginInfo {
    private final String name;
    private final String version;
    private final String description;
    private final String web;
    private final OServerPlugin instance;
    private final Map<String, Object> parameters;
    private final long loadedOn;
    private final URLClassLoader pluginClassLoader;

    public OServerPluginInfo(String name, String version, String description, String web, OServerPlugin instance, Map<String, Object> parameters, long loadedOn, URLClassLoader pluginClassLoader) {
        this.name = name;
        this.version = version;
        this.description = description;
        this.web = web;
        this.instance = instance;
        this.parameters = parameters != null ? parameters : new HashMap();
        this.loadedOn = loadedOn;
        this.pluginClassLoader = pluginClassLoader;
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean closeClassLoader) {
        if (this.instance != null) {
            this.instance.sendShutdown();
        }
        if (this.pluginClassLoader != null && closeClassLoader) {
            try {
                Method m = this.pluginClassLoader.getClass().getMethod("close", new Class[0]);
                if (m != null) {
                    m.invoke((Object)this.pluginClassLoader, new Object[0]);
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error on closing plugin classloader", e, new Object[0]);
            }
        }
    }

    public boolean isDynamic() {
        return this.loadedOn > 0L;
    }

    public String getName() {
        return this.name;
    }

    public OServerPlugin getInstance() {
        return this.instance;
    }

    public long getLoadedOn() {
        return this.loadedOn;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getWeb() {
        return this.web;
    }

    public Object getParameter(String iName) {
        return this.parameters.get(iName);
    }

    public URLClassLoader getClassLoader() {
        return this.pluginClassLoader;
    }
}

