/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.event;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.WrappedGraphQuery;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.util.wrappers.event.EventEdge;
import com.tinkerpop.blueprints.util.wrappers.event.EventEdgeIterable;
import com.tinkerpop.blueprints.util.wrappers.event.EventTrigger;
import com.tinkerpop.blueprints.util.wrappers.event.EventVertex;
import com.tinkerpop.blueprints.util.wrappers.event.EventVertexIterable;
import com.tinkerpop.blueprints.util.wrappers.event.listener.EdgeAddedEvent;
import com.tinkerpop.blueprints.util.wrappers.event.listener.EdgeRemovedEvent;
import com.tinkerpop.blueprints.util.wrappers.event.listener.GraphChangedListener;
import com.tinkerpop.blueprints.util.wrappers.event.listener.VertexAddedEvent;
import com.tinkerpop.blueprints.util.wrappers.event.listener.VertexRemovedEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EventGraph<T extends Graph>
implements Graph,
WrapperGraph<T> {
    protected EventTrigger trigger;
    protected final T baseGraph;
    protected final List<GraphChangedListener> graphChangedListeners = new ArrayList<GraphChangedListener>();
    private final Features features;

    public EventGraph(T baseGraph) {
        this.baseGraph = baseGraph;
        this.features = this.baseGraph.getFeatures().copyFeatures();
        this.features.isWrapper = true;
        this.trigger = new EventTrigger(this, false);
    }

    public void removeAllListeners() {
        this.graphChangedListeners.clear();
    }

    public void addListener(GraphChangedListener listener) {
        this.graphChangedListeners.add(listener);
    }

    public Iterator<GraphChangedListener> getListenerIterator() {
        return this.graphChangedListeners.iterator();
    }

    public EventTrigger getTrigger() {
        return this.trigger;
    }

    public void removeListener(GraphChangedListener listener) {
        this.graphChangedListeners.remove(listener);
    }

    protected void onVertexAdded(Vertex vertex) {
        this.trigger.addEvent(new VertexAddedEvent(vertex));
    }

    protected void onVertexRemoved(Vertex vertex, Map<String, Object> props2) {
        this.trigger.addEvent(new VertexRemovedEvent(vertex, props2));
    }

    protected void onEdgeAdded(Edge edge) {
        this.trigger.addEvent(new EdgeAddedEvent(edge));
    }

    protected void onEdgeRemoved(Edge edge, Map<String, Object> props2) {
        this.trigger.addEvent(new EdgeRemovedEvent(edge, props2));
    }

    @Override
    public Vertex addVertex(Object id) {
        Vertex vertex = this.baseGraph.addVertex(id);
        if (vertex == null) {
            return null;
        }
        this.onVertexAdded(vertex);
        return new EventVertex(vertex, this);
    }

    @Override
    public Vertex getVertex(Object id) {
        Vertex vertex = this.baseGraph.getVertex(id);
        if (vertex == null) {
            return null;
        }
        return new EventVertex(vertex, this);
    }

    @Override
    public void removeVertex(Vertex vertex) {
        Vertex vertexToRemove = vertex;
        if (vertex instanceof EventVertex) {
            vertexToRemove = ((EventVertex)vertex).getBaseVertex();
        }
        Map<String, Object> props2 = ElementHelper.getProperties(vertex);
        this.baseGraph.removeVertex(vertexToRemove);
        this.onVertexRemoved(vertex, props2);
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new EventVertexIterable(this.baseGraph.getVertices(), this);
    }

    @Override
    public Iterable<Vertex> getVertices(String key, Object value) {
        return new EventVertexIterable(this.baseGraph.getVertices(key, value), this);
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        Edge edge;
        Vertex outVertexToSet = outVertex;
        if (outVertex instanceof EventVertex) {
            outVertexToSet = ((EventVertex)outVertex).getBaseVertex();
        }
        Vertex inVertexToSet = inVertex;
        if (inVertex instanceof EventVertex) {
            inVertexToSet = ((EventVertex)inVertex).getBaseVertex();
        }
        if ((edge = this.baseGraph.addEdge(id, outVertexToSet, inVertexToSet, label)) == null) {
            return null;
        }
        this.onEdgeAdded(edge);
        return new EventEdge(edge, this);
    }

    @Override
    public Edge getEdge(Object id) {
        Edge edge = this.baseGraph.getEdge(id);
        if (edge == null) {
            return null;
        }
        return new EventEdge(edge, this);
    }

    @Override
    public void removeEdge(Edge edge) {
        Edge edgeToRemove = edge;
        if (edge instanceof EventEdge) {
            edgeToRemove = ((EventEdge)edge).getBaseEdge();
        }
        Map<String, Object> props2 = ElementHelper.getProperties(edge);
        this.baseGraph.removeEdge(edgeToRemove);
        this.onEdgeRemoved(edge, props2);
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new EventEdgeIterable(this.baseGraph.getEdges(), this);
    }

    @Override
    public Iterable<Edge> getEdges(String key, Object value) {
        return new EventEdgeIterable(this.baseGraph.getEdges(key, value), this);
    }

    @Override
    public GraphQuery query() {
        final EventGraph eventGraph = this;
        return new WrappedGraphQuery(this.baseGraph.query()){

            @Override
            public Iterable<Edge> edges() {
                return new EventEdgeIterable(this.query.edges(), eventGraph);
            }

            @Override
            public Iterable<Vertex> vertices() {
                return new EventVertexIterable(this.query.vertices(), eventGraph);
            }
        };
    }

    @Override
    public void shutdown() {
        try {
            this.baseGraph.shutdown();
            this.trigger.fireEventQueue();
            this.trigger.resetEventQueue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return StringFactory.graphString(this, this.baseGraph.toString());
    }

    @Override
    public T getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }
}

