/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.logging.LogFactory;

public class DatabaseConfiguration
extends AbstractConfiguration {
    private DataSource datasource;
    private String table;
    private String nameColumn;
    private String keyColumn;
    private String valueColumn;
    private String name;

    public DatabaseConfiguration(DataSource datasource, String table, String nameColumn, String keyColumn, String valueColumn, String name) {
        this.datasource = datasource;
        this.table = table;
        this.nameColumn = nameColumn;
        this.keyColumn = keyColumn;
        this.valueColumn = valueColumn;
        this.name = name;
        this.setLogger(LogFactory.getLog(this.getClass()));
        this.addErrorLogListener();
    }

    public DatabaseConfiguration(DataSource datasource, String table, String keyColumn, String valueColumn) {
        this(datasource, table, null, keyColumn, valueColumn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String key) {
        ArrayList<Object> result = null;
        StringBuffer query = new StringBuffer("SELECT * FROM ");
        query.append(this.table).append(" WHERE ");
        query.append(this.keyColumn).append("=?");
        if (this.nameColumn != null) {
            query.append(" AND " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            pstmt.setString(1, key);
            if (this.nameColumn != null) {
                pstmt.setString(2, this.name);
            }
            ResultSet rs = pstmt.executeQuery();
            ArrayList<Object> results = new ArrayList<Object>();
            while (rs.next()) {
                Object value = rs.getObject(this.valueColumn);
                if (this.isDelimiterParsingDisabled()) {
                    results.add(value);
                    continue;
                }
                CollectionUtils.addAll(results, (Iterator)PropertyConverter.toIterator(value, this.getListDelimiter()));
            }
            if (!results.isEmpty()) {
                result = results.size() > 1 ? results : results.get(0);
            }
            this.close(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                this.fireError(5, key, null, e);
                this.close(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPropertyDirect(String key, Object obj) {
        StringBuffer query = new StringBuffer("INSERT INTO " + this.table);
        if (this.nameColumn != null) {
            query.append(" (" + this.nameColumn + ", " + this.keyColumn + ", " + this.valueColumn + ") VALUES (?, ?, ?)");
        } else {
            query.append(" (" + this.keyColumn + ", " + this.valueColumn + ") VALUES (?, ?)");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            int index = 1;
            if (this.nameColumn != null) {
                pstmt.setString(index++, this.name);
            }
            pstmt.setString(index++, key);
            pstmt.setString(index++, String.valueOf(obj));
            pstmt.executeUpdate();
            this.close(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                this.fireError(1, key, obj, e);
                this.close(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String key, Object value) {
        boolean parsingFlag = this.isDelimiterParsingDisabled();
        try {
            if (value instanceof String) {
                this.setDelimiterParsingDisabled(true);
            }
            super.addProperty(key, value);
        }
        finally {
            this.setDelimiterParsingDisabled(parsingFlag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean empty = true;
        StringBuffer query = new StringBuffer("SELECT count(*) FROM " + this.table);
        if (this.nameColumn != null) {
            query.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            ResultSet rs;
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            if (this.nameColumn != null) {
                pstmt.setString(1, this.name);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                empty = rs.getInt(1) == 0;
            }
            this.close(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                this.fireError(5, null, null, e);
                this.close(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt);
                throw throwable;
            }
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        boolean found = false;
        StringBuffer query = new StringBuffer("SELECT * FROM " + this.table + " WHERE " + this.keyColumn + "=?");
        if (this.nameColumn != null) {
            query.append(" AND " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            pstmt.setString(1, key);
            if (this.nameColumn != null) {
                pstmt.setString(2, this.name);
            }
            ResultSet rs = pstmt.executeQuery();
            found = rs.next();
            this.close(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                this.fireError(5, key, null, e);
                this.close(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt);
                throw throwable;
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProperty(String key) {
        StringBuffer query = new StringBuffer("DELETE FROM " + this.table + " WHERE " + this.keyColumn + "=?");
        if (this.nameColumn != null) {
            query.append(" AND " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            pstmt.setString(1, key);
            if (this.nameColumn != null) {
                pstmt.setString(2, this.name);
            }
            pstmt.executeUpdate();
            this.close(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                this.fireError(2, key, null, e);
                this.close(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        StringBuffer query = new StringBuffer("DELETE FROM " + this.table);
        if (this.nameColumn != null) {
            query.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            if (this.nameColumn != null) {
                pstmt.setString(1, this.name);
            }
            pstmt.executeUpdate();
            this.close(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                this.fireError(4, null, null, e);
                this.close(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getKeys() {
        ArrayList<String> keys2 = new ArrayList<String>();
        StringBuffer query = new StringBuffer("SELECT DISTINCT " + this.keyColumn + " FROM " + this.table);
        if (this.nameColumn != null) {
            query.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            if (this.nameColumn != null) {
                pstmt.setString(1, this.name);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                keys2.add(rs.getString(1));
            }
            this.close(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                this.fireError(5, null, null, e);
                this.close(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt);
                throw throwable;
            }
        }
        return keys2.iterator();
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    protected Connection getConnection() throws SQLException {
        return this.getDatasource().getConnection();
    }

    private void close(Connection conn, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            this.getLogger().error("An error occured on closing the statement", e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            this.getLogger().error("An error occured on closing the connection", e);
        }
    }
}

