/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.computer.util.MemoryHelper;

public final class MemoryComputeKey<A>
implements Serializable,
Cloneable {
    private final String key;
    private BinaryOperator<A> reducer;
    private final boolean isTransient;
    private final boolean isBroadcast;

    private MemoryComputeKey(String key, BinaryOperator<A> reducer, boolean isBroadcast, boolean isTransient) {
        this.key = key;
        this.reducer = reducer;
        this.isTransient = isTransient;
        this.isBroadcast = isBroadcast;
        MemoryHelper.validateKey(key);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public BinaryOperator<A> getReducer() {
        return this.reducer;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof MemoryComputeKey && ((MemoryComputeKey)object).key.equals(this.key);
    }

    public MemoryComputeKey<A> clone() {
        try {
            MemoryComputeKey clone = (MemoryComputeKey)super.clone();
            for (Method method : this.reducer.getClass().getMethods()) {
                if (!method.getName().equals("clone") || 0 != method.getParameterCount()) continue;
                clone.reducer = (BinaryOperator)method.invoke(this.reducer, new Object[0]);
                break;
            }
            return clone;
        }
        catch (CloneNotSupportedException | IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static <A> MemoryComputeKey<A> of(String key, BinaryOperator<A> reducer, boolean isBroadcast, boolean isTransient) {
        return new MemoryComputeKey<A>(key, reducer, isBroadcast, isTransient);
    }
}

