/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.dsl;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.GremlinDsl;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.ProcessorException;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

@SupportedAnnotationTypes(value={"org.apache.tinkerpop.gremlin.process.traversal.dsl.GremlinDsl"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class GremlinDslProcessor
extends AbstractProcessor {
    private Messager messager;
    private Elements elementUtils;
    private Filer filer;
    private Types typeUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.typeUtils = processingEnv.getTypeUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            for (Element element : roundEnv.getElementsAnnotatedWith(GremlinDsl.class)) {
                this.validateDSL(element);
                Context ctx = new Context((TypeElement)element);
                this.generateTraversalInterface(ctx);
                this.generateDefaultTraversal(ctx);
                this.generateTraversalSource(ctx);
                this.generateAnonymousTraversal(ctx);
            }
        }
        catch (Exception ex) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
        }
        return true;
    }

    private void generateAnonymousTraversal(Context ctx) throws IOException {
        TypeSpec.Builder anonymousClass = TypeSpec.classBuilder("__").addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        anonymousClass.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        anonymousClass.addMethod(MethodSpec.methodBuilder("start").addModifiers(Modifier.PUBLIC, Modifier.STATIC).addTypeVariable(TypeVariableName.get("A")).addStatement("return new $N<>()", ctx.defaultTraversalClazz).returns(ParameterizedTypeName.get(ctx.traversalClassName, TypeVariableName.get("A"), TypeVariableName.get("A"))).build());
        for (ExecutableElement templateMethod : this.findMethodsOfElement(ctx.annotatedDslType, null)) {
            String methodName = templateMethod.getSimpleName().toString();
            TypeName returnType = this.getReturnTypeDefinition(ctx.traversalClassName, templateMethod);
            MethodSpec.Builder methodToAdd = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.STATIC, Modifier.PUBLIC).addExceptions(templateMethod.getThrownTypes().stream().map(TypeName::get).collect(Collectors.toList())).returns(returnType);
            templateMethod.getTypeParameters().forEach(tp -> methodToAdd.addTypeVariable(TypeVariableName.get(tp)));
            List<? extends TypeMirror> returnTypeArguments = this.getTypeArguments(templateMethod);
            returnTypeArguments.stream().filter(rtm -> rtm instanceof TypeVariable).forEach(rtm -> {
                if (((TypeVariable)rtm).asElement().getSimpleName().contentEquals("S")) {
                    methodToAdd.addTypeVariable(TypeVariableName.get(((TypeVariable)rtm).asElement().getSimpleName().toString()));
                }
            });
            this.addMethodBody(methodToAdd, templateMethod, "return __.<S>start().$L(", ")", methodName);
            anonymousClass.addMethod(methodToAdd.build());
        }
        TypeElement anonymousTraversal = this.elementUtils.getTypeElement(__.class.getCanonicalName());
        Predicate<ExecutableElement> ignore = ee -> ee.getSimpleName().contentEquals("start");
        for (ExecutableElement templateMethod : this.findMethodsOfElement(anonymousTraversal, ignore)) {
            String methodName = templateMethod.getSimpleName().toString();
            TypeName returnType = this.getReturnTypeDefinition(ctx.traversalClassName, templateMethod);
            MethodSpec.Builder methodToAdd = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.STATIC, Modifier.PUBLIC).addExceptions(templateMethod.getThrownTypes().stream().map(TypeName::get).collect(Collectors.toList())).returns(returnType);
            templateMethod.getTypeParameters().forEach(tp -> methodToAdd.addTypeVariable(TypeVariableName.get(tp)));
            if (methodName.equals("__")) {
                for (VariableElement variableElement : templateMethod.getParameters()) {
                    methodToAdd.addParameter(ParameterSpec.get(variableElement));
                }
                methodToAdd.varargs(true);
                methodToAdd.addStatement("return inject(starts)", methodName);
            } else if (templateMethod.getTypeParameters().isEmpty()) {
                List<? extends TypeMirror> types = this.getTypeArguments(templateMethod);
                this.addMethodBody(methodToAdd, templateMethod, "return __.<$T>start().$L(", ")", types.get(0), methodName);
            } else {
                this.addMethodBody(methodToAdd, templateMethod, "return __.<A>start().$L(", ")", methodName);
            }
            anonymousClass.addMethod(methodToAdd.build());
        }
        JavaFile traversalSourceJavaFile = JavaFile.builder(ctx.packageName, anonymousClass.build()).build();
        traversalSourceJavaFile.writeTo(this.filer);
    }

    private void generateTraversalSource(Context ctx) throws IOException {
        TypeElement graphTraversalSourceElement = ctx.traversalSourceDslType;
        TypeSpec.Builder traversalSourceClass = TypeSpec.classBuilder(ctx.traversalSourceClazz).addModifiers(Modifier.PUBLIC).superclass(TypeName.get(graphTraversalSourceElement.asType()));
        traversalSourceClass.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter((Type)((Object)Graph.class), "graph", new Modifier[0]).addStatement("super($N)", "graph").build());
        traversalSourceClass.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter((Type)((Object)Graph.class), "graph", new Modifier[0]).addParameter((Type)((Object)TraversalStrategies.class), "strategies", new Modifier[0]).addStatement("super($N, $N)", "graph", "strategies").build());
        Element tinkerPopsGraphTraversalSource = this.findClassAsElement(graphTraversalSourceElement, GraphTraversalSource.class);
        Predicate<ExecutableElement> ignore = e -> e.getReturnType().getKind() != TypeKind.DECLARED || !((DeclaredType)e.getReturnType()).asElement().getSimpleName().contentEquals(GraphTraversalSource.class.getSimpleName());
        for (ExecutableElement elementOfGraphTraversalSource : this.findMethodsOfElement(tinkerPopsGraphTraversalSource, ignore)) {
            traversalSourceClass.addMethod(this.constructMethod(elementOfGraphTraversalSource, ctx.traversalSourceClassName, "", Modifier.PUBLIC));
        }
        if (!graphTraversalSourceElement.getSimpleName().contentEquals(GraphTraversalSource.class.getSimpleName())) {
            for (ExecutableElement templateMethod : this.findMethodsOfElement(graphTraversalSourceElement, null)) {
                MethodSpec.Builder methodToAdd = MethodSpec.methodBuilder(templateMethod.getSimpleName().toString()).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class);
                methodToAdd.addStatement("$T clone = this.clone()", ctx.traversalSourceClassName);
                this.addMethodBody(methodToAdd, templateMethod, "return new $T (clone, super.$L(", ").asAdmin())", ctx.defaultTraversalClassName, templateMethod.getSimpleName());
                methodToAdd.returns(this.getReturnTypeDefinition(ctx.traversalClassName, templateMethod));
                traversalSourceClass.addMethod(methodToAdd.build());
            }
        }
        if (ctx.generateDefaultMethods) {
            traversalSourceClass.addMethod(MethodSpec.methodBuilder("addV").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addStatement("$N clone = this.clone()", ctx.traversalSourceClazz).addStatement("clone.getBytecode().addStep($T.addV)", GraphTraversal.Symbols.class).addStatement("$N traversal = new $N(clone)", ctx.defaultTraversalClazz, ctx.defaultTraversalClazz).addStatement("return ($T) traversal.asAdmin().addStep(new $T(traversal, null))", ctx.traversalClassName, AddVertexStartStep.class).returns(ParameterizedTypeName.get(ctx.traversalClassName, ClassName.get(Vertex.class), ClassName.get(Vertex.class))).build());
            traversalSourceClass.addMethod(MethodSpec.methodBuilder("addV").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addParameter((Type)((Object)String.class), "label", new Modifier[0]).addStatement("$N clone = this.clone()", ctx.traversalSourceClazz).addStatement("clone.getBytecode().addStep($T.addV, label)", GraphTraversal.Symbols.class).addStatement("$N traversal = new $N(clone)", ctx.defaultTraversalClazz, ctx.defaultTraversalClazz).addStatement("return ($T) traversal.asAdmin().addStep(new $T(traversal, label))", ctx.traversalClassName, AddVertexStartStep.class).returns(ParameterizedTypeName.get(ctx.traversalClassName, ClassName.get(Vertex.class), ClassName.get(Vertex.class))).build());
            traversalSourceClass.addMethod(MethodSpec.methodBuilder("V").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addParameter((Type)((Object)Object[].class), "vertexIds", new Modifier[0]).varargs(true).addStatement("$N clone = this.clone()", ctx.traversalSourceClazz).addStatement("clone.getBytecode().addStep($T.V, vertexIds)", GraphTraversal.Symbols.class).addStatement("$N traversal = new $N(clone)", ctx.defaultTraversalClazz, ctx.defaultTraversalClazz).addStatement("return ($T) traversal.asAdmin().addStep(new $T(traversal, $T.class, true, vertexIds))", ctx.traversalClassName, GraphStep.class, Vertex.class).returns(ParameterizedTypeName.get(ctx.traversalClassName, ClassName.get(Vertex.class), ClassName.get(Vertex.class))).build());
            traversalSourceClass.addMethod(MethodSpec.methodBuilder("E").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addParameter((Type)((Object)Object[].class), "edgeIds", new Modifier[0]).varargs(true).addStatement("$N clone = this.clone()", ctx.traversalSourceClazz).addStatement("clone.getBytecode().addStep($T.E, edgeIds)", GraphTraversal.Symbols.class).addStatement("$N traversal = new $N(clone)", ctx.defaultTraversalClazz, ctx.defaultTraversalClazz).addStatement("return ($T) traversal.asAdmin().addStep(new $T(traversal, $T.class, true, edgeIds))", ctx.traversalClassName, GraphStep.class, Edge.class).returns(ParameterizedTypeName.get(ctx.traversalClassName, ClassName.get(Edge.class), ClassName.get(Edge.class))).build());
        }
        JavaFile traversalSourceJavaFile = JavaFile.builder(ctx.packageName, traversalSourceClass.build()).build();
        traversalSourceJavaFile.writeTo(this.filer);
    }

    private Element findClassAsElement(Element element, Class<?> clazz) {
        if (element.getSimpleName().contentEquals(clazz.getSimpleName())) {
            return element;
        }
        List<? extends TypeMirror> supertypes = this.typeUtils.directSupertypes(element.asType());
        return this.findClassAsElement(this.typeUtils.asElement(supertypes.get(0)), clazz);
    }

    private void generateDefaultTraversal(Context ctx) throws IOException {
        TypeSpec.Builder defaultTraversalClass = TypeSpec.classBuilder(ctx.defaultTraversalClazz).addModifiers(Modifier.PUBLIC).addTypeVariables(Arrays.asList(TypeVariableName.get("S"), TypeVariableName.get("E"))).superclass(TypeName.get(this.elementUtils.getTypeElement(DefaultTraversal.class.getCanonicalName()).asType())).addSuperinterface(ParameterizedTypeName.get(ctx.traversalClassName, TypeVariableName.get("S"), TypeVariableName.get("E")));
        defaultTraversalClass.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addStatement("super()", new Object[0]).build());
        defaultTraversalClass.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter((Type)((Object)Graph.class), "graph", new Modifier[0]).addStatement("super($N)", "graph").build());
        defaultTraversalClass.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ctx.traversalSourceClassName, "traversalSource", new Modifier[0]).addStatement("super($N)", "traversalSource").build());
        defaultTraversalClass.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ctx.traversalSourceClassName, "traversalSource", new Modifier[0]).addParameter(ctx.graphTraversalAdminClassName, "traversal", new Modifier[0]).addStatement("super($N, $N.asAdmin())", "traversalSource", "traversal").build());
        defaultTraversalClass.addMethod(MethodSpec.methodBuilder("iterate").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addStatement("return ($T) super.iterate()", ctx.traversalClassName).returns(ParameterizedTypeName.get(ctx.traversalClassName, TypeVariableName.get("S"), TypeVariableName.get("E"))).build());
        defaultTraversalClass.addMethod(MethodSpec.methodBuilder("asAdmin").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addStatement("return ($T) super.asAdmin()", GraphTraversal.Admin.class).returns(ParameterizedTypeName.get(ctx.graphTraversalAdminClassName, TypeVariableName.get("S"), TypeVariableName.get("E"))).build());
        defaultTraversalClass.addMethod(MethodSpec.methodBuilder("clone").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addStatement("return ($T) super.clone()", ctx.defaultTraversalClassName).returns(ParameterizedTypeName.get(ctx.defaultTraversalClassName, TypeVariableName.get("S"), TypeVariableName.get("E"))).build());
        JavaFile defaultTraversalJavaFile = JavaFile.builder(ctx.packageName, defaultTraversalClass.build()).build();
        defaultTraversalJavaFile.writeTo(this.filer);
    }

    private void generateTraversalInterface(Context ctx) throws IOException {
        TypeSpec.Builder traversalInterface = TypeSpec.interfaceBuilder(ctx.traversalClazz).addModifiers(Modifier.PUBLIC).addTypeVariables(Arrays.asList(TypeVariableName.get("S"), TypeVariableName.get("E"))).addSuperinterface(TypeName.get(ctx.annotatedDslType.asType()));
        for (ExecutableElement templateMethod : this.findMethodsOfElement(ctx.annotatedDslType, null)) {
            traversalInterface.addMethod(this.constructMethod(templateMethod, ctx.traversalClassName, ctx.dslName, Modifier.PUBLIC, Modifier.DEFAULT));
        }
        TypeElement graphTraversalElement = this.elementUtils.getTypeElement(GraphTraversal.class.getCanonicalName());
        Predicate<ExecutableElement> ignore = e -> e.getSimpleName().contentEquals("asAdmin") || e.getSimpleName().contentEquals("iterate");
        for (ExecutableElement templateMethod : this.findMethodsOfElement(graphTraversalElement, ignore)) {
            traversalInterface.addMethod(this.constructMethod(templateMethod, ctx.traversalClassName, ctx.dslName, Modifier.PUBLIC, Modifier.DEFAULT));
        }
        traversalInterface.addMethod(MethodSpec.methodBuilder("iterate").addModifiers(Modifier.PUBLIC, Modifier.DEFAULT).addAnnotation(Override.class).addStatement("$T.super.iterate()", ClassName.get(ctx.annotatedDslType)).addStatement("return this", new Object[0]).returns(ParameterizedTypeName.get(ctx.traversalClassName, TypeVariableName.get("S"), TypeVariableName.get("E"))).build());
        JavaFile traversalJavaFile = JavaFile.builder(ctx.packageName, traversalInterface.build()).build();
        traversalJavaFile.writeTo(this.filer);
    }

    private MethodSpec constructMethod(Element element, ClassName returnClazz, String parent, Modifier ... modifiers) {
        ExecutableElement templateMethod = (ExecutableElement)element;
        String methodName = templateMethod.getSimpleName().toString();
        TypeName returnType = this.getReturnTypeDefinition(returnClazz, templateMethod);
        MethodSpec.Builder methodToAdd = MethodSpec.methodBuilder(methodName).addModifiers(modifiers).addAnnotation(Override.class).addExceptions(templateMethod.getThrownTypes().stream().map(TypeName::get).collect(Collectors.toList())).returns(returnType);
        templateMethod.getTypeParameters().forEach(tp -> methodToAdd.addTypeVariable(TypeVariableName.get(tp)));
        String parentCall = parent.isEmpty() ? "" : parent + ".";
        String body = "return ($T) " + parentCall + "super.$L(";
        this.addMethodBody(methodToAdd, templateMethod, body, ")", returnClazz, methodName);
        return methodToAdd.build();
    }

    private void addMethodBody(MethodSpec.Builder methodToAdd, ExecutableElement templateMethod, String startBody, String endBody, Object ... statementArgs) {
        List<? extends VariableElement> parameters = templateMethod.getParameters();
        String body = startBody;
        int numberOfParams = parameters.size();
        for (int ix = 0; ix < numberOfParams; ++ix) {
            VariableElement param = parameters.get(ix);
            methodToAdd.addParameter(ParameterSpec.get(param));
            body = body + param.getSimpleName();
            if (ix >= numberOfParams - 1) continue;
            body = body + ",";
        }
        body = body + endBody;
        if (!parameters.isEmpty() && parameters.get(parameters.size() - 1).asType().getKind() == TypeKind.ARRAY) {
            methodToAdd.varargs(true);
        }
        methodToAdd.addStatement(body, statementArgs);
    }

    private TypeName getReturnTypeDefinition(ClassName returnClazz, ExecutableElement templateMethod) {
        List<? extends TypeMirror> returnTypeArguments = this.getTypeArguments(templateMethod);
        return returnTypeArguments.isEmpty() ? returnClazz : ParameterizedTypeName.get(returnClazz, returnTypeArguments.stream().map(TypeName::get).collect(Collectors.toList()).toArray(new TypeName[returnTypeArguments.size()]));
    }

    private void validateDSL(Element dslElement) throws ProcessorException {
        if (dslElement.getKind() != ElementKind.INTERFACE) {
            throw new ProcessorException(dslElement, "Only interfaces can be annotated with @%s", GremlinDsl.class.getSimpleName());
        }
        TypeElement typeElement = (TypeElement)dslElement;
        if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ProcessorException(dslElement, "The interface %s is not public.", typeElement.getQualifiedName());
        }
    }

    private List<ExecutableElement> findMethodsOfElement(Element element, Predicate<ExecutableElement> ignore) {
        Predicate<ExecutableElement> test = null == ignore ? ee -> false : ignore;
        return element.getEnclosedElements().stream().filter(ee -> ee.getKind() == ElementKind.METHOD).map(ee -> (ExecutableElement)ee).filter(ee -> !test.test((ExecutableElement)ee)).collect(Collectors.toList());
    }

    private List<? extends TypeMirror> getTypeArguments(ExecutableElement templateMethod) {
        DeclaredType returnTypeMirror = (DeclaredType)templateMethod.getReturnType();
        return returnTypeMirror.getTypeArguments();
    }

    private class Context {
        private final TypeElement annotatedDslType;
        private final String packageName;
        private final String dslName;
        private final String traversalClazz;
        private final ClassName traversalClassName;
        private final String traversalSourceClazz;
        private final ClassName traversalSourceClassName;
        private final String defaultTraversalClazz;
        private final ClassName defaultTraversalClassName;
        private final ClassName graphTraversalAdminClassName;
        private final TypeElement traversalSourceDslType;
        private final boolean generateDefaultMethods;

        public Context(TypeElement dslElement) {
            this.annotatedDslType = dslElement;
            GremlinDsl gremlinDslAnnotation = dslElement.getAnnotation(GremlinDsl.class);
            this.generateDefaultMethods = gremlinDslAnnotation.generateDefaultMethods();
            this.traversalSourceDslType = GremlinDslProcessor.this.elementUtils.getTypeElement(gremlinDslAnnotation.traversalSource());
            this.packageName = this.getPackageName(dslElement, gremlinDslAnnotation);
            this.dslName = dslElement.getSimpleName().toString();
            String dslPrefix = this.dslName.substring(0, this.dslName.length() - "TraversalDSL".length());
            this.traversalClazz = dslPrefix + "Traversal";
            this.traversalClassName = ClassName.get(this.packageName, this.traversalClazz, new String[0]);
            this.traversalSourceClazz = dslPrefix + "TraversalSource";
            this.traversalSourceClassName = ClassName.get(this.packageName, this.traversalSourceClazz, new String[0]);
            this.defaultTraversalClazz = "Default" + this.traversalClazz;
            this.defaultTraversalClassName = ClassName.get(this.packageName, this.defaultTraversalClazz, new String[0]);
            this.graphTraversalAdminClassName = ClassName.get(GraphTraversal.Admin.class);
        }

        private String getPackageName(Element dslElement, GremlinDsl gremlinDslAnnotation) {
            return gremlinDslAnnotation.packageName().isEmpty() ? GremlinDslProcessor.this.elementUtils.getPackageOf(dslElement).getQualifiedName().toString() : gremlinDslAnnotation.packageName();
        }
    }
}

