/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.TreeSupplier;

public final class TreeStep<S>
extends ReducingBarrierStep<S, Tree>
implements TraversalParent,
ByModulating,
PathProcessor {
    private TraversalRing<Object, Object> traversalRing = new TraversalRing(new Traversal.Admin[0]);
    private Set<String> keepLabels;

    public TreeStep(Traversal.Admin traversal) {
        super(traversal);
        this.setSeedSupplier(TreeSupplier.instance());
        this.setReducingBiOperator(TreeBiOperator.instance());
    }

    public List<Traversal.Admin<Object, Object>> getLocalChildren() {
        return this.traversalRing.getTraversals();
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> treeTraversal) {
        this.traversalRing.addTraversal(this.integrateChild(treeTraversal));
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.PATH, TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    public Tree projectTraverser(Traverser.Admin<S> traverser) {
        Tree topTree;
        Tree depth = topTree = new Tree();
        Path path = traverser.path();
        for (int i = 0; i < path.size(); ++i) {
            Object object = TraversalUtil.applyNullable(path.get(i), this.traversalRing.next());
            if (!depth.containsKey(object)) {
                depth.put(object, new Tree());
            }
            depth = (Tree)depth.get(object);
        }
        this.traversalRing.reset();
        return topTree;
    }

    @Override
    public TreeStep<S> clone() {
        TreeStep clone = (TreeStep)super.clone();
        clone.traversalRing = this.traversalRing.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.traversalRing.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.traversalRing.hashCode();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.traversalRing);
    }

    @Override
    public void reset() {
        super.reset();
        this.traversalRing.reset();
    }

    @Override
    public void setKeepLabels(Set<String> labels) {
        this.keepLabels = labels;
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }

    public static final class TreeBiOperator
    implements BinaryOperator<Tree>,
    Serializable {
        private static final TreeBiOperator INSTANCE = new TreeBiOperator();

        @Override
        public Tree apply(Tree mutatingSeed, Tree tree) {
            mutatingSeed.addTree(tree);
            return mutatingSeed;
        }

        public static final TreeBiOperator instance() {
            return INSTANCE;
        }
    }
}

