/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.Mutating;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.EventCallback;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.MutationListener;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;

public final class EventStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private final EventQueue eventQueue;

    private EventStrategy(Builder builder) {
        this.eventQueue = builder.eventQueue;
        this.eventQueue.setListeners(builder.listeners);
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        EventStrategyCallback callback = new EventStrategyCallback(this.eventQueue);
        TraversalHelper.getStepsOfAssignableClass(Mutating.class, traversal).forEach(s -> s.getMutatingCallbackRegistry().addCallback(callback));
    }

    public static Builder build() {
        return new Builder();
    }

    public static class TransactionalEventQueue
    implements EventQueue {
        private final ThreadLocal<Deque<Event>> eventQueue = new ThreadLocal<Deque<Event>>(){

            @Override
            protected Deque<Event> initialValue() {
                return new ArrayDeque<Event>();
            }
        };
        private List<MutationListener> listeners = Collections.emptyList();

        public TransactionalEventQueue(Graph graph) {
            if (!graph.features().graph().supportsTransactions()) {
                throw new IllegalStateException(String.format("%s requires the graph to support transactions", EventStrategy.class.getName()));
            }
            graph.tx().addTransactionListener(status -> {
                if (status == Transaction.Status.COMMIT) {
                    this.fireEventQueue();
                } else if (status == Transaction.Status.ROLLBACK) {
                    this.resetEventQueue();
                } else {
                    throw new RuntimeException(String.format("The %s is not aware of this status: %s", EventQueue.class.getName(), status));
                }
            });
        }

        @Override
        public void addEvent(Event evt) {
            this.eventQueue.get().add(evt);
        }

        @Override
        public void setListeners(List<MutationListener> listeners) {
            this.listeners = listeners;
        }

        private void resetEventQueue() {
            this.eventQueue.set(new ArrayDeque());
        }

        private void fireEventQueue() {
            Deque<Event> deque = this.eventQueue.get();
            Event event = deque.pollFirst();
            while (event != null) {
                event.fireEvent(this.listeners.iterator());
                event = deque.pollFirst();
            }
        }
    }

    public static class DefaultEventQueue
    implements EventQueue {
        private List<MutationListener> listeners = Collections.emptyList();

        @Override
        public void setListeners(List<MutationListener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void addEvent(Event evt) {
            evt.fireEvent(this.listeners.iterator());
        }
    }

    public static interface EventQueue {
        public void setListeners(List<MutationListener> var1);

        public void addEvent(Event var1);
    }

    public static final class Builder {
        private final List<MutationListener> listeners = new ArrayList<MutationListener>();
        private EventQueue eventQueue = new DefaultEventQueue();

        Builder() {
        }

        public Builder addListener(MutationListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public Builder eventQueue(EventQueue eventQueue) {
            this.eventQueue = eventQueue;
            return this;
        }

        public EventStrategy create() {
            return new EventStrategy(this);
        }
    }

    public class EventStrategyCallback
    implements EventCallback<Event>,
    Serializable {
        private final EventQueue eventQueue;

        public EventStrategyCallback(EventQueue eventQueue) {
            this.eventQueue = eventQueue;
        }

        @Override
        public void accept(Event event) {
            this.eventQueue.addEvent(event);
        }
    }
}

