/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public interface Element {
    public Object id();

    public String label();

    public Graph graph();

    default public Set<String> keys() {
        HashSet keys2 = new HashSet();
        this.properties(new String[0]).forEachRemaining(property -> keys2.add(property.key()));
        return Collections.unmodifiableSet(keys2);
    }

    default public <V> Property<V> property(String key) {
        Iterator<Property<V>> iterator = this.properties(key);
        return iterator.hasNext() ? iterator.next() : Property.empty();
    }

    public <V> Property<V> property(String var1, V var2);

    default public <V> V value(String key) throws NoSuchElementException {
        return this.property(key).orElseThrow(() -> Property.Exceptions.propertyDoesNotExist(this, key));
    }

    public void remove();

    default public <V> Iterator<V> values(String ... propertyKeys) {
        return IteratorUtils.map(this.properties(propertyKeys), property -> property.value());
    }

    public <V> Iterator<? extends Property<V>> properties(String ... var1);

    public static class Exceptions {
        protected Exceptions() {
        }

        public static IllegalArgumentException providedKeyValuesMustBeAMultipleOfTwo() {
            return new IllegalArgumentException("The provided key/value array length must be a multiple of two");
        }

        public static IllegalArgumentException providedKeyValuesMustHaveALegalKeyOnEvenIndices() {
            return new IllegalArgumentException("The provided key/value array must have a String or T on even array indices");
        }

        public static IllegalStateException propertyAdditionNotSupported() {
            return new IllegalStateException("Property addition is not supported");
        }

        public static IllegalArgumentException labelCanNotBeNull() {
            return new IllegalArgumentException("Label can not be null");
        }

        public static IllegalArgumentException labelCanNotBeEmpty() {
            return new IllegalArgumentException("Label can not be empty");
        }

        public static IllegalArgumentException labelCanNotBeAHiddenKey(String label) {
            return new IllegalArgumentException("Label can not be a hidden key: " + label);
        }

        @Deprecated
        public static IllegalStateException elementAlreadyRemoved(Class<? extends Element> clazz, Object id) {
            return new IllegalStateException(String.format("%s with id %s was removed.", clazz.getSimpleName(), id));
        }
    }
}

