/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONReader;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONWriter;

public final class GraphSONIo
implements Io<GraphSONReader.Builder, GraphSONWriter.Builder, GraphSONMapper.Builder> {
    private final Graph graph;
    private final Optional<Consumer<Mapper.Builder>> onMapper;
    private final GraphSONVersion version;

    private GraphSONIo(Builder builder) {
        this.graph = builder.graph;
        this.onMapper = Optional.ofNullable(builder.onMapper);
        this.version = builder.version;
    }

    @Override
    public GraphSONReader.Builder reader() {
        return GraphSONReader.build().mapper(this.mapper().create());
    }

    @Override
    public GraphSONWriter.Builder writer() {
        return GraphSONWriter.build().mapper(this.mapper().create());
    }

    @Override
    public GraphSONMapper.Builder mapper() {
        GraphSONMapper.Builder builder = GraphSONMapper.build().version(this.version);
        this.onMapper.ifPresent(c -> c.accept(builder));
        return builder;
    }

    @Override
    public void writeGraph(String file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.writer().create().writeGraph(out, this.graph);
        }
    }

    @Override
    public void readGraph(String file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.reader().create().readGraph(in, this.graph);
        }
    }

    public static Io.Builder<GraphSONIo> build() {
        return GraphSONIo.build(GraphSONVersion.V2_0);
    }

    public static Io.Builder<GraphSONIo> build(GraphSONVersion version) {
        return new Builder(version);
    }

    public static final class Builder
    implements Io.Builder<GraphSONIo> {
        private Graph graph;
        private Consumer<Mapper.Builder> onMapper = null;
        private final GraphSONVersion version;

        Builder(GraphSONVersion version) {
            this.version = version;
        }

        @Override
        public Io.Builder<? extends Io> onMapper(Consumer<Mapper.Builder> onMapper) {
            this.onMapper = onMapper;
            return this;
        }

        @Override
        public Io.Builder<GraphSONIo> graph(Graph g) {
            this.graph = g;
            return this;
        }

        @Override
        public GraphSONIo create() {
            if (null == this.graph) {
                throw new IllegalArgumentException("The graph argument was not specified");
            }
            return new GraphSONIo(this);
        }
    }
}

