/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.util.function.Function;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.tinkerpop.gremlin.structure.io.gryo.TypeRegistration;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.shaded.ShadedSerializerAdapter;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;

final class GryoTypeReg<T>
implements TypeRegistration<T> {
    private final Class<T> clazz;
    private final Serializer<T> shadedSerializer;
    private final SerializerShim<T> serializerShim;
    private final Function<Kryo, Serializer> functionOfShadedKryo;
    private final int id;

    private GryoTypeReg(Class<T> clazz, Serializer<T> shadedSerializer, SerializerShim<T> serializerShim, Function<Kryo, Serializer> functionOfShadedKryo, int id) {
        if (null == clazz) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        this.clazz = clazz;
        this.shadedSerializer = shadedSerializer;
        this.serializerShim = serializerShim;
        this.functionOfShadedKryo = functionOfShadedKryo;
        this.id = id;
        int serializerCount = 0;
        if (null != this.shadedSerializer) {
            ++serializerCount;
        }
        if (null != this.serializerShim) {
            ++serializerCount;
        }
        if (null != this.functionOfShadedKryo) {
            ++serializerCount;
        }
        if (1 < serializerCount) {
            String msg = String.format("GryoTypeReg accepts at most one kind of serializer, but multiple serializers were supplied for class %s (id %s).  Shaded serializer: %s.  Shim serializer: %s.  Shaded serializer function: %s.", this.clazz.getCanonicalName(), id, this.shadedSerializer, this.serializerShim, this.functionOfShadedKryo);
            throw new IllegalArgumentException(msg);
        }
    }

    static <T> GryoTypeReg<T> of(Class<T> clazz, int id) {
        return new GryoTypeReg<T>(clazz, null, null, null, id);
    }

    static <T> GryoTypeReg<T> of(Class<T> clazz, int id, Serializer<T> shadedSerializer) {
        return new GryoTypeReg<T>(clazz, shadedSerializer, null, null, id);
    }

    static <T> GryoTypeReg<T> of(Class<T> clazz, int id, SerializerShim<T> serializerShim) {
        return new GryoTypeReg<T>(clazz, null, serializerShim, null, id);
    }

    static <T> GryoTypeReg<T> of(Class clazz, int id, Function<Kryo, Serializer> fct) {
        return new GryoTypeReg<T>(clazz, null, null, fct, id);
    }

    @Override
    public Serializer<T> getShadedSerializer() {
        return this.shadedSerializer;
    }

    @Override
    public SerializerShim<T> getSerializerShim() {
        return this.serializerShim;
    }

    @Override
    public Function<Kryo, Serializer> getFunctionOfShadedKryo() {
        return this.functionOfShadedKryo;
    }

    @Override
    public Class<T> getTargetClass() {
        return this.clazz;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Kryo registerWith(Kryo kryo) {
        if (null != this.functionOfShadedKryo) {
            kryo.register(this.clazz, this.functionOfShadedKryo.apply(kryo), this.id);
        } else if (null != this.shadedSerializer) {
            kryo.register(this.clazz, this.shadedSerializer, this.id);
        } else if (null != this.serializerShim) {
            kryo.register(this.clazz, new ShadedSerializerAdapter<T>(this.serializerShim), this.id);
        } else {
            kryo.register(this.clazz, kryo.getDefaultSerializer(this.clazz), this.id);
        }
        return kryo;
    }

    public String toString() {
        return new ToStringBuilder(this).append("targetClass", this.clazz).append("id", this.id).append("shadedSerializer", this.shadedSerializer).append("serializerShim", this.serializerShim).append("functionOfShadedKryo", this.functionOfShadedKryo).toString();
    }
}

